/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.basic;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.PhoneUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.common.util.Digests;
import cn.smarthse.common.util.Encodes;
import cn.smarthse.common.util.MD5Utils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.excel.ExcelUtil;
import cn.smarthse.common.util.passwordLog.Md5Utils;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.framework.redis.utils.RedisUtils;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.log.ISysOperLogProviderService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.supervise.config.properties.ZwddProperties;
import cn.smarthse.modules.health.supervise.dao.basic.OrganizationUserMapper;
import cn.smarthse.modules.health.supervise.dao.sys.v3.SysUserRoleV3Mapper;
import cn.smarthse.modules.health.supervise.entity.basic.Organization;
import cn.smarthse.modules.health.supervise.entity.basic.OrganizationUser;
import cn.smarthse.modules.health.supervise.entity.sys.SysArea;
import cn.smarthse.modules.health.supervise.entity.sys.v3.SysUserRoleV3;
import cn.smarthse.modules.health.supervise.enums.sys.UserFromEnum;
import cn.smarthse.modules.health.supervise.enums.sys.UserRolesEnum;
import cn.smarthse.modules.health.supervise.model.sys.v3.organization.MaintenanceUserV3AddParam;
import cn.smarthse.modules.health.supervise.model.sys.v3.organization.MaintenanceUserV3EditParam;
import cn.smarthse.modules.health.supervise.model.sys.v3.organization.OrganizationUserV3AddParam;
import cn.smarthse.modules.health.supervise.model.sys.v3.organization.OrganizationUserV3EditParam;
import cn.smarthse.modules.health.supervise.model.sys.v3.organization.OrganizationUserV3ImportDto;
import cn.smarthse.modules.health.supervise.model.sys.v3.organization.OrganizationUserV3ImportListParam;
import cn.smarthse.modules.health.supervise.model.sys.v3.organization.OrganizationUserV3ListParam;
import cn.smarthse.modules.health.supervise.model.sys.v3.township.TownshipUserImportDto;
import cn.smarthse.modules.health.supervise.model.sys.v3.township.TownshipUserV3AddParam;
import cn.smarthse.modules.health.supervise.model.sys.v3.township.TownshipUserV3EditParam;
import cn.smarthse.modules.health.supervise.model.sys.v3.township.TownshipUserV3ListParam;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationService;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationUserService;
import cn.smarthse.modules.health.supervise.service.basic.SysOrganizationUserImportListener;
import cn.smarthse.modules.health.supervise.service.basic.SysTownshipUserImportListener;
import cn.smarthse.modules.health.supervise.service.sys.v3.ISysRoleV3Service;
import cn.smarthse.modules.health.supervise.service.sys.v3.ISysUserRoleV3Service;
import cn.smarthse.modules.health.supervise.vo.sys.TownshipUserCountVo;
import cn.smarthse.modules.health.supervise.vo.sys.v3.organization.OrganizationUserV3ImportListVo;
import cn.smarthse.modules.health.supervise.vo.sys.v3.organization.OrganizationUserV3ListVo;
import cn.smarthse.modules.health.supervise.vo.sys.v3.organization.OrganizationUserV3OneVo;
import cn.smarthse.modules.health.supervise.vo.sys.v3.role.SysRoleV3Vo;
import cn.smarthse.modules.health.supervise.vo.sys.v3.township.TownshipUserV3ListVo;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.modules.sys.enumd.OperatorDataSourceEnum;
import cn.smarthse.modules.sys.enumd.UserSystemWideEnum;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.xxpt.gateway.shared.api.request.OapiMoziEmployeeGetByMobileRequest;
import com.alibaba.xxpt.gateway.shared.api.response.OapiMoziEmployeeGetByMobileResponse;
import com.alibaba.xxpt.gateway.shared.client.http.ExecutableClient;
import com.alibaba.xxpt.gateway.shared.client.http.IntelligentGetClient;
import com.alibaba.xxpt.gateway.shared.client.http.api.OapiRequest;
import com.alibaba.xxpt.gateway.shared.client.http.api.OapiSpResultContent;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.ErrorEnum;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.redisson.api.RLock;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.DigestUtils;
import tk.mybatis.mapper.entity.Example;

@Service
@DubboService
@Transactional(readOnly=true)
public class OrganizationUserServiceImpl
extends BaseServiceImpl<OrganizationUserMapper, OrganizationUser>
implements IOrganizationUserService {
    @Autowired
    private IOrganizationService organizationService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService areaService;
    @DubboReference
    private ISysOperLogProviderService sysOperLogService;
    @Autowired
    private ISysRoleV3Service sysRoleV3Service;
    @Autowired
    private ISysUserRoleV3Service sysUserRoleV3Service;
    @DubboReference
    private ISysFileProvideService sysFileProvideService;
    @Autowired
    private OssClientBean ossClientBean;
    @Autowired
    private ExecutableClient executableClient;
    @Autowired
    private ZwddProperties zwddProperties;

    public OrganizationUser getUserByuserame(String username) {
        if (StrUtil.isBlank((CharSequence)username)) {
            return null;
        }
        username = StrUtil.toUpperCase((CharSequence)StrUtil.trim((CharSequence)username));
        OrganizationUser param = new OrganizationUser();
        param.setUsername(username);
        OrganizationUser user = ((OrganizationUserMapper)this.dao).getUserInfoByUsername(param);
        if (Objects.nonNull(user)) {
            user.setOrganization((Organization)this.organizationService.getById(user.getOid()));
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getAccountId(String tel) {
        RLock lock = RedisUtils.getClient().getLock(String.format("setAccountId Lock:%s", tel));
        if (lock.tryLock()) {
            try {
                OapiSpResultContent content = this.getOapiSpResultContent(tel);
                this.logger.debug("OapiSpResultContent_tel\uff1a{}\uff0cresut\uff1a{}", (Object)tel, (Object)JSONObject.toJSONString((Object)content));
                if (content.getSuccess().booleanValue()) {
                    JSONObject dataObject = JSONObject.parseObject((String)content.getData());
                    Long l = (Long)dataObject.getObject("accountId", Long.class);
                    return l;
                }
                Long l = 0L;
                return l;
            }
            catch (Exception e) {
                this.logger.error("\u83b7\u53d6accountId\u5931\u8d25\uff1a", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        }
        return null;
    }

    @Override
    public OrganizationUser getById(Long id) {
        OrganizationUser user = (OrganizationUser)super.getById(id);
        if (user == null || user.getOid() == null) {
            return user;
        }
        Organization organization = (Organization)this.organizationService.getById(user.getOid());
        if (Objects.nonNull(organization)) {
            AreaModel areaModel = this.areaService.getAreaById(organization.getAreaId());
            if (Objects.nonNull(areaModel)) {
                SysArea sysArea = new SysArea();
                BeanUtils.copyProperties((Object)areaModel, (Object)sysArea);
                organization.setSysArea(sysArea);
            }
            user.setOrganization(organization);
        }
        return user;
    }

    public List<OrganizationUser> getListByOid(Long oid) {
        if (oid == null) {
            return Collections.emptyList();
        }
        OrganizationUser user = new OrganizationUser();
        user.setOid(oid);
        user.setIsValid(Boolean.valueOf(true));
        return ((OrganizationUserMapper)this.dao).select(user);
    }

    public int getCountByOid(Long oid) {
        if (oid == null) {
            return 0;
        }
        OrganizationUser user = new OrganizationUser();
        user.setOid(oid);
        user.setIsValid(Boolean.valueOf(true));
        user.setIsForbidden(Boolean.valueOf(false));
        return ((OrganizationUserMapper)this.dao).selectCount(user);
    }

    public List<String> getMobilesByOid(Long oid) {
        return ((OrganizationUserMapper)this.dao).getMobilesByOid(oid);
    }

    @Transactional
    public void deleteByIds(String ids, Long loginStaffId) {
        if (StringUtils.isNotEmpty((String)ids)) {
            CommonUtil.str2LongList((String)ids).forEach(s -> {
                OrganizationUser entity = new OrganizationUser();
                entity.setId(s);
                this.delete(entity, loginStaffId);
            });
        }
    }

    @Transactional
    public void modifyPassword(Long userId, String md5Password) {
        OrganizationUser byId = this.getById(userId);
        if (DigestUtils.md5DigestAsHex((byte[])"Zyj@2022".getBytes()).equals(md5Password)) {
            throw new HealthException("\u4e0d\u80fd\u4fee\u6539\u4e3a\u9ed8\u8ba4\u5bc6\u7801\uff01");
        }
        String encryptPassword = Encodes.hexEncode((byte[])Digests.sha1((byte[])md5Password.toLowerCase().getBytes(), (byte[])Encodes.hexDecode((String)byId.getSalt()), (int)1024));
        if (Objects.equals(encryptPassword, byId.getPassword())) {
            throw new HealthException("\u65b0\u5bc6\u7801\u4e0e\u65e7\u5bc6\u7801\u4e0d\u80fd\u76f8\u540c\uff01");
        }
        OrganizationUser resetUser = new OrganizationUser();
        resetUser.setId(userId);
        byte[] salt = Digests.generateSalt((int)8);
        resetUser.setSalt(Encodes.hexEncode((byte[])salt));
        byte[] hashPassword = Digests.sha1((byte[])md5Password.getBytes(), (byte[])salt, (int)1024);
        resetUser.setPassword(Encodes.hexEncode((byte[])hashPassword));
        resetUser.setUpdateDate(new Date());
        resetUser.setIsDefaultPwd(Boolean.valueOf(false));
        resetUser.setPwdUpdateTime(resetUser.getUpdateDate());
        this.update(resetUser, userId);
        String username = StrUtil.toUpperCase((CharSequence)StrUtil.trim((CharSequence)byId.getUsername()));
        RedisUtils.deleteObject((String)("superivse-web" + Md5Utils.hash((String)username)));
    }

    @Transactional
    public void modifyPassword(Long userId, String md5OldPassword, String md5Password) {
        if (StringUtils.isBlank((CharSequence)md5OldPassword) || StringUtils.isBlank((CharSequence)md5Password)) {
            throw new HealthException("\u65b0\u65e7\u5bc6\u7801\u5747\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (md5OldPassword.equals(md5Password)) {
            throw new HealthException("\u65b0\u65e7\u5bc6\u7801\u4e0d\u80fd\u76f8\u540c");
        }
        OrganizationUser userById = this.getUserInfoById(userId);
        if (!StringUtils.getPassword((String)userById.getSalt(), (String)md5OldPassword).equals(userById.getPassword())) {
            throw new HealthException("\u65e7\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
        String username = StrUtil.toUpperCase((CharSequence)StrUtil.trim((CharSequence)userById.getUsername()));
        if (this.sysOperLogService.isPasswordAvailable(md5Password, username, OperatorDataSourceEnum.SUPERVISE.getValue()).booleanValue()) {
            throw new HealthException("\u4e0d\u53ef\u4f7f\u7528\u5386\u53f2\u5bc6\u7801\u6216\u521d\u59cb\u5bc6\u7801");
        }
        OrganizationUser user = new OrganizationUser();
        user.setId(userById.getId());
        byte[] salt = Digests.generateSalt((int)8);
        user.setSalt(Encodes.hexEncode((byte[])salt));
        byte[] hashPassword = Digests.sha1((byte[])md5Password.getBytes(), (byte[])salt, (int)1024);
        user.setPassword(Encodes.hexEncode((byte[])hashPassword));
        user.setIsDefaultPwd(Boolean.valueOf(false));
        Date date = new Date();
        user.setPwdUpdateTime(date);
        user.setUpdateDate(date);
        this.update(user, userById.getId());
    }

    @Transactional
    public void updatePassStateThreeMonth() {
        ((OrganizationUserMapper)this.dao).updatePassStateThreeMonth();
    }

    @Transactional
    public void bindAccountId(Long userId, Long accountId) {
        OrganizationUser user = this.getById(userId);
        if (user == null) {
            this.logger.warn("\u7ed1\u5b9aaccoundId\uff0cOrganizationUser\u4e0d\u5b58\u5728\u3002userId\uff1a{}-accoundId\uff1a{}", (Object)userId, (Object)accountId);
            return;
        }
        OrganizationUser organizationUser = new OrganizationUser();
        organizationUser.setId(user.getId());
        organizationUser.setAccountId(accountId);
        this.update(organizationUser);
    }

    @Transactional
    public void bindTel(Long userId, String tel) {
        OrganizationUser user = this.getById(userId);
        if (user == null) {
            this.logger.warn("\u7ed1\u5b9a\u624b\u673a\u53f7\uff0cOrganizationUser\u4e0d\u5b58\u5728\u3002userId\uff1a{}-accoundId\uff1a{}", (Object)userId, (Object)tel);
            return;
        }
        OrganizationUser organizationUser = new OrganizationUser();
        organizationUser.setId(user.getId());
        organizationUser.setTel(tel);
        organizationUser.setAccountId(this.getAccountId(tel));
        this.update(organizationUser);
    }

    public OrganizationUser getUserByAccoundId(Long accountId, String role) {
        List<OrganizationUser> list = this.getUserListByAccoundId(accountId);
        return CollectionUtils.isEmpty(list) ? null : (role == null ? list.get(0) : (OrganizationUser)list.stream().filter(u -> u.getRoleList().contains(Long.valueOf(role))).findFirst().orElse(null));
    }

    public List<OrganizationUser> getUserListByAccoundId(Long accountId) {
        return ((OrganizationUserMapper)this.dao).getUserListByAccoundId(accountId);
    }

    public Integer getStreetUserCount16(Long areaId, Integer level) {
        return ((OrganizationUserMapper)this.dao).getStreetUserCount(areaId, level, UserRolesEnum.townshipCoordinator.getValue());
    }

    public List<TownshipUserCountVo> getStreetUserCountList16(Long areaId, Integer level) {
        return ((OrganizationUserMapper)this.dao).getStreetUserCountList(areaId, level, UserRolesEnum.townshipCoordinator.getValue());
    }

    public List<OrganizationUser> getWithOutAccountIdList() {
        return ((OrganizationUserMapper)this.dao).getWithOutAccountIdList(UserRolesEnum.townshipCoordinator.getValue());
    }

    public OrganizationUser setPasswordInfo(OrganizationUser user, String plainPassword) {
        byte[] salt = Digests.generateSalt((int)8);
        user.setSalt(Encodes.hexEncode((byte[])salt));
        byte[] hashPassword = Digests.sha1((byte[])DigestUtils.md5DigestAsHex((byte[])plainPassword.getBytes()).getBytes(), (byte[])salt, (int)1024);
        user.setPassword(Encodes.hexEncode((byte[])hashPassword));
        user.setIsDefaultPwd(Boolean.valueOf(true));
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrganizationUser setTelAndAccountId(OrganizationUser user, String tel) {
        if (StrUtil.isBlank((CharSequence)tel)) {
            user.setAccountId(Long.valueOf(0L));
            user.setTel("");
            return user;
        }
        RLock lock = RedisUtils.getClient().getLock(String.format("setTelAndAccountId Lock:%s", tel));
        if (lock.tryLock()) {
            try {
                OapiSpResultContent content = this.getOapiSpResultContent(tel);
                this.logger.debug("OapiSpResultContent_tel\uff1a{}\uff0cresut\uff1a{}", (Object)tel, (Object)JSONObject.toJSONString((Object)content));
                if (content.getSuccess().booleanValue()) {
                    JSONObject dataObject = JSONObject.parseObject((String)content.getData());
                    user.setAccountId((Long)dataObject.getObject("accountId", Long.class));
                    user.setTel(tel);
                } else {
                    user.setAccountId(Long.valueOf(0L));
                    user.setTel("");
                }
                OrganizationUser organizationUser = user;
                return organizationUser;
            }
            catch (Exception e) {
                this.logger.error("\u83b7\u53d6accountId\u5931\u8d25\uff1a", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getAccountIdByTel(String tel) {
        RLock lock = RedisUtils.getClient().getLock(String.format("getAccountIdByTel Lock:%s", tel));
        if (lock.tryLock()) {
            try {
                OapiSpResultContent content = this.getOapiSpResultContent(SpringEncryptUtils.decrypt((String)tel));
                this.logger.debug("OapiSpResultContent_tel\uff1a{}\uff0cresut\uff1a{}", (Object)tel, (Object)JSONObject.toJSONString((Object)content));
                if (content.getSuccess().booleanValue()) {
                    JSONObject dataObject = JSONObject.parseObject((String)content.getData());
                    Long l = (Long)dataObject.getObject("accountId", Long.class);
                    return l;
                }
                Long l = null;
                return l;
            }
            catch (Exception e) {
                this.logger.error("\u83b7\u53d6accountId\u5931\u8d25\uff1a", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        }
        return null;
    }

    public Integer getOrganizationUserCountThisLevelByOid(Long oid) {
        if (Objects.isNull(oid)) {
            throw new HealthException("oid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OrganizationUser entity = new OrganizationUser();
        entity.setIsValid(Boolean.TRUE);
        entity.setOid(oid);
        return ((OrganizationUserMapper)this.dao).selectCount(entity);
    }

    public Integer getOrganizationUserCountNextLevelByOid(Long oid) {
        if (Objects.isNull(oid)) {
            throw new HealthException("oid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return ((OrganizationUserMapper)this.dao).getOrganizationUserCountNextLevelByOid(oid);
    }

    public Integer getOrganizationUserCountThisAndNextLevelByOid(Long oid) {
        if (Objects.isNull(oid)) {
            throw new HealthException("oid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return ((OrganizationUserMapper)this.dao).getOrganizationUserCountThisAndNextLevelByOid(oid);
    }

    public PageInfo<TownshipUserV3ListVo> getTownshipUserList(TownshipUserV3ListParam param) {
        param.setKeywordEn(param.getKeyword());
        PageHelper.startPage((int)param.getPage(), (int)param.getRows(), (boolean)param.getCount());
        return new PageInfo(((OrganizationUserMapper)this.dao).getTownshipUserList(param));
    }

    public Boolean isHaveThisUserName(String username, Integer organizationType, Long excludeId) {
        if (StrUtil.isBlank((CharSequence)username)) {
            throw new HealthException("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        username = StrUtil.toUpperCase((CharSequence)StrUtil.trim((CharSequence)username));
        OrganizationUser param = new OrganizationUser();
        param.setUsername(username);
        return ((OrganizationUserMapper)this.dao).isHaveThisUserName(param, organizationType, excludeId) > 0;
    }

    public Boolean isHaveThisTelByType(String tel, Integer organizationType, Long excludeId) {
        if (StrUtil.isBlank((CharSequence)tel)) {
            throw new HealthException("\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OrganizationUser param = new OrganizationUser();
        param.setTel(tel);
        return ((OrganizationUserMapper)this.dao).isHaveThisTelByType(param, organizationType, excludeId) > 0;
    }

    public Boolean isHaveThisTelByRoleId(String tel, Long roleId, Long excludeId) {
        if (StrUtil.isBlank((CharSequence)tel)) {
            throw new HealthException("\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OrganizationUser param = new OrganizationUser();
        param.setTel(tel);
        return ((OrganizationUserMapper)this.dao).isHaveThisTelByRoleId(param, roleId, excludeId) > 0;
    }

    public OrganizationUser getUserInfoById(Long id) {
        if (Objects.isNull(id)) {
            return null;
        }
        List<OrganizationUser> list = ((OrganizationUserMapper)this.dao).getUserInfoById(Collections.singletonList(id));
        if (CollUtil.isEmpty(list)) {
            return null;
        }
        OrganizationUser user = list.get(0);
        if (Objects.nonNull(user)) {
            user.setOrganization((Organization)this.organizationService.getById(user.getOid()));
        }
        return user;
    }

    public List<OrganizationUser> getUserInfoByIdList(List<Long> idList) {
        if (CollUtil.isEmpty(idList)) {
            return Collections.emptyList();
        }
        return ((OrganizationUserMapper)this.dao).getUserInfoById(idList);
    }

    public List<Organization> getOrganizationByUserIdList(List<Long> userIdList) {
        if (CollUtil.isEmpty(userIdList)) {
            return Collections.emptyList();
        }
        return ((OrganizationUserMapper)this.dao).getOrganizationByUserIdList(userIdList);
    }

    public Map<Long, OrganizationUser> getUserInfoMapByIdList(List<Long> idList) {
        return this.getUserInfoByIdList(idList).stream().collect(Collectors.toMap(OrganizationUser::getId, item -> item, (v1, v2) -> v1));
    }

    public List<OrganizationUser> getUserInfoListByOid(Long oid) {
        if (Objects.isNull(oid)) {
            return Collections.emptyList();
        }
        return ((OrganizationUserMapper)this.dao).getUserInfoListByOid(oid);
    }

    @Transactional
    public void importTownshipUserData(List<TownshipUserImportDto> dataList) {
        if (CollUtil.isEmpty(dataList)) {
            return;
        }
        Date date = new Date();
        ArrayList<OrganizationUser> rst = new ArrayList<OrganizationUser>(dataList.size());
        ArrayList<SysUserRoleV3> rst2 = new ArrayList<SysUserRoleV3>(dataList.size());
        for (TownshipUserImportDto dto : dataList) {
            OrganizationUser user = new OrganizationUser();
            user.setId(dto.getId());
            user.setOid(dto.getOid());
            user.setUsername(StrUtil.toUpperCase((CharSequence)StrUtil.trim((CharSequence)dto.getUsername())));
            user.setFullName(dto.getFullName());
            user.setDepartment(dto.getDepartment());
            user.setPost(dto.getPost());
            user.setIsManger(Boolean.FALSE);
            user.setSystemWide(UserSystemWideEnum.ZLWQ.getCodeStr());
            user.setUserFrom(UserFromEnum.SUPERVISE.getCode());
            user.setCreateBy(dto.getLoginUserId());
            user.setCreateDate(date);
            user = this.setPasswordInfo(user, "Zyj@2022");
            user = this.setTelAndAccountId(user, dto.getTel());
            rst.add(user);
            SysUserRoleV3 userRole = new SysUserRoleV3();
            userRole.setId(Long.valueOf(this.idworker.nextId()));
            userRole.setUserId(user.getId());
            userRole.setRoleId(Long.valueOf(UserRolesEnum.townshipCoordinator.getValue().byteValue()));
            userRole.setCreateBy(dto.getLoginUserId());
            userRole.setUpdateBy(dto.getLoginUserId());
            rst2.add(userRole);
        }
        int a = this.batchUpdateOrInsert(rst, OrganizationUserMapper.class, (item, mapper) -> mapper.insertSelective(item));
        if (a <= 0) {
            throw new HealthException(ResponseStateEnum.fail.getName());
        }
        this.sysUserRoleV3Service.batchUpdateOrInsert(rst2, SysUserRoleV3Mapper.class, (item, mapper) -> mapper.insertSelective(item));
    }

    @Transactional
    public void rollbackImportUserData(List<Long> idList, Long loginUserId) {
        if (CollUtil.isEmpty(idList)) {
            return;
        }
        this.sysUserRoleV3Service.deleteByUserIdList(idList, loginUserId);
    }

    public PageInfo<OrganizationUserV3ListVo> getOrganizationUserList(OrganizationUserV3ListParam param) {
        param.setKeywordEn(param.getKeyword());
        PageHelper.startPage((int)param.getPage(), (int)param.getRows(), (boolean)param.getCount());
        List<OrganizationUserV3ListVo> rst = ((OrganizationUserMapper)this.dao).getOrganizationUserList(param);
        if (CollUtil.isNotEmpty(rst)) {
            Map roleMap = this.sysRoleV3Service.selectJGRoleListByUserIdList(rst.stream().map(OrganizationUserV3ListVo::getId).collect(Collectors.toList()));
            rst.stream().peek(row -> row.setRoleList(roleMap.getOrDefault(row.getId(), Collections.emptyList()))).collect(Collectors.toList());
        }
        return new PageInfo(rst);
    }

    public List<OrganizationUserV3ImportListVo> getOrganizationUserListForImport(OrganizationUserV3ImportListParam param) {
        return ((OrganizationUserMapper)this.dao).getOrganizationUserListForImport(param);
    }

    public OrganizationUserV3OneVo getOrganizationUserOne(Long id) {
        if (Objects.isNull(id)) {
            return null;
        }
        return ((OrganizationUserMapper)this.dao).getOrganizationUserOne(id);
    }

    public List<OrganizationUserV3OneVo> getOrganizationUserByTel(String tel) {
        if (StrUtil.isBlank((CharSequence)tel)) {
            return Collections.emptyList();
        }
        tel = SpringEncryptUtils.encrypt((String)tel);
        return ((OrganizationUserMapper)this.dao).getOrganizationUserByTel(tel);
    }

    @Transactional
    public Boolean delete(Long id, Long loginUserId) {
        if (Objects.isNull(id)) {
            throw new HealthException("\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u7528\u6237");
        }
        OrganizationUser organizationUserV3 = this.getUserInfoById(id);
        if (Objects.isNull(organizationUserV3)) {
            throw new HealthException("\u8be5\u7528\u6237\u5df2\u4e0d\u5b58\u5728");
        }
        OrganizationUser entity = new OrganizationUser();
        entity.setId(id);
        this.delete(entity, loginUserId);
        return Boolean.TRUE;
    }

    @Transactional
    public Boolean delete(List<Long> idList, Long loginUserId) {
        if (CollUtil.isEmpty(idList)) {
            throw new HealthException("\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u7528\u6237");
        }
        List<OrganizationUser> organizationUserV3List = this.getUserInfoByIdList(idList);
        if (Objects.isNull(organizationUserV3List)) {
            throw new HealthException("\u7528\u6237\u5df2\u4e0d\u5b58\u5728");
        }
        if (this.getUserInfoByIdList(idList).stream().anyMatch(i -> !Objects.equals(i.getIsForbidden(), Boolean.TRUE))) {
            throw new HealthException("\u5b58\u5728\u672a\u88ab\u7981\u7528\u7528\u6237\uff0c\u4e0d\u53ef\u88ab\u5220\u9664");
        }
        OrganizationUser entity = new OrganizationUser();
        entity.setIsValid(Boolean.FALSE);
        this.setUpdateInfo(entity, loginUserId);
        Example example = new Example(OrganizationUser.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("id", idList).andEqualTo("isValid", (Object)Boolean.TRUE);
        return ((OrganizationUserMapper)this.dao).updateByExampleSelective(entity, example) > 0;
    }

    @Transactional
    public Boolean enableOrDisable(List<Long> idList, Boolean isForbidden, Long loginUserId) {
        if (CollUtil.isEmpty(idList)) {
            throw new HealthException("\u8bf7\u9009\u62e9\u7528\u6237");
        }
        List<OrganizationUser> list = this.getUserInfoByIdList(idList);
        if (CollUtil.isEmpty(list)) {
            throw new HealthException("\u7528\u6237\u5df2\u4e0d\u5b58\u5728");
        }
        idList = list.stream().filter(i -> !Objects.equals(i.getIsForbidden(), isForbidden)).map(OrganizationUser::getId).collect(Collectors.toList());
        if (CollUtil.isEmpty(idList)) {
            throw new HealthException("\u8bf7\u9009\u62e9\u7528\u6237");
        }
        ArrayList<OrganizationUser> rst = new ArrayList<OrganizationUser>(idList.size());
        for (Long id : idList) {
            OrganizationUser entity = new OrganizationUser();
            entity.setId(id);
            entity.setIsForbidden(isForbidden);
            this.setUpdateInfo(entity, loginUserId);
            rst.add(entity);
        }
        return this.batchUpdateOrInsert(rst, OrganizationUserMapper.class, (item, mapper) -> mapper.updateByPrimaryKeySelective(item)) > 0;
    }

    @Transactional
    public Boolean resetPassword(Long id, String plainPassword, Long loginUserId) {
        boolean b;
        if (Objects.isNull(id)) {
            throw new HealthException("\u8bf7\u9009\u62e9\u8981\u91cd\u7f6e\u5bc6\u7801\u7684\u7528\u6237");
        }
        if (StrUtil.isBlank((CharSequence)plainPassword)) {
            throw new HealthException("\u9ed8\u8ba4\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OrganizationUser organizationUserV3 = this.getUserInfoById(id);
        if (Objects.isNull(organizationUserV3)) {
            throw new HealthException("\u8be5\u7528\u6237\u5df2\u4e0d\u5b58\u5728");
        }
        OrganizationUser user = new OrganizationUser();
        user.setId(id);
        this.setUpdateInfo(user, loginUserId);
        user = this.setPasswordInfo(user, plainPassword);
        boolean bl = b = ((OrganizationUserMapper)this.dao).updateByPrimaryKeySelective(user) > 0;
        if (b) {
            RedisUtils.deleteObject((String)("superivse-web" + Md5Utils.hash((String)StrUtil.toUpperCase((CharSequence)StrUtil.trim((CharSequence)organizationUserV3.getUsername())))));
        }
        return b;
    }

    @Transactional
    public void importOrganizationUserData(List<OrganizationUserV3ImportDto> dataList) {
        if (CollUtil.isEmpty(dataList)) {
            return;
        }
        Date date = new Date();
        ArrayList<OrganizationUser> rst = new ArrayList<OrganizationUser>(dataList.size());
        ArrayList<SysUserRoleV3> rst2 = new ArrayList<SysUserRoleV3>(dataList.size());
        for (OrganizationUserV3ImportDto dto : dataList) {
            OrganizationUser user = new OrganizationUser();
            user.setId(dto.getId());
            user.setOid(dto.getOid());
            user.setUsername(StrUtil.toUpperCase((CharSequence)StrUtil.trim((CharSequence)dto.getUsername())));
            user.setFullName(dto.getFullName());
            user.setDepartment(dto.getDepartment());
            user.setPost(dto.getPost());
            user.setIsManger(dto.getIsManger());
            user.setSystemWide(UserSystemWideEnum.ZLWQ.getCodeStr());
            user.setUserFrom(UserFromEnum.SUPERVISE.getCode());
            user.setCreateBy(dto.getLoginUserId());
            user.setCreateDate(date);
            user = this.setPasswordInfo(user, "Zjs@2022");
            user = this.setTelAndAccountId(user, dto.getTel());
            rst.add(user);
            SysUserRoleV3 userRole = new SysUserRoleV3();
            userRole.setId(Long.valueOf(this.idworker.nextId()));
            userRole.setUserId(user.getId());
            userRole.setRoleId(dto.getRole());
            userRole.setCreateBy(dto.getLoginUserId());
            userRole.setUpdateBy(dto.getLoginUserId());
            rst2.add(userRole);
        }
        int a = this.batchUpdateOrInsert(rst, OrganizationUserMapper.class, (item, mapper) -> mapper.insertSelective(item));
        if (a <= 0) {
            throw new HealthException(ResponseStateEnum.fail.getName());
        }
        this.sysUserRoleV3Service.batchUpdateOrInsert(rst2, SysUserRoleV3Mapper.class, (item, mapper) -> mapper.insertSelective(item));
    }

    @Transactional
    public Boolean save(OrganizationUserV3AddParam param) {
        if (Objects.isNull(param.getLoginUserId())) {
            throw new HealthException("\u7528\u6237\u4fe1\u606f\u6216\u767b\u5f55\u7528\u6237\u4e22\u5931");
        }
        if (!PhoneUtil.isMobile((CharSequence)param.getTel())) {
            throw new HealthException("\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        String username = StrUtil.toUpperCase((CharSequence)StrUtil.trim((CharSequence)param.getUsername()));
        if (this.isHaveThisUserName(username, null, null).booleanValue()) {
            throw new HealthException("\u8be5\u7528\u6237\u540d\u5df2\u7ecf\u5b58\u5728");
        }
        if (this.isHaveThisTelByType(param.getTel(), null, null).booleanValue()) {
            throw new HealthException("\u8be5\u624b\u673a\u53f7\u5df2\u88ab\u5176\u4ed6\u4eba\u4f7f\u7528");
        }
        OrganizationUser user = new OrganizationUser();
        SysRoleV3Vo role = this.sysRoleV3Service.selectRoleById(param.getRoleId());
        if (role.getIsManger() == 1) {
            List<OrganizationUser> userList = this.getUserInfoListByOid(param.getOid());
            if (CollUtil.isNotEmpty(userList) && userList.stream().anyMatch(i -> Boolean.TRUE.equals(i.getIsManger()))) {
                throw new HealthException("\u8be5\u7ec4\u7ec7\u5355\u4f4d\u5df2\u5b58\u5728\u7ba1\u7406\u5458\u7528\u6237");
            }
            user.setIsManger(Boolean.TRUE);
        } else {
            user.setIsManger(Boolean.FALSE);
        }
        user.setIsTest(role.getIsTest());
        user.setOid(param.getOid());
        user.setUsername(username);
        user.setFullName(param.getFullName());
        user.setDepartment(param.getDepartment());
        user.setPost(param.getPost());
        user.setSystemWide(param.getSystemWide());
        user.setUserFrom(UserFromEnum.SUPERVISE.getCode());
        user = this.setPasswordInfo(user, "Zjs@2022");
        user = this.setTelAndAccountId(user, param.getTel());
        if (role.getIsTest() == 1) {
            user.setIsDefaultPwd(Boolean.valueOf(false));
            user.setTimedPasswordReset(Byte.valueOf((byte)0));
            user.setTwoFactorCheck(Byte.valueOf((byte)0));
        } else {
            user.setTimedPasswordReset(Byte.valueOf((byte)1));
            user.setTwoFactorCheck(Byte.valueOf((byte)1));
            if (StrUtil.startWith((CharSequence)param.getLoginUserAreaId().toString(), (CharSequence)"33") && Objects.equals(user.getAccountId(), 0L)) {
                throw new HealthException("\u65e0\u6cd5\u7ed1\u5b9a\u672a\u6388\u6743\u7684\u6d59\u653f\u9489\u624b\u673a\u53f7");
            }
        }
        user = this.add(user, param.getLoginUserId(), null);
        SysUserRoleV3 userRole = new SysUserRoleV3();
        userRole.setUserId(user.getId());
        userRole.setRoleId(param.getRoleId());
        userRole.setCreateBy(param.getLoginUserId());
        userRole.setUpdateBy(param.getLoginUserId());
        this.sysUserRoleV3Service.add((Object)userRole);
        return Boolean.TRUE;
    }

    @Transactional
    public Boolean saveMaintenance(MaintenanceUserV3AddParam param) {
        if (Objects.isNull(param.getLoginUserId())) {
            throw new HealthException("\u7528\u6237\u4fe1\u606f\u6216\u767b\u5f55\u7528\u6237\u4e22\u5931");
        }
        String username = StrUtil.toUpperCase((CharSequence)StrUtil.trim((CharSequence)param.getUsername()));
        if (this.isHaveThisUserName(username, null, null).booleanValue()) {
            throw new HealthException("\u8be5\u7528\u6237\u540d\u5df2\u7ecf\u5b58\u5728");
        }
        OrganizationUser user = new OrganizationUser();
        SysRoleV3Vo role = this.sysRoleV3Service.selectRoleById(param.getRoleId());
        if (role.getIsManger() == 1) {
            user.setIsManger(Boolean.TRUE);
        } else {
            user.setIsManger(Boolean.FALSE);
        }
        user.setIsTest(role.getIsTest());
        user.setOid(Long.valueOf(0L));
        user.setUsername(username);
        user.setFullName(param.getFullName());
        user.setSystemWide(UserSystemWideEnum.MAINTENANCE.getCodeStr());
        user.setUserFrom(UserFromEnum.MAINTENANCE.getCode());
        user = this.setPasswordInfo(user, "Zjs@2022");
        user.setTimedPasswordReset(Byte.valueOf((byte)1));
        user.setTwoFactorCheck(Byte.valueOf((byte)0));
        user = this.add(user, param.getLoginUserId(), null);
        SysUserRoleV3 userRole = new SysUserRoleV3();
        userRole.setUserId(user.getId());
        userRole.setRoleId(param.getRoleId());
        userRole.setCreateBy(param.getLoginUserId());
        userRole.setUpdateBy(param.getLoginUserId());
        this.sysUserRoleV3Service.add((Object)userRole);
        return Boolean.TRUE;
    }

    @Transactional
    public Boolean update(OrganizationUserV3EditParam param) {
        if (Objects.isNull(param.getLoginUserId())) {
            throw new HealthException("\u7528\u6237\u4fe1\u606f\u6216\u767b\u5f55\u7528\u6237\u4e22\u5931");
        }
        if (Objects.nonNull(param.getTel()) && !PhoneUtil.isMobile((CharSequence)param.getTel())) {
            throw new HealthException("\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        if (this.isHaveThisTelByType(param.getTel(), null, param.getId()).booleanValue()) {
            throw new HealthException("\u8be5\u624b\u673a\u53f7\u5df2\u88ab\u5176\u4ed6\u4eba\u4f7f\u7528");
        }
        OrganizationUser oldUser = this.getUserInfoById(param.getId());
        if (Objects.isNull(oldUser)) {
            throw new HealthException("\u8be5\u7528\u6237\u4fe1\u606f\u5df2\u4e0d\u5b58\u5728");
        }
        OrganizationUser user = new OrganizationUser();
        SysRoleV3Vo role = this.sysRoleV3Service.selectRoleById(param.getRoleId());
        if (role.getIsManger() == 1) {
            List<OrganizationUser> userList = this.getUserInfoListByOid(param.getOid());
            if (CollUtil.isNotEmpty(userList) && userList.stream().anyMatch(i -> Boolean.TRUE.equals(i.getIsManger()) && !Objects.equals(i.getId(), param.getId()))) {
                throw new HealthException("\u8be5\u7ec4\u7ec7\u5355\u4f4d\u5df2\u5b58\u5728\u7ba1\u7406\u5458\u7528\u6237");
            }
            user.setIsManger(Boolean.TRUE);
        } else {
            user.setIsManger(Boolean.FALSE);
        }
        user.setIsTest(role.getIsTest());
        user.setId(param.getId());
        user.setOid(param.getOid());
        user.setFullName(param.getFullName());
        user.setDepartment(param.getDepartment());
        user.setPost(param.getPost());
        user.setSystemWide(param.getSystemWide());
        user = this.setTelAndAccountId(user, param.getTel());
        if (role.getIsTest() == 1) {
            user.setIsDefaultPwd(Boolean.valueOf(false));
            user.setTimedPasswordReset(Byte.valueOf((byte)0));
            user.setTwoFactorCheck(Byte.valueOf((byte)0));
        } else {
            user.setTimedPasswordReset(Byte.valueOf((byte)1));
            user.setTwoFactorCheck(Byte.valueOf((byte)1));
            if (StrUtil.startWith((CharSequence)param.getLoginUserAreaId().toString(), (CharSequence)"33") && Objects.equals(user.getAccountId(), 0L)) {
                throw new HealthException("\u65e0\u6cd5\u7ed1\u5b9a\u672a\u6388\u6743\u7684\u6d59\u653f\u9489\u624b\u673a\u53f7");
            }
        }
        this.update(user, param.getLoginUserId());
        this.sysUserRoleV3Service.deleteByUserId(param.getId(), param.getLoginUserId());
        SysUserRoleV3 userRole = new SysUserRoleV3();
        userRole.setUserId(user.getId());
        userRole.setRoleId(param.getRoleId());
        userRole.setCreateBy(param.getLoginUserId());
        userRole.setUpdateBy(param.getLoginUserId());
        this.sysUserRoleV3Service.add((Object)userRole);
        return Boolean.TRUE;
    }

    @Transactional
    public Boolean updateMaintenance(MaintenanceUserV3EditParam param) {
        if (Objects.isNull(param.getLoginUserId())) {
            throw new HealthException("\u7528\u6237\u4fe1\u606f\u6216\u767b\u5f55\u7528\u6237\u4e22\u5931");
        }
        OrganizationUser oldUser = this.getUserInfoById(param.getId());
        if (Objects.isNull(oldUser)) {
            throw new HealthException("\u8be5\u7528\u6237\u4fe1\u606f\u5df2\u4e0d\u5b58\u5728");
        }
        OrganizationUser user = new OrganizationUser();
        SysRoleV3Vo role = this.sysRoleV3Service.selectRoleById(param.getRoleId());
        if (role.getIsManger() == 1) {
            user.setIsManger(Boolean.TRUE);
        } else {
            user.setIsManger(Boolean.FALSE);
        }
        user.setIsTest(role.getIsTest());
        user.setId(param.getId());
        user.setOid(Long.valueOf(0L));
        user.setFullName(param.getFullName());
        user.setSystemWide(UserSystemWideEnum.MAINTENANCE.getCodeStr());
        user.setUserFrom(UserFromEnum.MAINTENANCE.getCode());
        user.setTimedPasswordReset(Byte.valueOf((byte)1));
        user.setTwoFactorCheck(Byte.valueOf((byte)0));
        this.update(user, param.getLoginUserId());
        this.sysUserRoleV3Service.deleteByUserId(param.getId(), param.getLoginUserId());
        SysUserRoleV3 userRole = new SysUserRoleV3();
        userRole.setUserId(user.getId());
        userRole.setRoleId(param.getRoleId());
        userRole.setCreateBy(param.getLoginUserId());
        userRole.setUpdateBy(param.getLoginUserId());
        this.sysUserRoleV3Service.add((Object)userRole);
        return Boolean.TRUE;
    }

    @Transactional
    public Boolean saveTownshipUser(TownshipUserV3AddParam param) {
        if (Objects.isNull(param.getLoginUserId())) {
            throw new HealthException("\u7528\u6237\u4fe1\u606f\u6216\u767b\u5f55\u7528\u6237\u4e22\u5931");
        }
        if (!PhoneUtil.isMobile((CharSequence)param.getTel())) {
            throw new HealthException("\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        Organization organization = this.organizationService.getOrgById(param.getOid());
        if (organization.getLevel() < 4) {
            throw new HealthException("\u7ec4\u7ec7\u5355\u4f4d\u9700\u9009\u62e9\u5230\u4e61\u9547\u8857\u9053\u7ea7\u522b");
        }
        String username = StrUtil.toUpperCase((CharSequence)StrUtil.trim((CharSequence)param.getUsername()));
        if (this.isHaveThisUserName(username, null, null).booleanValue()) {
            throw new HealthException("\u8be5\u7528\u6237\u540d\u5df2\u7ecf\u5b58\u5728");
        }
        if (this.isHaveThisTelByRoleId(param.getTel(), null, null).booleanValue()) {
            throw new HealthException("\u8be5\u624b\u673a\u53f7\u5df2\u88ab\u5176\u4ed6\u4eba\u4f7f\u7528");
        }
        OrganizationUser user = new OrganizationUser();
        user.setOid(param.getOid());
        user.setUsername(username);
        user.setFullName(param.getFullName());
        user.setDepartment(param.getDepartment());
        user.setPost(param.getPost());
        user.setIsManger(Boolean.FALSE);
        user.setSystemWide(param.getSystemWide());
        user.setUserFrom(UserFromEnum.SUPERVISE.getCode());
        user = this.setPasswordInfo(user, "Zyj@2022");
        user = this.setTelAndAccountId(user, param.getTel());
        user.setTimedPasswordReset(Byte.valueOf((byte)1));
        user.setTwoFactorCheck(Byte.valueOf((byte)1));
        if (StrUtil.startWith((CharSequence)param.getLoginUserAreaId().toString(), (CharSequence)"33") && Objects.equals(user.getAccountId(), 0L)) {
            throw new HealthException("\u65e0\u6cd5\u7ed1\u5b9a\u672a\u6388\u6743\u7684\u6d59\u653f\u9489\u624b\u673a\u53f7");
        }
        user = this.add(user, param.getLoginUserId(), null);
        SysUserRoleV3 userRole = new SysUserRoleV3();
        userRole.setUserId(user.getId());
        userRole.setRoleId(Long.valueOf(UserRolesEnum.townshipCoordinator.getValue().byteValue()));
        userRole.setCreateBy(param.getLoginUserId());
        userRole.setUpdateBy(param.getLoginUserId());
        this.sysUserRoleV3Service.add((Object)userRole);
        return Boolean.TRUE;
    }

    private OapiSpResultContent getOapiSpResultContent(String tel) {
        IntelligentGetClient intelligentGetClient = this.executableClient.newIntelligentGetClient("/mozi/employee/get_by_mobile");
        OapiMoziEmployeeGetByMobileRequest oapiMoziEmployeeGetByMobileRequest = new OapiMoziEmployeeGetByMobileRequest();
        oapiMoziEmployeeGetByMobileRequest.setAreaCode("86");
        oapiMoziEmployeeGetByMobileRequest.setTenantId(this.zwddProperties.getTenantId());
        oapiMoziEmployeeGetByMobileRequest.setNamespace("local");
        oapiMoziEmployeeGetByMobileRequest.setMobile(tel);
        OapiMoziEmployeeGetByMobileResponse apiResult = (OapiMoziEmployeeGetByMobileResponse)intelligentGetClient.get((OapiRequest)oapiMoziEmployeeGetByMobileRequest);
        this.logger.info("\u6d59\u653f\u9489[/mozi/employee/get_by_mobile]\u8fd4\u56de\uff1a{}", (Object)JSON.toJSONString((Object)apiResult));
        return Objects.isNull(apiResult) ? new OapiSpResultContent() : apiResult.getContent();
    }

    @Transactional
    public Boolean updateTownshipUser(TownshipUserV3EditParam param) {
        if (Objects.isNull(param.getLoginUserId())) {
            throw new HealthException("\u7528\u6237\u4fe1\u606f\u6216\u767b\u5f55\u7528\u6237\u4e22\u5931");
        }
        if (Objects.nonNull(param.getTel()) && !PhoneUtil.isMobile((CharSequence)param.getTel())) {
            throw new HealthException("\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        Organization organization = this.organizationService.getOrgById(param.getOid());
        if (organization.getLevel() < 4) {
            throw new HealthException("\u7ec4\u7ec7\u5355\u4f4d\u9700\u9009\u62e9\u5230\u4e61\u9547\u8857\u9053\u7ea7\u522b");
        }
        if (this.isHaveThisTelByRoleId(param.getTel(), null, param.getId()).booleanValue()) {
            throw new HealthException("\u8be5\u624b\u673a\u53f7\u5df2\u88ab\u5176\u4ed6\u4eba\u4f7f\u7528");
        }
        OrganizationUser oldUser = this.getUserInfoById(param.getId());
        if (Objects.isNull(oldUser)) {
            throw new HealthException("\u8be5\u7528\u6237\u4fe1\u606f\u5df2\u4e0d\u5b58\u5728");
        }
        OrganizationUser user = new OrganizationUser();
        user.setId(param.getId());
        user.setOid(param.getOid());
        user.setFullName(param.getFullName());
        user.setDepartment(param.getDepartment());
        user.setPost(param.getPost());
        user.setSystemWide(param.getSystemWide());
        user = this.setTelAndAccountId(user, param.getTel());
        if (StrUtil.startWith((CharSequence)param.getLoginUserAreaId().toString(), (CharSequence)"33") && Objects.equals(user.getAccountId(), 0L)) {
            throw new HealthException("\u65e0\u6cd5\u7ed1\u5b9a\u672a\u6388\u6743\u7684\u6d59\u653f\u9489\u624b\u673a\u53f7");
        }
        this.update(user, param.getLoginUserId());
        return Boolean.TRUE;
    }

    @Transactional
    public List<OrganizationUser> isDefaultPwdList() {
        Example example = new Example(OrganizationUser.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("isDefaultPwd", (Object)Boolean.FALSE).andEqualTo("isValid", (Object)Boolean.TRUE);
        List list = ((OrganizationUserMapper)this.dao).selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        String defaultPwdMD5 = MD5Utils.getMD5String((String)"Zyj@2022");
        String defaultSupervisePwdMD5 = MD5Utils.getMD5String((String)"Zjs@2022");
        List<OrganizationUser> rst = list.parallelStream().filter(user -> {
            byte[] salt = Encodes.hexDecode((String)user.getSalt());
            byte[] hashPassword1 = Digests.sha1((byte[])defaultPwdMD5.getBytes(), (byte[])salt, (int)1024);
            String inputPasswordHash1 = Encodes.hexEncode((byte[])hashPassword1);
            byte[] hashPassword2 = Digests.sha1((byte[])defaultSupervisePwdMD5.getBytes(), (byte[])salt, (int)1024);
            String inputPasswordHash2 = Encodes.hexEncode((byte[])hashPassword2);
            return Objects.equals(inputPasswordHash1, user.getPassword()) || Objects.equals(inputPasswordHash2, user.getPassword());
        }).collect(Collectors.toList());
        this.batchUpdateOrInsert(rst, OrganizationUserMapper.class, (e, mapper) -> mapper.updateByPrimaryKeySelective(e));
        return rst;
    }

    public Boolean importOrganizationUser(Long fileId, Long loginUserId) {
        SysFileModel file = this.sysFileProvideService.getFileById(fileId);
        if (Objects.isNull(file)) {
            throw new HealthException("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        if (Objects.nonNull(this.ossClientBean)) {
            String ossUrl = this.ossClientBean.getUrl(file.getOssUrl());
            try (InputStream inputStream = ExcelUtil.getInstance().getOssInputStream(ossUrl);
                 ExcelReader excelReader = EasyExcel.read((InputStream)inputStream).build();){
                excelReader.read(new ReadSheet[]{((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet().headRowNumber(Integer.valueOf(2))).head(OrganizationUserV3ImportDto.class)).registerReadListener((ReadListener)new SysOrganizationUserImportListener(loginUserId, this.areaService, this.organizationService, this))).build()});
            }
            catch (Exception e) {
                throw new HealthException(ErrorEnum.FAIL_DEAL, e.getMessage());
            }
        }
        return Boolean.TRUE;
    }

    public Boolean importTownshipUser(Long fileId, Long loginUserId) {
        SysFileModel file = this.sysFileProvideService.getFileById(fileId);
        if (Objects.isNull(file)) {
            throw new HealthException("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        if (Objects.nonNull(this.ossClientBean)) {
            String ossUrl = this.ossClientBean.getUrl(file.getOssUrl());
            try (InputStream inputStream = ExcelUtil.getInstance().getOssInputStream(ossUrl);
                 ExcelReader excelReader = EasyExcel.read((InputStream)inputStream).build();){
                excelReader.read(new ReadSheet[]{((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet().headRowNumber(Integer.valueOf(2))).head(TownshipUserImportDto.class)).registerReadListener((ReadListener)new SysTownshipUserImportListener(loginUserId, this.areaService, this.organizationService, this))).build()});
            }
            catch (Exception e) {
                throw new HealthException(ErrorEnum.FAIL_DEAL, e.getMessage());
            }
        }
        return Boolean.TRUE;
    }

    @XxlJob(value="v3-setTelAndAccountId")
    @Transactional
    public void setTelAndAccountId() {
        XxlJobHelper.log((String)"\u8bbe\u7f6etel\u548caccountId\u9ed8\u8ba4\u503c\u5f00\u59cb", (Object[])new Object[0]);
        Example example = new Example(OrganizationUser.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIsNotNull("tel");
        List list = this.getListByExample(example);
        if (CollUtil.isNotEmpty(list)) {
            XxlJobHelper.log((String)"setTelAndAccountId.size\uff08{}\uff09\u6761,", (Object[])new Object[]{list.size()});
            ArrayList<OrganizationUser> rst = new ArrayList<OrganizationUser>(list.size());
            for (OrganizationUser userV3 : list) {
                OrganizationUser user = new OrganizationUser();
                user.setId(userV3.getId());
                user = this.setTelAndAccountId(user, userV3.getTel());
                rst.add(user);
            }
            if (CollUtil.isNotEmpty(rst)) {
                XxlJobHelper.log((String)"setTelAndAccountId.\u9700\u5904\u7406\uff08{}\uff09\u6761,", (Object[])new Object[]{rst.size()});
                this.batchUpdateOrInsert(rst, OrganizationUserMapper.class, (item, mapper) -> mapper.updateByPrimaryKeySelective(item));
            }
        }
        XxlJobHelper.log((String)"\u8bbe\u7f6etel\u548caccountId\u9ed8\u8ba4\u503c\u7ed3\u675f", (Object[])new Object[0]);
    }

    @XxlJob(value="v3-setIsForbidden")
    @Transactional
    public void setIsForbidden() {
        XxlJobHelper.log((String)"\u8bbe\u7f6eisForbidden\u5f00\u59cb", (Object[])new Object[0]);
        ArrayList<OrganizationUser> rst = new ArrayList<OrganizationUser>();
        OrganizationUserV3ListParam param = new OrganizationUserV3ListParam();
        param.setPage(1);
        param.setRows(Integer.MAX_VALUE);
        param.setIsForbidden(Boolean.valueOf(false));
        param.setCount(Boolean.FALSE);
        param.setIsOnlineSpecialTestUser(Boolean.valueOf(false));
        param.setIsBind(Boolean.FALSE);
        List list = this.getOrganizationUserList(param).getList();
        if (CollUtil.isNotEmpty((Collection)list)) {
            XxlJobHelper.log((String)"setIsForbidden-list.size\uff08{}\uff09\u6761,", (Object[])new Object[]{list.size()});
            for (OrganizationUserV3ListVo userV3 : list) {
                if (userV3.getAreaLevel() <= 1 || !ObjectUtil.isNull((Object)userV3.getAccountId()) && userV3.getAccountId() != 0L && !StrUtil.isBlank((CharSequence)userV3.getTel())) continue;
                OrganizationUser user = new OrganizationUser();
                user.setId(userV3.getId());
                user.setIsForbidden(Boolean.valueOf(true));
                rst.add(user);
            }
        }
        TownshipUserV3ListParam param2 = new TownshipUserV3ListParam();
        param2.setPage(1);
        param2.setRows(Integer.MAX_VALUE);
        param2.setIsForbidden(Boolean.valueOf(false));
        param2.setCount(Boolean.FALSE);
        param2.setIsBind(Boolean.FALSE);
        List list2 = this.getTownshipUserList(param2).getList();
        if (CollUtil.isNotEmpty((Collection)list2)) {
            XxlJobHelper.log((String)"setIsForbidden-list2.size\uff08{}\uff09\u6761,", (Object[])new Object[]{list2.size()});
            for (TownshipUserV3ListVo userV3 : list2) {
                if (!ObjectUtil.isNull((Object)userV3.getAccountId()) && userV3.getAccountId() != 0L && !StrUtil.isBlank((CharSequence)userV3.getTel())) continue;
                OrganizationUser user = new OrganizationUser();
                user.setId(userV3.getId());
                user.setIsForbidden(Boolean.valueOf(true));
                rst.add(user);
            }
        }
        if (CollUtil.isNotEmpty(rst)) {
            XxlJobHelper.log((String)"setIsForbidden.\u9700\u5904\u7406\uff08{}\uff09\u6761,", (Object[])new Object[]{rst.size()});
            this.batchUpdateOrInsert(rst, OrganizationUserMapper.class, (item, mapper) -> mapper.updateByPrimaryKeySelective(item));
        }
        XxlJobHelper.log((String)"\u8bbe\u7f6eisForbidden\u7ed3\u675f", (Object[])new Object[0]);
    }
}

