/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.basic;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.tree.Tree;
import cn.hutool.core.lang.tree.TreeNodeConfig;
import cn.hutool.core.lang.tree.TreeUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.framework.Constants;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseSearchModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.entity.base.company.CompanySoft;
import cn.smarthse.modules.health.supervise.dao.basic.OrganizationMapper;
import cn.smarthse.modules.health.supervise.entity.basic.Organization;
import cn.smarthse.modules.health.supervise.entity.sys.SysArea;
import cn.smarthse.modules.health.supervise.enums.sys.OrganizationTypeEnum;
import cn.smarthse.modules.health.supervise.model.sys.v3.organization.OrganizationV3AddParam;
import cn.smarthse.modules.health.supervise.model.sys.v3.organization.OrganizationV3CurrentAreaIdTreeParam;
import cn.smarthse.modules.health.supervise.model.sys.v3.organization.OrganizationV3EditParam;
import cn.smarthse.modules.health.supervise.model.sys.v3.organization.OrganizationV3ImportDto;
import cn.smarthse.modules.health.supervise.model.sys.v3.organization.OrganizationV3ListParam;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationService;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationUserService;
import cn.smarthse.modules.health.supervise.service.company.IDcCompanyService;
import cn.smarthse.modules.health.supervise.service.company.IThirdCompanySoftService;
import cn.smarthse.modules.health.supervise.vo.sys.v3.organization.OrganizationV3IsDelegateVo;
import cn.smarthse.modules.health.supervise.vo.sys.v3.organization.OrganizationV3ListVo;
import cn.smarthse.modules.health.supervise.vo.sys.v3.organization.OrganizationV3OneVo;
import cn.smarthse.modules.health.supervise.vo.sys.v3.organization.OrganizationV3TreeVo;
import cn.smarthse.modules.platform.model.AreaModel;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@DubboService
@Transactional(readOnly=true)
public class OrganizationServiceImpl
extends BaseServiceImpl<OrganizationMapper, Organization>
implements IOrganizationService {
    @Autowired
    private IOrganizationUserService organizationUserService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @DubboReference
    private IThirdCompanySoftService thirdCompanySoftService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @DubboReference
    private IDcCompanyService dcCompanyService;
    @Autowired
    private RedisClient redisClient;

    public Organization getOrganizationByAreaId(Long areaId) {
        if (areaId == null) {
            return null;
        }
        Example example = new Example(Organization.class);
        example.createCriteria().andEqualTo("isValid", (Object)Boolean.TRUE).andEqualTo("areaId", (Object)areaId).andEqualTo("isDelegate", (Object)Boolean.TRUE).andEqualTo("organizationType", (Object)OrganizationTypeEnum.HEALTH_CONSTRUCTION_SYSTEM.getValue());
        List list = ((OrganizationMapper)this.dao).selectByExample(example);
        if (CollUtil.isNotEmpty((Collection)list) && list.size() == 1) {
            return (Organization)list.get(0);
        }
        return null;
    }

    public Map<Long, Organization> getOrganizationMapByAreaIdList(List<Long> areaIdList) {
        if (CollUtil.isEmpty(areaIdList)) {
            return Collections.emptyMap();
        }
        Example example = new Example(Organization.class);
        example.createCriteria().andEqualTo("isValid", (Object)Boolean.TRUE).andIn("areaId", areaIdList).andEqualTo("isDelegate", (Object)Boolean.TRUE).andEqualTo("organizationType", (Object)OrganizationTypeEnum.HEALTH_CONSTRUCTION_SYSTEM.getValue());
        List list = ((OrganizationMapper)this.dao).selectByExample(example);
        if (CollUtil.isNotEmpty((Collection)list) && list.size() == areaIdList.size()) {
            return list.stream().collect(Collectors.toMap(Organization::getAreaId, item -> item, (v1, v2) -> v1));
        }
        return Collections.emptyMap();
    }

    private List<Organization> getOrganizationListByAreaId(Long areaId, Byte level) {
        if (areaId == null) {
            return new ArrayList<Organization>();
        }
        Example example = new Example(Organization.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("areaId", (Object)areaId).andGreaterThanOrEqualTo("level", (Object)level);
        return ((OrganizationMapper)this.dao).selectByExample(example);
    }

    @Override
    public Organization getById(Long id) {
        if (id == null) {
            return null;
        }
        Organization organ = (Organization)((OrganizationMapper)this.dao).selectByPrimaryKey(id);
        if (organ != null) {
            AreaModel areaById = this.sysAreaProvideService.getAreaById(organ.getAreaId());
            SysArea sysArea = new SysArea();
            BeanUtils.copyProperties((Object)areaById, (Object)sysArea);
            organ.setSysArea(sysArea);
        }
        return organ;
    }

    @Deprecated
    public List<Organization> getParentOrgansByAreaId(Long areaId) {
        ArrayList<Organization> list = new ArrayList<Organization>();
        AreaModel areaById = this.sysAreaProvideService.getAreaById(areaId);
        SysArea area = new SysArea();
        BeanUtils.copyProperties((Object)areaById, (Object)area);
        while (area != null && area.getId() != null) {
            List<Organization> orgList = this.getOrganizationListByAreaId(area.getId(), area.getLevel());
            list.addAll(orgList);
            AreaModel areaById2 = this.sysAreaProvideService.getAreaById(area.getParentId());
            SysArea area2 = new SysArea();
            BeanUtils.copyProperties((Object)areaById2, (Object)area2);
            area = area2;
        }
        return list;
    }

    @Deprecated
    public Organization getNearestOrganHasUserByCidAnd(Long cid) {
        if (cid == null) {
            return null;
        }
        CompanySuperviseModel companyInfo = this.companyProvideBySuperviseService.getCompanyInfoById(cid);
        if (companyInfo == null) {
            return null;
        }
        Organization organ = this.getAreaNearOrganByAreaId(companyInfo.getAreaId());
        return this.getHasUserOrgan(organ);
    }

    private Organization getHasUserOrgan(Organization organ) {
        if (organ == null) {
            return null;
        }
        if (Constants.NATIONAL_LEVEL_ID.equals(organ.getId())) {
            return organ;
        }
        int count = this.organizationUserService.getCountByOid(organ.getId());
        if (count > 0) {
            return organ;
        }
        if (organ.getPid() == null) {
            return null;
        }
        return this.getHasUserOrgan(this.getById(organ.getPid()));
    }

    private Organization getAreaNearOrganByAreaId(Long areaId) {
        if (areaId == null) {
            return null;
        }
        Organization organ = this.getOrganizationByAreaId(areaId);
        if (organ == null) {
            AreaModel areaById = this.sysAreaProvideService.getAreaById(areaId);
            SysArea sysArea = new SysArea();
            BeanUtils.copyProperties((Object)areaById, (Object)sysArea);
            return this.getAreaNearOrganByAreaId(sysArea.getParentId());
        }
        return organ;
    }

    @Deprecated
    public Organization getNearestOrganHasUserByPlatCidAnd(Long cid) {
        if (cid == null) {
            return null;
        }
        CompanySoft company = this.thirdCompanySoftService.getCompanySoftByPcid(cid);
        if (company == null || company.getCid() == null) {
            return null;
        }
        CompanySuperviseModel companyInfo = this.companyProvideBySuperviseService.getCompanyInfoById(cid);
        if (companyInfo == null) {
            return null;
        }
        Organization organ = this.getAreaNearOrganByAreaId(companyInfo.getAreaId());
        return this.getHasUserOrgan(organ);
    }

    @Transactional
    public void setCompanySupervisionUnit() {
        ArrayList<Long> areaIdList = new ArrayList<Long>();
        areaIdList.add(330000000000L);
        areaIdList.add(350000000000L);
        areaIdList.add(650000000000L);
        areaIdList.add(660000000000L);
        this.setCompanySupervisionUnit(areaIdList);
    }

    public void setCompanySupervisionUnit(List<Long> areaIdList) {
        areaIdList.forEach(areaId -> {
            Byte areaLevel = 1;
            List<Organization> childNodes = ((OrganizationMapper)this.dao).getChildNodes((Long)areaId, null, areaLevel, false, true);
            this.getAndSetSupervisionUnit(childNodes, 1, 1);
            this.getAndSetSupervisionUnit(childNodes, 2, 2);
            this.getAndSetSupervisionUnit(childNodes, 3, 0);
        });
    }

    public List<Organization> getSupervisionUnitByAreaId(Long areaId) {
        Example example = new Example(Organization.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("isSupervisionUnit", (Object)1).andEqualTo("areaId", (Object)areaId);
        return ((OrganizationMapper)this.dao).selectByExample(example);
    }

    @Transactional
    public void generateAllOrganizationAncestorIdTree() {
        ((OrganizationMapper)this.dao).generateAllOrganizationAncestorIdTree();
    }

    private void getAndSetSupervisionUnit(List<Organization> childNodes, Integer areaLevel, Integer belongType) {
        childNodes.forEach(organizationItem -> {
            if (organizationItem.getAreaLevel() != null && organizationItem.getAreaLevel() == areaLevel) {
                CompanySuperviseSearchModel companySearchVo = new CompanySuperviseSearchModel();
                companySearchVo.setAreaId(organizationItem.getAreaId());
                companySearchVo.setAreaLevel(Byte.valueOf((byte)organizationItem.getAreaLevel().intValue()));
                companySearchVo.setBelongType(belongType);
                List companyIdList = this.dcCompanyService.getNoSupervisionUnitCompany(companySearchVo);
                if (CollUtil.isNotEmpty((Collection)companyIdList)) {
                    for (int a = 0; a < companyIdList.size(); a += 500) {
                        int length = a + 500;
                        if (length > companyIdList.size()) {
                            length = companyIdList.size();
                        }
                        List newList = companyIdList.subList(a, length);
                        this.companyProvideBySuperviseService.updateCompanySuperviseUnit(organizationItem.getId(), organizationItem.getAreaId(), newList);
                    }
                }
            }
        });
    }

    @Transactional
    public Boolean maintenanceTreePath() {
        Example example = new Example(Organization.class);
        List allOrganizationV3List = this.getListByExample(example);
        if (CollUtil.isNotEmpty(allOrganizationV3List)) {
            Map<Long, Organization> organizationMap = allOrganizationV3List.stream().collect(Collectors.toMap(Organization::getId, item -> item, (v1, v2) -> v1));
            ArrayList<Organization> updateList = new ArrayList<Organization>();
            for (Organization organization : allOrganizationV3List) {
                int level = organization.getLevel();
                if (level == 0) continue;
                StringBuffer buffer = new StringBuffer();
                Organization pOrganization = organizationMap.get(organization.getPid());
                while (level > 0) {
                    if (Objects.isNull(pOrganization)) {
                        this.logger.error("pid\u4e0d\u6b63\u5e38\u7684\u6570\u636e\uff1a{}", (Object)organization);
                        break;
                    }
                    buffer.insert(0, pOrganization.getId() + ",");
                    level = pOrganization.getLevel();
                    pOrganization = organizationMap.get(pOrganization.getPid());
                }
                Organization update = new Organization();
                update.setId(organization.getId());
                update.setTreePath(buffer.toString());
                updateList.add(update);
            }
            if (CollUtil.isNotEmpty(updateList)) {
                this.batchUpdateOrInsert(updateList, OrganizationMapper.class, (item, mapper) -> mapper.updateByPrimaryKeySelective(item));
            }
        }
        return Boolean.TRUE;
    }

    @Transactional
    public Boolean maintenanceInnerTreePath(Long areaId) {
        Example example2 = new Example(Organization.class);
        Example.Criteria criteria = example2.createCriteria();
        criteria.andEqualTo("organizationType", (Object)2);
        if (Objects.nonNull(areaId)) {
            criteria.andEqualTo("areaId", (Object)areaId);
        } else {
            criteria.andGreaterThan("innerLevel", (Object)0);
        }
        List organizationV3ListById = this.getListByExample(example2);
        Example example = new Example(Organization.class);
        List allOrganizationV3List = this.getListByExample(example);
        if (CollUtil.isNotEmpty(organizationV3ListById)) {
            Map<Long, Organization> organizationMap = allOrganizationV3List.stream().collect(Collectors.toMap(Organization::getId, item -> item, (v1, v2) -> v1));
            ArrayList<Organization> updateList = new ArrayList<Organization>();
            for (Organization organization : organizationV3ListById) {
                int level = organization.getInnerLevel();
                if (level == 0) continue;
                StringBuffer buffer = new StringBuffer();
                Organization pOrganization = organizationMap.get(organization.getInnerPid());
                while (level > 0) {
                    if (Objects.isNull(pOrganization)) {
                        this.logger.error("innerPid\u4e0d\u6b63\u5e38\u7684\u6570\u636e\uff1a{}", (Object)organization);
                        break;
                    }
                    buffer.insert(0, pOrganization.getId() + ",");
                    level = pOrganization.getInnerLevel();
                    pOrganization = organizationMap.get(pOrganization.getInnerPid());
                }
                Organization update = new Organization();
                update.setId(organization.getId());
                update.setInnerTreePath(buffer.toString());
                updateList.add(update);
            }
            if (CollUtil.isNotEmpty(updateList)) {
                this.batchUpdateOrInsert(updateList, OrganizationMapper.class, (item, mapper) -> mapper.updateByPrimaryKeySelective(item));
            }
        }
        return Boolean.TRUE;
    }

    @Transactional
    public Boolean maintenanceDelegateInnerTreePath(Integer organizationType) {
        if (Objects.isNull(organizationType)) {
            throw new HealthException("organizationType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<OrganizationV3IsDelegateVo> allOrganizationList = ((OrganizationMapper)this.dao).getOrganizationV3IsDelegateVoList(organizationType, 0L, (byte)0);
        if (CollUtil.isEmpty(allOrganizationList)) {
            throw new HealthException("allOrganizationList\u65e0\u6570\u636e");
        }
        Map<Long, OrganizationV3IsDelegateVo> organizationMap1 = allOrganizationList.stream().filter(i -> i.getOrgLevel() == 1).collect(Collectors.toMap(OrganizationV3IsDelegateVo::getProvinceId, item -> item));
        Map<Long, OrganizationV3IsDelegateVo> organizationMap2 = allOrganizationList.stream().filter(i -> i.getOrgLevel() == 2).collect(Collectors.toMap(OrganizationV3IsDelegateVo::getCityId, item -> item));
        Map<Long, OrganizationV3IsDelegateVo> organizationMap3 = allOrganizationList.stream().filter(i -> i.getOrgLevel() == 3).collect(Collectors.toMap(OrganizationV3IsDelegateVo::getAreaId, item -> item));
        ArrayList<Organization> dtoList = new ArrayList<Organization>(allOrganizationList.size());
        for (OrganizationV3IsDelegateVo dto : allOrganizationList) {
            Organization org = new Organization();
            org.setId(dto.getOrgId());
            org.setLevel(dto.getOrgLevel());
            if (dto.getOrgLevel() == 0) {
                org.setDelegatePid(Long.valueOf(999999999999L));
            } else if (dto.getOrgLevel() == 1) {
                org.setDelegatePid(Long.valueOf(OrganizationTypeEnum.HEALTH_CONSTRUCTION_SYSTEM.getValue().equals(organizationType) ? 0L : 1000L));
            } else if (dto.getOrgLevel() == 2) {
                if (!organizationMap1.containsKey(dto.getProvinceId())) {
                    throw new HealthException(String.format("\u5b58\u5728\u5f02\u5e38\u6570\u636e ID:%s", dto.getOrgId()));
                }
                org.setDelegatePid(organizationMap1.get(dto.getProvinceId()).getOrgId());
            } else if (dto.getOrgLevel() == 3) {
                if (!organizationMap2.containsKey(dto.getCityId())) {
                    throw new HealthException(String.format("\u5b58\u5728\u5f02\u5e38\u6570\u636e ID:%s", dto.getOrgId()));
                }
                org.setDelegatePid(organizationMap2.get(dto.getCityId()).getOrgId());
            } else if (dto.getOrgLevel() == 4) {
                if (!organizationMap3.containsKey(dto.getAreaId())) {
                    throw new HealthException(String.format("\u5b58\u5728\u5f02\u5e38\u6570\u636e ID:%s", dto.getOrgId()));
                }
                org.setDelegatePid(organizationMap3.get(dto.getAreaId()).getOrgId());
            }
            dtoList.add(org);
        }
        if (CollUtil.isNotEmpty(dtoList)) {
            Map<Long, Organization> organizationMap = dtoList.stream().collect(Collectors.toMap(Organization::getId, item -> item, (v1, v2) -> v1));
            ArrayList<Organization> updateList = new ArrayList<Organization>(dtoList.size());
            for (Organization organization : dtoList) {
                int level = organization.getLevel();
                if (level == 0) continue;
                StringBuffer buffer = new StringBuffer();
                Organization pOrganization = organizationMap.get(organization.getDelegatePid());
                while (level > 0) {
                    if (Objects.isNull(pOrganization)) {
                        this.logger.error("delegatePid\u4e0d\u6b63\u5e38\u7684\u6570\u636e\uff1a{}", (Object)organization);
                        break;
                    }
                    buffer.insert(0, pOrganization.getId() + ",");
                    level = pOrganization.getLevel();
                    pOrganization = organizationMap.get(pOrganization.getDelegatePid());
                }
                Organization update = new Organization();
                update.setId(organization.getId());
                update.setDelegatePid(organization.getDelegatePid());
                update.setDelegateTreePath(buffer.toString());
                updateList.add(update);
            }
            if (CollUtil.isNotEmpty(updateList)) {
                this.batchUpdateOrInsert(updateList, OrganizationMapper.class, (item, mapper) -> mapper.updateByPrimaryKeySelective(item));
            }
        }
        return Boolean.TRUE;
    }

    public List<Map<String, String>> getNoDeDelegateAreaIdList(Integer organizationType, Long searchAreaId, Byte searchAreaLevel) {
        if (Objects.isNull(organizationType)) {
            throw new HealthException("\u8bf7\u786e\u5b9aorganizationType\u503c");
        }
        return ((OrganizationMapper)this.dao).getNoDeDelegateAreaIdList(organizationType, searchAreaId, searchAreaLevel);
    }

    @Transactional
    public void importOrganizationData(List<OrganizationV3ImportDto> dataList) {
        if (CollUtil.isEmpty(dataList)) {
            return;
        }
        Date date = new Date();
        ArrayList<Organization> rst = new ArrayList<Organization>(dataList.size());
        for (OrganizationV3ImportDto dto : dataList) {
            Organization org = new Organization();
            org.setId(dto.getId());
            org.setOrganizationType(dto.getOrganizationType());
            org.setPid(dto.getPid());
            org.setName(dto.getName());
            org.setLevel(dto.getLevel());
            org.setInnerPid(dto.getInnerPid());
            org.setInnerLevel(dto.getInnerLevel());
            org.setAreaId(dto.getAreaId());
            org.setControlRegion(dto.getControlRegion());
            org.setIsDelegate(dto.getIsDelegate());
            org.setCreateDate(date);
            rst.add(org);
        }
        if (this.batchUpdateOrInsert(rst, OrganizationMapper.class, (item, mapper) -> mapper.insertSelective(item)) < 1) {
            throw new HealthException(ResponseStateEnum.fail.getName());
        }
    }

    @Transactional
    public void rollbackImportData(List<Long> idList) {
        if (CollUtil.isEmpty(idList)) {
            return;
        }
        Example example = new Example(Organization.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("id", idList).andEqualTo("isValid", (Object)Boolean.TRUE);
        Organization organizationV3 = new Organization();
        organizationV3.setIsValid(Boolean.FALSE);
        organizationV3.setUpdateDate(new Date());
        ((OrganizationMapper)this.dao).updateByExampleSelective(organizationV3, example);
    }

    public JqGridData<OrganizationV3ListVo> getList(OrganizationV3ListParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<OrganizationV3ListVo> rst = ((OrganizationMapper)this.dao).getList(param);
        if (CollUtil.isNotEmpty(rst)) {
            String pids = rst.stream().map(i -> String.valueOf(i.getPid())).collect(Collectors.joining(","));
            List pOrgList = this.getListByIds(pids);
            Map<Long, String> map = pOrgList.stream().collect(Collectors.toMap(Organization::getId, Organization::getName, (v1, v2) -> v1));
            Map<Long, Long> map2 = pOrgList.stream().collect(Collectors.toMap(Organization::getId, Organization::getAreaId, (v1, v2) -> v1));
            for (OrganizationV3ListVo row : rst) {
                row.setPname(map.getOrDefault(row.getPid(), ""));
                row.setParentAreaId(map2.getOrDefault(row.getPid(), 0L));
                row.setControlRegionName(this.sysAreaProvideService.getAreaListByIds(row.getControlRegion()).stream().map(i -> i.getFullname(">")).collect(Collectors.joining(",")));
            }
        }
        return new JqGridData((Page)rst, (JqGridParam)param);
    }

    public Organization getOrgById(Long id) {
        return (Organization)((OrganizationMapper)this.dao).selectByPrimaryKey(id);
    }

    public List<Organization> getOrgListByIdList(Set<Long> idList) {
        if (CollUtil.isEmpty(idList)) {
            return Collections.emptyList();
        }
        Example example = new Example(Organization.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("id", idList);
        return ((OrganizationMapper)this.dao).selectByExample(example);
    }

    public Map<Long, Organization> getOrgMapByIdList(Set<Long> idList) {
        if (CollUtil.isEmpty(idList)) {
            return Collections.emptyMap();
        }
        return this.getOrgListByIdList(idList).stream().collect(Collectors.toMap(Organization::getId, item -> item, (v1, v2) -> v1));
    }

    public List<Organization> getAllOrg() {
        Organization org = new Organization();
        org.setIsValid(Boolean.TRUE);
        return ((OrganizationMapper)this.dao).select(org);
    }

    public Map<Long, Organization> getOrganizationByAreaIdList(Set<Long> areaIdList, Integer organizationType) {
        if (CollUtil.isEmpty(areaIdList) || Objects.isNull(organizationType)) {
            return Collections.emptyMap();
        }
        Example example = new Example(Organization.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andIn("areaId", areaIdList).andEqualTo("isDelegate", (Object)true).andEqualTo("organizationType", (Object)organizationType);
        return ((OrganizationMapper)this.dao).selectByExample(example).stream().collect(Collectors.toMap(Organization::getAreaId, item -> item, (v1, v2) -> v1));
    }

    @Transactional
    public Boolean save(OrganizationV3AddParam param) {
        boolean b;
        Organization pEntity = this.getOrgById(param.getPid());
        if (Objects.isNull(pEntity)) {
            throw new HealthException("\u8be5\u4e0a\u7ea7\u7ec4\u7ec7\u5355\u4f4d\u5df2\u4e0d\u5b58\u5728");
        }
        if (Boolean.TRUE.equals(this.isThisAreaExistNameByOrgType(param.getOrganizationType(), param.getAreaId(), param.getName(), null))) {
            throw new HealthException("\u5df2\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u7ec4\u7ec7\u5355\u4f4d\uff0c\u65e0\u6cd5\u65b0\u589e");
        }
        if (Boolean.TRUE.equals(param.getIsDelegate()) && this.isThisAreaExistDelegateByOrgType(param.getOrganizationType(), param.getAreaId(), null).booleanValue()) {
            throw new HealthException("\u8be5\u7ea7\u522b\u7684\u533a\u57df\u5df2\u6709\u7ec4\u7ec7\u5355\u4f4d\u88ab\u663e\u793a\u5728\u7b5b\u9009\u9879\uff0c\u8bf7\u5148\u524d\u5f80\u53d6\u6d88");
        }
        Organization addEntity = new Organization();
        addEntity.setId(Long.valueOf(this.idworker.nextId()));
        addEntity.setOrganizationType(param.getOrganizationType());
        addEntity.setName(param.getName());
        addEntity.setAreaId(param.getAreaId());
        addEntity.setControlRegion(param.getControlRegion());
        addEntity.setAddType(Integer.valueOf(2));
        if (Boolean.TRUE.equals(param.getIsDelegate())) {
            addEntity.setIsDelegate(Boolean.valueOf(true));
        }
        if (Objects.equals(pEntity.getAreaId(), param.getAreaId())) {
            addEntity.setPid(pEntity.getPid());
            addEntity.setLevel(pEntity.getLevel());
            addEntity.setTreePath(pEntity.getTreePath());
            addEntity.setInnerPid(pEntity.getId());
            addEntity.setInnerLevel(Integer.valueOf(pEntity.getInnerLevel() + 1));
            addEntity.setInnerTreePath((StrUtil.isBlank((CharSequence)pEntity.getInnerTreePath()) ? "" : pEntity.getInnerTreePath()) + pEntity.getId() + ",");
        } else {
            addEntity.setPid(pEntity.getId());
            addEntity.setLevel(Integer.valueOf(pEntity.getLevel() + 1));
            addEntity.setTreePath((StrUtil.isBlank((CharSequence)pEntity.getTreePath()) ? "" : pEntity.getTreePath()) + pEntity.getId() + ",");
            addEntity.setInnerPid(Long.valueOf(999999999999L));
            addEntity.setInnerLevel(Integer.valueOf(0));
            addEntity.setInnerTreePath("");
        }
        this.setCreateInfo(addEntity, param.getLoginUserId(), null);
        this.setUpdateInfo(addEntity, param.getLoginUserId());
        boolean bl = b = ((OrganizationMapper)this.dao).insertSelective(addEntity) > 0;
        if (b) {
            this.redisClient.delPrefix("v3SuperviseOrg");
        }
        return b;
    }

    private void updateChildOrganizationDelegateTreePath(List<Organization> children, Organization pOrganization) {
        if (CollUtil.isEmpty(children)) {
            return;
        }
        for (Organization organ : children) {
            if (!pOrganization.getId().equals(organ.getDelegatePid())) continue;
            children.forEach(i -> organ.setDelegateTreePath(pOrganization.getDelegateTreePath() + pOrganization.getId() + ","));
            this.updateChildOrganizationDelegateTreePath(children, organ);
        }
    }

    public Boolean isThisAreaExistNameByOrgType(Integer organizationType, Long areaId, String name, Long excludeId) {
        if (Objects.isNull(organizationType) || Objects.isNull(areaId)) {
            throw new HealthException("\u53c2\u6570\u9519\u8bef");
        }
        Example example = new Example(Organization.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isValid", (Object)Boolean.TRUE).andEqualTo("organizationType", (Object)organizationType).andEqualTo("areaId", (Object)areaId).andEqualTo("name", (Object)name);
        if (Objects.nonNull(excludeId)) {
            criteria.andNotEqualTo("id", (Object)excludeId);
        }
        return this.getCountByExample(example) > 0;
    }

    public Boolean isThisAreaExistDelegateByOrgType(Integer organizationType, Long areaId, Long excludeId) {
        if (Objects.isNull(organizationType) || Objects.isNull(areaId)) {
            throw new HealthException("\u53c2\u6570\u9519\u8bef");
        }
        Example example = new Example(Organization.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isValid", (Object)Boolean.TRUE).andEqualTo("organizationType", (Object)organizationType).andEqualTo("areaId", (Object)areaId).andEqualTo("isDelegate", (Object)Boolean.TRUE);
        if (Objects.nonNull(excludeId)) {
            criteria.andNotEqualTo("id", (Object)excludeId);
        }
        return this.getCountByExample(example) > 0;
    }

    @Transactional
    public Boolean delete(Long id, Long loginUserId) {
        if (Objects.isNull(id)) {
            throw new HealthException("\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u7ec4\u7ec7\u5355\u4f4d");
        }
        Organization pOrganizationV3 = this.getOrgById(id);
        if (Objects.isNull(pOrganizationV3)) {
            throw new HealthException("\u8be5\u7ec4\u7ec7\u5355\u4f4d\u5df2\u4e0d\u5b58\u5728");
        }
        if (Boolean.TRUE.equals(pOrganizationV3.getIsDelegate())) {
            throw new HealthException("\u8be5\u7ec4\u7ec7\u5355\u4f4d\u88ab\u663e\u793a\u5728\u7b5b\u9009\u9879\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        if (this.organizationUserService.getOrganizationUserCountThisLevelByOid(id) > 0) {
            throw new HealthException("\u8be5\u7ec4\u7ec7\u5355\u4f4d\u7684\u672c\u7ea7\u5b58\u5728\u53ef\u7528\u7528\u6237\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        if (this.organizationUserService.getOrganizationUserCountNextLevelByOid(id) > 0) {
            throw new HealthException("\u8be5\u7ec4\u7ec7\u5355\u4f4d\u7684\u5b50\u7ea7\u5b58\u5728\u53ef\u7528\u7528\u6237\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        Organization entity = new Organization();
        entity.setId(id);
        this.delete(entity, loginUserId);
        this.redisClient.delPrefix("v3SuperviseOrg");
        return Boolean.TRUE;
    }

    @Transactional
    public Boolean update(OrganizationV3EditParam param) {
        boolean b;
        if (Objects.equals(param.getId(), param.getPid())) {
            throw new HealthException("\u4e0a\u7ea7\u7ec4\u7ec7\u5355\u4f4d\u4e0d\u80fd\u662f\u81ea\u5df1");
        }
        Organization entity = this.getOrgById(param.getId());
        if (Objects.isNull(entity)) {
            throw new HealthException("\u8be5\u7ec4\u7ec7\u5355\u4f4d\u5df2\u4e0d\u5b58\u5728");
        }
        Organization pEntity = this.getOrgById(param.getPid());
        if (Objects.isNull(pEntity)) {
            throw new HealthException("\u8be5\u4e0a\u7ea7\u7ec4\u7ec7\u5355\u4f4d\u5df2\u4e0d\u5b58\u5728");
        }
        if (Boolean.TRUE.equals(this.isThisAreaExistNameByOrgType(entity.getOrganizationType(), entity.getAreaId(), param.getName(), param.getId()))) {
            throw new HealthException("\u5df2\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u7ec4\u7ec7\u5355\u4f4d\uff0c\u65e0\u6cd5\u4fee\u6539");
        }
        if (Boolean.TRUE.equals(param.getIsDelegate()) && this.isThisAreaExistDelegateByOrgType(entity.getOrganizationType(), entity.getAreaId(), entity.getId()).booleanValue()) {
            throw new HealthException("\u8be5\u7ea7\u522b\u533a\u57df\u5df2\u6709\u7ec4\u7ec7\u5355\u4f4d\u88ab\u663e\u793a\u5728\u7b5b\u9009\u9879\uff0c\u8bf7\u5148\u524d\u5f80\u53d6\u6d88");
        }
        List<Organization> children = null;
        Organization updateEntity = new Organization();
        updateEntity.setId(param.getId());
        updateEntity.setName(param.getName());
        updateEntity.setControlRegion(param.getControlRegion());
        if (Boolean.TRUE.equals(param.getIsDelegate())) {
            updateEntity.setIsDelegate(Boolean.valueOf(true));
        }
        if (Boolean.FALSE.equals(param.getIsDelegate())) {
            updateEntity.setIsDelegate(Boolean.valueOf(false));
        }
        if (entity.getInnerLevel() > 0) {
            long[] treePathToCheck = StrUtil.splitToLong((CharSequence)pEntity.getInnerTreePath(), (CharSequence)",");
            if (Arrays.stream(treePathToCheck).anyMatch(pathId -> pathId == param.getId())) {
                throw new HealthException("\u4e0a\u7ea7\u7ec4\u7ec7\u5355\u4f4d\u4e0d\u80fd\u9009\u672c\u7ec4\u7ec7\u5355\u4f4d\u5185\u7684");
            }
            updateEntity.setInnerPid(pEntity.getId());
            updateEntity.setInnerLevel(Integer.valueOf(pEntity.getInnerLevel() + 1));
            updateEntity.setInnerTreePath((StrUtil.isBlank((CharSequence)pEntity.getInnerTreePath()) ? "" : pEntity.getInnerTreePath()) + pEntity.getId() + ",");
            children = this.getAllChildOrgListByOidWithInnerTreePath(param.getId());
        }
        this.setUpdateInfo(updateEntity, param.getLoginUserId());
        boolean bl = b = ((OrganizationMapper)this.dao).updateByPrimaryKeySelective(updateEntity) > 0;
        if (b) {
            if (CollUtil.isNotEmpty(children)) {
                this.updateChildOrganizationTreePath(children, updateEntity, param.getLoginUserId());
                this.batchUpdateOrInsert(children, OrganizationMapper.class, (item, mapper) -> mapper.updateByPrimaryKeySelective(item));
            }
            this.redisClient.delPrefix("v3SuperviseOrg");
        }
        return b;
    }

    private void updateChildOrganizationTreePath(List<Organization> children, Organization pOrganization, Long loginId) {
        if (CollUtil.isEmpty(children)) {
            return;
        }
        for (Organization organ : children) {
            if (!pOrganization.getId().equals(organ.getInnerPid())) continue;
            children.forEach(i -> {
                organ.setInnerLevel(Integer.valueOf(pOrganization.getInnerLevel() + 1));
                organ.setInnerTreePath(pOrganization.getInnerTreePath() + pOrganization.getId() + ",");
                this.setUpdateInfo(i, loginId);
            });
            this.updateChildOrganizationTreePath(children, organ, loginId);
        }
    }

    public List<Organization> getAllChildOrgListByOidWithTreePath(Long id) {
        return ((OrganizationMapper)this.dao).getAllChildOrgListByOidWithTreePath(id);
    }

    public List<Organization> getAllChildOrgListByOidWithInnerTreePath(Long id) {
        return ((OrganizationMapper)this.dao).getAllChildOrgListByOidWithInnerTreePath(id);
    }

    public OrganizationV3OneVo getDelegateOrgByOrgTypeAndAreaId(Integer organizationType, Long areaId) {
        return ((OrganizationMapper)this.dao).getDelegateOrgByOrgTypeAndAreaId(organizationType, areaId);
    }

    public Map<Long, OrganizationV3OneVo> getDelegateOrgMapByOrgTypeAndAreaId(Integer organizationType, Set<Long> areaIdList) {
        List<OrganizationV3OneVo> rst = ((OrganizationMapper)this.dao).getDelegateOrgMapByOrgTypeAndAreaId(organizationType, areaIdList);
        return rst.stream().collect(Collectors.toMap(OrganizationV3OneVo::getDetailAreaId, Function.identity(), (v1, v2) -> v1));
    }

    public List<OrganizationV3TreeVo> getAllCurrentAreaIdOrgListByOrgTypeAndAreaId(OrganizationV3CurrentAreaIdTreeParam param) {
        return ((OrganizationMapper)this.dao).getAllCurrentAreaIdOrgListByOrgTypeAndAreaId(param);
    }

    public Tree<String> getAllCurrentAreaIdOrgTreeByOrgTypeAndAreaId(OrganizationV3CurrentAreaIdTreeParam param) {
        List<OrganizationV3TreeVo> rst = this.getAllCurrentAreaIdOrgListByOrgTypeAndAreaId(param);
        return this.getOrgStringTree(param.getKeyword(), rst, null);
    }

    private Tree<String> getOrgStringTree(String keyword, List<OrganizationV3TreeVo> rst, Long rootId) {
        if (CollUtil.isEmpty(rst)) {
            return null;
        }
        if (Objects.isNull(rootId)) {
            List orgLevel0List = rst.stream().filter(i -> i.getLevel() == 0).collect(Collectors.toList());
            if (CollUtil.isEmpty(orgLevel0List)) {
                return null;
            }
            rootId = ((OrganizationV3TreeVo)orgLevel0List.get(0)).getPid();
        }
        TreeNodeConfig treeNodeConfig = new TreeNodeConfig();
        treeNodeConfig.setParentIdKey("pid");
        Tree built = TreeUtil.buildSingle(rst, (Object)String.valueOf(rootId), (TreeNodeConfig)treeNodeConfig, (treeNode, tree) -> {
            tree.setId((Object)String.valueOf(treeNode.getId()));
            tree.setParentId((Object)String.valueOf(treeNode.getPid()));
            tree.setName((CharSequence)treeNode.getName());
            tree.putExtra("level", (Object)treeNode.getLevel());
            tree.putExtra("isLeaf", (Object)treeNode.getIsLeaf());
            tree.putExtra("treePath", (Object)treeNode.getTreePath());
        });
        if (StrUtil.isNotBlank((CharSequence)keyword)) {
            built.filter(stringTree -> StrUtil.containsIgnoreCase((CharSequence)stringTree.getName(), (CharSequence)keyword));
        }
        return built;
    }

    public OrganizationV3OneVo getDelegateOrgListByOidAndAreaId(Long oid, Integer organizationType, Long areaId) {
        if (Objects.isNull(organizationType)) {
            Organization organizationV3 = this.getOrgById(oid);
            if (Objects.isNull(organizationV3)) {
                return null;
            }
            organizationType = organizationV3.getOrganizationType();
        }
        return this.getDelegateOrgByOrgTypeAndAreaId(organizationType, areaId);
    }

    public List<OrganizationV3TreeVo> getNextLevelDelegateOrgListByParentId(Long parentId) {
        return ((OrganizationMapper)this.dao).getNextLevelDelegateOrgListByParentId(parentId);
    }

    public Map<Long, Long> getRegionOrganizationRelaList() {
        return ((OrganizationMapper)this.dao).getRegionOrganizationRelaList();
    }
}

