/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.basic;

import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.health.enums.company.CompanySizeEnum;
import cn.smarthse.modules.health.supervise.entity.harmFactorDeclare.CountDataModel;
import cn.smarthse.modules.health.supervise.home.service.IHomeDataService;
import cn.smarthse.modules.health.supervise.model.home.KeyWorkDevelopRate;
import cn.smarthse.modules.health.supervise.model.home.KeyWorkInfo;
import cn.smarthse.modules.health.supervise.model.home.RegionalOverviewModel;
import cn.smarthse.modules.health.supervise.service.basic.IHomeCountService;
import cn.smarthse.modules.health.supervise.service.company.IThirdCompanyService;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="homeCountServiceImpl")
@DubboService
@Transactional(readOnly=true)
public class HomeCountServiceImpl
implements IHomeCountService {
    @DubboReference
    IThirdCompanyService thirdCompanyService;
    @DubboReference(check=false)
    IHomeDataService homeDataService;
    @DubboReference(check=false)
    private ICheckPlanService checkPlanService;
    private ThreadPoolExecutor homeCountThreadpool = new ThreadPoolExecutor(4, 30, 2L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(50), Executors.defaultThreadFactory(), new ThreadPoolExecutor.AbortPolicy());

    public RegionalOverviewModel getRegionalOverview(Long areaId, Byte level, Boolean isOwnLevel) {
        RegionalOverviewModel model = new RegionalOverviewModel();
        if (areaId == null) {
            return model;
        }
        Future<RegionalOverviewModel> summTask = this.homeCountThreadpool.submit(() -> this.getRegionalOSumData(areaId, level, isOwnLevel));
        Future<List> SDBNumTask = this.homeCountThreadpool.submit(() -> this.homeDataService.countSDByArea(areaId, level, isOwnLevel));
        Future<List> OCBNumTask = this.homeCountThreadpool.submit(() -> this.homeDataService.countOCByArea(areaId, level, isOwnLevel));
        Future<List> ODBNumTask = this.homeCountThreadpool.submit(() -> this.homeDataService.countODByArea(areaId, level, isOwnLevel));
        try {
            RegionalOverviewModel model1 = summTask.get();
            model.setCompanyNum(model1.getCompanyNum());
            model.setDeclareNum(model1.getDeclareNum());
            model.setPhysicalNum(model1.getPhysicalNum());
            model.setCheckNum(model1.getCheckNum());
            model.setContactFactorNum(model1.getContactFactorNum());
            model.setManagerNum(model1.getManagerNum());
            model.setSDBlist(SDBNumTask.get());
            model.setOCBlist(OCBNumTask.get());
            model.setODBlist(ODBNumTask.get());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return model;
    }

    public RegionalOverviewModel getRegionalOSumData(Long areaId, Byte level, Boolean isOwnLevel) {
        RegionalOverviewModel model = new RegionalOverviewModel();
        if (areaId == null) {
            return model;
        }
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        Date nowdate = new Date();
        Date fistDayThisYear = DateUtils.getYearFirstDay((int)year);
        String areaIdStr = areaId.toString();
        model.setCompanyNum(Integer.valueOf(this.thirdCompanyService.countCompanyNumByAreaId(areaId, level, this.getByteLevel(level, isOwnLevel))));
        model.setDeclareNum(Integer.valueOf(this.homeDataService.getDeclareCompanyNumByAreaAndTime(areaId, level, null, null, isOwnLevel)));
        model.setPhysicalNum(this.homeDataService.checkStaffCountByDate(fistDayThisYear, nowdate, areaId, level, isOwnLevel));
        model.setCheckNum(this.homeDataService.getHcCheckCompanyCountByAreaAndBetweenTime(areaIdStr, level, fistDayThisYear, nowdate, this.getByteLevel(level, isOwnLevel)));
        model.setContactFactorNum(this.homeDataService.getWorkHarmStaffCountByAreaAndYear(areaIdStr, level, null, isOwnLevel));
        model.setManagerNum(this.homeDataService.getCompanyFunctionalOrganizationMemberCountByAreaAndYear(areaIdStr, level, null, isOwnLevel));
        return model;
    }

    public KeyWorkDevelopRate getKeyWorkDevelopInfoByTime(int comNum, Long areaId, Byte level, Date beginTime, Date endTime, Boolean isOwnLevel) {
        KeyWorkDevelopRate info = new KeyWorkDevelopRate();
        Future<Integer> decTask = this.homeCountThreadpool.submit(() -> this.homeDataService.getDeclareCompanyNumByAreaAndTime(areaId, level, beginTime, endTime, isOwnLevel));
        Future<Integer> trainTask = this.homeCountThreadpool.submit(() -> this.homeDataService.getTrainCompanyNumByAreaAndTime(areaId, level, beginTime, endTime, isOwnLevel));
        Future<Integer> hccheckTask = this.homeCountThreadpool.submit(() -> this.homeDataService.getHcCheckCompanyCountByAreaAndBetweenTime(areaId.toString(), level, beginTime, endTime, this.getByteLevel(level, isOwnLevel)));
        Future<Integer> checkTask = this.homeCountThreadpool.submit(() -> this.homeDataService.checkComNumByDate(beginTime, endTime, areaId, level, isOwnLevel));
        int decNum = 0;
        int trainNum = 0;
        int checkNum = 0;
        int physicalNum = 0;
        try {
            decNum = decTask.get();
            trainNum = trainTask.get();
            checkNum = hccheckTask.get();
            physicalNum = checkTask.get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        info.setCheckNum(Integer.valueOf(checkNum));
        info.setDeclareNum(Integer.valueOf(decNum));
        info.setPhysicalNum(Integer.valueOf(physicalNum));
        info.setTrainNum(Integer.valueOf(trainNum));
        info.setDeclareRate(this.getPercentRate(decNum, comNum));
        info.setCheckRate(this.getPercentRate(checkNum, comNum));
        info.setTrainReta(this.getPercentRate(trainNum, comNum));
        info.setPhysicalRate(this.getPercentRate(physicalNum, comNum));
        return info;
    }

    private String getPercentRate(int num, int totalNum) {
        if (totalNum == 0) {
            return "0";
        }
        if (num == 0) {
            return "0";
        }
        float rate = (float)num / (float)totalNum * 100.0f;
        if (rate > 0.0f && rate < 1.0f) {
            DecimalFormat formatter = new DecimalFormat("0.00");
            String rateStr = formatter.format(rate);
            return rateStr;
        }
        DecimalFormat formatter = new DecimalFormat("0.0");
        String rateStr = formatter.format(rate);
        return rateStr;
    }

    public KeyWorkInfo getDecWorkInfo(int comNum, Long areaId, Byte level, Boolean isOwnLevel) {
        KeyWorkInfo info = new KeyWorkInfo();
        Date nowdate = new Date();
        int year = DateUtils.getYear((Date)new Date());
        Date fistDayThisYear = DateUtils.getYearFirstDay((int)year);
        Date lastDayLastYear = DateUtils.getYearLastDay((int)(year - 1));
        Date firstDayThreeYear = DateUtils.getYearFirstDay((int)(year - 3));
        int totalNum = this.homeDataService.getDeclareCompanyNumByAreaAndTime(areaId, level, null, null, isOwnLevel);
        int threeYearsNum = this.homeDataService.getDeclareCompanyNumByAreaAndTime(areaId, level, firstDayThreeYear, lastDayLastYear, isOwnLevel);
        int thisYearNum = this.homeDataService.getDeclareCompanyNumByAreaAndTime(areaId, level, fistDayThisYear, nowdate, isOwnLevel);
        info.setThisYearNum(Integer.valueOf(thisYearNum));
        info.setThreeYearsNum(Integer.valueOf(threeYearsNum));
        info.setTotalNum(Integer.valueOf(totalNum));
        info.setThisYearRate(this.getPercentRate(thisYearNum, comNum));
        info.setThreeYearsReta(this.getPercentRate(threeYearsNum, comNum));
        info.setTotalRate(this.getPercentRate(totalNum, comNum));
        info.setTotalCom(Integer.valueOf(comNum));
        return info;
    }

    public KeyWorkInfo getCheckWorkInfo(int comNum, Long areaId, Byte level, Boolean isOwnLevel) {
        KeyWorkInfo info = new KeyWorkInfo();
        Date nowdate = new Date();
        int year = DateUtils.getYear((Date)new Date());
        Date fistDayThisYear = DateUtils.getYearFirstDay((int)year);
        Date lastDayLastYear = DateUtils.getYearLastDay((int)(year - 1));
        Date firstDayThreeYear = DateUtils.getYearFirstDay((int)(year - 3));
        int totalNum = this.homeDataService.getHcCheckCompanyCountByAreaAndBetweenTime(areaId.toString(), level, null, null, this.getByteLevel(level, isOwnLevel));
        int threeYearsNum = this.homeDataService.getHcCheckCompanyCountByAreaAndBetweenTime(areaId.toString(), level, firstDayThreeYear, lastDayLastYear, this.getByteLevel(level, isOwnLevel));
        int thisYearNum = this.homeDataService.getHcCheckCompanyCountByAreaAndBetweenTime(areaId.toString(), level, fistDayThisYear, nowdate, this.getByteLevel(level, isOwnLevel));
        info.setThisYearNum(Integer.valueOf(thisYearNum));
        info.setThreeYearsNum(Integer.valueOf(threeYearsNum));
        info.setTotalNum(Integer.valueOf(totalNum));
        info.setThisYearRate(this.getPercentRate(thisYearNum, comNum));
        info.setThreeYearsReta(this.getPercentRate(threeYearsNum, comNum));
        info.setTotalRate(this.getPercentRate(totalNum, comNum));
        info.setTotalCom(Integer.valueOf(comNum));
        return info;
    }

    public KeyWorkInfo getPhysicalWorkInfo(int comNum, Long areaId, Byte level, Boolean isOwnLevel) {
        KeyWorkInfo info = new KeyWorkInfo();
        Date nowdate = new Date();
        int year = DateUtils.getYear((Date)new Date());
        Date fistDayThisYear = DateUtils.getYearFirstDay((int)year);
        Date lastDayLastYear = DateUtils.getYearLastDay((int)(year - 1));
        Date firstDayThreeYear = DateUtils.getYearFirstDay((int)(year - 3));
        int totalNum = this.homeDataService.checkComNumByDate(null, null, areaId, level, isOwnLevel);
        int threeYearsNum = this.homeDataService.checkComNumByDate(firstDayThreeYear, lastDayLastYear, areaId, level, isOwnLevel);
        int thisYearNum = this.homeDataService.checkComNumByDate(fistDayThisYear, nowdate, areaId, level, isOwnLevel);
        info.setThisYearNum(Integer.valueOf(thisYearNum));
        info.setThreeYearsNum(Integer.valueOf(threeYearsNum));
        info.setTotalNum(Integer.valueOf(totalNum));
        info.setThisYearRate(this.getPercentRate(thisYearNum, comNum));
        info.setThreeYearsReta(this.getPercentRate(threeYearsNum, comNum));
        info.setTotalRate(this.getPercentRate(totalNum, comNum));
        info.setTotalCom(Integer.valueOf(comNum));
        return info;
    }

    public KeyWorkInfo getTrainWorkInfo(int comNum, Long areaId, Byte level, Boolean isOwnLevel) {
        KeyWorkInfo info = new KeyWorkInfo();
        Date nowdate = new Date();
        int year = DateUtils.getYear((Date)new Date());
        Date fistDayThisYear = DateUtils.getYearFirstDay((int)year);
        Date lastDayLastYear = DateUtils.getYearLastDay((int)(year - 1));
        Date firstDayThreeYear = DateUtils.getYearFirstDay((int)(year - 3));
        int totalNum = this.homeDataService.getTrainCompanyNumByAreaAndTime(areaId, level, null, null, isOwnLevel);
        int threeYearsNum = this.homeDataService.getTrainCompanyNumByAreaAndTime(areaId, level, firstDayThreeYear, lastDayLastYear, isOwnLevel);
        int thisYearNum = this.homeDataService.getTrainCompanyNumByAreaAndTime(areaId, level, fistDayThisYear, nowdate, isOwnLevel);
        info.setThisYearNum(Integer.valueOf(thisYearNum));
        info.setThreeYearsNum(Integer.valueOf(threeYearsNum));
        info.setTotalNum(Integer.valueOf(totalNum));
        info.setThisYearRate(this.getPercentRate(thisYearNum, comNum));
        info.setThreeYearsReta(this.getPercentRate(threeYearsNum, comNum));
        info.setTotalRate(this.getPercentRate(totalNum, comNum));
        info.setTotalCom(Integer.valueOf(comNum));
        return info;
    }

    public List<KeyWorkDevelopRate> getWorkInfoByScale(Long areaId, Byte level, Boolean isOwnLevel) {
        ArrayList<KeyWorkDevelopRate> list = new ArrayList<KeyWorkDevelopRate>();
        List totalData = this.homeDataService.getComNumByScale(areaId, level, isOwnLevel);
        List decData = this.homeDataService.getDecComNumBySacle(areaId, level, isOwnLevel);
        List physicalData = this.homeDataService.countCompanyByScale(areaId, level, isOwnLevel);
        List checkData = this.homeDataService.getHcCheckCompanyCountGroupByScale(areaId, level, this.getByteLevel(level, isOwnLevel));
        List trainData = this.homeDataService.getTrainPlanCompanyCountByScale(areaId, level, isOwnLevel);
        for (CompanySizeEnum type : CompanySizeEnum.values()) {
            KeyWorkDevelopRate data = new KeyWorkDevelopRate();
            data.setCountNameValue(type.getCode().toString());
            data.setCountName(type.getShortName());
            for (CountDataModel model : totalData) {
                if (model.getCountNameValue() == null || !type.getCode().toString().equals(model.getCountNameValue())) continue;
                data.setTotalNum(model.getTotalNum());
                break;
            }
            for (CountDataModel model : decData) {
                if (model.getCountNameValue() == null || !type.getCode().toString().equals(model.getCountNameValue())) continue;
                data.setDeclareNum(model.getHaveDataNum());
                break;
            }
            for (CountDataModel model : physicalData) {
                if (model.getGroupCode() == null || !type.getCode().toString().equals(model.getGroupCode())) continue;
                data.setPhysicalNum(model.getCompanyNum());
                break;
            }
            for (CountDataModel model : checkData) {
                if (model.getScale() == null || !type.getCode().toString().equals(model.getScale())) continue;
                data.setCheckNum(Integer.valueOf(model.getCheckNum().intValue()));
                break;
            }
            for (CountDataModel model : trainData) {
                if (model.getScaleId() == null || !type.getCode().toString().equals(model.getScaleId().toString())) continue;
                data.setTrainNum(model.getCidCount());
                break;
            }
            data.setDeclareRate(this.getPercentRate(data.getDeclareNum(), data.getTotalNum()));
            data.setCheckRate(this.getPercentRate(data.getCheckNum(), data.getTotalNum()));
            data.setTrainReta(this.getPercentRate(data.getTrainNum(), data.getTotalNum()));
            data.setPhysicalRate(this.getPercentRate(data.getPhysicalNum(), data.getTotalNum()));
            list.add(data);
        }
        return list;
    }

    public KeyWorkDevelopRate getIndustryWorkInfo(Long areaId, Byte level, String indus, Boolean isOwnLevel) {
        KeyWorkDevelopRate info = new KeyWorkDevelopRate();
        Date nowdate = new Date();
        int year = DateUtils.getYear((Date)new Date());
        Date fistDayThisYear = DateUtils.getYearFirstDay((int)year);
        Future<Integer> totalTask = this.homeCountThreadpool.submit(() -> this.homeDataService.countCompanyByIndusties(areaId, level, indus, isOwnLevel));
        Future<Integer> decTask = this.homeCountThreadpool.submit(() -> this.homeDataService.getKeyIndustryDecComNum(areaId, level, indus, isOwnLevel));
        Future<Integer> physicalTask = this.homeCountThreadpool.submit(() -> this.homeDataService.checkComNumByIndustry(fistDayThisYear, nowdate, areaId, level, indus, isOwnLevel));
        Future<Integer> checkTask = this.homeCountThreadpool.submit(() -> this.homeDataService.getHcCheckCompanyCountByIndustry(areaId, level, indus, this.getByteLevel(level, isOwnLevel)));
        Future<Integer> trainTask = this.homeCountThreadpool.submit(() -> this.homeDataService.getTrainPlanCompanyCountByIndustry(areaId, level, indus, Integer.valueOf(year), isOwnLevel));
        try {
            info.setTotalNum(totalTask.get());
            info.setDeclareNum(decTask.get());
            info.setPhysicalNum(physicalTask.get());
            info.setCheckNum(checkTask.get());
            info.setTrainNum(trainTask.get());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return info;
    }

    public KeyWorkDevelopRate getHarmFactorWorkInfo(Long areaId, Byte level, String facs, Boolean isOwnLevel) {
        KeyWorkDevelopRate info = new KeyWorkDevelopRate();
        ArrayList<Long> harmIds = new ArrayList<Long>();
        for (String s : facs.split(",")) {
            harmIds.add(Long.parseLong(s));
        }
        List cids = this.checkPlanService.getCidListByFactorAndArea(areaId, level, Integer.valueOf(DateUtil.getYear()), harmIds);
        Future<Integer> totalTask = this.homeCountThreadpool.submit(() -> this.homeDataService.countCompanyByHarmIds(areaId, level, cids, isOwnLevel));
        Future<Integer> decTask = this.homeCountThreadpool.submit(() -> this.homeDataService.getKeyFactorsDecComNum(areaId, level, cids, isOwnLevel));
        Future<Integer> physicalTask = this.homeCountThreadpool.submit(() -> this.homeDataService.countCompanyByHarms(cids, areaId, level, isOwnLevel));
        Future<Integer> checkTask = this.homeCountThreadpool.submit(() -> this.homeDataService.getHcCheckCompanyCountByHarms(areaId, level, cids, this.getByteLevel(level, isOwnLevel)));
        Future<Integer> trainTask = this.homeCountThreadpool.submit(() -> this.homeDataService.getTrainPlanCompanyCountByHarms(cids, areaId, level, isOwnLevel));
        try {
            info.setTotalNum(totalTask.get());
            info.setDeclareNum(decTask.get());
            info.setPhysicalNum(physicalTask.get());
            info.setCheckNum(checkTask.get());
            info.setTrainNum(trainTask.get());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return info;
    }

    private Byte getByteLevel(Byte level, Boolean isOwnLevel) {
        Byte ownLevel = null;
        if (isOwnLevel != null && isOwnLevel.booleanValue() && (level.intValue() == 1 || level.intValue() == 2)) {
            ownLevel = level;
        }
        return ownLevel;
    }
}

