/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.framework.service;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.database.mybatis.HSEMapper;
import cn.smarthse.common.framework.service.CacheTables;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.snowflake.IdWorker;
import jakarta.annotation.Resource;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import tk.mybatis.mapper.entity.Example;

public abstract class BaseServiceImpl<D extends HSEMapper<T>, T>
implements IBaseService<T> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    protected IdWorker idworker;
    @Autowired(required=false)
    protected D dao;
    private static final int BATCH_SIZE = 1000;
    @Resource
    private SqlSessionFactory sqlSessionFactory;

    private String getMemoryCacheName() {
        String memoryCacheName = this.dao.getClass().getInterfaces()[0].getName();
        return memoryCacheName;
    }

    protected T getFromMemoryCache(Long id) {
        if (id == null) {
            return null;
        }
        String memoryCacheName = this.getMemoryCacheName();
        if (CacheTables.isUseCache(memoryCacheName)) {
            // empty if block
        }
        return null;
    }

    protected void putToMemoryCache(Long id, T t) {
        if (id == null || t == null) {
            return;
        }
        String memoryCacheName = this.getMemoryCacheName();
        if (CacheTables.isUseCache(memoryCacheName)) {
            // empty if block
        }
    }

    protected void delFromMemoryCache(Long id) {
        if (id == null) {
            return;
        }
        String memoryCacheName = this.getMemoryCacheName();
        if (CacheTables.isUseCache(memoryCacheName)) {
            // empty if block
        }
    }

    private Long getIdFromT(T entity) {
        Object id = null;
        try {
            Method getId = this.getMethod(entity, "getId", null);
            if (getId != null) {
                id = getId.invoke(entity, new Object[0]);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return (Long)id;
    }

    public T getById(Long id) {
        if (id == null || id == 0L) {
            return null;
        }
        Object t = this.getFromMemoryCache(id);
        if (t == null) {
            t = this.dao.selectByPrimaryKey((Object)id);
            if (t == null) {
                return null;
            }
            this.putToMemoryCache(id, t);
        }
        return t;
    }

    @Deprecated
    public T getByEntity(T entity) {
        return (T)this.dao.selectOne(entity);
    }

    public List<T> getListByExample(Example example) {
        return this.dao.selectByExample((Object)example);
    }

    public int getCountByExample(Example example) {
        return this.dao.selectCountByExample((Object)example);
    }

    protected void setUpdateInfo(T entity, Long loginStaffId) {
        try {
            Method setUpdateBy;
            Method setUpdateDate = this.getMethod(entity, "setUpdateDate", Date.class);
            if (setUpdateDate != null) {
                setUpdateDate.invoke(entity, new Date());
            }
            if (loginStaffId != null && (setUpdateBy = this.getMethod(entity, "setUpdateBy", Long.class)) != null) {
                setUpdateBy.invoke(entity, loginStaffId);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private void setIsValid(T entity, boolean bln) {
        try {
            Method setIsValid = this.getMethod(entity, "setIsValid", Boolean.class);
            if (setIsValid != null) {
                setIsValid.invoke(entity, bln);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private Method getMethod(T entity, String methodStr, Class<?> paramType) {
        Method method = null;
        for (Class<?> clazz = entity.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                method = paramType != null ? clazz.getDeclaredMethod(methodStr, paramType) : clazz.getDeclaredMethod(methodStr, new Class[0]);
                return method;
            }
            catch (Exception exception) {
                continue;
            }
        }
        return method;
    }

    protected void setCreateInfo(T entity, Long loginStaffId, Long cid) {
        Method setCreateDate = null;
        Method setCreateBy = null;
        Method setCid = null;
        try {
            Method setId;
            Long id;
            Method getId;
            setCreateDate = this.getMethod(entity, "setCreateDate", Date.class);
            if (setCreateDate != null) {
                setCreateDate.invoke(entity, new Date());
            }
            this.setIsValid(entity, Global.TRUE);
            if (loginStaffId != null && (setCreateBy = this.getMethod(entity, "setCreateBy", Long.class)) != null) {
                setCreateBy.invoke(entity, loginStaffId);
            }
            if (cid != null && (setCid = this.getMethod(entity, "setCid", Long.class)) != null) {
                setCid.invoke(entity, cid);
            }
            if ((getId = this.getMethod(entity, "getId", null)) != null && (id = (Long)getId.invoke(entity, new Object[0])) == null && (setId = this.getMethod(entity, "setId", Long.class)) != null) {
                setId.invoke(entity, this.idworker.nextId());
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Transactional(readOnly=false)
    public T add(T entity) {
        return this.add(entity, null, null);
    }

    @Transactional(readOnly=false)
    public T add(T entity, Long loginStaffId, Long cid) {
        this.setCreateInfo(entity, loginStaffId, cid);
        this.setUpdateInfo(entity, loginStaffId);
        this.dao.insertSelective(entity);
        this.putToMemoryCache(this.getIdFromT(entity), entity);
        return entity;
    }

    @Transactional(readOnly=false)
    public void update(T entity) {
        this.dao.updateByPrimaryKeySelective(entity);
        Long id = this.getIdFromT(entity);
        this.delFromMemoryCache(id);
    }

    @Transactional(readOnly=false)
    public void update(T entity, Long loginStaffId) {
        this.setUpdateInfo(entity, loginStaffId);
        this.dao.updateByPrimaryKeySelective(entity);
        Long id = this.getIdFromT(entity);
        this.delFromMemoryCache(id);
    }

    @Transactional(readOnly=false)
    public void updateByPrimaryKey(T entity, Long loginStaffId) {
        this.setUpdateInfo(entity, loginStaffId);
        this.dao.updateByPrimaryKey(entity);
        Long id = this.getIdFromT(entity);
        this.delFromMemoryCache(id);
    }

    @Transactional(readOnly=false)
    public void delete(T entity) {
        this.dao.delete(entity);
        this.delFromMemoryCache(this.getIdFromT(entity));
    }

    @Transactional(readOnly=false)
    public void delete(T entity, Long loginStaffId) {
        if (entity == null) {
            return;
        }
        this.setUpdateInfo(entity, loginStaffId);
        this.setIsValid(entity, Global.FALSE);
        this.dao.updateByPrimaryKeySelective(entity);
        Long id = this.getIdFromT(entity);
        this.delFromMemoryCache(id);
    }

    public List<T> getListByIds(String ids) {
        String[] idArray;
        if (StringUtils.isEmpty((CharSequence)ids) || ids.equals(",")) {
            return Collections.emptyList();
        }
        ids = ids.trim();
        ids = ids.replaceAll(" ", "");
        StringBuffer idBuffer = new StringBuffer();
        for (String idStr : idArray = ids.split(",")) {
            if (!StringUtils.isLong((String)idStr)) continue;
            idBuffer.append(idStr).append(",");
        }
        if (idBuffer.length() > 0) {
            idBuffer.deleteCharAt(idBuffer.length() - 1);
            return this.dao.selectByIds(idBuffer.toString());
        }
        return Collections.emptyList();
    }

    protected T getOneByExample(Example example) {
        return (T)this.dao.selectOneByExample((Object)example);
    }

    @Transactional
    public <T, U, R> int batchUpdateOrInsert(List<T> data, Class<U> mapperClass, BiFunction<T, U, R> function) {
        return this.batchUpdateOrInsert(data, mapperClass, function, 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public <T, U, R> int batchUpdateOrInsert(List<T> data, Class<U> mapperClass, BiFunction<T, U, R> function, int batchSize) {
        int i = 1;
        try (SqlSession batchSqlSession = this.sqlSessionFactory.openSession(ExecutorType.BATCH);){
            Object mapper = batchSqlSession.getMapper(mapperClass);
            int size = data.size();
            for (T element : data) {
                R r = function.apply(element, mapper);
                if (i % batchSize == 0 || i == size) {
                    batchSqlSession.flushStatements();
                }
                ++i;
            }
            batchSqlSession.commit(!TransactionSynchronizationManager.isSynchronizationActive());
        }
        return i - 1;
    }
}

