/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.home.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.common.util.number.SysConvertTool;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.health.entity.work.check.vo.PhcThirdOccupationalDiseaserParamVo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcThirdOccupationalDiseaserVo;
import cn.smarthse.modules.health.enums.home.grade.GradeSourceEnum;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyInfoService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateStaffDetailService;
import cn.smarthse.modules.health.service.work.reform.ICompanyRiskCompletionService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicEconomyService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicNewService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.supervise.entity.check.CheckCountInfo;
import cn.smarthse.modules.health.supervise.entity.check.CompanyCountInfo;
import cn.smarthse.modules.health.supervise.entity.harmFactorDeclare.CountDataModel;
import cn.smarthse.modules.health.supervise.home.dao.HomeDataMapper;
import cn.smarthse.modules.health.supervise.home.service.IHomeDataService;
import cn.smarthse.modules.health.supervise.model.home.v3223.homeIndex.CreditSuperviseComplianceVo;
import cn.smarthse.modules.health.supervise.model.home.v3223.homeIndex.HomeEnergyEfficiencyVo;
import cn.smarthse.modules.health.supervise.model.home.v3223.homeIndex.HomeHelpCompanyVo;
import cn.smarthse.modules.health.supervise.model.home.v3223.homeIndex.HomeReceivingUnitVo;
import cn.smarthse.modules.health.supervise.service.company.IDcCompanyService;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3Service;
import cn.smarthse.modules.health.supervise.service.importantIndustryCategory.IImportantIndustryCategoryService;
import cn.smarthse.modules.health.supervise.service.keyFactory.IKeyFactoryService;
import cn.smarthse.modules.health.supervise.service.keyIndustryTrain.IKeyIndustryTrainService;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineDeviceService;
import cn.smarthse.modules.health.supervise.vo.company.CompanyTrainVo;
import cn.smarthse.modules.health.supervise.vo.company.ScaleCompanyCheckNum;
import cn.smarthse.modules.health.supervise.vo.train.TrainPlanCountScaleVo;
import cn.smarthse.modules.health.vo.base.company.gradev3.GradeSearchV314;
import cn.smarthse.modules.health.vo.riskResolve.RiskCalculator;
import cn.smarthse.modules.health.vo.riskResolve.RiskVisualDto;
import cn.smarthse.modules.health.vo.work.HomeIndexSearchVo;
import cn.smarthse.modules.health.vo.work.certificate.CertificateStaffDetailVo;
import cn.smarthse.services.hfi.api.pojo.bo.ScaleCompanyCheckNumBo;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import cn.smarthse.services.wanda.api.service.IWandaZywsPunishInfoService;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@DubboService
@Transactional(readOnly=true)
public class HomeDataServiceImpl
implements IHomeDataService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HomeDataServiceImpl.class);
    @DubboReference
    private INewComplianceCompanyInfoService complianceService;
    @Autowired
    private HomeDataMapper homeDataMapper;
    @DubboReference(version="1.0.0")
    private IHarmFactorService harmFactorService;
    @DubboReference
    private ICheckPlanService checkPlanService;
    @DubboReference
    private IImportantIndustryCategoryService importantIndustryCategoryService;
    @DubboReference
    private IReformItemBasicService reformItemBasicService;
    @DubboReference
    private IReformItemBasicNewService reformItemBasicNewService;
    @DubboReference
    private IReformItemBasicEconomyService reformItemBasicEconomyService;
    @DubboReference
    private ICompanyGradeV3Service companyGradeV3Service;
    @DubboReference
    private IWandaZywsPunishInfoService wandaZywsPunishInfoService;
    @DubboReference
    private IKeyFactoryService keyFactoryService;
    @DubboReference
    private ICompanyRiskCompletionService riskCompletionService;
    @DubboReference
    private IOnlineDeviceService onlineDeviceService;
    @DubboReference
    private ICertificateStaffDetailService certificateStaffDetailService;
    @DubboReference
    private IDcCompanyService iDcCompanyService;
    @Autowired
    private RedisClient redisClient;
    @DubboReference
    private IKeyIndustryTrainService keyIndustryTrainService;
    @Autowired
    private ThreadPoolTaskExecutor poolTaskExecutor;
    private String cacheName = "IHomeDataService";
    public static final int TIMEOUT = 10800;

    public int getDeclareCompanyNumByAreaAndTime(Long areaId, Byte level, Date beginTime, Date endTime, Boolean isOwnLevel) {
        if (areaId == null) {
            return 0;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("areaId", areaId);
        params.put("level", level);
        params.put("beginTime", beginTime);
        params.put("endTime", endTime);
        params.put("isOwnLevel", isOwnLevel);
        Integer comNum = 0;
        comNum = this.homeDataMapper.getDeclareCompanyNumByAreaAndTime(params);
        return comNum;
    }

    public int getAllDeclareCompanyNumByAreaAndTime(Long areaId, Byte level, Date beginTime, Date endTime, Boolean isOwnLevel) {
        if (areaId == null) {
            return 0;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("areaId", areaId);
        params.put("level", level);
        params.put("beginTime", beginTime);
        params.put("endTime", endTime);
        params.put("isOwnLevel", isOwnLevel);
        Integer comNum = 0;
        comNum = this.homeDataMapper.getAllDeclareCompanyNumByAreaAndTime(params);
        return comNum;
    }

    public Integer getHcCheckCompanyCountByAreaAndBetweenTime(String areaIdStr, Byte level, Date begin, Date end, Byte isOwnLevel) {
        Long areaId = null;
        if (areaIdStr != null && !areaIdStr.isEmpty()) {
            areaId = Long.parseLong(areaIdStr);
        }
        if (begin == null) {
            return this.checkPlanService.countComNumByTimeRangeByArea(areaId, level, null, null, isOwnLevel);
        }
        return this.checkPlanService.countComNumByTimeRangeByArea(areaId, level, DateUtil.getFromDate((Date)begin), DateUtil.getFromDate((Date)end), isOwnLevel);
    }

    public int getTrainCompanyNumByAreaAndTime(Long areaId, Byte level, Date beginTime, Date endTime, Boolean isOwnLevel) {
        if (areaId == null) {
            return 0;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("level", level);
        params.put("areaId", areaId);
        params.put("beginTime", beginTime);
        params.put("endTime", endTime);
        params.put("isOwnLevel", isOwnLevel);
        Integer comNum = this.homeDataMapper.getTrainCompanyNumByAreaAndTime(params);
        return comNum;
    }

    public int countCompanyByIndusties(Long areaId, Byte areaLevel, String industies, Boolean isOwnLevel) {
        return this.homeDataMapper.countCompanyByIndusties(areaId, areaLevel, industies, isOwnLevel);
    }

    public Integer checkComNumByDate(Date beginTime, Date endTime, Long areaId, Byte areaLevel, Boolean isOwnLevel) {
        Integer checkedCount = this.homeDataMapper.checkedCount(beginTime, endTime, null, areaId, areaLevel, null, isOwnLevel);
        return checkedCount == null ? 0 : checkedCount;
    }

    public int getKeyIndustryDecComNum(Long areaId, Byte level, String indutries, Boolean isOwnLevel) {
        if (areaId == null || indutries == null) {
            return 0;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("level", level);
        params.put("areaId", areaId);
        params.put("indutries", indutries);
        params.put("isOwnLevel", isOwnLevel);
        Integer comNum = this.homeDataMapper.getKeyIndustryDecComNum(params);
        return comNum;
    }

    public Integer checkComNumByIndustry(Date beginTime, Date endTime, Long areaId, Byte areaLevel, String industries, Boolean isOwnLevel) {
        Integer checkedCount = this.homeDataMapper.checkedCount(beginTime, endTime, null, areaId, areaLevel, industries, isOwnLevel);
        return checkedCount == null ? 0 : checkedCount;
    }

    public Integer getHcCheckCompanyCountByIndustry(Long areaId, Byte level, String industryCategoryIds, Byte isOwnLevel) {
        if (industryCategoryIds == null || industryCategoryIds.isEmpty()) {
            return 0;
        }
        LocalDateTime start = DateUtil.getLocalDateTime((int)LocalDate.now().getYear(), (int)1, (int)1, (int)0, (int)0, (int)0);
        LocalDateTime end = LocalDateTime.now();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (String s : industryCategoryIds.split(",")) {
            ids.add(Long.parseLong(s));
        }
        return this.checkPlanService.countComNumByYearByIndustryByArea(areaId, level, ids, start, end, isOwnLevel);
    }

    public Integer getTrainPlanCompanyCountByIndustry(Long areaId, Byte level, String industryCategoryIds, Integer year, Boolean isOwnLevel) {
        ArrayList<Long> iids = new ArrayList<Long>();
        if (StringUtils.isNotEmpty((String)industryCategoryIds)) {
            iids.addAll(Arrays.asList(industryCategoryIds.split(",")).stream().mapToLong(s -> Long.valueOf(s)).boxed().collect(Collectors.toList()));
        }
        if (iids.size() == 0) {
            return 0;
        }
        return this.homeDataMapper.getTrainPlanCompanyCountByIndustry(areaId, level, iids, year, isOwnLevel);
    }

    public int countCompanyByHarmIds(Long areaId, Byte areaLevel, List<Long> cids, Boolean isOwnLevel) {
        if (areaId == null || cids == null || cids.size() == 0) {
            return 0;
        }
        return this.homeDataMapper.countCompanyByHarmIds(areaId, areaLevel, cids, isOwnLevel);
    }

    public int getKeyFactorsDecComNum(Long areaId, Byte level, List<Long> cids, Boolean isOwnLevel) {
        if (areaId == null || cids == null || cids.size() == 0) {
            return 0;
        }
        Integer comNum = this.homeDataMapper.getKeyFactorsDecComNum(areaId, level, cids, isOwnLevel);
        return comNum;
    }

    public Integer countCompanyByHarms(List<Long> cids, Long areaId, Byte areaLevel, Boolean isOwnLevel) {
        if (cids == null || cids.size() == 0) {
            return 0;
        }
        return this.homeDataMapper.countCompanyByHarms(cids, areaId, areaLevel, isOwnLevel);
    }

    public Integer getTrainPlanCompanyCountByHarms(List<Long> cids, Long areaId, Byte areaLevel, Boolean isOwnLevel) {
        if (cids == null || cids.size() == 0) {
            return 0;
        }
        return this.homeDataMapper.getTrainPlanCompanyCountByHarms(cids, areaId, areaLevel, isOwnLevel);
    }

    public List<CountDataModel> getComNumByScale(Long areaId, Byte level, Boolean isOwnLevel) {
        if (areaId == null) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("level", level);
        params.put("areaId", areaId);
        params.put("isOwnLevel", isOwnLevel);
        List<CountDataModel> list = this.homeDataMapper.getComNumByScale(params);
        return list;
    }

    public List<CountDataModel> getDecComNumBySacle(Long areaId, Byte level, Boolean isOwnLevel) {
        if (areaId == null) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("level", level);
        params.put("areaId", areaId);
        params.put("isOwnLevel", isOwnLevel);
        List<CountDataModel> list = this.homeDataMapper.getDecComNumBySacle(params);
        return list;
    }

    public List<CheckCountInfo> countCompanyByScale(Long areaId, Byte areaLevel, Boolean isOwnLevel) {
        return this.homeDataMapper.countCompanyByScale(areaId, areaLevel, isOwnLevel);
    }

    public Integer checkStaffCountByDate(Date beginTime, Date endTime, Long areaId, Byte areaLevel, Boolean isOwnLevel) {
        return this.homeDataMapper.checkStaffCountByDate(beginTime, endTime, areaId, areaLevel, isOwnLevel);
    }

    public List<CompanyCountInfo> countSDByArea(Long areaId, Byte areaLevel, Boolean isOwnLevel) {
        List<CompanyCountInfo> returnList = this.getHomeAreaCountInitList();
        List<CompanyCountInfo> resultList = this.homeDataMapper.countSDByArea(areaId, areaLevel, isOwnLevel);
        if (CollectionUtils.isEmpty(resultList)) {
            return returnList;
        }
        int total = resultList.stream().mapToInt(c -> c.getDiseaserCount()).sum();
        this.setReturnList(returnList, resultList, total);
        return returnList;
    }

    private List<CompanyCountInfo> getHomeAreaCountInitList() {
        ArrayList returnList = new ArrayList(){
            {
                this.add(new CompanyCountInfo());
                this.add(new CompanyCountInfo());
                this.add(new CompanyCountInfo());
                this.add(new CompanyCountInfo());
            }
        };
        return returnList;
    }

    private void setReturnList(List<CompanyCountInfo> returnList, List<CompanyCountInfo> resultList, int total) {
        int other = total;
        int size = resultList.size();
        int len = size < 3 ? size : 3;
        for (int i = 0; i < len; ++i) {
            CompanyCountInfo r = resultList.get(i);
            int count = r.getDiseaserCount();
            r.setGroupCode(NumberUtil.rateProcessing((int)count, (int)total));
            returnList.set(i, r);
            other -= count;
        }
        if (other > 0) {
            CompanyCountInfo o = new CompanyCountInfo();
            o.setGroupName("\u5176\u4ed6");
            o.setGroupCode(NumberUtil.rateProcessing((int)other, (int)total));
            o.setDiseaserCount(Integer.valueOf(other));
            returnList.set(len, o);
        }
    }

    public List<CompanyCountInfo> countOCByArea(Long areaId, Byte areaLevel, Boolean isOwnLevel) {
        List<CompanyCountInfo> returnList = this.getHomeAreaCountInitList();
        List<CompanyCountInfo> resultList = this.homeDataMapper.countOCByArea(areaId, areaLevel, isOwnLevel);
        if (CollectionUtils.isEmpty(resultList)) {
            return returnList;
        }
        int total = 0;
        for (CompanyCountInfo companyCountInfo : resultList) {
            companyCountInfo.setGroupCode(SpringEncryptUtils.decrypt((String)companyCountInfo.getGroupCode()));
        }
        ArrayList<CompanyCountInfo> finalResultList = new ArrayList<CompanyCountInfo>();
        total = this.splitOCByHarms(finalResultList, resultList);
        this.setReturnList(returnList, finalResultList, total);
        return returnList;
    }

    private int splitOCByHarms(List<CompanyCountInfo> finalResultList, List<CompanyCountInfo> resultList) {
        int total = 0;
        Map allIdAndNameMap = this.harmFactorService.getAllIdAndNameMap();
        Map<String, Set<String>> harmStaffIds = this.splitOccIds(resultList);
        for (Map.Entry<String, Set<String>> entry : harmStaffIds.entrySet()) {
            CompanyCountInfo info = new CompanyCountInfo();
            String mapKey = entry.getKey();
            String groupName = (String)allIdAndNameMap.get(mapKey);
            int size = entry.getValue().size();
            info.setGroupName(groupName);
            info.setDiseaserCount(Integer.valueOf(size));
            total += size;
            finalResultList.add(info);
        }
        this.sortCountList(finalResultList);
        return total;
    }

    private void sortCountList(List<CompanyCountInfo> finalResultList) {
        Collections.sort(finalResultList, new Comparator<CompanyCountInfo>(){

            @Override
            public int compare(CompanyCountInfo arg0, CompanyCountInfo arg1) {
                return arg1.getDiseaserCount().compareTo(arg0.getDiseaserCount());
            }
        });
    }

    private Map<String, Set<String>> splitOccIds(List<CompanyCountInfo> resultList) {
        HashMap<String, Set<String>> harmStaffIds = new HashMap<String, Set<String>>();
        for (CompanyCountInfo r : resultList) {
            String harmIds = r.getGroupName();
            String staffId = r.getGroupCode();
            if (StringUtils.isEmpty((CharSequence)harmIds)) {
                this.countByStaffId(null, staffId, harmStaffIds);
                continue;
            }
            List harmIdList = StringUtils.parseToStringList((String)harmIds, (String)",");
            harmIdList.forEach(h -> this.countByStaffId((String)h, staffId, (Map<String, Set<String>>)harmStaffIds));
        }
        return harmStaffIds;
    }

    private void countByStaffId(String key, String staffId, Map<String, Set<String>> staffIdMap) {
        HashSet<String> staffIds = staffIdMap.get(key);
        staffIds = staffIds == null ? new HashSet<String>() : staffIds;
        staffIds.add(staffId);
        staffIdMap.put(key, staffIds);
    }

    public List<CompanyCountInfo> countODByArea(Long areaId, Byte areaLevel, Boolean isOwnLevel) {
        List<CompanyCountInfo> returnList = this.getHomeAreaCountInitList();
        List<PhcThirdOccupationalDiseaserVo> odList = this.getODList(areaId, areaLevel, isOwnLevel);
        if (CollectionUtils.isEmpty(odList)) {
            return returnList;
        }
        int total = 0;
        ArrayList<CompanyCountInfo> finalResultList = new ArrayList<CompanyCountInfo>();
        total = this.splitByODName(finalResultList, odList);
        this.setReturnList(returnList, finalResultList, total);
        return returnList;
    }

    private int splitByODName(List<CompanyCountInfo> finalResultList, List<PhcThirdOccupationalDiseaserVo> odList) {
        int total = 0;
        Map<String, Set<String>> harmStaffIds = this.splitODName(odList);
        for (Map.Entry<String, Set<String>> entry : harmStaffIds.entrySet()) {
            CompanyCountInfo info = new CompanyCountInfo();
            String mapKey = entry.getKey();
            int size = entry.getValue().size();
            info.setGroupName(mapKey);
            info.setDiseaserCount(Integer.valueOf(size));
            total += size;
            finalResultList.add(info);
        }
        this.sortCountList(finalResultList);
        return total;
    }

    private Map<String, Set<String>> splitODName(List<PhcThirdOccupationalDiseaserVo> resultList) {
        HashMap<String, Set<String>> odStaffIdMap = new HashMap<String, Set<String>>();
        for (PhcThirdOccupationalDiseaserVo r : resultList) {
            String odNames = r.getDiseaseName();
            String staffId = Convert.toStr((Object)r.getIdCard());
            if (StringUtils.isEmpty((CharSequence)odNames)) {
                this.countByStaffId(null, staffId, odStaffIdMap);
                continue;
            }
            List odNameList = StringUtils.parseToStringList((String)odNames, (String)",");
            odNameList.forEach(h -> this.countByStaffId((String)h, staffId, (Map<String, Set<String>>)odStaffIdMap));
        }
        return odStaffIdMap;
    }

    private List<PhcThirdOccupationalDiseaserVo> getODList(Long areaId, Byte areaLevel, Boolean isOwnLevel) {
        PhcThirdOccupationalDiseaserParamVo checkParam = new PhcThirdOccupationalDiseaserParamVo();
        checkParam.setAreaLevel(areaLevel);
        checkParam.setAreaId(areaId);
        checkParam.setIsOwnLevel(isOwnLevel);
        checkParam.setKeywordEncrypt(checkParam.getKeyword());
        List<PhcThirdOccupationalDiseaserVo> phcThirdOccupationalDiseaserVos = this.homeDataMapper.checkOdInfoList(checkParam);
        if (CollectionUtil.isNotEmpty(phcThirdOccupationalDiseaserVos)) {
            phcThirdOccupationalDiseaserVos.forEach(p -> {
                p.setIdCard(SpringEncryptUtils.decrypt((String)p.getIdCard()));
                p.setStaffName(SpringEncryptUtils.decrypt((String)p.getStaffName()));
            });
        }
        return phcThirdOccupationalDiseaserVos;
    }

    public Integer getWorkHarmStaffCountByAreaAndYear(String areaId, Byte level, Integer year, Boolean isOwnLevel) {
        return this.homeDataMapper.getWorkHarmStaffCountByAreaAndYear(areaId, level, year, isOwnLevel);
    }

    public List<ScaleCompanyCheckNum> getHcCheckCompanyCountGroupByScale(Long areaId, Byte level, Byte isOwnLevel) {
        LocalDateTime start = DateUtil.getLocalDateTime((int)LocalDate.now().getYear(), (int)1, (int)1, (int)0, (int)0, (int)0);
        LocalDateTime end = LocalDateTime.now();
        List numBos = this.checkPlanService.countComNumByAreaGroupByScale(areaId, level, start, end, isOwnLevel);
        LinkedList<ScaleCompanyCheckNum> list = new LinkedList<ScaleCompanyCheckNum>();
        for (ScaleCompanyCheckNumBo numBo : numBos) {
            ScaleCompanyCheckNum num = new ScaleCompanyCheckNum();
            num.setCheckNum(numBo.getCheckComNum());
            num.setScale(numBo.getScale());
            list.add(num);
        }
        return list;
    }

    public Integer getCompanyFunctionalOrganizationMemberCountByAreaAndYear(String areaId, Byte level, Integer year, Boolean isOwnLevel) {
        return this.homeDataMapper.getCompanyFunctionalOrganizationMemberCountByAreaAndYear(areaId, level, year, isOwnLevel);
    }

    public List<TrainPlanCountScaleVo> getTrainPlanCompanyCountByScale(Long areaId, Byte areaLevel, Boolean isOwnLevel) {
        return this.homeDataMapper.getTrainPlanCompanyCountByScale(areaId, areaLevel, isOwnLevel);
    }

    public Integer getHcCheckCompanyCountByHarms(Long areaId, Byte level, List<Long> cids, Byte isOwnLevel) {
        if (cids == null || cids.size() == 0) {
            return 0;
        }
        LocalDateTime start = DateUtil.getLocalDateTime((int)LocalDate.now().getYear(), (int)1, (int)1, (int)0, (int)0, (int)0);
        LocalDateTime end = LocalDateTime.now();
        return this.checkPlanService.countComNumByTimeRangeByFactorByArea(areaId, level, cids, start, end, isOwnLevel);
    }

    public int getImportIndustryCompanyNum(Long areaId, Byte areaLevel, Boolean isBelongType) {
        return this.importantIndustryCategoryService.getImportIndustryCompanyNum(areaId, areaLevel, isBelongType);
    }

    public List<CompanySuperviseModel> getImportIndustryCompanyList(Long areaId, Byte areaLevel, Boolean isBelongType) {
        return this.importantIndustryCategoryService.getImportIndustryCompanyList(areaId, areaLevel, isBelongType);
    }

    public HomeHelpCompanyVo getHelpCompanyInfo(HomeIndexSearchVo searchVo) {
        CountDownLatch latch = new CountDownLatch(5);
        HomeHelpCompanyVo helpInfo = new HomeHelpCompanyVo();
        this.poolTaskExecutor.execute(() -> {
            try {
                Long regionId = searchVo.getAreaId();
                Byte regionLevel = searchVo.getAreaLevel();
                Integer isFcImportanceCompany = searchVo.getIsFcImportanceCompany() == null ? 0 : searchVo.getIsFcImportanceCompany();
                Integer belongType = searchVo.getBelongType();
                Boolean isCurrent = searchVo.getIsCurrent();
                RiskVisualDto dto = (RiskVisualDto)this.redisClient.get(this.cacheName, "visualEconomicAccountStatementDataFetch" + searchVo.hashCode(), 10800L, () -> this.reformItemBasicEconomyService.visualEconomicAccountStatementDataFetch(regionId, regionLevel, isFcImportanceCompany, belongType, isCurrent));
                Long num = dto.getNum();
                BigDecimal amount = dto.getAccount();
                log.error("\u3010\u6253\u5370ERROR\u65e5\u5fd7\u3011\u76d1\u7ba1\u7aef::\u52a9\u4f01\u60e0\u4f01::\u7ecf\u6d4e\u8d26::\u5173\u952e\u6570\u636e\u7ed3\u679c::\u5df2\u5316\u89e3\u98ce\u9669\u4f01\u4e1a\u6570[{}]::\u514d\u4e8e\u5904\u7f5a\u989d\u5ea6[{}]", (Object)num, (Object)amount);
                helpInfo.setFreePunishAmount(SysConvertTool.convertUnit((BigDecimal)amount)).setMostFreePunishAmount(SysConvertTool.convertUnit((BigDecimal)Convert.toBigDecimal((Object)num).multiply(RiskCalculator.MOST_FREE_RATE).setScale(2, RoundingMode.HALF_UP))).setLeastFreePunishAmount(SysConvertTool.convertUnit((BigDecimal)Convert.toBigDecimal((Object)num).multiply(RiskCalculator.LESS_FREE_RATE).setScale(2, RoundingMode.HALF_UP)));
            }
            finally {
                latch.countDown();
            }
        });
        this.poolTaskExecutor.execute(() -> {
            try {
                if (searchVo.getAreaId() != null) {
                    Integer companyNum;
                    searchVo.setPickupCount3("1,2");
                    searchVo.setIsDeclare("olddec");
                    HomeReceivingUnitVo data5 = this.iDcCompanyService.getData5(searchVo);
                    if (data5 != null && (companyNum = data5.getCompanyNum()) != null && companyNum != 0) {
                        BigDecimal regionNeedKeyFactoryNum = new BigDecimal(companyNum);
                        helpInfo.setRegionNeedKeyFactoryNum(Convert.toStr((Object)companyNum));
                        Integer companyTrainNum = data5.getNum4();
                        String companyTrainRate = Convert.toStr((Object)new BigDecimal(Convert.toStr((Object)companyTrainNum)).multiply(new BigDecimal("100")).divide(regionNeedKeyFactoryNum, 2, RoundingMode.HALF_UP));
                        helpInfo.setCompanyTrainNum(Convert.toStr((Object)companyTrainNum));
                        helpInfo.setCompanyTrainRate(companyTrainRate);
                    }
                }
            }
            finally {
                latch.countDown();
            }
        });
        this.poolTaskExecutor.execute(() -> {
            try {
                Object weiqiExpress = null;
                if (weiqiExpress != null) {
                    String problemResponseRate = weiqiExpress.getProblemResponseRate();
                    String accessExperts = weiqiExpress.getAccessExperts();
                    helpInfo.setProblemResponseRate(problemResponseRate);
                    helpInfo.setAccessExperts(accessExperts);
                }
            }
            finally {
                latch.countDown();
            }
        });
        this.poolTaskExecutor.execute(() -> {
            try {
                GradeSearchV314 search = new GradeSearchV314();
                search.setIsFcImportanceCompany(searchVo.getIsFcImportanceCompany());
                search.setGradeSource("" + GradeSourceEnum.CREDITSUPERVISE.getCode());
                search.setAreaId(searchVo.getAreaId());
                search.setAreaLevel(searchVo.getAreaLevel());
                search.setOrgAreaId(searchVo.getOrgAreaId());
                search.setOrgAreaLevel(searchVo.getOrgAreaLevel());
                search.setOnlyThislevel(searchVo.getIsCurrent());
                CreditSuperviseComplianceVo creditVo = this.companyGradeV3Service.getCreditSuperviseComplianceCountNew(search);
                helpInfo.setCreditSuperviseNum(creditVo.getCreditSuperviseTotal());
                helpInfo.setCreditSuperviseHgNum(creditVo.getComplianceTotal());
                helpInfo.setReformRemainTotal(creditVo.getReformRemainTotal());
            }
            finally {
                latch.countDown();
            }
        });
        this.poolTaskExecutor.execute(() -> {
            try {
                helpInfo.setOccHealthAssistantServiceCoverRate("-");
            }
            finally {
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return helpInfo;
    }

    public List<CompanyTrainVo> getRegionCompanyTrainRateList(HomeIndexSearchVo searchVo) {
        searchVo.setPickupCount3("1,2");
        searchVo.setIsDeclare("olddec");
        List<CompanyTrainVo> companyTrainList = this.iDcCompanyService.statisticRegionCompanyTrainRateBatch(searchVo);
        companyTrainList = companyTrainList.stream().filter(t -> t.getCompanyNum() != 0 && t.getCompanyTrainNum() != 0).collect(Collectors.toList());
        for (CompanyTrainVo companyTrain : companyTrainList) {
            BigDecimal divide = Convert.toBigDecimal((Object)companyTrain.getCompanyTrainNum()).multiply(Convert.toBigDecimal((Object)100)).divide(Convert.toBigDecimal((Object)companyTrain.getCompanyNum()), 2, RoundingMode.HALF_UP);
            companyTrain.setCompanyTrainRate(Double.valueOf(divide.doubleValue()));
        }
        return companyTrainList;
    }

    private static long getHeadOrManageNum(List<CertificateStaffDetailVo> certList, Long certId) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date currentTime = new Date();
        String currentTimeString = dateFormat.format(currentTime);
        HashSet<String> cidList = new HashSet<String>();
        for (CertificateStaffDetailVo c : certList) {
            boolean isOk;
            try {
                isOk = Objects.equals(c.getCertId(), certId) && c.getValidityDate() != null && dateFormat.format(c.getValidityDate()).compareTo(currentTimeString) >= 0;
            }
            catch (Exception e) {
                continue;
            }
            if (!isOk) continue;
            cidList.add(c.getCid());
        }
        return cidList.size();
    }

    private static long getCompanyTrainNum(List<CertificateStaffDetailVo> certList) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date currentTime = new Date();
        String currentTimeString = dateFormat.format(currentTime);
        HashSet<String> cidList = new HashSet<String>();
        for (CertificateStaffDetailVo c : certList) {
            boolean isOk;
            try {
                isOk = (Objects.equals(c.getCertId(), 12L) || Objects.equals(c.getCertId(), 13L)) && c.getValidityDate() != null && dateFormat.format(c.getValidityDate()).compareTo(currentTimeString) >= 0;
            }
            catch (Exception e) {
                continue;
            }
            if (!isOk) continue;
            cidList.add(c.getCid());
        }
        return cidList.size();
    }

    public HomeEnergyEfficiencyVo getEnergyEfficiency(HomeIndexSearchVo searchVo) {
        HomeEnergyEfficiencyVo efficiencyVo = new HomeEnergyEfficiencyVo();
        if (!searchVo.getAreaId().toString().startsWith("33")) {
            return efficiencyVo;
        }
        if (searchVo.getAreaLevel().intValue() != 1 && searchVo.getAreaLevel().intValue() != 2) {
            return efficiencyVo;
        }
        if (searchVo.getAreaLevel().intValue() == 1) {
            searchVo.setChooseAreaId(Long.valueOf(330100000000L));
        }
        if (searchVo.getAreaLevel().intValue() == 2) {
            searchVo.setChooseAreaId(searchVo.getAreaId());
        }
        HomeEnergyEfficiencyVo data1 = this.companyGradeV3Service.getCompanyClassifyRate(searchVo, efficiencyVo);
        HomeEnergyEfficiencyVo data2 = this.wandaZywsPunishInfoService.getData2(searchVo, data1);
        HomeEnergyEfficiencyVo data3 = this.certificateStaffDetailService.getCertificateRate(searchVo, data2);
        if (Objects.equals(1, searchVo.getIsFcImportanceCompany())) {
            data3.setRank3(null);
            data3.setScore3(null);
        }
        HomeEnergyEfficiencyVo data4 = this.wandaZywsPunishInfoService.getData4(searchVo, data3);
        HomeEnergyEfficiencyVo data5 = this.wandaZywsPunishInfoService.getData5(searchVo, data4);
        HomeEnergyEfficiencyVo data6 = this.keyFactoryService.getData6(searchVo, data5);
        HomeEnergyEfficiencyVo data7 = this.wandaZywsPunishInfoService.getData7(searchVo, data6);
        data7.setKeyIndustryTrainStatus(this.keyIndustryTrainService.getKeyIndustryTrainStatusByAreaId(searchVo));
        HomeEnergyEfficiencyVo data8 = this.getData8(searchVo, data7);
        if (Objects.equals(1, searchVo.getIsFcImportanceCompany())) {
            data8.setDeclareSort(null);
            data8.setDeclareScore(null);
        }
        return data8;
    }

    private HomeEnergyEfficiencyVo getData8(HomeIndexSearchVo searchVo, HomeEnergyEfficiencyVo efficiencyVo) {
        HomeEnergyEfficiencyVo declareSort = this.homeDataMapper.countNewReportHistory2024(searchVo);
        efficiencyVo.setDeclareNum(declareSort.getDeclareNum());
        efficiencyVo.setDeclareSort(declareSort.getDeclareSort());
        efficiencyVo.setDeclareScore(Integer.valueOf(12 - declareSort.getDeclareSort()));
        efficiencyVo.setMoreThan3Num(declareSort.getMoreThan3Num());
        return efficiencyVo;
    }

    @Generated
    public HomeDataServiceImpl() {
    }
}

