/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.home.service;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.datacentre.provider.email.IEmailService;
import cn.smarthse.modules.health.component.AsyncTaskExecutor;
import cn.smarthse.modules.health.entity.sys.SysArea;
import cn.smarthse.modules.health.supervise.entity.company.ComExpire;
import cn.smarthse.modules.health.supervise.home.cache.ExpireComNumCache;
import cn.smarthse.modules.health.supervise.home.cache.WillExpireComNumCache;
import cn.smarthse.modules.health.supervise.home.dao.ExpireDateCompanyMapper;
import cn.smarthse.modules.health.supervise.home.entity.ComExpireDate;
import cn.smarthse.modules.health.supervise.home.entity.ExpireDateCompany;
import cn.smarthse.modules.health.supervise.home.model.ComLatestSelfJudgeDate;
import cn.smarthse.modules.health.supervise.home.model.ExpireComQueryModel;
import cn.smarthse.modules.health.supervise.home.model.ExpireWorkNumComNum;
import cn.smarthse.modules.health.supervise.home.service.IExpireDateCompanyService;
import cn.smarthse.modules.health.supervise.service.harmFactorDeclare.ISuperviseHarmFactorDeclareService;
import cn.smarthse.services.hfi.api.pojo.vo.ComLatestCheckDate;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import jakarta.annotation.PostConstruct;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import tk.mybatis.mapper.entity.Example;

@Service(value="expireDateCompanyServiceImpl")
@DubboService
public class ExpireDateCompanyServiceImpl
extends BaseServiceImpl<ExpireDateCompanyMapper, ExpireDateCompany>
implements IExpireDateCompanyService {
    @DubboReference
    private ISuperviseHarmFactorDeclareService declareService;
    @Autowired
    private AsyncTaskExecutor executor;
    @DubboReference
    private ICheckPlanService checkPlanService;
    @Autowired
    private DataSourceTransactionManager txManager;
    @DubboReference(version="1.0.0")
    private IEmailService emailService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final int COM_NUM_EXPIRE_TIME = 720;
    @Autowired
    private ExpireComNumCache expireComNumMap;
    @Autowired
    private WillExpireComNumCache willExpireComNumMap;
    private volatile LocalDateTime updateTime = null;
    private Map<String, String> superviseParam = new HashMap<String, String>();

    @PostConstruct
    public void init() {
    }

    public PageInfo<ExpireDateCompany> getExpireComPageByType(ExpireComQueryModel queryModel) {
        PageHelper.startPage((int)queryModel.getJqGridParam().getPage(), (int)queryModel.getJqGridParam().getRows());
        List<Object> expireComList = null;
        Integer selectType = queryModel.getSelectType();
        switch (selectType) {
            case -1: {
                expireComList = ((ExpireDateCompanyMapper)this.dao).getExpireComList(queryModel);
                break;
            }
            case 0: {
                expireComList = ((ExpireDateCompanyMapper)this.dao).getDeclareExpireComList(queryModel);
                break;
            }
            case 1: {
                expireComList = ((ExpireDateCompanyMapper)this.dao).getHcCheckExpireComList(queryModel);
                break;
            }
            case 2: {
                expireComList = ((ExpireDateCompanyMapper)this.dao).getEvaluateExpireComList(queryModel);
                break;
            }
            case 3: {
                expireComList = ((ExpireDateCompanyMapper)this.dao).getPrincipalTrainExpireComList(queryModel);
                break;
            }
            case 4: {
                expireComList = ((ExpireDateCompanyMapper)this.dao).getManagerTrainExpireComList(queryModel);
                break;
            }
            case 5: {
                expireComList = ((ExpireDateCompanyMapper)this.dao).getPhysicalCheckExpireComList(queryModel);
                break;
            }
            case 6: {
                expireComList = ((ExpireDateCompanyMapper)this.dao).getSelfJudgeExpireComList(queryModel);
                break;
            }
            default: {
                expireComList = new LinkedList();
            }
        }
        return new PageInfo(expireComList);
    }

    public List<ExpireWorkNumComNum> getExpireComNumByType(ExpireComQueryModel queryModel) {
        return ((ExpireDateCompanyMapper)this.dao).getExpireComNumByType(queryModel);
    }

    public PageInfo<ExpireDateCompany> getWillExpireComPage(ExpireComQueryModel queryModel) {
        PageHelper.startPage((int)queryModel.getJqGridParam().getPage(), (int)queryModel.getJqGridParam().getRows());
        return new PageInfo(((ExpireDateCompanyMapper)this.dao).getWillExpireComList(queryModel));
    }

    public PageInfo<ExpireDateCompany> getWillExpireComPageByType(ExpireComQueryModel queryModel) {
        PageHelper.startPage((int)queryModel.getJqGridParam().getPage(), (int)queryModel.getJqGridParam().getRows());
        List<Object> expireComList = null;
        Integer selectType = queryModel.getSelectType();
        switch (selectType) {
            case -1: {
                expireComList = ((ExpireDateCompanyMapper)this.dao).getWillExpireComList(queryModel);
                break;
            }
            case 0: {
                expireComList = ((ExpireDateCompanyMapper)this.dao).getDeclareWillExpireComList(queryModel);
                break;
            }
            case 1: {
                expireComList = ((ExpireDateCompanyMapper)this.dao).getHcCheckWillExpireComList(queryModel);
                break;
            }
            case 2: {
                expireComList = ((ExpireDateCompanyMapper)this.dao).getEvaluateWillExpireComList(queryModel);
                break;
            }
            case 3: {
                expireComList = ((ExpireDateCompanyMapper)this.dao).getPrincipalTrainWillExpireComList(queryModel);
                break;
            }
            case 4: {
                expireComList = ((ExpireDateCompanyMapper)this.dao).getManagerTrainWillExpireComList(queryModel);
                break;
            }
            case 5: {
                expireComList = ((ExpireDateCompanyMapper)this.dao).getPhysicalCheckWillExpireComList(queryModel);
                break;
            }
            case 6: {
                expireComList = ((ExpireDateCompanyMapper)this.dao).getSelfJudgeWillExpireComList(queryModel);
                break;
            }
            default: {
                expireComList = new LinkedList();
            }
        }
        PageInfo pageInfo = new PageInfo(expireComList);
        return pageInfo;
    }

    public Long[] getExpireComNum(Long areaId, Integer level, Byte ownLevel) {
        this.checkUpdateExpireCom();
        return this.statisticsExpireComNum(areaId, level, ownLevel);
    }

    public Long[] getWillExpireComNum(Long areaId, Integer level, Byte ownLevel) {
        return this.statisticsWillExpireComNum(areaId, level, ownLevel, 30);
    }

    public Long[] getWillExpireComNum(Long areaId, Integer level, Byte ownLevel, Integer days) {
        return this.statisticsWillExpireComNum(areaId, level, ownLevel, days);
    }

    public void statisticExpireComNum(List<SysArea> areas) {
        Byte ownLevel = 0;
        this.logger.info("\u6309\u533a\u57df\u7edf\u8ba1\u8fc7\u671f\u4f01\u4e1a\u6570\u91cf:size=" + areas.size());
        for (SysArea area : areas) {
            if (this.expireComNumMap.get("" + area.getId() + ownLevel) == null) {
                this.executor.execute(() -> this.expireComNumMap.put("" + area.getId() + ownLevel, this.doStatisticsExpireComNum(area.getId(), (int)area.getLevel(), ownLevel)));
            }
            if (this.willExpireComNumMap.get("" + area.getId() + ownLevel) != null) continue;
            this.executor.execute(() -> {
                String key = area.getId() + "_" + ownLevel + "_30";
                this.willExpireComNumMap.put(key, this.doStatisticsWillExpireComNum(area.getId(), (int)area.getLevel(), ownLevel, 30));
                String key2 = area.getId() + "_" + ownLevel + "_60";
                this.willExpireComNumMap.put(key2, this.doStatisticsWillExpireComNum(area.getId(), (int)area.getLevel(), ownLevel, 60));
            });
        }
    }

    public List<ComExpireDate> getComExpireDate() {
        return ((ExpireDateCompanyMapper)this.dao).getComExpireDate();
    }

    public Map<Long, List<Integer>> expireComProject(List<Long> cids) {
        if (cids == null || cids.isEmpty()) {
            return new HashMap<Long, List<Integer>>();
        }
        Example example = new Example(ExpireDateCompany.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andIn("cid", cids);
        List<ExpireDateCompany> list = this.getListByExample(example);
        HashMap<Long, List<Integer>> map = new HashMap<Long, List<Integer>>();
        Date now = new Date();
        list.forEach(com -> {
            ArrayList<Integer> integers = new ArrayList<Integer>(8);
            if (com.getDeclareExpireDate() == null || com.getDeclareExpireDate().compareTo(now) < 0) {
                integers.add(0);
            }
            if (com.getHcCheckPlanExpireDate() == null || com.getHcCheckPlanExpireDate().compareTo(now) < 0) {
                integers.add(1);
            }
            if (com.getEvaluateExpireDate() == null || com.getEvaluateExpireDate().compareTo(now) < 0) {
                integers.add(2);
            }
            if (com.getPrincipalTrainExpireDate() == null || com.getPrincipalTrainExpireDate().compareTo(now) < 0) {
                integers.add(3);
            }
            if (com.getManagerTrainExpireDate() == null || com.getManagerTrainExpireDate().compareTo(now) < 0) {
                integers.add(4);
            }
            if (com.getPhysicalCheckExpireDate() == null || com.getPhysicalCheckExpireDate().compareTo(now) < 0) {
                integers.add(5);
            }
            if (com.getSelfJudgeExpireDate() == null || com.getSelfJudgeExpireDate().compareTo(now) < 0) {
                integers.add(6);
            }
            map.put(com.getCid(), integers);
        });
        cids.forEach(cid -> {
            if (!map.containsKey(cid)) {
                map.put((Long)cid, Arrays.asList(0, 1, 2, 3, 4, 5, 6));
            }
        });
        return map;
    }

    public void copySuperviseParamsFromSupervise(Map<String, String> params) {
        for (Map.Entry<String, String> entry : params.entrySet()) {
            this.superviseParam.put(entry.getKey(), entry.getValue());
        }
    }

    public Long[] statisticsExpireComNum(Long areaId, Integer level, Byte ownLevel) {
        String key = areaId + "_" + ownLevel;
        Long[] data = this.expireComNumMap.get(key);
        if (data != null) {
            this.logger.info("\u8fc7\u671f\u4f01\u4e1a\u6570\u91cf,\u7f13\u5b58\u547d\u4e2d:areaId:" + areaId);
            this.executor.execute(() -> this.expireComNumMap.put(key, this.doStatisticsExpireComNum(areaId, level, ownLevel)));
            return data;
        }
        this.logger.info("\u8fc7\u671f\u4f01\u4e1a\u6570\u91cf,\u7f13\u5b58\u65e0\u547d\u4e2d:areaId:" + areaId);
        data = this.doStatisticsExpireComNum(areaId, level, ownLevel);
        this.expireComNumMap.put("" + areaId + ownLevel, data);
        return data;
    }

    public Long[] statisticsWillExpireComNum(Long areaId, Integer level, Byte ownLevel, Integer days) {
        String key = areaId + "_" + ownLevel + "_" + days;
        Long[] data = this.willExpireComNumMap.get(key);
        if (data != null) {
            this.executor.execute(() -> this.willExpireComNumMap.put(key, this.doStatisticsWillExpireComNum(areaId, level, ownLevel, days)));
            return data;
        }
        data = this.doStatisticsWillExpireComNum(areaId, level, ownLevel, days);
        this.willExpireComNumMap.put(key, data);
        return data;
    }

    private Long[] doStatisticsExpireComNum(Long areaId, Integer level, Byte ownLevel) {
        this.logger.info("\u7edf\u8ba1\u8fc7\u671f\u4f01\u4e1a\u6570\u91cf,area_id=" + areaId);
        Long[] data = new Long[7];
        ExpireComQueryModel queryModel = new ExpireComQueryModel();
        queryModel.setAreaId(areaId);
        queryModel.setLevel(Byte.valueOf(level.byteValue()));
        queryModel.setOwnLevel(ownLevel);
        data[6] = ((ExpireDateCompanyMapper)this.dao).countJudgeOutDateComNum(queryModel);
        data[3] = ((ExpireDateCompanyMapper)this.dao).getExpireMainTrainComNum(queryModel);
        data[4] = ((ExpireDateCompanyMapper)this.dao).getExpireHseTrainComNum(queryModel);
        data[5] = ((ExpireDateCompanyMapper)this.dao).physicalCheckExpireCount(queryModel);
        data[0] = ((ExpireDateCompanyMapper)this.dao).getExpireDeclareCompNum(queryModel);
        data[2] = ((ExpireDateCompanyMapper)this.dao).countOverdueEvaluate(queryModel);
        data[1] = ((ExpireDateCompanyMapper)this.dao).getHcCheckExpireCompanyCount(queryModel);
        return data;
    }

    private Long[] doStatisticsWillExpireComNum(Long areaId, Integer level, Byte ownLevel, Integer days) {
        this.logger.info("\u7edf\u8ba1\u5373\u5c06\u8fc7\u671f\u4f01\u4e1a\u6570\u91cf,area_id=" + areaId);
        Long[] data = new Long[7];
        ExpireComQueryModel queryModel = new ExpireComQueryModel();
        queryModel.setAreaId(areaId);
        queryModel.setLevel(Byte.valueOf(level.byteValue()));
        queryModel.setOwnLevel(ownLevel);
        queryModel.setDays(days);
        data[6] = ((ExpireDateCompanyMapper)this.dao).countJudgeOutDateComNumWill(queryModel);
        data[3] = ((ExpireDateCompanyMapper)this.dao).getExpireMainTrainComNumWill(queryModel);
        data[4] = ((ExpireDateCompanyMapper)this.dao).getExpireHseTrainComNumWill(queryModel);
        data[5] = ((ExpireDateCompanyMapper)this.dao).physicalCheckExpireCountWill(queryModel);
        data[0] = ((ExpireDateCompanyMapper)this.dao).getExpireDeclareCompNumWill(queryModel);
        data[2] = ((ExpireDateCompanyMapper)this.dao).countOverdueEvaluateWill(queryModel);
        data[1] = ((ExpireDateCompanyMapper)this.dao).getHcCheckExpireCompanyCountWill(queryModel);
        return data;
    }

    private void doStatisticsComExpireDate() {
        try {
            this.updateTime = LocalDateTime.now();
            this.logger.info("\u7edf\u8ba1\u8fc7\u671f\u4f01\u4e1a\u5230\u7edf\u8ba1\u8868com_expire_date\u4e2d...");
            HashSet<Long> cids = new HashSet<Long>();
            List<ComExpire> list1 = this.getSelfJudgeExpireCom();
            Map<Long, Date> map1 = this.parseExpireCom(list1, cids);
            this.logger.info("\u7edf\u8ba1\u8fc7\u671f\u4f01\u4e1a\u5230\u7edf\u8ba1\u8868com_expire_date\u4e2d->\u81ea\u6211\u8bc4\u4f30\u8fc7\u671f\u65f6\u95f4\u83b7\u53d6\u5b8c\u6210...");
            List<ComExpire> list2 = ((ExpireDateCompanyMapper)this.dao).getExpireMainTrainCom();
            Map<Long, Date> map2 = this.parseExpireCom(list2, cids);
            this.logger.info("\u7edf\u8ba1\u8fc7\u671f\u4f01\u4e1a\u5230\u7edf\u8ba1\u8868com_expire_date\u4e2d->\u4e3b\u8981\u8d1f\u8d23\u4eba\u57f9\u8bad\u8fc7\u671f\u65f6\u95f4\u83b7\u53d6\u5b8c\u6210...");
            List<ComExpire> list3 = ((ExpireDateCompanyMapper)this.dao).getManagerTrainExpire();
            Map<Long, Date> map3 = this.parseExpireCom(list3, cids);
            this.logger.info("\u7edf\u8ba1\u8fc7\u671f\u4f01\u4e1a\u5230\u7edf\u8ba1\u8868com_expire_date\u4e2d->\u7ba1\u7406\u4eba\u5458\u57f9\u8bad\u8fc7\u671f\u65f6\u95f4\u83b7\u53d6\u5b8c\u6210...");
            List<ComExpire> list4 = ((ExpireDateCompanyMapper)this.dao).physicalCheckExpireComFromView();
            Map<Long, Date> map4 = this.parseExpireCom(list4, cids);
            this.logger.info("\u7edf\u8ba1\u8fc7\u671f\u4f01\u4e1a\u5230\u7edf\u8ba1\u8868com_expire_date\u4e2d->\u5728\u5c97\u671f\u95f4\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5\u8fc7\u671f\u65f6\u95f4\u83b7\u53d6\u5b8c\u6210...");
            List<ComExpire> list5 = ((ExpireDateCompanyMapper)this.dao).getExpireDeclareComFromView();
            Map<Long, Date> map5 = this.parseExpireCom(list5, cids);
            this.logger.info("\u7edf\u8ba1\u8fc7\u671f\u4f01\u4e1a\u5230\u7edf\u8ba1\u8868com_expire_date\u4e2d->\u7533\u62a5\u8fc7\u671f\u65f6\u95f4\u83b7\u53d6\u5b8c\u6210...");
            List<ComExpire> list6 = ((ExpireDateCompanyMapper)this.dao).getEvaluateExpireComFromView();
            Map<Long, Date> map6 = this.parseExpireCom(list6, cids);
            this.logger.info("\u7edf\u8ba1\u8fc7\u671f\u4f01\u4e1a\u5230\u7edf\u8ba1\u8868com_expire_date\u4e2d->\u73b0\u72b6\u8bc4\u4ef7\u8fc7\u671f\u65f6\u95f4\u83b7\u53d6\u5b8c\u6210...");
            List<ComExpire> list7 = this.getHcCheckExpireCom();
            Map<Long, Date> map7 = this.parseExpireCom(list7, cids);
            this.logger.info("\u7edf\u8ba1\u8fc7\u671f\u4f01\u4e1a\u5230\u7edf\u8ba1\u8868com_expire_date\u4e2d->\u5b9a\u671f\u68c0\u6d4b\u8fc7\u671f\u65f6\u95f4\u83b7\u53d6\u5b8c\u6210...");
            LinkedList<ExpireDateCompany> list = new LinkedList<ExpireDateCompany>();
            for (Long cid : cids) {
                ExpireDateCompany expireDateCompany = new ExpireDateCompany();
                expireDateCompany.setCid(cid);
                expireDateCompany.setSelfJudgeExpireDate(map1.get(cid));
                expireDateCompany.setPrincipalTrainExpireDate(map2.get(cid));
                expireDateCompany.setManagerTrainExpireDate(map3.get(cid));
                expireDateCompany.setPhysicalCheckExpireDate(map4.get(cid));
                expireDateCompany.setDeclareExpireDate(map5.get(cid));
                expireDateCompany.setEvaluateExpireDate(map6.get(cid));
                expireDateCompany.setHcCheckPlanExpireDate(map7.get(cid));
                expireDateCompany.setUpdateBy(Long.valueOf(0L));
                expireDateCompany.setCreateBy(Long.valueOf(0L));
                expireDateCompany.setUpdateDate(new Date());
                expireDateCompany.setCreateDate(new Date());
                expireDateCompany.setIsValid(Boolean.valueOf(true));
                list.add(expireDateCompany);
            }
            ((ExpireDateCompanyMapper)this.dao).deleteAll();
            this.logger.info("\u7edf\u8ba1\u8fc7\u671f\u4f01\u4e1a\u5230\u7edf\u8ba1\u8868com_expire_date\u4e2d->\u6279\u91cf\u6dfb\u52a0\u4f01\u4e1a\u8fc7\u671f\u65f6\u95f4,size=" + list.size());
            List lists = ExpireDateCompanyServiceImpl.splitList(list, 500);
            for (List<ExpireDateCompany> list8 : lists) {
                this.insertSubBatch(list8);
            }
            this.logger.info("\u7edf\u8ba1\u8fc7\u671f\u4f01\u4e1a\u5230\u7edf\u8ba1\u8868com_expire_date\u4e2d->\u7edf\u8ba1\u8fc7\u671f\u4f01\u4e1a\u5230\u7edf\u8ba1\u8868com_expire_date\u4e2d...\u5b8c\u6210");
            this.doStatisticsComExpireNum();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u7edf\u8ba1\u8fc7\u671f\u4f01\u4e1a\u5230\u7edf\u8ba1\u8868com_expire_date\u4e2d->\u5f02\u5e38", (Throwable)e);
            this.emailService.sendExceptionEmail("\u7edf\u8ba1\u8fc7\u671f\u4f01\u4e1a\u5f02\u5e38", e);
        }
    }

    private List<ComExpire> getSelfJudgeExpireCom() {
        List<ComLatestSelfJudgeDate> latestDateList = ((ExpireDateCompanyMapper)this.dao).getComLatestSelfJudgeDate();
        String general_self_assessment_warning_cycle_key = "general_self_assessment_warning_cycle";
        String serious_self_assessment_warning_cycle_key = "serious_self_assessment_warning_cycle";
        int generalPlusYear = 3;
        int seriousPlusYear = 1;
        String s1 = this.superviseParam.get(general_self_assessment_warning_cycle_key);
        this.logger.info("\u4e00\u822c\u7c7b\u522b\u81ea\u6211\u8bc4\u4f30\u9884\u8b66\u5468\u671f:{}", (Object)s1);
        if (s1 != null && !s1.isEmpty()) {
            generalPlusYear = Integer.parseInt(s1);
        }
        String s2 = this.superviseParam.get(serious_self_assessment_warning_cycle_key);
        this.logger.info("\u4e25\u91cd\u7c7b\u522b\u81ea\u6211\u8bc4\u4f30\u9884\u8b66\u5468\u671f:{}", (Object)s2);
        if (s2 != null && !s2.isEmpty()) {
            seriousPlusYear = Integer.parseInt(s2);
        }
        int plusYear = 1;
        LinkedList<ComExpire> rList = new LinkedList<ComExpire>();
        for (ComLatestSelfJudgeDate judgeDate : latestDateList) {
            ComExpire comExpire = new ComExpire();
            comExpire.setCid(judgeDate.getCid());
            if (judgeDate.getUpdateDate() == null) {
                comExpire.setExpireDate(null);
                this.logger.warn("\u6700\u65b0\u8bc4\u5b9a\u65f6\u95f4\u4e3a\u7a7a");
            } else {
                plusYear = judgeDate.getOccupationalRiskClassify() != null && judgeDate.getOccupationalRiskClassify().equals(0) ? seriousPlusYear : generalPlusYear;
                Date date = DateUtils.addYear((Date)judgeDate.getUpdateDate(), (int)plusYear);
                comExpire.setExpireDate(date);
            }
            rList.add(comExpire);
        }
        return rList;
    }

    private void insertSubBatch(List<ExpireDateCompany> subList) {
        this.logger.info("\u7edf\u8ba1\u8fc7\u671f\u4f01\u4e1a\u5230\u7edf\u8ba1\u8868com_expire_date\u4e2d->\u6309\u6279\u6b21\u63d2\u5165\u8fc7\u671f\u4f01\u4e1a:size=" + subList.size());
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
        try {
            ((ExpireDateCompanyMapper)this.dao).insertBatch(subList);
            this.txManager.commit(status);
        }
        catch (Exception e) {
            this.txManager.rollback(status);
            e.printStackTrace();
            this.logger.error("\u3010\u7edf\u8ba1\u8fc7\u671f\u4f01\u4e1a\u5230\u7edf\u8ba1\u8868com_expire_date\u4e2d->\u63d2\u5165\u4f01\u4e1a\u8fc7\u671f\u65f6\u95f4\u5f02\u5e38\u3011", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private List<ComExpire> getHcCheckExpireCom() {
        int plusYear = 3;
        List list = this.checkPlanService.getComLatestCheckDate();
        LinkedList<ComExpire> rList = new LinkedList<ComExpire>();
        for (ComLatestCheckDate checkDate : list) {
            ComExpire comExpire = new ComExpire();
            comExpire.setCid(checkDate.getCid());
            if (checkDate.getLatestCheckDate() == null) {
                comExpire.setExpireDate(null);
                this.logger.warn("\u6700\u65b0\u68c0\u6d4b\u65f6\u95f4\u4e3a\u7a7a");
            } else {
                plusYear = 3;
                if (checkDate.getOccupationalRiskClassify() != null && checkDate.getOccupationalRiskClassify().equals(0)) {
                    plusYear = 1;
                }
                Date date = DateUtil.getDate((LocalDateTime)checkDate.getLatestCheckDate().plusYears(plusYear));
                comExpire.setExpireDate(date);
            }
            rList.add(comExpire);
        }
        return rList;
    }

    private void doStatisticsComExpireNum() {
        LinkedList<SysArea> list = new LinkedList<SysArea>();
        SysArea sysArea = new SysArea();
        sysArea.setId(Long.valueOf(0L));
        sysArea.setLevel(Byte.valueOf((byte)0));
        list.add(sysArea);
        sysArea = new SysArea();
        sysArea.setId(Long.valueOf(330000000000L));
        sysArea.setLevel(Byte.valueOf((byte)1));
        list.add(sysArea);
        sysArea = new SysArea();
        sysArea.setId(Long.valueOf(330522000000L));
        sysArea.setLevel(Byte.valueOf((byte)3));
        list.add(sysArea);
        this.statisticExpireComNum(list);
    }

    private Map<Long, Date> parseExpireCom(List<ComExpire> comExpires, Set<Long> cids) {
        HashMap<Long, Date> map = new HashMap<Long, Date>();
        for (ComExpire expire : comExpires) {
            if (expire.getCid() == null) continue;
            cids.add(expire.getCid());
            map.put(expire.getCid(), expire.getExpireDate());
        }
        return map;
    }

    private synchronized void checkUpdateExpireCom() {
        if (this.updateTime == null || DateUtil.caculateMinutes((LocalDateTime)this.updateTime, (LocalDateTime)LocalDateTime.now()) > 720L) {
            this.updateTime = LocalDateTime.now();
            this.executor.execute(this::doStatisticsComExpireDate);
        }
    }

    public static <T> List<List<T>> splitList(List<T> resList, int count) {
        if (resList == null || count < 1) {
            return new ArrayList<List<T>>();
        }
        ArrayList<List<T>> ret = new ArrayList<List<T>>();
        int size = resList.size();
        if (size <= count) {
            ret.add(resList);
        } else {
            int pre = size / count;
            int last = size % count;
            for (int i = 0; i < pre; ++i) {
                ArrayList<T> itemList = new ArrayList<T>();
                for (int j = 0; j < count; ++j) {
                    itemList.add(resList.get(i * count + j));
                }
                ret.add(itemList);
            }
            if (last > 0) {
                ArrayList<T> itemList = new ArrayList<T>();
                for (int i = 0; i < last; ++i) {
                    itemList.add(resList.get(pre * count + i));
                }
                ret.add(itemList);
            }
        }
        return ret;
    }
}

