/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.home.service;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.datacentre.provider.email.IEmailService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.component.AsyncTaskExecutor;
import cn.smarthse.modules.health.entity.sys.SysArea;
import cn.smarthse.modules.health.supervise.home.dao.AbnormalOrgMapper;
import cn.smarthse.modules.health.supervise.home.entity.AbnormalOrg;
import cn.smarthse.modules.health.supervise.home.model.AbnormalType;
import cn.smarthse.modules.health.supervise.home.service.IAbnormalOrgService;
import cn.smarthse.modules.health.supervise.model.AbnormalOrgComResult;
import cn.smarthse.modules.health.supervise.model.EarlyWarnThreshold;
import cn.smarthse.modules.health.supervise.service.check.ISuperviseCheckAbnormalService;
import cn.smarthse.modules.health.supervise.service.check.ISupervisePhcPhysicalCheckService;
import cn.smarthse.modules.health.supervise.service.company.IThirdCompanyService;
import cn.smarthse.modules.health.supervise.service.evaluate.IThirdEvaluateService;
import cn.smarthse.modules.health.supervise.service.sys.ISysAreaService;
import cn.smarthse.modules.health.supervise.vo.evaluate.EvaluateMaxTimeByOrgIdVo;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrganization;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrganizationService;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import com.alibaba.fastjson.JSON;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
@DubboService
public class AbnormalOrgServiceImp
extends BaseServiceImpl<AbnormalOrgMapper, AbnormalOrg>
implements IAbnormalOrgService {
    @DubboReference
    private ISupervisePhcPhysicalCheckService phcPhysicalCheckService;
    @DubboReference
    private IThirdEvaluateService thirdEvaluateService;
    @DubboReference
    private ISysAreaService sysAreaService;
    @Autowired
    private AsyncTaskExecutor executor;
    @DubboReference
    private IThirdCompanyService thirdCompanyService;
    @DubboReference
    private ICheckPlanService checkPlanService;
    @DubboReference
    private ISuperviseCheckAbnormalService superviseCheckAbnormalService;
    @DubboReference
    private IThirdOrganizationService thirdOrganizationService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @DubboReference(version="1.0.0")
    private IEmailService emailService;
    private static volatile int statisticsStatus = 2;
    private static final Map<Long, LocalDateTime> statisticMap = new HashMap<Long, LocalDateTime>();
    private static final int STATISTICS_EXPIRE_TIME = 180;

    public void statisticsAbnormalOrg(List<AbnormalOrg> abnormalOrgs, EarlyWarnThreshold threshold) {
        LocalDateTime time = statisticMap.get(threshold.getSuperviseUserId());
        if (time == null || DateUtil.caculateMinutes((LocalDateTime)time, (LocalDateTime)LocalDateTime.now()) > 180L) {
            this.executor.execute(() -> this.statistics(abnormalOrgs, threshold));
        }
    }

    public void doStatisticsAbnormalOrgNow(List<AbnormalOrg> abnormalOrgs, EarlyWarnThreshold threshold) {
        this.executor.execute(() -> this.statistics(abnormalOrgs, threshold));
    }

    private void updateToCompleted(Long superviseUserId) {
        ((AbnormalOrgMapper)this.dao).updateToCompleted(superviseUserId);
    }

    private void deleteByStatus(byte status, Long superViseUserId) {
        Example example = new Example(AbnormalOrg.class);
        example.createCriteria().andEqualTo("status", (Object)status).andEqualTo("superviseUserId", (Object)superViseUserId);
        ((AbnormalOrgMapper)this.dao).deleteByExample(example);
    }

    private void statistics(List<AbnormalOrg> abnormalOrgs, EarlyWarnThreshold threshold) {
        try {
            this.logger.info("\u5f00\u59cb\u7edf\u8ba1\u5f02\u5e38\u673a\u6784.........");
            this.deleteByStatus((byte)1, threshold.getSuperviseUserId());
            List<AbnormalOrg> list = this.doStatistics(abnormalOrgs, threshold);
            for (AbnormalOrg org : list) {
                org.setSuperviseUserId(threshold.getSuperviseUserId());
                this.add(org);
            }
            this.deleteByStatus((byte)2, threshold.getSuperviseUserId());
            this.updateToCompleted(threshold.getSuperviseUserId());
            this.logger.info("\u7528\u6237\uff1a" + threshold.getSuperviseUserId() + " \u5f02\u5e38\u673a\u6784\u7edf\u8ba1\u5b8c\u6210.........,\u6570\u91cf:" + list.size());
            statisticMap.put(threshold.getSuperviseUserId(), LocalDateTime.now());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u5f02\u5e38\u673a\u6784\u7edf\u8ba1\u5f02\u5e38", (Throwable)e);
            this.emailService.sendExceptionEmail("\u5f02\u5e38\u673a\u6784\u7edf\u8ba1\u5f02\u5e38", e);
        }
    }

    private List<AbnormalOrg> doStatistics(List<AbnormalOrg> abnormalOrgs, EarlyWarnThreshold threshold) {
        LinkedList<AbnormalOrg> list = new LinkedList<AbnormalOrg>();
        LinkedList<AbnormalOrgComResult> orgIds = new LinkedList<AbnormalOrgComResult>();
        for (AbnormalOrg abnormalOrg : abnormalOrgs) {
            Date latestDate = null;
            Date latestDate1 = null;
            Date latestDate2 = null;
            Date latestDate3 = null;
            Date latestDate4 = null;
            List list1 = this.phcPhysicalCheckService.listOrgLastReportTime(Arrays.asList(abnormalOrg.getOrgId()), abnormalOrg.getAreaId());
            if (list1 != null && !list1.isEmpty()) {
                latestDate1 = ((EvaluateMaxTimeByOrgIdVo)list1.get(0)).getBeginMaxtime();
            }
            latestDate = latestDate1;
            List list2 = this.thirdEvaluateService.listNowEvaOrgIdLastTime(abnormalOrg.getAreaId(), Arrays.asList(abnormalOrg.getOrgId()));
            if (list2 != null && !list2.isEmpty()) {
                latestDate2 = ((EvaluateMaxTimeByOrgIdVo)list2.get(0)).getBeginMaxtime();
            }
            latestDate = this.getMaxDate(latestDate, latestDate2);
            List list3 = this.thirdEvaluateService.listPreEvaOrgIdLastTime(abnormalOrg.getAreaId(), Arrays.asList(abnormalOrg.getOrgId()));
            if (list3 != null && !list3.isEmpty()) {
                latestDate3 = ((EvaluateMaxTimeByOrgIdVo)list3.get(0)).getBeginMaxtime();
            }
            latestDate = this.getMaxDate(latestDate, latestDate3);
            List<EvaluateMaxTimeByOrgIdVo> list4 = this.getHcCheckThirdOrgMaxTimeVo(new Long[]{abnormalOrg.getOrgId()}, abnormalOrg.getAreaId());
            if (!list4.isEmpty()) {
                latestDate4 = list4.get(0).getBeginMaxtime();
            }
            if (!this.isAbnormal(abnormalOrg, latestDate = this.getMaxDate(latestDate, latestDate4))) continue;
            orgIds.add(new AbnormalOrgComResult(abnormalOrg.getOrgId(), null));
        }
        this.logger.info("\u6ce8\u9500\u5907\u6848\u540e\u5f00\u5c55\u4e1a\u52a1\u673a\u6784:" + JSON.toJSONString(orgIds));
        list.addAll(this.getByIds(orgIds, AbnormalType.Type8));
        return list;
    }

    private Date getMaxDate(Date date1, Date date2) {
        if (date1 == null) {
            return date2;
        }
        if (date2 == null) {
            return date1;
        }
        return date1.compareTo(date1) > 0 ? date1 : date2;
    }

    private boolean isAbnormal(AbnormalOrg abnormalOrg, Date lateDate) {
        if (lateDate == null) {
            return false;
        }
        return abnormalOrg.getLogoutTime().compareTo(lateDate) < 0;
    }

    private List<EvaluateMaxTimeByOrgIdVo> getHcCheckThirdOrgMaxTimeVo(Long[] orgIds, Long areaId) {
        ArrayList<EvaluateMaxTimeByOrgIdVo> list = new ArrayList<EvaluateMaxTimeByOrgIdVo>();
        for (Long orgId : orgIds) {
            EvaluateMaxTimeByOrgIdVo vo = new EvaluateMaxTimeByOrgIdVo();
            vo.setOrgId(orgId);
            SysArea area = (SysArea)this.sysAreaService.getById(areaId);
            if (area == null) continue;
            vo.setBeginMaxtime(this.getLastHcCheckReportTimeByOrgAndArea(areaId, area.getLevel(), orgId));
            list.add(vo);
        }
        return list;
    }

    private Date getLastHcCheckReportTimeByOrgAndArea(Long orgId, Byte level, Long areaId) {
        List cids = this.thirdCompanyService.getCidByArea(areaId, level);
        LocalDateTime lastCheckTime = this.checkPlanService.getLastCheckStartTimeByOrg(orgId, cids);
        if (lastCheckTime == null) {
            return null;
        }
        return DateUtil.getDate((LocalDateTime)lastCheckTime);
    }

    private List<AbnormalOrg> getListG(Integer recheckDays) {
        List orgIds = this.superviseCheckAbnormalService.checkResult2Unreport(Long.valueOf(0L), Byte.valueOf((byte)0), recheckDays.intValue());
        this.logger.info("\u672a\u53ca\u65f6\u4e0a\u4f20\u590d\u67e5\u4f53\u68c0\u8bb0\u5f55\u7684\u673a\u6784(\u9608\u503c:" + recheckDays + "):" + JSON.toJSONString((Object)orgIds));
        return this.getByIds(orgIds, AbnormalType.Type7);
    }

    private List<AbnormalOrg> getListH(Integer odDays) {
        List orgIds = this.superviseCheckAbnormalService.checkResult3Unreport(Long.valueOf(0L), Byte.valueOf((byte)0), odDays.intValue());
        this.logger.info("\u672a\u53ca\u65f6\u4e0a\u4f20\u804c\u4e1a\u75c5\u8bca\u65ad\u7ed3\u679c(\u9608\u503c:" + odDays + "):" + JSON.toJSONString((Object)orgIds));
        return this.getByIds(orgIds, AbnormalType.Type6);
    }

    private List<AbnormalOrg> getByIds(List<AbnormalOrgComResult> list, AbnormalType abnormalType) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        list = list.stream().distinct().collect(Collectors.toList());
        ArrayList<Long> orgIds = new ArrayList<Long>();
        HashMap<Long, String> orgIdProjectsMap = new HashMap<Long, String>();
        for (AbnormalOrgComResult abnormalOrgComResult : list) {
            orgIds.add(abnormalOrgComResult.getCidOrOrgId());
            orgIdProjectsMap.put(abnormalOrgComResult.getCidOrOrgId(), abnormalOrgComResult.getProjectIds());
        }
        List thirdOrganizations = this.thirdOrganizationService.getAllByIds(orgIds);
        Map map = this.sysAreaProvideService.getAreaMap();
        HashMap<Long, ThirdOrganization> map2 = new HashMap<Long, ThirdOrganization>();
        for (ThirdOrganization org : thirdOrganizations) {
            map2.put(org.getId(), org);
        }
        LinkedList<AbnormalOrg> abnormalOrgs = new LinkedList<AbnormalOrg>();
        for (Long id : orgIds) {
            ThirdOrganization org = (ThirdOrganization)map2.get(id);
            if (org == null) continue;
            AreaModel areaModel = (AreaModel)map.get(org.getAreaId());
            AbnormalOrg abnormalOrg = new AbnormalOrg();
            abnormalOrg.setOrgId(id);
            abnormalOrg.setOrgName(org.getName());
            abnormalOrg.setStatus(Byte.valueOf((byte)1));
            if (areaModel != null) {
                abnormalOrg.setWorkAddress(areaModel.getProvinceName() + areaModel.getCityName() + areaModel.getAreaName() + org.getAddress());
            }
            abnormalOrg.setDescMsg(abnormalType.getDesc());
            abnormalOrg.setAbnormalType(abnormalType.getType());
            abnormalOrg.setCreateBy(Long.valueOf(0L));
            abnormalOrg.setCreateDate(new Date());
            abnormalOrg.setUpdateBy(Long.valueOf(0L));
            abnormalOrg.setUpdateDate(new Date());
            abnormalOrg.setIsValid(Boolean.valueOf(true));
            abnormalOrg.setAreaId(Long.valueOf(0L));
            abnormalOrg.setOrgType(org.getOrgType());
            abnormalOrg.setProjectIds((String)orgIdProjectsMap.get(abnormalOrg.getOrgId()));
            abnormalOrgs.add(abnormalOrg);
        }
        return abnormalOrgs;
    }
}

