/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.home.service;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.datacentre.model.platform.riskFactors.OccupationalRiskAttrDc;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.email.IEmailService;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.health.component.AsyncTaskExecutor;
import cn.smarthse.modules.health.provider.IOccupationalRiskAttrDcService;
import cn.smarthse.modules.health.supervise.entity.warning.CompanyHarms;
import cn.smarthse.modules.health.supervise.home.dao.AbnormalComMapper;
import cn.smarthse.modules.health.supervise.home.entity.AbnormalCom;
import cn.smarthse.modules.health.supervise.home.model.AbnormalType;
import cn.smarthse.modules.health.supervise.home.service.IAbnormalComService;
import cn.smarthse.modules.health.supervise.model.AbnormalOrgComResult;
import cn.smarthse.modules.health.supervise.model.EarlyWarnThreshold;
import cn.smarthse.modules.health.supervise.service.check.ISupervisePhcPhysicalCheckService;
import cn.smarthse.modules.health.supervise.service.reform.IReformService;
import cn.smarthse.modules.health.supervise.service.selfjudge.IOccupationalSelfJudgeStatisticService;
import cn.smarthse.services.hfi.api.model.ComFactorQueryModel;
import cn.smarthse.services.hfi.api.pojo.bo.ChemicalCheckResultBo;
import cn.smarthse.services.hfi.api.pojo.bo.DustCheckResultBo;
import cn.smarthse.services.hfi.api.pojo.bo.FactorBo;
import cn.smarthse.services.hfi.api.service.ICheckFactorService;
import cn.smarthse.services.hfi.api.service.ICheckResultService;
import com.alibaba.fastjson.JSON;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
@DubboService
public class AbnormalComServiceImp
extends BaseServiceImpl<AbnormalComMapper, AbnormalCom>
implements IAbnormalComService {
    private final Double SIMILARITY = 0.5;
    @DubboReference
    private ISupervisePhcPhysicalCheckService phcPhysicalCheckService;
    @Autowired
    private AsyncTaskExecutor executor;
    @DubboReference
    private ICheckFactorService checkFactorService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @DubboReference
    private ICheckResultService checkResultService;
    @DubboReference
    private IOccupationalRiskAttrDcService riskAttrDcService;
    @DubboReference(version="1.0.0")
    private IHarmFactorService harmFactorService;
    @DubboReference(version="1.0.0")
    private IEmailService emailService;
    @DubboReference
    private IOccupationalSelfJudgeStatisticService occupationalSelfJudgeStatisticService;
    @DubboReference
    private IReformService reformService;
    private static volatile int statisticsStatus = 2;
    private static final Map<Long, LocalDateTime> statisticMap = new HashMap<Long, LocalDateTime>();
    private static final int STATISTICS_EXPIRE_TIME = 180;

    public List<AbnormalCom> getAll(Long areaId, byte level, EarlyWarnThreshold threshold) {
        return ((AbnormalComMapper)this.dao).getAll(areaId, level);
    }

    public void statisticsAbnormalCom(EarlyWarnThreshold threshold) {
        LocalDateTime statisticTime = statisticMap.get(threshold.getSuperviseUserId());
        if (statisticTime == null || DateUtil.caculateMinutes((LocalDateTime)statisticTime, (LocalDateTime)LocalDateTime.now()) > 180L) {
            this.executor.execute(() -> this.doStatisticsAbnormalCom(threshold));
        }
    }

    public void doStatisticsAbnormalComNow(EarlyWarnThreshold threshold) {
        this.executor.execute(() -> this.doStatisticsAbnormalCom(threshold));
    }

    private void deleteByStatus(Byte status, Long superviseUserId) {
        Example example = new Example(AbnormalCom.class);
        example.createCriteria().andEqualTo("status", (Object)status).andEqualTo("superviseUserId", (Object)superviseUserId);
        ((AbnormalComMapper)this.dao).deleteByExample(example);
    }

    private void updateToCompleted(Long superviseUserId) {
        ((AbnormalComMapper)this.dao).updateToCompleted(superviseUserId);
    }

    private void deleteAll() {
        ((AbnormalComMapper)this.dao).deleteAll();
    }

    private void doStatisticsAbnormalCom(EarlyWarnThreshold threshold) {
        try {
            this.logger.info("\u5f00\u59cb\u7edf\u8ba1\u5f02\u5e38\u4f01\u4e1a.........");
            this.deleteByStatus((byte)1, threshold.getSuperviseUserId());
            List<AbnormalCom> abnormalComs = this.statisticsAbnormalComList(threshold);
            for (AbnormalCom com : abnormalComs) {
                com.setCreateBy(Long.valueOf(0L));
                com.setUpdateBy(Long.valueOf(0L));
                com.setCreateDate(new Date());
                com.setUpdateDate(new Date());
                com.setIsValid(Boolean.valueOf(true));
                com.setSuperviseUserId(threshold.getSuperviseUserId());
                this.add(com);
            }
            this.deleteByStatus((byte)2, threshold.getSuperviseUserId());
            this.updateToCompleted(threshold.getSuperviseUserId());
            this.logger.info("\u7528\u6237:" + threshold.getSuperviseUserId() + "\u5f02\u5e38\u4f01\u4e1a\u7edf\u8ba1\u5b8c\u6210.........\u6570\u91cf:" + abnormalComs.size());
            statisticMap.put(threshold.getSuperviseUserId(), LocalDateTime.now());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u5f02\u5e38\u4f01\u4e1a\u7edf\u8ba1\u5f02\u5e38::" + e.toString(), (Throwable)e);
            this.emailService.sendExceptionEmail("\u68c0\u6d4b\u670d\u52a1\u5f02\u5e38", e);
        }
    }

    private List<AbnormalCom> statisticsAbnormalComList(EarlyWarnThreshold threshold) throws InterruptedException, ExecutionException {
        Map factorIdNameMap = this.harmFactorService.getAllIdAndNameMapIncludeInValid();
        long s = System.currentTimeMillis();
        LocalDateTime nowDateTime = LocalDateTime.now();
        LocalDateTime lastYear = nowDateTime.minusYears(1L);
        List<CompanyHarms> list1 = this.getHcCheckCompanyHarmList(lastYear, nowDateTime);
        List list2 = this.phcPhysicalCheckService.getCheckCompanyHarms(Long.valueOf(0L), Byte.valueOf((byte)0));
        List<CompanyHarms> list3 = this.getHcCheckCompanyHarmList(lastYear.minusYears(1L), lastYear);
        list1.sort(Comparator.comparing(CompanyHarms::getCid));
        list2.sort(Comparator.comparing(CompanyHarms::getCid));
        list3.sort(Comparator.comparing(CompanyHarms::getCid));
        this.delComRepeatFactorIds(list1, factorIdNameMap);
        this.delComRepeatFactorIds(list2, factorIdNameMap);
        this.delComRepeatFactorIds(list3, factorIdNameMap);
        LinkedList<AbnormalCom> list = new LinkedList<AbnormalCom>();
        List<CompanyHarms> companyHarms = this.parseNoSimilarCompanyHarms(list1, list2);
        LinkedList<AbnormalOrgComResult> ids = new LinkedList<AbnormalOrgComResult>();
        for (CompanyHarms companyHarms2 : companyHarms) {
            ids.add(new AbnormalOrgComResult(companyHarms2.getCid(), null));
        }
        List<AbnormalCom> checkExamComs = this.getByIds(ids, AbnormalType.Type2);
        this.setCheckAndExamFactorIds(checkExamComs, list1, list2);
        list.addAll(checkExamComs);
        companyHarms = this.parseNoSimilarCompanyHarms(list1, list3);
        ids.clear();
        for (CompanyHarms companyHarms3 : companyHarms) {
            ids.add(new AbnormalOrgComResult(companyHarms3.getCid(), null));
        }
        List<Long> list4 = this.getCidsByCheckResult();
        for (Long aLong : list4) {
            ids.add(new AbnormalOrgComResult(aLong, null));
        }
        list.addAll(this.getByIds(ids, AbnormalType.Type1));
        list.addAll(this.getReformList(threshold.getThreshold17(), 4));
        list.addAll(this.getReformList(threshold.getThreshold16(), 3));
        list.addAll(this.getReformList(threshold.getThreshold11(), 2));
        list.addAll(this.getReformList(threshold.getThreshold18(), 1));
        LinkedList<AbnormalOrgComResult> linkedList = new LinkedList<AbnormalOrgComResult>();
        List selfResultNotEqualCids = this.occupationalSelfJudgeStatisticService.getDifferentCompanyIds();
        for (Long aLong : selfResultNotEqualCids) {
            linkedList.add(new AbnormalOrgComResult(aLong, null));
        }
        list.addAll(this.getByIds(linkedList, AbnormalType.Type9));
        long e = System.currentTimeMillis();
        this.logger.info("\u5f02\u5e38\u4f01\u4e1a\u5171\u8017\u65f6:" + (e - s));
        return list;
    }

    private List<AbnormalCom> getReformList(Integer threshold, int generationSource) {
        List list = null;
        list = generationSource == 1 ? this.reformService.queryNoReportCheckPlanCidProjects(threshold, generationSource) : this.reformService.queryNoReportPhcCheckCidProjects(threshold, generationSource);
        AbnormalType abnormalType = this.getByGenerationSource(generationSource);
        if (abnormalType == null) {
            return Collections.emptyList();
        }
        return this.getByIds(list, abnormalType);
    }

    private AbnormalType getByGenerationSource(int generationSource) {
        switch (generationSource) {
            case 1: {
                return AbnormalType.Type10;
            }
            case 2: {
                return AbnormalType.Type5;
            }
            case 3: {
                return AbnormalType.Type4;
            }
            case 4: {
                return AbnormalType.Type3;
            }
        }
        return null;
    }

    private void setCheckAndExamFactorIds(List<AbnormalCom> checkExamComs, List<CompanyHarms> list1, List<CompanyHarms> list2) {
        Map<Long, List<Long>> map1 = this.toComFactorMap(list1);
        Map<Long, List<Long>> map2 = this.toComFactorMap(list2);
        List<Long> factorIds = null;
        for (AbnormalCom com : checkExamComs) {
            factorIds = map1.get(com.getCid());
            com.setCheckFactorIds(this.listToString(factorIds));
            factorIds = map2.get(com.getCid());
            com.setExamFactorIds(this.listToString(factorIds));
        }
    }

    private Map<Long, List<Long>> toComFactorMap(List<CompanyHarms> list) {
        HashMap<Long, List<Long>> map = new HashMap<Long, List<Long>>();
        for (CompanyHarms harms : list) {
            map.put(harms.getCid(), harms.getHarmFactorIdList());
        }
        return map;
    }

    private String listToString(List<Long> list) {
        if (list == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        list.forEach(item -> {
            sb.append(item);
            sb.append(",");
        });
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return "";
    }

    private List<CompanyHarms> getHcCheckCompanyHarmList(LocalDateTime startDate, LocalDateTime endDate) {
        ComFactorQueryModel comFactorQueryModel = new ComFactorQueryModel();
        comFactorQueryModel.setCheckType(Integer.valueOf(2));
        comFactorQueryModel.setStartDate(startDate);
        comFactorQueryModel.setEndDate(endDate);
        comFactorQueryModel.setReportStatus(Integer.valueOf(2));
        Map map = this.checkFactorService.getComFactorIds(comFactorQueryModel);
        ArrayList<CompanyHarms> list = new ArrayList<CompanyHarms>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            CompanyHarms harms = new CompanyHarms();
            harms.setCid((Long)entry.getKey());
            harms.setHarmFactorIdList((List)entry.getValue());
            list.add(harms);
        }
        return list;
    }

    private List<CompanyHarms> parseNoSimilarCompanyHarms(List<CompanyHarms> list1, List<CompanyHarms> list2) {
        ArrayList<CompanyHarms> rList = new ArrayList<CompanyHarms>();
        int size1 = list1.size();
        int size2 = list2.size();
        int index1 = 0;
        int index2 = 0;
        while (index1 < size1 || index2 < size2) {
            if (index1 >= size1) {
                ++index2;
                continue;
            }
            if (index2 >= size2) {
                ++index1;
                continue;
            }
            CompanyHarms companyHarms1 = list1.get(index1);
            CompanyHarms companyHarms2 = list2.get(index2);
            if (companyHarms1.getCid().equals(companyHarms2.getCid())) {
                if (this.isFactorNoSimilar(companyHarms1.getHarmFactorIdList(), companyHarms2.getHarmFactorIdList())) {
                    rList.add(companyHarms1);
                }
                ++index1;
                ++index2;
                continue;
            }
            if (companyHarms1.getCid().compareTo(companyHarms2.getCid()) > 0) {
                ++index2;
                continue;
            }
            ++index1;
        }
        return rList;
    }

    private void delComRepeatFactorIds(List<CompanyHarms> companyHarms, Map<String, String> factorIdNameMap) {
        for (CompanyHarms companyHarm : companyHarms) {
            companyHarm.setHarmFactorIdList(this.delRepeatFactorIds(companyHarm.getHarmFactorIdList(), factorIdNameMap));
        }
    }

    private List<Long> delRepeatFactorIds(List<Long> ids, Map<String, String> factorIdNameMap) {
        if (ids == null) {
            return new LinkedList<Long>();
        }
        ids = ids.stream().map(i -> i.equals(63L) ? 1L : i).map(i -> {
            String name = (String)factorIdNameMap.get("" + i);
            if (name != null && name.startsWith("\u5176\u4ed6\u7c89\u5c18")) {
                return 654L;
            }
            return i;
        }).collect(Collectors.toList());
        return new LinkedList<Long>(new HashSet<Long>(ids));
    }

    private boolean isFactorNoSimilar(List<Long> list1, List<Long> list2) {
        if (list1 == null || list2 == null) {
            return false;
        }
        int sameSize = 0;
        HashSet<Long> s = new HashSet<Long>(list1);
        for (Long l : list2) {
            if (s.contains(l)) {
                ++sameSize;
                continue;
            }
            s.add(l);
        }
        return (double)sameSize < (double)s.size() * this.SIMILARITY;
    }

    private List<CompanyHarms> intersection(List<CompanyHarms> list1, List<CompanyHarms> list2) {
        ArrayList<CompanyHarms> rList = new ArrayList<CompanyHarms>();
        int size1 = list1.size();
        int size2 = list2.size();
        int index1 = 0;
        int index2 = 0;
        while (index1 < size1 || index2 < size2) {
            if (index1 >= size1) {
                ++index2;
                continue;
            }
            if (index2 >= size2) {
                ++index1;
                continue;
            }
            CompanyHarms companyHarms1 = list1.get(index1);
            CompanyHarms companyHarms2 = list2.get(index2);
            if (companyHarms1.getCid().equals(companyHarms2.getCid())) {
                if (companyHarms1.getHarmFactorIdList() != null && !companyHarms1.getHarmFactorIdList().isEmpty() && companyHarms2.getHarmFactorIdList() != null && !companyHarms2.getHarmFactorIdList().isEmpty()) {
                    ArrayList<Long> factorIds = new ArrayList<Long>();
                    for (Long id : companyHarms1.getHarmFactorIdList()) {
                        if (!companyHarms2.getHarmFactorIdList().contains(id)) continue;
                        factorIds.add(id);
                    }
                    if (!factorIds.isEmpty()) {
                        CompanyHarms companyHarms = new CompanyHarms();
                        companyHarms.setCid(companyHarms1.getCid());
                        companyHarms.setCompanyName(companyHarms1.getCompanyName());
                        companyHarms.setWorkAddress(companyHarms1.getWorkAddress());
                        companyHarms.setHarmFactorIdList(factorIds);
                        rList.add(companyHarms);
                    }
                }
                ++index1;
                ++index2;
                continue;
            }
            if (companyHarms1.getCid().compareTo(companyHarms2.getCid()) > 0) {
                ++index2;
                continue;
            }
            ++index1;
        }
        return rList;
    }

    private List<Long> getCidsByCheckResult() {
        this.logger.info("\u7edf\u8ba1\u5316\u5b66\u6216\u7c89\u5c18\u68c0\u6d4b\u7ed3\u679c\u5f02\u5e38\u7684\u4f01\u4e1a");
        List all = this.riskAttrDcService.getAll();
        all.sort(Comparator.comparing(OccupationalRiskAttrDc::getHazardId));
        ArrayList<Long> cids = new ArrayList<Long>();
        cids.addAll(this.getChemicalCidsByCheckResult(all));
        cids.addAll(this.getDustCidsByCheckResult(all));
        this.logger.info("\u7edf\u8ba1\u5316\u5b66\u6216\u7c89\u5c18\u68c0\u6d4b\u7ed3\u679c\u5f02\u5e38\u7684\u4f01\u4e1a\u5b8c\u6210,\u7ed3\u679c:" + JSON.toJSONString(cids));
        return cids;
    }

    private List<OccupationalRiskAttrDc> findFactor(List<OccupationalRiskAttrDc> all, Long factorId) {
        LinkedList<OccupationalRiskAttrDc> rList = new LinkedList<OccupationalRiskAttrDc>();
        for (OccupationalRiskAttrDc occupationalRiskAttrDc : all) {
            if (!occupationalRiskAttrDc.getHazardId().equals(factorId)) continue;
            rList.add(occupationalRiskAttrDc);
        }
        return rList;
    }

    private List<Long> getChemicalCidsByCheckResult(List<OccupationalRiskAttrDc> all) {
        ArrayList<Long> cids = new ArrayList<Long>();
        LocalDateTime now = LocalDateTime.now();
        List latestCheckResultBos = this.checkResultService.queryChemicalFactorResultGroupByFactor(now.minusYears(1L), now);
        List lastCheckResultBos = this.checkResultService.queryChemicalFactorResultGroupByFactor(now.minusYears(2L), now.minusYears(1L));
        cids.addAll(this.getChemicalCidsByCheckResult1(latestCheckResultBos, all));
        cids.addAll(this.getChemicalCidsByCheckResult1(lastCheckResultBos, all));
        cids.addAll(this.getChemicalCidsByCheckResult2(latestCheckResultBos, lastCheckResultBos));
        return cids;
    }

    private List<Long> getChemicalCidsByCheckResult1(List<ChemicalCheckResultBo> bos, List<OccupationalRiskAttrDc> all) {
        ArrayList<Long> cids = new ArrayList<Long>();
        List<OccupationalRiskAttrDc> factorAttrs = null;
        for (ChemicalCheckResultBo bo : bos) {
            try {
                factorAttrs = this.findFactor(all, Long.parseLong(bo.getFactorId()));
            }
            catch (NumberFormatException e) {
                continue;
            }
            for (OccupationalRiskAttrDc factorAttr : factorAttrs) {
                if (factorAttr.getAttrName().equals("twa") && bo.getCtwa() != null && !bo.getCtwa().isEmpty() && Double.parseDouble(bo.getCtwa()) > Double.parseDouble(factorAttr.getAttrValue())) {
                    cids.add(bo.getCid());
                }
                if (factorAttr.getAttrName().equals("max_excursion_limit") && bo.getLimitTimes() != null && !bo.getLimitTimes().isEmpty() && Double.parseDouble(bo.getLimitTimes()) > Double.parseDouble(factorAttr.getAttrValue())) {
                    cids.add(bo.getCid());
                }
                if (factorAttr.getAttrName().equals("stel")) {
                    if (bo.getCste() != null && !bo.getCste().isEmpty() && Double.parseDouble(bo.getCste()) > Double.parseDouble(factorAttr.getAttrValue())) {
                        cids.add(bo.getCid());
                    }
                    if (bo.getCstel() != null && !bo.getCstel().isEmpty() && Double.parseDouble(bo.getCstel()) > Double.parseDouble(factorAttr.getAttrValue())) {
                        cids.add(bo.getCid());
                    }
                }
                if (!factorAttr.getAttrName().equals("mac")) continue;
                if (bo.getCmac() != null && !bo.getCmac().isEmpty() && Double.parseDouble(bo.getCmac()) > Double.parseDouble(factorAttr.getAttrValue())) {
                    cids.add(bo.getCid());
                }
                if (bo.getCme() == null || bo.getCme().isEmpty() || !(Double.parseDouble(bo.getCme()) > Double.parseDouble(factorAttr.getAttrValue()))) continue;
                cids.add(bo.getCid());
            }
        }
        this.logger.info("\u5316\u5b66\u56e0\u7d20\u8d85\u8fc7\u9608\u503c\u7684\u4f01\u4e1a:" + JSON.toJSONString(cids));
        return cids;
    }

    private List<Long> getDustCidsByCheckResult1(List<DustCheckResultBo> bos, List<OccupationalRiskAttrDc> all) {
        ArrayList<Long> cids = new ArrayList<Long>();
        List<OccupationalRiskAttrDc> factorAttrs = null;
        for (DustCheckResultBo bo : bos) {
            try {
                factorAttrs = this.findFactor(all, Long.parseLong(bo.getFactorId()));
            }
            catch (NumberFormatException e) {
                continue;
            }
            for (OccupationalRiskAttrDc factorAttr : factorAttrs) {
                if (factorAttr.getAttrName().equals("twa_total") && bo.getCtwaTotal() != null && !bo.getCtwaTotal().isEmpty() && Double.parseDouble(bo.getCtwaTotal()) > Double.parseDouble(factorAttr.getAttrValue())) {
                    cids.add(bo.getCid());
                }
                if (!factorAttr.getAttrName().equals("twa_respirabel") || bo.getCtwaRespirable() == null || bo.getCtwaRespirable().isEmpty() || !(Double.parseDouble(bo.getCtwaRespirable()) > Double.parseDouble(factorAttr.getAttrValue()))) continue;
                cids.add(bo.getCid());
            }
        }
        this.logger.info("\u7c89\u5c18\u7d20\u8d85\u8fc7\u9608\u503c\u7684\u4f01\u4e1a:" + JSON.toJSONString(cids));
        return cids;
    }

    private List<Long> getChemicalCidsByCheckResult2(List<ChemicalCheckResultBo> bos1, List<ChemicalCheckResultBo> bos2) {
        int index1 = 0;
        int index2 = 0;
        ArrayList<Long> cids = new ArrayList<Long>();
        while (index1 < bos1.size() && index2 < bos2.size()) {
            Long c1Id = bos1.get(index1).getCid();
            Long c2Id = bos2.get(index2).getCid();
            if (c1Id < c2Id) {
                ++index1;
                continue;
            }
            if (c1Id > c2Id) {
                ++index2;
                continue;
            }
            Long f1Id = Long.parseLong(bos1.get(index1).getFactorId());
            Long f2Id = Long.parseLong(bos2.get(index2).getFactorId());
            if (f1Id > f2Id) {
                ++index2;
                continue;
            }
            if (f1Id < f2Id) {
                ++index1;
                continue;
            }
            if (this.isAbnormal((FactorBo)bos1.get(index1), (FactorBo)bos2.get(index2))) {
                cids.add(bos1.get(index1).getCid());
            }
            ++index1;
            ++index2;
        }
        this.logger.info("\u5316\u5b66\u56e0\u7d20\u8d85\u8fc7\u5b9a\u503c\u7684\u4f01\u4e1a:" + JSON.toJSONString(cids));
        return cids;
    }

    private boolean isAbnormal(FactorBo bo1, FactorBo bo2) {
        PropertyDescriptor[] propertyDescriptors;
        String v1 = "";
        String v2 = "";
        for (PropertyDescriptor descriptor : propertyDescriptors = BeanUtils.getPropertyDescriptors(bo1.getClass())) {
            try {
                String propertyName;
                Class<?> propertyType = descriptor.getPropertyType();
                if (propertyType.equals(Long.class) || propertyType.equals(Class.class) || (propertyName = descriptor.getName()).equals("cid") || propertyName.equals("factorId") || propertyName.equals("class")) continue;
                v1 = (String)descriptor.getReadMethod().invoke((Object)bo1, new Object[0]);
                v2 = (String)descriptor.getReadMethod().invoke((Object)bo2, new Object[0]);
                if (v1 == null || v2 == null || v1.isEmpty() || v2.isEmpty()) continue;
                double defValue = this.getDefValue(descriptor.getName(), v1);
                return defValue != -1.0 && Math.abs(Double.parseDouble(v1) - Double.parseDouble(v2)) >= defValue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private double getDefValue(String propertyName, String value) {
        double d = Double.parseDouble(value);
        if (propertyName.equals("cmac") || propertyName.equals("cme")) {
            if (d >= 0.001 && d < 0.1) {
                return 0.028;
            }
            if (d >= 0.1 && d < 1.0) {
                return 0.38;
            }
            if (d >= 1.0 && d < 10.0) {
                return 2.6;
            }
            if (d >= 10.0 && d < 100.0) {
                return 20.0;
            }
        }
        if (propertyName.equals("ctwa")) {
            if (d >= 0.001 && d < 0.1) {
                return 0.04;
            }
            if (d >= 0.1 && d < 1.0) {
                return 0.32;
            }
            if (d >= 1.0 && d < 10.0) {
                return 3.0;
            }
            if (d >= 10.0 && d < 100.0) {
                return 29.0;
            }
            if (d >= 100.0 && d < 1000.0) {
                return 301.0;
            }
            if (d >= 1000.0 && d < 10000.0) {
                return 4657.0;
            }
        }
        if (propertyName.equals("cstel") || propertyName.equals("cste")) {
            if (d >= 0.001 && d < 0.1) {
                return 0.033;
            }
            if (d >= 0.1 && d < 1.0) {
                return 0.318;
            }
            if (d >= 1.0 && d < 10.0) {
                return 3.0;
            }
            if (d >= 10.0 && d < 100.0) {
                return 22.0;
            }
            if (d >= 100.0 && d < 1000.0) {
                return 333.0;
            }
            if (d >= 1000.0 && d < 18000.0) {
                return 1083.0;
            }
        }
        if (propertyName.equals("ctwaRespirable")) {
            if (d >= 0.1 && d < 1.0) {
                return 0.4;
            }
            if (d >= 1.0 && d < 10.0) {
                return 3.0;
            }
        }
        if (propertyName.equals("ctwaTotal")) {
            if (d >= 0.1 && d < 1.0) {
                return 0.6;
            }
            if (d >= 1.0 && d < 10.0) {
                return 4.0;
            }
        }
        if (propertyName.equals("limitTimes")) {
            return 2.0;
        }
        return -1.0;
    }

    private List<Long> getDustCidsByCheckResult2(List<DustCheckResultBo> bos1, List<DustCheckResultBo> bos2) {
        int index1 = 0;
        int index2 = 0;
        ArrayList<Long> cids = new ArrayList<Long>();
        while (index1 < bos1.size() && index2 < bos2.size()) {
            Long c1Id = bos1.get(index1).getCid();
            Long c2Id = bos2.get(index2).getCid();
            if (c1Id < c2Id) {
                ++index1;
                continue;
            }
            if (c1Id > c2Id) {
                ++index2;
                continue;
            }
            Long f1Id = Long.parseLong(bos1.get(index1).getFactorId());
            Long f2Id = Long.parseLong(bos2.get(index2).getFactorId());
            if (f1Id > f2Id) {
                ++index2;
                continue;
            }
            if (f1Id < f2Id) {
                ++index1;
                continue;
            }
            if (this.isAbnormal((FactorBo)bos1.get(index1), (FactorBo)bos2.get(index2))) {
                cids.add(bos1.get(index1).getCid());
            }
            ++index1;
            ++index2;
        }
        this.logger.info("\u7c89\u5c18\u7d20\u8d85\u8fc7\u5b9a\u503c\u7684\u4f01\u4e1a:" + JSON.toJSONString(cids));
        return cids;
    }

    private List<Long> getDustCidsByCheckResult(List<OccupationalRiskAttrDc> all) {
        ArrayList<Long> cids = new ArrayList<Long>();
        LocalDateTime now = LocalDateTime.now();
        List latestCheckResultBos = this.checkResultService.queryDustFactorResultGroupByFactor(now.minusYears(1L), now);
        List lastCheckResultBos = this.checkResultService.queryDustFactorResultGroupByFactor(now.minusYears(2L), now.minusYears(1L));
        cids.addAll(this.getDustCidsByCheckResult1(latestCheckResultBos, all));
        cids.addAll(this.getDustCidsByCheckResult1(lastCheckResultBos, all));
        cids.addAll(this.getDustCidsByCheckResult2(latestCheckResultBos, lastCheckResultBos));
        return cids;
    }

    private List<AbnormalCom> getByIds(List<AbnormalOrgComResult> list, AbnormalType abnormalType) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        list = list.stream().distinct().collect(Collectors.toList());
        HashMap<Long, String> orgIdProjectsMap = new HashMap<Long, String>();
        ArrayList<Long> cids = new ArrayList<Long>(64);
        for (AbnormalOrgComResult abnormalOrgComResult : list) {
            if (abnormalOrgComResult.getCidOrOrgId() == null) continue;
            cids.add(abnormalOrgComResult.getCidOrOrgId());
            orgIdProjectsMap.put(abnormalOrgComResult.getCidOrOrgId(), abnormalOrgComResult.getProjectIds());
        }
        List companyList = this.companyProvideBySuperviseService.getOnlyCompanyByCid(cids);
        HashMap<Long, CompanySuperviseModel> hashMap = new HashMap<Long, CompanySuperviseModel>();
        for (CompanySuperviseModel company : companyList) {
            hashMap.put(company.getId(), company);
        }
        LinkedList<AbnormalCom> abnormalComs = new LinkedList<AbnormalCom>();
        for (Long id : cids) {
            CompanySuperviseModel company = (CompanySuperviseModel)hashMap.get(id);
            if (company == null) continue;
            AbnormalCom com = new AbnormalCom();
            com.setCid(id);
            com.setComName(company.getName());
            com.setStatus(Byte.valueOf((byte)1));
            com.setWorkAddress(company.getWorkAddress());
            com.setDescMsg(abnormalType.getDesc());
            com.setAbnormalType(abnormalType.getType());
            com.setCreateBy(Long.valueOf(0L));
            com.setCreateDate(new Date());
            com.setUpdateBy(Long.valueOf(0L));
            com.setUpdateDate(new Date());
            com.setIsValid(Boolean.valueOf(true));
            com.setProjectIds((String)orgIdProjectsMap.get(com.getCid()));
            abnormalComs.add(com);
        }
        return abnormalComs;
    }
}

