/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.home.service;

import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.health.component.AsyncTaskExecutor;
import cn.smarthse.modules.health.supervise.home.dao.AbnormalComOrgMapper;
import cn.smarthse.modules.health.supervise.home.entity.AbnormalComOrg;
import cn.smarthse.modules.health.supervise.home.model.QueryParam;
import cn.smarthse.modules.health.supervise.home.service.IAbnormalComOrgService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import jakarta.annotation.PostConstruct;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@DubboService
public class AbnormalComOrgServiceImp
implements IAbnormalComOrgService {
    @DubboReference(version="1.0.0")
    private IHarmFactorService harmFactorService;
    @Autowired
    private AbnormalComOrgMapper mapper;
    private Map<String, String> factorIdToNameMap;
    @Autowired
    private AsyncTaskExecutor asyncTaskExecutor;

    @PostConstruct
    public void init() {
        this.factorIdToNameMap = this.harmFactorService.getAllIdAndNameMap();
    }

    public PageInfo<AbnormalComOrg> getPage(QueryParam param) {
        PageHelper.startPage((int)param.getPageNum(), (int)param.getPageSize());
        if (param.getIdNotIn() == null || param.getIdNotIn().isEmpty()) {
            param.setIdNotIn(null);
        }
        List<AbnormalComOrg> list = this.mapper.queryList(param);
        this.setFactorNames(list);
        this.asyncTaskExecutor.execute(() -> {
            this.factorIdToNameMap = this.harmFactorService.getAllIdAndNameMap();
        });
        return new PageInfo(list);
    }

    private void setFactorNames(List<AbnormalComOrg> list) {
        list.forEach(item -> {
            item.setCheckFactorNames(this.getFactorNames(item.getCheckFactorIds()));
            item.setExamFactorNames(this.getFactorNames(item.getExamFactorIds()));
        });
    }

    private List<String> getFactorNames(String checkFactorIds) {
        if (checkFactorIds == null || checkFactorIds.isEmpty()) {
            return null;
        }
        HashSet<String> names = new HashSet<String>();
        for (String sId : checkFactorIds.split(",")) {
            String name = this.factorIdToNameMap.get(sId);
            if (name == null) continue;
            names.add(name);
        }
        return new LinkedList<String>(names);
    }
}

