/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.enums.sys;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.ArrayList;
import java.util.List;

@JsonFormat(shape=JsonFormat.Shape.OBJECT)
public enum UserRolesEnum {
    medicalCommunityPersonnel("\u533b\u5171\u4f53\u533b\u52a1\u4eba\u5458", (byte)4, (byte)18, false, null, null, null),
    gridOperator("\u5c5e\u5730\u4e61\u9547\u8f85\u52a9\u76d1\u7763\u5458", (byte)4, (byte)17, false, null, null, null),
    townshipCoordinator("\u4e61\u9547\u534f\u7ba1\u5458", (byte)4, (byte)16, false, null, null, null),
    streetUser("\u4e61\u9547\u8857\u9053\u666e\u901a\u7528\u6237", (byte)4, (byte)10, false, null, null, null),
    streetAdmin("\u4e61\u9547\u8857\u9053\u7ba1\u7406\u5458", (byte)4, (byte)9, true, null, null, streetUser),
    streetTest("\u4e61\u9547\u8857\u9053\u6d4b\u8bd5\u5458", (byte)1, (byte)26, false, null, null, null),
    countyCdc("\u53bf\u533a\u7ea7\u75be\u63a7\u673a\u6784", (byte)3, (byte)21, false, null, null, null),
    countyUser("\u533a\u53bf\u7ea7\u666e\u901a\u7528\u6237", (byte)3, (byte)8, false, streetAdmin, streetUser, null),
    countyAdmin("\u533a\u53bf\u7ea7\u7ba1\u7406\u5458", (byte)3, (byte)7, true, streetAdmin, streetUser, countyUser),
    countryTest("\u533a\u53bf\u7ea7\u6d4b\u8bd5\u5458", (byte)1, (byte)25, false, null, null, null),
    cityCdc("\u5730\u5e02\u7ea7\u75be\u63a7\u673a\u6784", (byte)2, (byte)20, false, countyCdc, null, null),
    cityUser("\u5e02\u7ea7\u666e\u901a\u7528\u6237", (byte)2, (byte)6, false, countyAdmin, countyUser, null),
    cityAdmin("\u5e02\u7ea7\u7ba1\u7406\u5458", (byte)2, (byte)5, true, countyAdmin, countyUser, cityUser),
    cityTest("\u5e02\u7ea7\u6d4b\u8bd5\u5458", (byte)1, (byte)24, false, null, null, null),
    provinceCdc("\u7701\u7ea7\u75be\u63a7\u673a\u6784", (byte)1, (byte)19, false, cityCdc, null, null),
    provinceUser("\u7701\u7ea7\u666e\u901a\u7528\u6237", (byte)1, (byte)4, false, cityAdmin, cityUser, null),
    provinceAdmin("\u7701\u7ea7\u7ba1\u7406\u5458", (byte)1, (byte)3, true, cityAdmin, cityUser, provinceUser),
    provinceTest("\u7701\u7ea7\u6d4b\u8bd5\u5458", (byte)1, (byte)23, false, null, null, null),
    provinceSingle("\u7701\u7ea7\u5355\u70b9\u7528\u6237", (byte)1, (byte)45, false, null, null, null),
    contryUser("\u56fd\u5bb6\u7ea7\u666e\u901a\u7528\u6237", (byte)0, (byte)2, false, provinceAdmin, provinceUser, null),
    contryAdmin("\u56fd\u5bb6\u7ea7\u7ba1\u7406\u5458", (byte)0, (byte)1, true, provinceAdmin, provinceUser, contryUser),
    maintenanceAdmin("\u8fd0\u7ef4\u7ba1\u7406\u5458", (byte)0, (byte)-56, true, null, null, null);

    private final String name;
    private final Byte areaLevel;
    private final Byte value;
    private final boolean isAdmin;
    private final UserRolesEnum nextAdminRole;
    private final UserRolesEnum nextUserRole;
    private final UserRolesEnum thisUserRole;

    public static List<Byte> getAdminValueList() {
        ArrayList<Byte> list = new ArrayList<Byte>();
        for (UserRolesEnum userRole : UserRolesEnum.values()) {
            if (!userRole.isAdmin) continue;
            list.add(userRole.getValue());
        }
        return list;
    }

    public static boolean hasRightToImport(Byte desRolId, Byte thisRoleId) {
        UserRolesEnum thisRole = UserRolesEnum.getByValue(thisRoleId);
        if (thisRole.getThisUserRole() != null && thisRole.getThisUserRole().getValue().equals(desRolId)) {
            return true;
        }
        if (thisRole.getNextAdminRole() != null && thisRole.getNextAdminRole().getValue().equals(desRolId)) {
            return true;
        }
        return thisRole.getNextUserRole() != null && thisRole.getNextUserRole().getValue().equals(desRolId);
    }

    public static List<UserRolesEnum> getAdminRoleList() {
        ArrayList<UserRolesEnum> list = new ArrayList<UserRolesEnum>();
        for (UserRolesEnum userRole : UserRolesEnum.values()) {
            if (!userRole.isAdmin) continue;
            list.add(userRole);
        }
        return list;
    }

    public static UserRolesEnum getByValue(Byte value) {
        for (UserRolesEnum userRole : UserRolesEnum.values()) {
            if (!userRole.getValue().equals(value)) continue;
            return userRole;
        }
        return null;
    }

    public static UserRolesEnum getByAreaLevelAndIsAdmin(Byte areaLevel, boolean isAdmin) {
        for (UserRolesEnum userRole : UserRolesEnum.values()) {
            if (!userRole.getAreaLevel().equals(areaLevel) || userRole.isAdmin != isAdmin) continue;
            return userRole;
        }
        return null;
    }

    public static UserRolesEnum getByAreaLevelAndIsAdminLte10(Byte areaLevel, boolean isAdmin) {
        for (UserRolesEnum userRole : UserRolesEnum.values()) {
            if (!userRole.getAreaLevel().equals(areaLevel) || userRole.isAdmin != isAdmin || userRole.value > 10) continue;
            return userRole;
        }
        return null;
    }

    public static UserRolesEnum getByName(String name) {
        for (UserRolesEnum userRole : UserRolesEnum.values()) {
            if (!userRole.getName().equals(name)) continue;
            return userRole;
        }
        return null;
    }

    private UserRolesEnum(String name, Byte areaLevel, Byte value, boolean isAdmin, UserRolesEnum nextAdminRole, UserRolesEnum nextUserRole, UserRolesEnum thisUserRole) {
        this.name = name;
        this.areaLevel = areaLevel;
        this.value = value;
        this.isAdmin = isAdmin;
        this.nextAdminRole = nextAdminRole;
        this.nextUserRole = nextUserRole;
        this.thisUserRole = thisUserRole;
    }

    public String getName() {
        return this.name;
    }

    public Byte getAreaLevel() {
        return this.areaLevel;
    }

    public Byte getValue() {
        return this.value;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public UserRolesEnum getNextAdminRole() {
        return this.nextAdminRole;
    }

    public UserRolesEnum getNextUserRole() {
        return this.nextUserRole;
    }

    public UserRolesEnum getThisUserRole() {
        return this.thisUserRole;
    }
}

