/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.wqyy.task;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.wqyy.entity.wqyy.WqyyOrganization;
import cn.smarthse.wqyy.entity.wqyy.WqyySchedule;
import cn.smarthse.wqyy.model.param.subscribe.WqyyScheduleAddParam;
import cn.smarthse.wqyy.service.wqyy.IWqyyOrganizationService;
import cn.smarthse.wqyy.service.wqyy.IWqyyScheduleService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class WqyyScheduleTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WqyyScheduleTask.class);
    private final IWqyyOrganizationService wqyyOrganizationService;
    private final IWqyyScheduleService wqyyScheduleService;

    @XxlJob(value="wqyyScheduleTask-autoGenerate")
    @Transactional(propagation=Propagation.REQUIRED)
    public void autoGenerate() {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(WqyyOrganization::getIsValid, (Object)true);
        List wqyyOrganizations = this.wqyyOrganizationService.list((Wrapper)wrapper);
        if (CollUtil.isEmpty((Collection)wqyyOrganizations)) {
            return;
        }
        String jobParam = XxlJobHelper.getJobParam();
        Long plusDay = 14L;
        if (StrUtil.isNotBlank((CharSequence)jobParam)) {
            plusDay = Long.valueOf(jobParam);
        }
        LocalDate now = LocalDate.now().plusDays(plusDay);
        if (CollUtil.isEmpty(wqyyOrganizations = wqyyOrganizations.stream().filter(organization -> StrUtil.isNotBlank((CharSequence)organization.getOpeningTime()) && organization.getOpeningTime().contains(String.valueOf(now.getDayOfWeek().getValue()))).collect(Collectors.toList()))) {
            return;
        }
        List longList = wqyyOrganizations.stream().map(WqyyOrganization::getId).collect(Collectors.toList());
        if (CollUtil.isEmpty(longList)) {
            return;
        }
        LambdaQueryWrapper wrapper2 = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(WqyySchedule::getIsValid, (Object)true)).eq(WqyySchedule::getScheduleDate, (Object)now)).select(new SFunction[]{WqyySchedule::getOrganizationId});
        List wqyySchedules = this.wqyyScheduleService.list((Wrapper)wrapper2);
        Collection<Object> subtract = longList;
        if (CollUtil.isNotEmpty((Collection)wqyySchedules)) {
            List list = wqyySchedules.stream().map(WqyySchedule::getOrganizationId).collect(Collectors.toList());
            subtract = CollUtil.subtract(longList, list);
        }
        if (CollUtil.isEmpty(subtract)) {
            return;
        }
        ArrayList<WqyyScheduleAddParam> addList = new ArrayList<WqyyScheduleAddParam>(subtract.size());
        Date date = Date.from(now.atStartOfDay(ZoneId.systemDefault()).toInstant());
        for (Long l : subtract) {
            WqyyScheduleAddParam wqyyScheduleAddParam = new WqyyScheduleAddParam();
            wqyyScheduleAddParam.setScheduleDate(date);
            wqyyScheduleAddParam.setOrganizationId(l);
            addList.add(wqyyScheduleAddParam);
        }
        this.wqyyScheduleService.addList(addList);
    }

    @Generated
    public WqyyScheduleTask(IWqyyOrganizationService wqyyOrganizationService, IWqyyScheduleService wqyyScheduleService) {
        this.wqyyOrganizationService = wqyyOrganizationService;
        this.wqyyScheduleService = wqyyScheduleService;
    }
}

