/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.wqyy.service.wqyy.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrgInfo;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrgInfoDic;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrganization;
import cn.smarthse.modules.health.thirdOrganization.vo.sys.SysAreaStandardVo;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.wqyy.dao.wqyy.WqyyOrganizationMapper;
import cn.smarthse.wqyy.entity.wqyy.WqyyOrganization;
import cn.smarthse.wqyy.entity.wqyy.WqyyOrganizationAudit;
import cn.smarthse.wqyy.entity.wqyy.WqyyOrganizationCheckType;
import cn.smarthse.wqyy.entity.wqyy.WqyyOrganizationContact;
import cn.smarthse.wqyy.entity.wqyy.WqyyWorkOperateLog;
import cn.smarthse.wqyy.enums.WqyyLogWorkModeEnum;
import cn.smarthse.wqyy.enums.WqyySourceEnum;
import cn.smarthse.wqyy.model.param.org.WqyyOrganizationCheckTypeParam;
import cn.smarthse.wqyy.model.param.org.WqyyOrganizationContactParam;
import cn.smarthse.wqyy.model.param.org.WqyyOrganizationParam;
import cn.smarthse.wqyy.model.param.subscribe.WqyyOrgChangeParam;
import cn.smarthse.wqyy.model.param.subscribe.WqyyScheduleAddParam;
import cn.smarthse.wqyy.model.vo.org.WqyyOrganizationCheckTypeVo;
import cn.smarthse.wqyy.model.vo.org.WqyyOrganizationContactVo;
import cn.smarthse.wqyy.model.vo.org.WqyyOrganizationVo;
import cn.smarthse.wqyy.service.wqyy.IWqyyOrganizationAuditService;
import cn.smarthse.wqyy.service.wqyy.IWqyyOrganizationCheckTypeService;
import cn.smarthse.wqyy.service.wqyy.IWqyyOrganizationContactService;
import cn.smarthse.wqyy.service.wqyy.IWqyyOrganizationService;
import cn.smarthse.wqyy.service.wqyy.IWqyyScheduleService;
import cn.smarthse.wqyy.service.wqyy.IWqyyWorkOperateLogService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.smarthse.exception.ServiceException;
import lombok.Generated;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class WqyyOrganizationServiceImpl
extends ServiceImpl<WqyyOrganizationMapper, WqyyOrganization>
implements IWqyyOrganizationService {
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService regionService;
    private final IWqyyOrganizationContactService contactService;
    private final IWqyyOrganizationCheckTypeService checkTypeService;
    private final IWqyyWorkOperateLogService operateLogService;
    private final IWqyyOrganizationAuditService orgAuditService;
    private final IWqyyScheduleService scheduleService;
    private final OssClientBean ossBean;
    @Autowired
    private DataSourceTransactionManager txManager;
    private static final Map<String, String> WEEK_MAP = new HashMap<String, String>(){
        {
            this.put("1", "\u661f\u671f\u4e00");
            this.put("2", "\u661f\u671f\u4e8c");
            this.put("3", "\u661f\u671f\u4e09");
            this.put("4", "\u661f\u671f\u56db");
            this.put("5", "\u661f\u671f\u4e94");
            this.put("6", "\u661f\u671f\u516d");
            this.put("7", "\u661f\u671f\u4e03");
            this.put("-", "-");
        }
    };

    @Override
    public PageInfo<WqyyOrganizationVo> queryOrganizationData(JqGridParam pageParam, WqyyOrganizationParam orgParam) {
        String openingTime;
        String concatCheckType;
        if (orgParam.getAreaLevel() == null) {
            Byte areaLevel = ((WqyyOrganizationMapper)this.baseMapper).getAreaLevel(orgParam.getAreaId());
            orgParam.setAreaLevel(areaLevel);
        }
        if (!StringUtils.isBlank((CharSequence)(concatCheckType = orgParam.getConcatCheckType()))) {
            List checkTypeParamList = Arrays.stream(concatCheckType.split(",")).map(c -> new WqyyOrganizationCheckTypeParam(Integer.valueOf(Integer.parseInt(c)))).collect(Collectors.toList());
            orgParam.setCheckTypeList(checkTypeParamList);
        }
        if (!StringUtils.isBlank((CharSequence)(openingTime = orgParam.getOpeningTime()))) {
            List openingTimeList = Arrays.stream(openingTime.split(",")).collect(Collectors.toList());
            orgParam.setOpeningTimeList(openingTimeList);
        }
        if (Objects.equals(orgParam.getSource(), WqyySourceEnum.Mobile.getSource())) {
            this.processRecursionAreaIdList(orgParam);
        }
        List<WqyyOrganizationVo> organizationList = ((WqyyOrganizationMapper)this.baseMapper).queryOrganizationList(orgParam);
        organizationList = WqyyOrganizationServiceImpl.judgeNotLogin3(orgParam, organizationList);
        organizationList = WqyyOrganizationServiceImpl.serviceAreaScreening(orgParam, organizationList);
        this.postSetRegionFullName(orgParam, organizationList);
        this.putCheckTypeAndTransformImg(orgParam, organizationList);
        this.servedEnterprisesAssignment(organizationList);
        int pageNum = pageParam.getPage();
        int pageSize = pageParam.getRows();
        Page organizationPage = new Page(pageNum, pageSize);
        int total = organizationList.size();
        int startIdx = (pageNum - 1) * pageSize;
        int endIdx = Math.min(startIdx + pageSize, total);
        organizationPage.setTotal((long)total);
        organizationPage.addAll(organizationList.subList(startIdx, endIdx));
        return new PageInfo((List)organizationPage);
    }

    private static List<WqyyOrganizationVo> serviceAreaScreening(WqyyOrganizationParam orgParam, List<WqyyOrganizationVo> organizationList) {
        boolean mobile = Objects.equals(orgParam.getSource(), WqyySourceEnum.Mobile.getSource());
        List areaIdSet = orgParam.getAreaIdSet();
        if (mobile && CollUtil.isNotEmpty((Collection)areaIdSet)) {
            organizationList = organizationList.stream().filter(org -> {
                String serviceArea = org.getServiceArea();
                if (StrUtil.isBlank((CharSequence)serviceArea)) {
                    return false;
                }
                HashSet<String> serviceAreaIds = new HashSet<String>(Arrays.asList(org.getServiceArea().split(",")));
                return areaIdSet.stream().map(String::valueOf).anyMatch(serviceAreaIds::contains);
            }).collect(Collectors.toList());
        }
        return organizationList;
    }

    private static List<WqyyOrganizationVo> judgeNotLogin3(WqyyOrganizationParam orgParam, List<WqyyOrganizationVo> organizationList) {
        Boolean notLog3 = orgParam.getNotLog3();
        if (Boolean.TRUE.equals(notLog3)) {
            organizationList = organizationList.stream().filter(org -> WqyyOrganizationServiceImpl.isMoreThanThreeDaysAgo(org.getMaxLoginDate())).collect(Collectors.toList());
        }
        return organizationList;
    }

    public static boolean isMoreThanThreeDaysAgo(Date date) {
        if (date == null) {
            return Boolean.TRUE;
        }
        LocalDateTime dateTime = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime dateTimePlus3Days = dateTime.plusDays(3L);
        return dateTimePlus3Days.isBefore(now);
    }

    public void postSetRegionFullName(WqyyOrganizationParam orgParam, List<WqyyOrganizationVo> organizationVoList) {
        if (CollUtil.isNotEmpty(organizationVoList)) {
            List regionList = this.regionService.getAreaListByIds(organizationVoList.stream().map(WqyyOrganizationVo::getAreaId).filter(Objects::nonNull).map(String::valueOf).collect(Collectors.joining(",")));
            Map<Long, String> orgDetailAreaMap = regionList.stream().collect(Collectors.toMap(AreaModel::getId, region -> region.getProvinceName() + region.getCityName() + region.getAreaName() + region.getStreetName()));
            organizationVoList.forEach(n -> n.setOrgDetailArea((String)orgDetailAreaMap.get(n.getAreaId()) + n.getOrganizationAddress()));
            boolean mobile = Objects.equals(orgParam.getSource(), WqyySourceEnum.Mobile.getSource());
            if (mobile) {
                Map<Long, String> regionMap = regionList.stream().collect(Collectors.toMap(AreaModel::getId, region -> {
                    switch (region.getLevel()) {
                        case 0: {
                            return "\u56fd\u5bb6";
                        }
                        case 1: {
                            return region.getProvinceName();
                        }
                        case 2: {
                            return region.getProvinceName() + "/" + region.getCityName();
                        }
                        case 3: {
                            return region.getProvinceName() + "/" + region.getCityName() + "/" + region.getAreaName();
                        }
                        case 4: {
                            return region.getProvinceName() + "/" + region.getCityName() + "/" + region.getAreaName();
                        }
                    }
                    return "";
                }));
                organizationVoList.forEach(n -> n.setAreaName((String)regionMap.get(n.getAreaId())));
            }
        }
    }

    @Override
    public List<WqyyOrganizationVo> queryOrgLastLoginDateList(WqyyOrganizationParam organizationParam) {
        return ((WqyyOrganizationMapper)this.baseMapper).queryOrgLastLoginDateList(organizationParam);
    }

    private void processRecursionAreaIdList(WqyyOrganizationParam orgParam) {
        Long areaId = orgParam.getAreaId();
        if (areaId == null || areaId == 0L) {
            return;
        }
        SysAreaStandardVo area = ((WqyyOrganizationMapper)this.baseMapper).getAreaById(areaId);
        ArrayList<Long> areaIdList = new ArrayList<Long>();
        List<Long> returnList = new ArrayList<Long>();
        areaIdList.add(areaId);
        this.recursionQueryAreaBatch(areaIdList, returnList);
        returnList.add(area.getProvinceId());
        returnList.add(area.getCityId());
        returnList.add(area.getAreaId());
        returnList.add(area.getStreetId());
        returnList.removeAll(Collections.singleton(null));
        returnList = returnList.stream().distinct().collect(Collectors.toList());
        orgParam.setAreaIdSet(returnList);
    }

    public void recursionQueryArea(List<Long> areaIdList, List<Long> returnList) {
        List<Object> subList = new ArrayList();
        for (Long id : areaIdList) {
            subList = ((WqyyOrganizationMapper)this.baseMapper).getAreaSubList(id);
            if (subList == null || subList.isEmpty()) continue;
            returnList.addAll(subList);
            this.recursionQueryArea(subList, returnList);
        }
    }

    public void recursionQueryAreaBatch(List<Long> areaIdList, List<Long> returnList) {
        List<Long> subList = ((WqyyOrganizationMapper)this.baseMapper).getAreaSubListBatch(areaIdList);
        if (subList != null && !subList.isEmpty()) {
            returnList.addAll(subList);
            this.recursionQueryAreaBatch(subList, returnList);
        }
    }

    public static int getAreaLevel(Long areaId) {
        if (areaId == null) {
            return 0;
        }
        return areaId == areaId / 10000000000L * 10000000000L ? 1 : (areaId == areaId / 100000000L * 100000000L ? 2 : (areaId == areaId / 1000000L * 1000000L ? 3 : (areaId == areaId / 100L * 100L ? 4 : 5)));
    }

    private void servedEnterprisesAssignment(List<WqyyOrganizationVo> organizationList) {
        List<Long> orgIdList = organizationList.stream().map(WqyyOrganizationVo::getId).distinct().collect(Collectors.toList());
        if (orgIdList.isEmpty()) {
            organizationList.forEach(o -> o.setServedEnterprises(Integer.valueOf(0)));
            return;
        }
        List<WqyyOrganizationVo> orgServicesList = ((WqyyOrganizationMapper)this.baseMapper).queryThirdOrgServedEnterprises(orgIdList);
        if (orgServicesList == null || orgServicesList.isEmpty()) {
            organizationList.forEach(o -> o.setServedEnterprises(Integer.valueOf(0)));
            return;
        }
        Map<Long, Integer> orgServicesMap = orgServicesList.stream().collect(Collectors.toMap(WqyyOrganizationVo::getId, WqyyOrganizationVo::getServedEnterprises));
        for (WqyyOrganizationVo vo : organizationList) {
            Integer services = orgServicesMap.get(vo.getId());
            if (services == null) {
                vo.setServedEnterprises(Integer.valueOf(0));
                continue;
            }
            vo.setServedEnterprises(services);
        }
    }

    private void putCheckTypeAndTransformImg(WqyyOrganizationParam orgParam, List<WqyyOrganizationVo> organizationList) {
        if (organizationList == null || organizationList.isEmpty()) {
            return;
        }
        Long areaId = orgParam.getAreaId();
        Byte source = orgParam.getSource();
        Long id = orgParam.getId();
        for (WqyyOrganizationVo vo : organizationList) {
            vo.setSearchAreaId(areaId);
        }
        List<Long> orgIdList = organizationList.stream().map(WqyyOrganizationVo::getId).distinct().collect(Collectors.toList());
        Map<Object, Object> groupConcatList = new HashMap();
        if (id != null) {
            List<WqyyOrganizationContactVo> concatList = this.contactService.getConcatListByOrgIdBatch(orgIdList, areaId, source);
            groupConcatList = concatList.stream().collect(Collectors.groupingBy(WqyyOrganizationContactVo::getOrganizationId));
        }
        List<WqyyOrganizationCheckTypeVo> checkTypeList = this.checkTypeService.getCheckTypeListByOrgIdBatch(orgIdList);
        Map<Long, List<WqyyOrganizationCheckTypeVo>> groupCheckTypeList = checkTypeList.stream().collect(Collectors.groupingBy(WqyyOrganizationCheckTypeVo::getOrganizationId));
        List<Long> imgIdList = WqyyOrganizationServiceImpl.extractOrgImgIdList(organizationList);
        List imgList = imgIdList.isEmpty() ? Collections.emptyList() : ((WqyyOrganizationMapper)this.baseMapper).selectFileInfoBatch(imgIdList);
        Map<Long, String> imgNameUrlMap = imgList.stream().collect(Collectors.toMap(SysFileModel::getId, img -> img.getFileName() + "," + this.ossBean.getUrl(img.getOssUrl()), (a, b) -> b));
        for (WqyyOrganizationVo orgRetData : organizationList) {
            String detailImg;
            String[] split;
            if (MapUtil.isNotEmpty(groupConcatList)) {
                orgRetData.setContactList(Optional.ofNullable((List)groupConcatList.get(orgRetData.getId())).orElse(Collections.emptyList()));
            }
            if (StringUtils.isNotBlank((CharSequence)orgRetData.getOpeningTime())) {
                Stream<String> openingTimeStream = Arrays.stream(orgRetData.getOpeningTime().split(","));
                List openingTimeList = openingTimeStream.map(v -> new HashMap<String, String>(){
                    {
                        this.put(WEEK_MAP.get(v), v);
                    }
                }).collect(Collectors.toList());
                orgRetData.setOpeningTimeList(openingTimeList);
            }
            orgRetData.setCheckTypeList(Optional.ofNullable(groupCheckTypeList.get(orgRetData.getId())).orElse(Collections.emptyList()));
            String orgListImg = orgRetData.getOrgListImg();
            if (StringUtils.isNotBlank((CharSequence)orgListImg) && NumberUtils.isNumber((String)orgListImg) && imgNameUrlMap.size() > 0) {
                String msg = imgNameUrlMap.get(Long.valueOf(orgListImg));
                split = msg.split(",");
                orgRetData.setOrgListImgName(split[0]);
                orgRetData.setOrgListImgOssUrl(split[1]);
            }
            if (!StringUtils.isNotBlank((CharSequence)(detailImg = orgRetData.getOrgDetailImg()))) continue;
            split = detailImg.split(",");
            boolean isNumber = true;
            for (String s : split) {
                if (NumberUtils.isNumber((String)s)) continue;
                isNumber = false;
                break;
            }
            if (!isNumber) continue;
            List detailImgIdList = Arrays.stream(detailImg.split(",")).map(Long::parseLong).collect(Collectors.toList());
            if (imgNameUrlMap.size() > 0) {
                List detailImgOssUrlList = detailImgIdList.stream().map(i -> ((String)imgNameUrlMap.get(i)).split(",")[1]).collect(Collectors.toList());
                orgRetData.setOrgDetailImgOssUrls(Optional.of(detailImgOssUrlList).orElse(Collections.emptyList()));
            }
            List collect = detailImgIdList.stream().map(i -> {
                SysFileModel file = new SysFileModel();
                file.setId(i);
                if (imgNameUrlMap.size() > 0) {
                    file.setFileName(((String)imgNameUrlMap.get(i)).split(",")[0]);
                    file.setOssUrl(((String)imgNameUrlMap.get(i)).split(",")[1]);
                }
                return file;
            }).collect(Collectors.toList());
            orgRetData.setOrgDetailImgBeanList(Optional.of(collect).orElse(Collections.emptyList()));
        }
    }

    private static List<Long> extractOrgImgIdList(List<WqyyOrganizationVo> orgRetDataList) {
        ArrayList<Long> fileIdList = new ArrayList<Long>();
        for (WqyyOrganizationVo orgRetData : orgRetDataList) {
            String orgDetailImg;
            String orgListImg = orgRetData.getOrgListImg();
            if (StringUtils.isNotBlank((CharSequence)orgListImg) && NumberUtils.isNumber((String)orgListImg)) {
                fileIdList.add(Long.valueOf(orgListImg));
            }
            if (!StringUtils.isNotBlank((CharSequence)(orgDetailImg = orgRetData.getOrgDetailImg()))) continue;
            String[] split = orgDetailImg.split(",");
            boolean isNumber = true;
            for (String s : split) {
                if (NumberUtils.isNumber((String)s)) continue;
                isNumber = false;
                break;
            }
            if (!isNumber) continue;
            List detailImgIdList = Arrays.stream(orgDetailImg.split(",")).map(Long::parseLong).collect(Collectors.toList());
            fileIdList.addAll(detailImgIdList);
        }
        return fileIdList;
    }

    @Override
    public List<WqyyOrganizationVo> getListOrgAuditBySearchModel(WqyyOrganizationParam orgParam) {
        return ((WqyyOrganizationMapper)this.baseMapper).getListOrgAuditBySearchModel(orgParam);
    }

    @Override
    public PageInfo<WqyyOrganizationVo> getPageOrgAuditBySearchModel(JqGridParam param, WqyyOrganizationParam orgParam) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<WqyyOrganizationVo> list = this.getListOrgAuditBySearchModel(orgParam);
        return new PageInfo(list);
    }

    @Override
    public WqyyOrganizationVo queryOrganizationDataById(WqyyOrganizationParam orgParam) {
        PageInfo<WqyyOrganizationVo> page = this.queryOrganizationData(new JqGridParam(), orgParam);
        List list = page.getList();
        if (list != null && !list.isEmpty() && list.get(0) != null) {
            WqyyWorkOperateLog operateLog;
            WqyyOrganizationVo wqyyOrganizationVo = (WqyyOrganizationVo)list.get(0);
            if (wqyyOrganizationVo.getIsShelves() != null && wqyyOrganizationVo.getIsShelves().equals(0) && (operateLog = (WqyyWorkOperateLog)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.operateLogService.lambdaQuery().eq(WqyyWorkOperateLog::getIsValid, (Object)true)).eq(WqyyWorkOperateLog::getWorkId, (Object)wqyyOrganizationVo.getId())).eq(WqyyWorkOperateLog::getWorkModule, (Object)WqyyLogWorkModeEnum.SJXJ.getCode())).eq(WqyyWorkOperateLog::getWorkStatus, (Object)0)).orderByDesc(WqyyWorkOperateLog::getUpdateDate)).last("limit 1")).one()) != null && StringUtils.isNotBlank((CharSequence)operateLog.getReason())) {
                wqyyOrganizationVo.setReason(operateLog.getReason());
            }
            return wqyyOrganizationVo;
        }
        return null;
    }

    @Override
    public WqyyOrganizationVo getForbiddenLineInfo(Long orgId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(WqyyOrganization::getOrgId, (Object)orgId)).eq(WqyyOrganization::getIsValid, (Object)true);
        WqyyOrganization organization = (WqyyOrganization)((WqyyOrganizationMapper)this.baseMapper).selectOne((Wrapper)wrapper);
        if (Objects.isNull(organization)) {
            return null;
        }
        WqyyOrganizationVo vo = new WqyyOrganizationVo();
        vo.setId(organization.getId());
        vo.setOrgId(organization.getOrgId());
        vo.setForbiddenLineOfPeople(organization.getForbiddenLineOfPeople());
        vo.setForbiddenLineOfEnterprises(organization.getForbiddenLineOfEnterprises());
        vo.setForbiddenLineOfVehicles(organization.getForbiddenLineOfVehicles());
        return vo;
    }

    @Override
    public WqyyOrganizationVo getForbiddenLineInfoById(Long orgId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(WqyyOrganization::getId, (Object)orgId)).eq(WqyyOrganization::getIsValid, (Object)true);
        WqyyOrganization organization = (WqyyOrganization)((WqyyOrganizationMapper)this.baseMapper).selectOne((Wrapper)wrapper);
        if (Objects.isNull(organization)) {
            return null;
        }
        WqyyOrganizationVo vo = new WqyyOrganizationVo();
        vo.setId(organization.getId());
        vo.setOrgId(organization.getOrgId());
        vo.setForbiddenLineOfPeople(organization.getForbiddenLineOfPeople());
        vo.setForbiddenLineOfEnterprises(organization.getForbiddenLineOfEnterprises());
        vo.setForbiddenLineOfVehicles(organization.getForbiddenLineOfVehicles());
        return vo;
    }

    private Long createSlaveInfo(Long loginUserId, WqyyOrganizationVo organization, Long needDelConcatId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(WqyyOrganization::getOrgId, (Object)organization.getOrgId())).eq(WqyyOrganization::getIsValid, (Object)true)).eq(WqyyOrganization::getAuditStatus, (Object)4)).select(new SFunction[]{WqyyOrganization::getId});
        WqyyOrganization primary = (WqyyOrganization)this.getOne((Wrapper)wrapper);
        WqyyOrganization slaveOrg = new WqyyOrganization();
        BeanUtils.copyProperties((Object)organization, (Object)slaveOrg, (String[])new String[]{"createDate", "updateDate"});
        slaveOrg.setId(Long.valueOf(IdWorker.getId()));
        slaveOrg.setAuditStatus(Byte.valueOf((byte)1));
        slaveOrg.setCreateBy(String.valueOf(loginUserId));
        slaveOrg.setUpdatedBy(String.valueOf(loginUserId));
        this.save(slaveOrg);
        this.updateById(primary);
        ArrayList<Object> contactSlaveList = new ArrayList<Object>();
        List contactList = organization.getContactList();
        for (WqyyOrganizationContactVo contact : contactList) {
            WqyyOrganizationContact slaveContact = new WqyyOrganizationContact();
            BeanUtils.copyProperties((Object)contact, (Object)slaveContact, (String[])new String[]{"createDate", "updateDate"});
            if (Objects.equals(slaveContact.getId(), needDelConcatId)) {
                slaveContact.setIsValid(Boolean.valueOf(false));
            }
            slaveContact.setId(Long.valueOf(IdWorker.getId()));
            slaveContact.setOrganizationId(slaveOrg.getId());
            slaveContact.setCreateBy(String.valueOf(loginUserId));
            slaveContact.setUpdatedBy(String.valueOf(loginUserId));
            contactSlaveList.add(slaveContact);
        }
        this.contactService.saveBatch(contactSlaveList);
        ArrayList<WqyyOrganizationCheckType> checkTypeSlaveList = new ArrayList<WqyyOrganizationCheckType>();
        List checkTypeList = organization.getCheckTypeList();
        for (WqyyOrganizationCheckTypeVo checkType : checkTypeList) {
            WqyyOrganizationCheckType slaveCheckType = new WqyyOrganizationCheckType();
            BeanUtils.copyProperties((Object)checkType, (Object)slaveCheckType, (String[])new String[]{"createDate", "updateDate"});
            slaveCheckType.setId(Long.valueOf(IdWorker.getId()));
            slaveCheckType.setOrganizationId(slaveOrg.getId());
            slaveCheckType.setCreateBy(String.valueOf(loginUserId));
            slaveCheckType.setUpdatedBy(String.valueOf(loginUserId));
            checkTypeSlaveList.add(slaveCheckType);
        }
        this.checkTypeService.saveBatch(checkTypeSlaveList);
        LambdaQueryWrapper logWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)logWrapper.eq(WqyyWorkOperateLog::getWorkId, (Object)organization.getId())).eq(WqyyWorkOperateLog::getIsValid, (Object)true)).eq(WqyyWorkOperateLog::getWorkModule, (Object)WqyyLogWorkModeEnum.ZLSH.getCode());
        List logList = this.operateLogService.list((Wrapper)logWrapper);
        ArrayList<WqyyWorkOperateLog> logSlaveList = new ArrayList<WqyyWorkOperateLog>();
        for (WqyyWorkOperateLog log : logList) {
            WqyyWorkOperateLog slaveLog = new WqyyWorkOperateLog();
            BeanUtils.copyProperties((Object)log, (Object)slaveLog, (String[])new String[]{"createDate", "updateDate"});
            slaveLog.setId(Long.valueOf(IdWorker.getId()));
            slaveLog.setWorkId(slaveOrg.getId());
            slaveLog.setCreateBy(loginUserId);
            slaveLog.setUpdateBy(loginUserId);
            logSlaveList.add(slaveLog);
        }
        this.operateLogService.saveBatch(logSlaveList);
        return slaveOrg.getId();
    }

    private void submitForAudit(WqyyOrganization org, List<WqyyOrganizationContact> contactList, List<WqyyOrganizationCheckType> checkTypeList) {
        this.saveOrUpdate(org);
        this.contactService.saveOrUpdateBatch(contactList);
        this.checkTypeService.saveOrUpdateBatch(checkTypeList);
    }

    private void verifyIncomingParameterData(WqyyOrganizationParam orgParam) {
        Long orgParamId = orgParam.getId();
        List contactList = orgParam.getContactList();
        if (contactList != null && !contactList.isEmpty()) {
            ArrayList<Long> orgIdList = new ArrayList<Long>();
            orgIdList.add(orgParamId);
            List<WqyyOrganizationContactVo> dbConcat = this.contactService.getConcatListByOrgIdBatch(orgIdList, null, (byte)1);
            List needAddAreaConcat = orgParam.getContactList().stream().filter(c -> c.getId() == null && c.getIsMaster() == false).collect(Collectors.toList());
            List needAddMasterConcat = orgParam.getContactList().stream().filter(WqyyOrganizationContactParam::getIsMaster).collect(Collectors.toList());
            List duplicateData = needAddAreaConcat.stream().filter(param -> {
                for (WqyyOrganizationContactVo db : dbConcat) {
                    boolean sameArea = Objects.equals(param.getAreaId(), db.getAreaId());
                    if (!sameArea) continue;
                    return true;
                }
                return false;
            }).collect(Collectors.toList());
            if (!duplicateData.isEmpty()) {
                String msg = duplicateData.stream().map(p -> p.getContact() + "-" + p.getAreaId()).collect(Collectors.joining(", "));
                throw new ServiceException("\u89c4\u5b9a\u533a\u57df\u8054\u7cfb\u4eba\u4ec5\u4e00\u4eba\uff0c\u8bf7\u68c0\u67e5\u4ee5\u4e0b\u6570\u636e\uff1a" + msg);
            }
            WqyyOrganizationContactVo masterConcat = dbConcat.stream().filter(WqyyOrganizationContactVo::getIsMaster).findFirst().orElse(null);
            if (masterConcat != null) {
                if (!needAddMasterConcat.isEmpty()) {
                    String msg = needAddMasterConcat.stream().map(p -> p.getContact() + "-" + p.getAreaId()).collect(Collectors.joining(", "));
                    throw new ServiceException("\u89c4\u5b9a\u603b\u90e8\u8054\u7cfb\u4eba\u6709\u4e14\u4ec5\u6709\u4e00\u4eba\uff0c\u8bf7\u68c0\u67e5\u4ee5\u4e0b\u6570\u636e\uff1a" + msg);
                }
            } else if (!needAddMasterConcat.isEmpty() && needAddMasterConcat.size() > 1) {
                String msg = needAddMasterConcat.stream().map(p -> p.getContact() + "-" + p.getAreaId()).collect(Collectors.joining(", "));
                throw new ServiceException("\u89c4\u5b9a\u603b\u90e8\u8054\u7cfb\u4eba\u6709\u4e14\u4ec5\u6709\u4e00\u4eba\uff0c\u8bf7\u68c0\u67e5\u4ee5\u4e0b\u6570\u636e\uff1a" + msg);
            }
        }
    }

    @Override
    @Transactional
    public Object insertOrUpdateOrganizationData(WqyyOrganizationParam orgParam) throws ServiceException {
        WqyyOrganization orgOld;
        Long id = orgParam.getId();
        if (id == null) {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)wrapper.eq(WqyyOrganization::getOrgId, (Object)orgParam.getCurrentLoginOrgId())).eq(WqyyOrganization::getIsValid, (Object)true);
            orgOld = (WqyyOrganization)this.getOne((Wrapper)wrapper);
            orgParam.setId(orgOld.getId());
        } else {
            orgOld = (WqyyOrganization)this.getById(orgParam.getId());
        }
        boolean isAddConcat = orgParam.getIsAddContact() != null && orgParam.getIsAddContact() != false;
        WqyyOrganization org = new WqyyOrganization();
        ArrayList<WqyyOrganizationContact> contactList = new ArrayList<WqyyOrganizationContact>();
        ArrayList<WqyyOrganizationCheckType> checkTypeList = new ArrayList<WqyyOrganizationCheckType>();
        this.verifyIncomingParameterData(orgParam);
        this.delAndPackLatestCheckTypeList(orgParam);
        this.organizationRelatedDataFill(orgParam, org, contactList, checkTypeList);
        if (orgOld.getIsShelves() == null) {
            org.setIsShelves(Integer.valueOf(1));
            WqyyWorkOperateLog operateLog2 = new WqyyWorkOperateLog();
            operateLog2.setWorkModule(WqyyLogWorkModeEnum.SJXJ.getCode());
            operateLog2.setWorkId(orgOld.getId());
            operateLog2.setReason(null);
            operateLog2.setOperater(orgParam.getCurrentLoginOrgName());
            operateLog2.setUpdateBy(orgParam.getCurrentLoginOrgId());
            operateLog2.setCreateBy(orgParam.getCurrentLoginOrgId());
            operateLog2.setUpdateDate(new Date());
            operateLog2.setCreateDate(new Date());
            operateLog2.setWorkStatus(Integer.valueOf(1));
            this.operateLogService.save(operateLog2);
        }
        this.saveOrUpdate(org);
        this.contactService.saveOrUpdateBatch(contactList);
        this.checkTypeService.saveOrUpdateBatch(checkTypeList);
        WqyyOrganization orgNew = (WqyyOrganization)this.getById(orgParam.getId());
        WqyyOrganizationAudit organizationAudit = new WqyyOrganizationAudit();
        BeanUtils.copyProperties((Object)orgNew, (Object)organizationAudit);
        organizationAudit.setOrganizationIntro(null);
        organizationAudit.setOrgListImg(null);
        organizationAudit.setOrgDetailImg(null);
        this.orgAuditService.saveOrUpdate(organizationAudit);
        this.setScheduleAdd(organizationAudit);
        if (isAddConcat) {
            return this.contactService.getConcatAreaInfo(((WqyyOrganizationContact)contactList.get(0)).getId());
        }
        return id;
    }

    public void setScheduleAdd(WqyyOrganizationAudit organizationAudit) {
        if (organizationAudit != null && StringUtils.isNotBlank((CharSequence)organizationAudit.getOpeningTime())) {
            ArrayList<WqyyScheduleAddParam> list = new ArrayList<WqyyScheduleAddParam>();
            try {
                Date beginDate = new Date();
                Set collect = Arrays.stream(organizationAudit.getOpeningTime().split(",")).map(Integer::valueOf).collect(Collectors.toSet());
                List needDateList = DateUtils.getWeekListDate((Date)beginDate, (Date)DateUtils.addDay((Date)beginDate, (int)21), collect);
                for (Date date : needDateList) {
                    if (date == null) continue;
                    WqyyScheduleAddParam scheduleAddParam = new WqyyScheduleAddParam();
                    scheduleAddParam.setOrganizationId(organizationAudit.getId());
                    scheduleAddParam.setScheduleDate(date);
                    list.add(scheduleAddParam);
                }
                this.scheduleService.addList(list);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.log.error("\u673a\u6784\u7aef\u4fdd\u5b58\u57fa\u7840\u4fe1\u606f\uff0c\u8425\u4e1a\u65f6\u95f4\u65e5\u671f\u89e3\u6790\u9519\u8bef\uff0c\u4e3b\u952eid\u4e3a" + organizationAudit.getId());
                throw new ServiceException("\u673a\u6784\u7aef\u4fdd\u5b58\u57fa\u7840\u4fe1\u606f\uff0c\u8425\u4e1a\u65f6\u95f4\u65e5\u671f\u89e3\u6790\u9519\u8bef\uff0c\u4e3b\u952eid\u4e3a" + organizationAudit.getId());
            }
        }
    }

    @Override
    @Transactional
    public Long editDetailAuditOrgData(WqyyOrganizationParam orgParam) {
        WqyyOrganizationAudit organizationAudit = (WqyyOrganizationAudit)this.orgAuditService.getById(orgParam.getId());
        if (organizationAudit == null) {
            throw new ServiceException("\u673a\u6784\u57fa\u7840\u4fe1\u606f\u672a\u5b8c\u5584\uff0c\u8bf7\u5148\u5b8c\u6210\u4fdd\u5b58\u57fa\u7840\u4fe1\u606f\uff01");
        }
        WqyyOrganization organization = new WqyyOrganization();
        organization.setId(organizationAudit.getId());
        organization.setOrganizationIntro(orgParam.getOrganizationIntro());
        organization.setOrgListImg(orgParam.getOrgListImg());
        organization.setOrgDetailImg(orgParam.getOrgDetailImg());
        organization.setUpdatedBy(orgParam.getCurrentLoginUserId().toString());
        organization.setUpdateDate(new Date());
        this.updateById(organization);
        return organizationAudit.getId();
    }

    private void delAndPackLatestCheckTypeList(WqyyOrganizationParam orgParam) {
        List<WqyyOrganizationCheckTypeVo> dbData = this.checkTypeService.getCheckTypeListByOrgId(orgParam.getId());
        List paramData = orgParam.getCheckTypeList();
        List dbCheckType = dbData == null ? Collections.emptyList() : dbData.stream().map(WqyyOrganizationCheckTypeVo::getCheckType).collect(Collectors.toList());
        List paramCheckType = paramData == null ? Collections.emptyList() : paramData.stream().map(WqyyOrganizationCheckTypeParam::getCheckType).collect(Collectors.toList());
        List<Integer> needDelCheckType = dbCheckType.stream().filter(d -> !paramCheckType.contains(d)).collect(Collectors.toList());
        List needAddCheckType = paramData == null ? Collections.emptyList() : paramData.stream().filter(p -> !dbCheckType.contains(p.getCheckType())).collect(Collectors.toList());
        this.checkTypeService.deleteCheckTypeMapByOrgIdBatch(orgParam.getId(), needDelCheckType);
        orgParam.setCheckTypeList(needAddCheckType);
    }

    private void organizationRelatedDataFill(WqyyOrganizationParam orgParam, WqyyOrganization org, List<WqyyOrganizationContact> contactList, List<WqyyOrganizationCheckType> checkTypelist) {
        Date currentDate = new Date();
        BeanUtils.copyProperties((Object)orgParam, (Object)org);
        org.setUpdateDate(currentDate);
        org.setUpdatedBy(String.valueOf(orgParam.getCurrentLoginUserId()));
        this.fillMasterContactInfo(orgParam, org, contactList, currentDate);
        List checkTypeParamList = orgParam.getCheckTypeList();
        if (checkTypeParamList != null) {
            for (WqyyOrganizationCheckTypeParam checkTypeParam : checkTypeParamList) {
                WqyyOrganizationCheckType checkType = new WqyyOrganizationCheckType();
                BeanUtils.copyProperties((Object)checkTypeParam, (Object)checkType);
                checkType.setOrganizationId(org.getId());
                checkType.setId(Long.valueOf(checkTypeParam.getId() == null ? IdWorker.getId() : checkTypeParam.getId()));
                checkType.setIsValid(Boolean.valueOf(checkTypeParam.getId() == null || checkTypeParam.getIsValid() == null || checkTypeParam.getIsValid() != false));
                checkType.setCreateDate(currentDate);
                checkType.setCreateBy(String.valueOf(orgParam.getCurrentLoginUserId()));
                checkType.setUpdatedBy(String.valueOf(orgParam.getCurrentLoginUserId()));
                checkTypelist.add(checkType);
            }
        }
    }

    private void fillAreaContactInfo(WqyyOrganizationParam orgParam, WqyyOrganization org, List<WqyyOrganizationContact> contactList, Date currentDate) {
        LambdaQueryWrapper cotWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)cotWrapper.eq(WqyyOrganizationContact::getOrganizationId, (Object)orgParam.getId())).eq(WqyyOrganizationContact::getIsValid, (Object)true)).eq(WqyyOrganizationContact::getIsMaster, (Object)false);
        List dbContactList = this.contactService.list((Wrapper)cotWrapper);
        List paramContactList = orgParam.getContactList();
        if (paramContactList == null) {
            List delAll = dbContactList.stream().map(WqyyOrganizationContact::getId).collect(Collectors.toList());
            this.contactService.removeByIds(delAll);
        } else {
            List needDelContact = dbContactList.stream().filter(db -> paramContactList.stream().noneMatch(param -> Objects.equals(param.getContact(), db.getContact()) && Objects.equals(param.getPhone(), db.getPhone()))).map(WqyyOrganizationContact::getId).collect(Collectors.toList());
            this.contactService.removeByIds(needDelContact);
            List needAddConcat = paramContactList.stream().filter(p -> dbContactList.stream().noneMatch(db -> Objects.equals(db.getContact(), p.getContact()) && Objects.equals(db.getPhone(), p.getPhone()))).collect(Collectors.toList());
            for (WqyyOrganizationContactParam contactParam : needAddConcat) {
                WqyyOrganizationContact contact = new WqyyOrganizationContact();
                BeanUtils.copyProperties((Object)contactParam, (Object)contact);
                contact.setOrganizationId(org.getId());
                contact.setId(Long.valueOf(IdWorker.getId()));
                contact.setAreaId(contactParam.getAreaId() == null ? orgParam.getCurrentLoginAreaId() : contactParam.getAreaId());
                contact.setIsValid(Boolean.valueOf(true));
                contact.setIsMaster(Boolean.valueOf(false));
                contact.setCreateDate(currentDate);
                contact.setCreateBy(String.valueOf(orgParam.getCurrentLoginUserId()));
                contact.setUpdatedBy(String.valueOf(orgParam.getCurrentLoginUserId()));
                contactList.add(contact);
            }
        }
    }

    private void fillMasterContactInfo(WqyyOrganizationParam orgParam, WqyyOrganization org, List<WqyyOrganizationContact> contactList, Date currentDate) {
        WqyyOrganizationContactParam masterParam = orgParam.getMasterContact();
        QueryWrapper masterWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)masterWrapper.eq((Object)"organization_id", (Object)orgParam.getId())).eq((Object)"is_master", (Object)true)).eq((Object)"is_valid", (Object)true);
        WqyyOrganizationContact masterDb = (WqyyOrganizationContact)this.contactService.getOne((Wrapper)masterWrapper);
        if (masterParam != null) {
            WqyyOrganizationContact master = new WqyyOrganizationContact();
            BeanUtils.copyProperties((Object)masterParam, (Object)master);
            master.setOrganizationId(org.getId());
            master.setId(Long.valueOf(masterDb == null ? IdWorker.getId() : masterDb.getId()));
            master.setAreaId(org.getAreaId());
            master.setIsValid(Boolean.valueOf(masterParam.getId() == null || masterParam.getIsValid() == null || masterParam.getIsValid() != false));
            master.setIsMaster(Boolean.valueOf(masterParam.getIsMaster() != null && masterParam.getIsMaster() != false));
            master.setCreateDate(currentDate);
            if (masterParam.getId() == null) {
                master.setCreateBy(String.valueOf(orgParam.getCurrentLoginUserId()));
            }
            master.setUpdatedBy(String.valueOf(orgParam.getCurrentLoginUserId()));
            contactList.add(master);
        }
    }

    @Override
    @Transactional
    public Boolean changeForbiddenLine(WqyyOrgChangeParam param) {
        WqyyOrganization wqyyOrganization = new WqyyOrganization();
        wqyyOrganization.setForbiddenLineOfPeople(param.getForbiddenLineOfPeople());
        wqyyOrganization.setForbiddenLineOfEnterprises(param.getForbiddenLineOfEnterprises());
        wqyyOrganization.setForbiddenLineOfVehicles(param.getForbiddenLineOfVehicles());
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(WqyyOrganization::getOrgId, (Object)param.getOrgId())).eq(WqyyOrganization::getIsValid, (Object)true);
        return ((WqyyOrganizationMapper)this.baseMapper).update(wqyyOrganization, (Wrapper)wrapper) > 0;
    }

    @Override
    @Transactional
    public void deleteContactInfo(Long concatId, Long loginUserId) {
        this.contactService.deleteContactInfo(concatId);
    }

    @Override
    public List<Object> queryOperateRecord(Long organizationId) {
        return null;
    }

    @Override
    public List<WqyyOrganizationCheckTypeVo> queryCheckTypeList() {
        return ((WqyyOrganizationMapper)this.baseMapper).queryCheckTypeList();
    }

    @Override
    public ThirdOrganization queryThirdOrganizationData(Long id) {
        return ((WqyyOrganizationMapper)this.baseMapper).queryThirdOrganizationData(id);
    }

    @Override
    public List<ThirdOrgInfoDic> queryThirdOrganizationCheckTypeListData(Long currentLoginOrgId) {
        List<ThirdOrgInfoDic> infoDics = ((WqyyOrganizationMapper)this.baseMapper).queryThirdOrganizationCheckTypeListData(currentLoginOrgId);
        if (infoDics == null) {
            return Collections.emptyList();
        }
        return infoDics;
    }

    @Override
    public List<ThirdOrgInfo> queryThirdOrgInfoListData(Long currentLoginOrgId) {
        List<ThirdOrgInfo> infos = ((WqyyOrganizationMapper)this.baseMapper).queryThirdOrgInfoListData(currentLoginOrgId);
        if (infos == null) {
            return Collections.emptyList();
        }
        return infos;
    }

    @Override
    public Byte judgeMasterSlaveAuditReturn(WqyyOrganizationVo organizationData) {
        Long organizationDataId = organizationData.getId();
        Long orgId = organizationData.getOrgId();
        WqyyOrganizationVo slaveOrganizationData = ((WqyyOrganizationMapper)this.baseMapper).judgeMasterSlaveAuditReturn(orgId);
        if (slaveOrganizationData != null) {
            return slaveOrganizationData.getAuditStatus();
        }
        return organizationData.getAuditStatus();
    }

    @Override
    public List<WqyyOrganizationVo> findOrganizationAllHistoryInfo(Long currentLoginOrgId) {
        if (currentLoginOrgId == null) {
            return Collections.emptyList();
        }
        return ((WqyyOrganizationMapper)this.baseMapper).findOrganizationAllHistoryInfo(currentLoginOrgId);
    }

    @Override
    public void updateThirdOrgInfoByPrimaryKey(ThirdOrganization thirdOrg) {
        ((WqyyOrganizationMapper)this.baseMapper).updateThirdOrgInfoByPrimaryKey(thirdOrg);
    }

    @Override
    public void deleteThirdOrgInfoByPrimaryKeys(List<Long> ids) {
        ((WqyyOrganizationMapper)this.baseMapper).deleteThirdOrgInfoByPrimaryKeys(ids);
    }

    @Override
    public void addThirdOrgInfo(List<ThirdOrgInfo> orgInfo) {
        if (orgInfo == null || orgInfo.isEmpty()) {
            return;
        }
        ((WqyyOrganizationMapper)this.baseMapper).addThirdOrgInfo(orgInfo);
    }

    @Override
    public boolean checkOrgUsccIsExist(String creditCode) {
        return ((WqyyOrganizationMapper)this.baseMapper).checkOrgUsccIsExist(creditCode);
    }

    @Override
    public void updateAuditScoreById(List<WqyyOrganization> orgList) {
        if (orgList == null || orgList.isEmpty()) {
            return;
        }
        ((WqyyOrganizationMapper)this.baseMapper).updateAuditScoreById(orgList);
    }

    private void insertOperateRecordLog(WqyyOrganizationParam orgParam) {
    }

    @Generated
    public WqyyOrganizationServiceImpl(IWqyyOrganizationContactService contactService, IWqyyOrganizationCheckTypeService checkTypeService, IWqyyWorkOperateLogService operateLogService, IWqyyOrganizationAuditService orgAuditService, IWqyyScheduleService scheduleService, OssClientBean ossBean) {
        this.contactService = contactService;
        this.checkTypeService = checkTypeService;
        this.operateLogService = operateLogService;
        this.orgAuditService = orgAuditService;
        this.scheduleService = scheduleService;
        this.ossBean = ossBean;
    }
}

