/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.wqyy.service.wqyy.impl;

import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.wqyy.dao.wqyy.WqyyOrganizationContactMapper;
import cn.smarthse.wqyy.entity.wqyy.WqyyOrganizationContact;
import cn.smarthse.wqyy.model.vo.appointment.ContactsInfo;
import cn.smarthse.wqyy.model.vo.org.WqyyOrganizationContactVo;
import cn.smarthse.wqyy.service.wqyy.IWqyyOrganizationContactService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class WqyyOrganizationContactServiceImpl
extends ServiceImpl<WqyyOrganizationContactMapper, WqyyOrganizationContact>
implements IWqyyOrganizationContactService {
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;

    @Override
    public List<ContactsInfo> getOrgContacts(Long orgId, Long orgCantactAreaId) {
        AreaModel areaById = this.sysAreaProvideService.getAreaById(orgCantactAreaId);
        return ((WqyyOrganizationContactMapper)this.baseMapper).getOrgContacts(orgId, areaById.getId(), areaById.getLevel());
    }

    @Override
    public void deleteContactInfo(Long concatId) {
        if (concatId == null) {
            return;
        }
        ((WqyyOrganizationContactMapper)this.baseMapper).deleteContactInfo(concatId);
    }

    @Override
    public void deleteContactInfoHard(Long concatId) {
        if (concatId == null) {
            return;
        }
        ((WqyyOrganizationContactMapper)this.baseMapper).deleteContactInfoHard(concatId);
    }

    @Override
    public List<WqyyOrganizationContactVo> getConcatListByOrgIdBatch(List<Long> orgIdList, Long nowAreaId, Byte source) {
        if (orgIdList == null || orgIdList.isEmpty()) {
            return Collections.emptyList();
        }
        List<WqyyOrganizationContactVo> concatList = ((WqyyOrganizationContactMapper)this.baseMapper).getConcatListByOrgIdBatch(orgIdList, source);
        if (concatList == null) {
            return Collections.emptyList();
        }
        List<WqyyOrganizationContactVo> masterConcatList = ((WqyyOrganizationContactMapper)this.baseMapper).getMasterConcatListByOrgIdBatch(orgIdList, source);
        concatList.addAll(masterConcatList);
        return concatList.stream().peek(c -> c.setIsNowAreaConcat(Boolean.valueOf(Objects.equals(nowAreaId, c.getAreaId())))).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<WqyyOrganizationContactVo>(Comparator.comparing(o -> o.getOrganizationId() + "_" + o.getId()))), ArrayList::new));
    }

    @Override
    public List<WqyyOrganizationContact> selectListByCondition() {
        return null;
    }

    @Override
    public WqyyOrganizationContactVo getConcatAreaInfo(Long concatPkId) {
        if (concatPkId == null) {
            return null;
        }
        return ((WqyyOrganizationContactMapper)this.baseMapper).getConcatAreaInfo(concatPkId);
    }

    @Override
    public List<WqyyOrganizationContactVo> getConcatAreaInfoBatch(List<Long> concatPkIdList) {
        if (concatPkIdList == null || concatPkIdList.isEmpty()) {
            return Collections.emptyList();
        }
        return ((WqyyOrganizationContactMapper)this.baseMapper).getConcatAreaInfoBatch(concatPkIdList);
    }

    @Override
    public WqyyOrganizationContactVo getConcatAreaInfoByContactId(Long contactId) {
        if (contactId == null) {
            return null;
        }
        return ((WqyyOrganizationContactMapper)this.baseMapper).getConcatAreaInfoByContactId(contactId);
    }

    @Override
    public List<WqyyOrganizationContactVo> getConcatAreaListByOrgId(Long orgId) {
        if (orgId == null) {
            return Collections.emptyList();
        }
        return ((WqyyOrganizationContactMapper)this.baseMapper).getConcatAreaListByOrgId(orgId);
    }

    @Override
    public void deleteContactInfoByContactIdHard(Long concatId) {
        if (concatId == null) {
            return;
        }
        ((WqyyOrganizationContactMapper)this.baseMapper).deleteContactInfoByContactIdHard(concatId);
    }

    @Generated
    public WqyyOrganizationContactServiceImpl() {
    }
}

