/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.wqyy.service.wqyy.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.provider.sms.ISMSProvideMasService;
import cn.smarthse.wqyy.bootstrap.security.service.ShiroUtil;
import cn.smarthse.wqyy.converter.appointment.AppointmentConverter;
import cn.smarthse.wqyy.dao.wqyy.WqyyAppointmentMapper;
import cn.smarthse.wqyy.entity.wqyy.WqyyAppointment;
import cn.smarthse.wqyy.entity.wqyy.WqyyAppointmentItem;
import cn.smarthse.wqyy.entity.wqyy.WqyyOrganization;
import cn.smarthse.wqyy.entity.wqyy.WqyyOrganizationContact;
import cn.smarthse.wqyy.enums.appointment.AppointmentStatusEnum;
import cn.smarthse.wqyy.enums.appointment.AppointmentTypeEnum;
import cn.smarthse.wqyy.model.param.appointment.ItemInfo;
import cn.smarthse.wqyy.model.param.appointment.PartOneParam;
import cn.smarthse.wqyy.model.param.appointment.PartTwoParam;
import cn.smarthse.wqyy.model.param.appointment.WqyyResponsivityParam;
import cn.smarthse.wqyy.model.param.subscribe.WqyyScheduleSearchParam;
import cn.smarthse.wqyy.model.param.subscribe.WqyySubscribeChangeParam;
import cn.smarthse.wqyy.model.param.subscribe.WqyySubscribeSearchParam;
import cn.smarthse.wqyy.model.vo.appointment.AppointmentDateInfo;
import cn.smarthse.wqyy.model.vo.appointment.AppointmentDateItem;
import cn.smarthse.wqyy.model.vo.appointment.AppointmentInfo;
import cn.smarthse.wqyy.model.vo.appointment.CompanyBaseInfo;
import cn.smarthse.wqyy.model.vo.appointment.ContactsInfo;
import cn.smarthse.wqyy.model.vo.appointment.RecordInfo;
import cn.smarthse.wqyy.model.vo.appointment.StatusAndChangeDateInfo;
import cn.smarthse.wqyy.model.vo.org.WqyyOrganizationVo;
import cn.smarthse.wqyy.model.vo.subscribe.WqyyResponsivityVo;
import cn.smarthse.wqyy.model.vo.subscribe.WqyyScheduleCompanyVo;
import cn.smarthse.wqyy.model.vo.subscribe.WqyyScheduleVo;
import cn.smarthse.wqyy.model.vo.subscribe.WqyySubscribeDetailDataVo;
import cn.smarthse.wqyy.model.vo.subscribe.WqyySubscribeHarmFactorVo;
import cn.smarthse.wqyy.service.wqyy.IWqyyActivationService;
import cn.smarthse.wqyy.service.wqyy.IWqyyAppointmentItemService;
import cn.smarthse.wqyy.service.wqyy.IWqyyAppointmentService;
import cn.smarthse.wqyy.service.wqyy.IWqyyOrganizationContactService;
import cn.smarthse.wqyy.service.wqyy.IWqyyOrganizationService;
import cn.smarthse.wqyy.service.wqyy.IWqyyReservationLogService;
import cn.smarthse.wqyy.service.wqyy.IWqyyScheduleService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class WqyyAppointmentServiceImpl
extends ServiceImpl<WqyyAppointmentMapper, WqyyAppointment>
implements IWqyyAppointmentService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WqyyAppointmentServiceImpl.class);
    private final IWqyyAppointmentItemService wqyyAppointmentItemService;
    private final IWqyyOrganizationContactService wqyyOrganizationContactService;
    private final IWqyyReservationLogService wqyyReservationLogService;
    private final IWqyyOrganizationService wqyyOrganizationService;
    private final IWqyyScheduleService wqyyScheduleService;
    private final IWqyyActivationService wqyyActivationService;
    @DubboReference
    private ISMSProvideMasService masService;
    private final AppointmentConverter converter;

    @Override
    @Transactional(readOnly=false)
    public AppointmentInfo appointmentPart1(PartOneParam param) {
        WqyyAppointment wqyyAppointment = this.converter.partOneParam2WqyyAppointment(param);
        wqyyAppointment.setStatus(AppointmentStatusEnum.DRAFT.getCode());
        wqyyAppointment.setCid(ShiroUtil.getCid());
        String unifiedSocialCc = ((WqyyAppointmentMapper)this.baseMapper).getUnifiedSocialCcByCid(wqyyAppointment.getCid());
        wqyyAppointment.setUnifiedSocialCc(unifiedSocialCc);
        if (Objects.nonNull(param.getAppointmentId())) {
            wqyyAppointment.setId(param.getAppointmentId());
        }
        this.saveOrUpdate(wqyyAppointment);
        this.wqyyAppointmentItemService.delByAppointmentId(param.getAppointmentId());
        List<WqyyAppointmentItem> wqyyAppointmentItems = this.converter.itemInfo2WqyyAppointmentItem(param.getItems());
        wqyyAppointmentItems.forEach(wqyyAppointmentItem -> wqyyAppointmentItem.setAppointmentId(wqyyAppointment.getId()));
        this.wqyyAppointmentItemService.saveOrUpdateBatch(wqyyAppointmentItems);
        AppointmentInfo info = this.converter.wqyyAppointment2AppointmentInfo(wqyyAppointment);
        info.setAppointmentId(wqyyAppointment.getId());
        List<ItemInfo> itemInfos = this.converter.wqyyAppointmentItem2IntemInfo(wqyyAppointmentItems);
        info.setItems(itemInfos);
        return info;
    }

    @Override
    @Transactional(readOnly=false)
    public AppointmentInfo appointmentPart2(PartTwoParam param) {
        AppointmentInfo info = this.getInfoById(param.getAppointmentId());
        WqyyAppointment wqyyAppointment = this.converter.appointmentInfo2WqyyAppointment(info);
        wqyyAppointment.setChangeDate(param.getAppointmentDate());
        wqyyAppointment.setAppointmentDate(param.getAppointmentDate());
        wqyyAppointment.setId(info.getAppointmentId());
        this.updateById(wqyyAppointment);
        info.setAppointmentDate(param.getAppointmentDate());
        return info;
    }

    @Override
    public AppointmentInfo getInfoById(Long appointmentId) {
        WqyyAppointment appointment = (WqyyAppointment)this.getById(appointmentId);
        if (Objects.isNull(appointment)) {
            return null;
        }
        AppointmentInfo info = new AppointmentInfo();
        BeanUtils.copyProperties((Object)appointment, (Object)info);
        info.setAppointmentId(appointment.getId());
        List<ItemInfo> items = this.wqyyAppointmentItemService.listByAppointmentId(appointmentId);
        info.setItems(items);
        return info;
    }

    @Override
    @Transactional(readOnly=false)
    public void appointmentPart3(Long appointmentId) {
        WqyyAppointment appointment = (WqyyAppointment)this.getById(appointmentId);
        if (Objects.isNull(appointment)) {
            throw new RuntimeException("\u4f20\u5165\u9884\u7ea6id\u6709\u8bef,\u8bf7\u68c0\u67e5");
        }
        if (!AppointmentStatusEnum.DRAFT.getCode().equals(appointment.getStatus())) {
            throw new RuntimeException("\u5f53\u524d\u9884\u7ea6\u5df2\u63d0\u4ea4,\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4");
        }
        LambdaQueryWrapper contactWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)contactWrapper.eq(WqyyOrganizationContact::getOrganizationId, (Object)appointment.getOrgId())).eq(WqyyOrganizationContact::getIsMaster, (Object)true)).eq(WqyyOrganizationContact::getIsValid, (Object)true);
        WqyyOrganizationContact one = (WqyyOrganizationContact)this.wqyyOrganizationContactService.getOne((Wrapper)contactWrapper);
        if (one != null && StringUtils.isNotBlank((CharSequence)one.getPhone())) {
            String principalPhone = one.getPhone();
            String date = DateUtil.format((Date)new Date(), (String)"yyyy\u5e74/MM\u6708/dd\u65e5");
            String companyName = appointment.getCompanyName();
            try {
                this.masService.sendSms(principalPhone, "\u3010" + companyName + "\u3011\u4e8e\u3010" + date + "\u3011\u5411\u8d35\u673a\u6784\u9884\u7ea6\u4e86\u804c\u4e1a\u5065\u5eb7\u4f53\u68c0\uff0c\u8bf7\u53ca\u65f6\u767b\u9646\u201c\u6d59\u91cc\u536b\u4f01-\u4e13\u4e1a\u673a\u6784\u7aef\u201d\uff08\u7f51\u5740\uff1ahttps://ohonline.wsjkw.zj.gov.cn:8184/login\uff09\u8fdb\u884c\u54cd\u5e94\u3002");
            }
            catch (Exception e) {
                log.error("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25{}", (Object)e.getMessage());
            }
        }
        appointment.setStatus(AppointmentStatusEnum.COMPANY_MADE_APPOINTMENT.getCode());
        this.wqyyReservationLogService.addLog(appointmentId, AppointmentStatusEnum.COMPANY_MADE_APPOINTMENT.getCode(), ShiroUtil.getUserId());
        this.updateById(appointment);
    }

    @Override
    public AppointmentInfo baseInfo(Long appointmentId) {
        WqyyAppointment appointment = (WqyyAppointment)this.getById(appointmentId);
        if (Objects.isNull(appointment)) {
            throw new RuntimeException("\u4f20\u5165\u9884\u7ea6id\u6709\u8bef,\u8bf7\u68c0\u67e5");
        }
        AppointmentInfo info = new AppointmentInfo();
        BeanUtils.copyProperties((Object)appointment, (Object)info);
        return info;
    }

    @Override
    public List<ContactsInfo> getOrgContacts(Long appointmentId) {
        WqyyAppointment appointment = (WqyyAppointment)this.getById(appointmentId);
        return this.wqyyOrganizationContactService.getOrgContacts(appointment.getOrgId(), appointment.getOrgCantactAreaId());
    }

    @Override
    public List<RecordInfo> recordInfoList(Long userId) {
        List<RecordInfo> recordInfos = ((WqyyAppointmentMapper)this.baseMapper).recordInfoList(userId);
        recordInfos.forEach(item -> {
            if (!DateUtil.isSameDay((Date)item.getAppointmentDate(), (Date)item.getChangeDate())) {
                item.setIsDateChanged(Boolean.valueOf(true));
                item.setAppointmentDate(item.getChangeDate());
            }
            item.setChangeDate(null);
        });
        return recordInfos;
    }

    @Override
    public PageInfo<RecordInfo> recordInfoListPage(JqGridParam param, Long userId) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        return new PageInfo(this.recordInfoList(userId));
    }

    @Override
    public StatusAndChangeDateInfo getStatusAndChangeDateInfo(Long appointmentId) {
        StatusAndChangeDateInfo info = new StatusAndChangeDateInfo();
        WqyyAppointment appointment = (WqyyAppointment)this.getById(appointmentId);
        if (Objects.isNull(appointment)) {
            return info;
        }
        info.setStatus(appointment.getStatus());
        info.setChangeDate(appointment.getChangeDate());
        if (DateUtil.isSameDay((Date)appointment.getChangeDate(), (Date)appointment.getAppointmentDate())) {
            info.setChangeDate(null);
        }
        return info;
    }

    @Override
    public JqGridData<WqyyAppointment> getSubscribeDataList(WqyySubscribeSearchParam param) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(WqyyOrganization::getOrgId, (Object)param.getOrgId())).eq(WqyyOrganization::getIsValid, (Object)true)).select(new SFunction[]{WqyyOrganization::getId});
        WqyyOrganization wqyyOrganization = (WqyyOrganization)this.wqyyOrganizationService.getOne((Wrapper)wrapper);
        if (Objects.isNull(wqyyOrganization)) {
            return new JqGridData();
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        LambdaQueryWrapper wrapper2 = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(WqyyAppointment::getOrgId, (Object)wqyyOrganization.getId())).eq(WqyyAppointment::getIsValid, (Object)true)).ne(WqyyAppointment::getStatus, (Object)AppointmentStatusEnum.DRAFT.getCode())).orderByAsc(WqyyAppointment::getCreateDate);
        if (StrUtil.isNotBlank((CharSequence)param.getKeyWord())) {
            wrapper2.and(i -> ((LambdaQueryWrapper)((LambdaQueryWrapper)i.like(WqyyAppointment::getCompanyName, (Object)param.getKeyWord())).or()).like(WqyyAppointment::getUnifiedSocialCc, (Object)param.getKeyWord()));
        }
        if (Objects.nonNull(param.getStatus())) {
            wrapper2.eq(WqyyAppointment::getStatus, (Object)param.getStatus());
        }
        return new JqGridData((Page)((WqyyAppointmentMapper)this.baseMapper).selectList((Wrapper)wrapper2), (JqGridParam)param);
    }

    @Override
    public WqyyScheduleVo getAllCompanyListByTime(WqyyScheduleSearchParam param) {
        WqyyScheduleVo rst = new WqyyScheduleVo();
        if (param.getTime() == null || param.getOrgId() == null) {
            return rst;
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(WqyyOrganization::getOrgId, (Object)param.getOrgId())).eq(WqyyOrganization::getIsValid, (Object)true)).select(new SFunction[]{WqyyOrganization::getId});
        WqyyOrganization wqyyOrganization = (WqyyOrganization)this.wqyyOrganizationService.getOne((Wrapper)wrapper);
        if (Objects.isNull(wqyyOrganization)) {
            return rst;
        }
        param.setOrgId(wqyyOrganization.getId());
        List<WqyyScheduleCompanyVo> allCompanyListByTime = ((WqyyAppointmentMapper)this.baseMapper).getAllCompanyListByTime(param);
        if (CollUtil.isEmpty(allCompanyListByTime)) {
            return rst;
        }
        rst.setCompanyTotalNums(Long.valueOf(allCompanyListByTime.stream().map(WqyyScheduleCompanyVo::getCompanyName).distinct().count()));
        rst.setAppointmentTotalNums(Integer.valueOf(allCompanyListByTime.stream().mapToInt(WqyyScheduleCompanyVo::getAppointmentNum).sum()));
        rst.setAppointmentVehicleNums(Long.valueOf(allCompanyListByTime.stream().filter(i -> Objects.equals(i.getType(), AppointmentTypeEnum.OUT_ORG_SERVICE.getCode())).map(WqyyScheduleCompanyVo::getCompanyName).distinct().count()));
        rst.setList(allCompanyListByTime);
        return rst;
    }

    @Override
    public List<AppointmentDateItem> appointmentDateList(Long orgId) {
        List<AppointmentDateItem> appointmentDateItems = ((WqyyAppointmentMapper)this.baseMapper).appointmentDateList(orgId);
        List<AppointmentDateItem> appointmentDateBaseList = ((WqyyAppointmentMapper)this.baseMapper).appointmentDateBaseList(orgId);
        appointmentDateBaseList.forEach(item -> {
            AppointmentDateItem appointmentDateItem = appointmentDateItems.stream().filter(app -> DateUtil.isSameDay((Date)app.getScheduleDate(), (Date)item.getScheduleDate())).findFirst().orElse(null);
            if (Objects.nonNull(appointmentDateItem)) {
                item.setCarNum(appointmentDateItem.getCarNum());
                item.setAlreadyBookedNum(appointmentDateItem.getAlreadyBookedNum());
            } else {
                item.setCarNum(Integer.valueOf(0));
                item.setAlreadyBookedNum(Integer.valueOf(0));
            }
        });
        appointmentDateBaseList.sort(Comparator.comparing(AppointmentDateItem::getScheduleDate));
        return appointmentDateBaseList;
    }

    @Override
    public AppointmentDateInfo appointmentDateInfoList(Long appointmentId) {
        AppointmentDateInfo info = new AppointmentDateInfo();
        WqyyAppointment appointment = (WqyyAppointment)this.getById(appointmentId);
        if (Objects.isNull(appointment)) {
            return info;
        }
        Long orgId = appointment.getOrgId();
        List<AppointmentDateItem> items = this.appointmentDateList(orgId);
        Date appointmentDate = appointment.getAppointmentDate();
        if (Objects.nonNull(appointmentDate)) {
            items.forEach(item -> {
                if (DateUtil.isSameDay((Date)appointmentDate, (Date)item.getScheduleDate())) {
                    item.setIsChoose(Boolean.valueOf(true));
                }
            });
        }
        WqyyOrganizationVo vo = this.wqyyOrganizationService.getForbiddenLineInfoById(orgId);
        if (AppointmentTypeEnum.IN_ORG_SERVICE.getCode().equals(appointment.getType())) {
            items.forEach(item -> item.setCarNum(null));
            vo.setForbiddenLineOfVehicles(null);
        }
        info.setItems(items);
        info.setForbiddenLineOfPeople(vo.getForbiddenLineOfPeople());
        info.setForbiddenLineOfCar(vo.getForbiddenLineOfVehicles());
        return info;
    }

    @Override
    @Transactional
    public Boolean changeSubscribe(WqyySubscribeChangeParam param) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(WqyyAppointment::getIsValid, (Object)true)).eq(WqyyAppointment::getId, (Object)param.getId())).set(WqyyAppointment::getChangeDate, (Object)param.getChangeTime());
        return this.update((Wrapper)wrapper);
    }

    @Override
    public List<WqyySubscribeDetailDataVo> getSubscribeDataByMonth(WqyyScheduleSearchParam param) {
        return ((WqyyAppointmentMapper)this.baseMapper).getSubscribeDataByMonth(param);
    }

    @Override
    public CompanyBaseInfo companyBaseInfo(Long cid) {
        return ((WqyyAppointmentMapper)this.baseMapper).companyBaseInfo(cid);
    }

    @Override
    public List<WqyySubscribeHarmFactorVo> getSubscribeHarmFactorVoByCid(Long cid) {
        String harmId = ((WqyyAppointmentMapper)this.baseMapper).getSubscribeHarmIdByCid(cid);
        if (StrUtil.isBlank((CharSequence)harmId)) {
            return Collections.emptyList();
        }
        List harmIdList = StringUtils.parseToLongList((String)harmId);
        if (CollUtil.isEmpty((Collection)harmIdList)) {
            return Collections.emptyList();
        }
        return ((WqyyAppointmentMapper)this.baseMapper).getHarmName(harmIdList);
    }

    @Override
    public WqyyResponsivityVo getResponsivityData(WqyyResponsivityParam param) {
        this.checkParam(param);
        WqyyResponsivityVo responsivityVo = null;
        responsivityVo = param.getOnlyCityLevelOrg() != false ? ((WqyyAppointmentMapper)this.baseMapper).getCityResponsivityData(param) : ((WqyyAppointmentMapper)this.baseMapper).getResponsivityData(param);
        return responsivityVo;
    }

    @Override
    public PageInfo<WqyyResponsivityVo> getResponsivityListData(WqyyResponsivityParam param) {
        this.checkParam(param);
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        Object order = "case when responseRate is null then 1 else 0 end,responseRate desc, medicalExaminationNum desc, responseNum desc, case when accessRate is null then 1 else 0 end,accessRate desc, totalNums desc, accessNum desc";
        if (StringUtils.isNotBlank((CharSequence)param.getSidx())) {
            order = "responseRate".equals(param.getSidx()) || "accessRate".equals(param.getSidx()) ? "case when " + param.getSidx() + " is null then 1 else 0 end," + param.getSidx() + " desc" : param.getSidx() + " desc";
        }
        PageHelper.orderBy((String)order);
        List<WqyyResponsivityVo> list = ((WqyyAppointmentMapper)this.baseMapper).getResponsivityListData(param);
        return new PageInfo(list);
    }

    @Override
    public PageInfo<WqyyResponsivityVo> getResponsivityDetail(WqyyResponsivityParam param) {
        this.checkParam(param);
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        return new PageInfo(((WqyyAppointmentMapper)this.baseMapper).getResponsivityDetail(param));
    }

    @Override
    public List<WqyyResponsivityVo> exportResponseData(WqyyResponsivityParam param) {
        this.checkParam(param);
        return ((WqyyAppointmentMapper)this.baseMapper).getResponsivityListData(param);
    }

    void checkParam(WqyyResponsivityParam param) {
        if ("2".equals(String.valueOf(param.getSearchAreaLevel())) && Objects.nonNull(param.getAreaName()) && param.getAreaName().endsWith("\u672c\u7ea7")) {
            param.setOnlyCityLevelOrg(Boolean.valueOf(true));
        } else {
            param.setOnlyCityLevelOrg(Boolean.valueOf(false));
        }
    }

    @Generated
    public WqyyAppointmentServiceImpl(IWqyyAppointmentItemService wqyyAppointmentItemService, IWqyyOrganizationContactService wqyyOrganizationContactService, IWqyyReservationLogService wqyyReservationLogService, IWqyyOrganizationService wqyyOrganizationService, IWqyyScheduleService wqyyScheduleService, IWqyyActivationService wqyyActivationService, AppointmentConverter converter) {
        this.wqyyAppointmentItemService = wqyyAppointmentItemService;
        this.wqyyOrganizationContactService = wqyyOrganizationContactService;
        this.wqyyReservationLogService = wqyyReservationLogService;
        this.wqyyOrganizationService = wqyyOrganizationService;
        this.wqyyScheduleService = wqyyScheduleService;
        this.wqyyActivationService = wqyyActivationService;
        this.converter = converter;
    }
}

