/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.wqyy.provider.third;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.wqyy.converter.appointment.AppointmentConverter;
import cn.smarthse.wqyy.converter.org.OrganizationConverter;
import cn.smarthse.wqyy.entity.wqyy.WqyyAppointment;
import cn.smarthse.wqyy.entity.wqyy.WqyyOrganization;
import cn.smarthse.wqyy.entity.wqyy.WqyySchedule;
import cn.smarthse.wqyy.manage.wqyy.WqyySubscribeManager;
import cn.smarthse.wqyy.model.param.appointment.ItemInfo;
import cn.smarthse.wqyy.model.param.subscribe.WqyyBusinessStatueChangeParam;
import cn.smarthse.wqyy.model.param.subscribe.WqyyConfirmParam;
import cn.smarthse.wqyy.model.param.subscribe.WqyyOrgChangeParam;
import cn.smarthse.wqyy.model.param.subscribe.WqyyScheduleSearchParam;
import cn.smarthse.wqyy.model.param.subscribe.WqyySubscribeChangeParam;
import cn.smarthse.wqyy.model.param.subscribe.WqyySubscribeSearchParam;
import cn.smarthse.wqyy.model.vo.org.WqyyOrganizationVo;
import cn.smarthse.wqyy.model.vo.subscribe.WqyyForbiddenLineVo;
import cn.smarthse.wqyy.model.vo.subscribe.WqyyScheduleDetailVo;
import cn.smarthse.wqyy.model.vo.subscribe.WqyyScheduleVo;
import cn.smarthse.wqyy.model.vo.subscribe.WqyySubscribeDataVo;
import cn.smarthse.wqyy.model.vo.subscribe.WqyySubscribeDetailDataVo;
import cn.smarthse.wqyy.provider.third.IWqyySubscribeProviderToThirdService;
import cn.smarthse.wqyy.service.wqyy.IWqyyAppointmentItemService;
import cn.smarthse.wqyy.service.wqyy.IWqyyAppointmentService;
import cn.smarthse.wqyy.service.wqyy.IWqyyOrganizationService;
import cn.smarthse.wqyy.service.wqyy.IWqyyScheduleService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboService;

@DubboService
public class WqyySubscribeProviderToThird
implements IWqyySubscribeProviderToThirdService {
    private final IWqyyAppointmentService wqyyAppointmentService;
    private final IWqyyAppointmentItemService wqyyAppointmentItemService;
    private final IWqyyOrganizationService wqyyOrganizationService;
    private final IWqyyScheduleService wqyyScheduleService;
    private final WqyySubscribeManager wqyySubscribeManager;
    private final AppointmentConverter appointmentConverter;
    private final OrganizationConverter organizationConverter;

    public JqGridData<WqyyAppointment> getSubscribeDataList(WqyySubscribeSearchParam param) {
        return this.wqyyAppointmentService.getSubscribeDataList(param);
    }

    public WqyyScheduleVo getAllCompanyListByTime(WqyyScheduleSearchParam param) {
        return this.wqyyAppointmentService.getAllCompanyListByTime(param);
    }

    public Boolean changeForbiddenLine(WqyyOrgChangeParam param) {
        return this.wqyyOrganizationService.changeForbiddenLine(param);
    }

    public Boolean changeBusinessStatueByTime(WqyyBusinessStatueChangeParam param) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(WqyyOrganization::getOrgId, (Object)param.getOrganizationId())).eq(WqyyOrganization::getIsValid, (Object)true)).select(new SFunction[]{WqyyOrganization::getId});
        WqyyOrganization wqyyOrganization = (WqyyOrganization)this.wqyyOrganizationService.getOne((Wrapper)wrapper);
        if (Objects.isNull(wqyyOrganization)) {
            return false;
        }
        param.setOrganizationId(wqyyOrganization.getId());
        return this.wqyyScheduleService.changeBusinessStatueByTime(param);
    }

    public WqyyScheduleDetailVo getSubscribeDataDetail(Long id) {
        WqyyAppointment appointment = (WqyyAppointment)this.wqyyAppointmentService.getById(id);
        WqyyScheduleDetailVo wqyyScheduleDetailVo = this.appointmentConverter.wqyyAppointment2WqyyScheduleDetailVo(appointment);
        if (wqyyScheduleDetailVo == null) {
            wqyyScheduleDetailVo = new WqyyScheduleDetailVo();
        }
        List<ItemInfo> itemInfos = this.wqyyAppointmentItemService.listByAppointmentId(id);
        wqyyScheduleDetailVo.setItems(this.appointmentConverter.itemInfo2WqyyScheduleDetailItemVo(itemInfos));
        wqyyScheduleDetailVo.setHarmItems(this.wqyyAppointmentService.getSubscribeHarmFactorVoByCid(appointment.getCid()));
        return wqyyScheduleDetailVo;
    }

    public WqyyForbiddenLineVo getForbiddenLine(Long orgId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(WqyyOrganization::getIsValid, (Object)true)).eq(WqyyOrganization::getOrgId, (Object)orgId)).select(new SFunction[]{WqyyOrganization::getForbiddenLineOfPeople, WqyyOrganization::getForbiddenLineOfVehicles, WqyyOrganization::getForbiddenLineOfEnterprises});
        return this.organizationConverter.organization2ForbiddenLineVo((WqyyOrganization)this.wqyyOrganizationService.getOne((Wrapper)wrapper));
    }

    public Boolean changeSubscribe(WqyySubscribeChangeParam param) {
        return this.wqyySubscribeManager.changeSubscribe(param);
    }

    public Boolean confirm(WqyyConfirmParam param) {
        return this.wqyySubscribeManager.confirm(param);
    }

    public WqyySubscribeDataVo getSubscribeDataByMonth(WqyyScheduleSearchParam param) {
        WqyyOrganizationVo forbiddenLineInfo = this.wqyyOrganizationService.getForbiddenLineInfo(param.getOrgId());
        if (forbiddenLineInfo == null) {
            return new WqyySubscribeDataVo();
        }
        WqyySubscribeDataVo rst = new WqyySubscribeDataVo();
        param.setOrgId(forbiddenLineInfo.getId());
        List<WqyySubscribeDetailDataVo> list = this.wqyyAppointmentService.getSubscribeDataByMonth(param);
        if (CollUtil.isNotEmpty(list)) {
            List stringList = list.stream().filter(i -> i.getForbiddenLineOfPeopleTotalNum() > forbiddenLineInfo.getForbiddenLineOfPeople()).map(WqyySubscribeDetailDataVo::getChangeDate).collect(Collectors.toList());
            List stringList2 = list.stream().filter(i -> i.getForbiddenLineOfEnterprisesTotalNum() > forbiddenLineInfo.getForbiddenLineOfEnterprises()).map(WqyySubscribeDetailDataVo::getChangeDate).collect(Collectors.toList());
            List stringList3 = list.stream().filter(i -> i.getForbiddenLineOfVehiclesTotalNum() > forbiddenLineInfo.getForbiddenLineOfVehicles()).map(WqyySubscribeDetailDataVo::getChangeDate).collect(Collectors.toList());
            rst.setAlertList((List)CollUtil.distinct((Collection)CollUtil.addAll((Collection)CollUtil.addAll(stringList, stringList2), stringList3)));
        }
        LambdaQueryWrapper wrapper2 = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(WqyySchedule::getIsValid, (Object)true)).eq(WqyySchedule::getOrganizationId, (Object)forbiddenLineInfo.getId())).ne(WqyySchedule::getBusinessStatus, (Object)1)).select(new SFunction[]{WqyySchedule::getScheduleDate});
        List list2 = this.wqyyScheduleService.list((Wrapper)wrapper2);
        if (CollUtil.isNotEmpty((Collection)list2)) {
            rst.setNotInOperationList(list2.stream().map(i -> DateUtil.format((Date)i.getScheduleDate(), (String)"yyyy-MM-dd")).collect(Collectors.toList()));
        }
        return rst;
    }

    public Integer getBusinessStatueByTime(WqyyScheduleSearchParam param) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(WqyyOrganization::getOrgId, (Object)param.getOrgId())).eq(WqyyOrganization::getIsValid, (Object)true)).select(new SFunction[]{WqyyOrganization::getId});
        WqyyOrganization wqyyOrganization = (WqyyOrganization)this.wqyyOrganizationService.getOne((Wrapper)wrapper);
        if (Objects.isNull(wqyyOrganization)) {
            return 1;
        }
        LambdaQueryWrapper wrapper2 = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(WqyySchedule::getOrganizationId, (Object)wqyyOrganization.getId())).eq(WqyySchedule::getIsValid, (Object)true)).eq(WqyySchedule::getScheduleDate, (Object)param.getTime());
        WqyySchedule wqyySchedule = (WqyySchedule)this.wqyyScheduleService.getOne((Wrapper)wrapper2);
        if (Objects.isNull(wqyySchedule)) {
            return 1;
        }
        return wqyySchedule.getBusinessStatus();
    }

    public Boolean basicDataIsComplete(Long loginUserThirdOrgId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(WqyyOrganization::getOrgId, (Object)loginUserThirdOrgId)).eq(WqyyOrganization::getIsValid, (Object)true);
        return this.wqyyOrganizationService.count((Wrapper)wrapper) > 0L;
    }

    @Generated
    public WqyySubscribeProviderToThird(IWqyyAppointmentService wqyyAppointmentService, IWqyyAppointmentItemService wqyyAppointmentItemService, IWqyyOrganizationService wqyyOrganizationService, IWqyyScheduleService wqyyScheduleService, WqyySubscribeManager wqyySubscribeManager, AppointmentConverter appointmentConverter, OrganizationConverter organizationConverter) {
        this.wqyyAppointmentService = wqyyAppointmentService;
        this.wqyyAppointmentItemService = wqyyAppointmentItemService;
        this.wqyyOrganizationService = wqyyOrganizationService;
        this.wqyyScheduleService = wqyyScheduleService;
        this.wqyySubscribeManager = wqyySubscribeManager;
        this.appointmentConverter = appointmentConverter;
        this.organizationConverter = organizationConverter;
    }
}

