/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.wqyy.provider.third;

import cn.smarthse.common.util.valid.RegexUtils;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrgInfo;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrgInfoDic;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrganization;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.wqyy.entity.wqyy.WqyyOrganization;
import cn.smarthse.wqyy.entity.wqyy.WqyyOrganizationAudit;
import cn.smarthse.wqyy.entity.wqyy.WqyyOrganizationCheckType;
import cn.smarthse.wqyy.entity.wqyy.WqyyOrganizationContact;
import cn.smarthse.wqyy.enums.WqyySourceEnum;
import cn.smarthse.wqyy.enums.WqyyStatusEnum;
import cn.smarthse.wqyy.model.param.org.WqyyOrganizationCheckTypeParam;
import cn.smarthse.wqyy.model.param.org.WqyyOrganizationContactParam;
import cn.smarthse.wqyy.model.param.org.WqyyOrganizationParam;
import cn.smarthse.wqyy.model.vo.org.WqyyOrganizationCheckTypeVo;
import cn.smarthse.wqyy.model.vo.org.WqyyOrganizationContactVo;
import cn.smarthse.wqyy.model.vo.org.WqyyOrganizationVo;
import cn.smarthse.wqyy.provider.supervise.IWqyyOrganizationProviderToSuperviseService;
import cn.smarthse.wqyy.provider.third.IWqyyOrganizationProviderToThirdService;
import cn.smarthse.wqyy.service.wqyy.IWqyyOrganizationAuditService;
import cn.smarthse.wqyy.service.wqyy.IWqyyOrganizationCheckTypeService;
import cn.smarthse.wqyy.service.wqyy.IWqyyOrganizationContactService;
import cn.smarthse.wqyy.service.wqyy.IWqyyOrganizationService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.smarthse.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@DubboService
@Transactional(readOnly=true)
public class WqyyOrganizationProviderToThird
implements IWqyyOrganizationProviderToThirdService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WqyyOrganizationProviderToThird.class);
    private static Map<Long, Integer> dicMap = new HashMap<Long, Integer>();
    private final IWqyyOrganizationService organizationService;
    private final IWqyyOrganizationContactService contactService;
    private final IWqyyOrganizationAuditService organizationAuditService;
    private final IWqyyOrganizationCheckTypeService checkTypeService;
    private final IWqyyOrganizationProviderToSuperviseService organizationServiceToSupervise;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService areaService;
    @Autowired
    private DataSourceTransactionManager txManager;

    @Transactional
    public WqyyOrganizationVo queryOrganizationData(Long currentLoginOrgId, Long currentUserId, boolean fillAgain) {
        WqyyOrganizationVo returnVo;
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(WqyyOrganization::getOrgId, (Object)currentLoginOrgId)).eq(WqyyOrganization::getIsValid, (Object)true);
        WqyyOrganization primary = (WqyyOrganization)this.organizationService.getOne((Wrapper)wrapper);
        if (primary == null) {
            return this.afterFillDefaultInfo(currentLoginOrgId, currentUserId);
        }
        WqyyOrganizationParam orgParam = new WqyyOrganizationParam().setSource(WqyySourceEnum.Organization.getSource()).setId(primary.getId());
        if (!fillAgain) {
            orgParam.setIsQueryPrimary(Boolean.valueOf(false));
        }
        if ((returnVo = this.organizationService.queryOrganizationDataById(orgParam)) == null || returnVo.getId() == null) {
            orgParam.setIsQueryPrimary(Boolean.valueOf(true));
            returnVo = this.organizationService.queryOrganizationDataById(orgParam);
        }
        if (returnVo != null && returnVo.getId() != null) {
            this.checkTypeLatestData(currentLoginOrgId, currentUserId, returnVo);
        }
        if (returnVo != null) {
            this.processIsFirstAudit(returnVo);
            this.processAuditStatus(returnVo, fillAgain);
            this.processContactInfo(returnVo);
        }
        return returnVo;
    }

    private void checkTypeLatestData(Long currentLoginOrgId, Long currentUserId, WqyyOrganizationVo returnVo) {
        List<ThirdOrgInfoDic> thirdOrgCheckTypeList = this.organizationService.queryThirdOrganizationCheckTypeListData(currentLoginOrgId);
        ArrayList<WqyyOrganizationCheckType> relevanceOrgCheckTypeList = new ArrayList<WqyyOrganizationCheckType>();
        for (ThirdOrgInfoDic infoDic : thirdOrgCheckTypeList) {
            Integer checkType = dicMap.get(infoDic.getId());
            WqyyOrganizationCheckType checkTypeBean = new WqyyOrganizationCheckType();
            checkTypeBean.setId(Long.valueOf(IdWorker.getId()));
            checkTypeBean.setCheckType(checkType);
            checkTypeBean.setOrganizationId(returnVo.getId());
            checkTypeBean.setCreateBy(String.valueOf(currentUserId));
            checkTypeBean.setUpdatedBy(String.valueOf(currentUserId));
            relevanceOrgCheckTypeList.add(checkTypeBean);
        }
        ArrayList checkTypeVos = new ArrayList();
        List<WqyyOrganizationCheckTypeVo> checkTypeZd = this.organizationService.queryCheckTypeList();
        relevanceOrgCheckTypeList.forEach(relevanceOrgCheckType -> {
            WqyyOrganizationCheckTypeVo checkTypeVo = new WqyyOrganizationCheckTypeVo();
            BeanUtils.copyProperties((Object)relevanceOrgCheckType, (Object)checkTypeVo);
            String checkTypeName = checkTypeZd.stream().filter(zd -> Objects.equals(zd.getCheckType(), checkTypeVo.getCheckType())).findFirst().orElse(new WqyyOrganizationCheckTypeVo()).getCheckTypeName();
            checkTypeVo.setCheckTypeName(checkTypeName);
            checkTypeVos.add(checkTypeVo);
        });
        returnVo.setCheckTypeList(checkTypeVos);
    }

    private void processAuditStatus(WqyyOrganizationVo returnVo, boolean fillAgain) {
        if (!fillAgain) {
            WqyyOrganizationParam param = new WqyyOrganizationParam();
            param.setOrgId(returnVo.getOrgId());
            WqyyOrganizationVo latest = this.organizationService.queryOrganizationDataById(param);
            returnVo.setAuditStatus(latest.getAuditStatus());
            boolean isFirstAudit = returnVo.getIsFirstAudit();
            if (isFirstAudit) {
                returnVo.setAuditStatus(latest.getAuditStatus());
                returnVo.setOrgListImg(latest.getOrgListImg());
                returnVo.setOrgListImgName(latest.getOrgListImgName());
                returnVo.setOrgListImgOssUrl(latest.getOrgListImgOssUrl());
                returnVo.setOrgDetailImg(latest.getOrgDetailImg());
                returnVo.setOrgDetailImgOssUrls(latest.getOrgDetailImgOssUrls());
                returnVo.setOrgDetailImgBeanList(latest.getOrgDetailImgBeanList());
                returnVo.setOrganizationIntro(latest.getOrganizationIntro());
            }
        }
    }

    private void processIsFirstAudit(WqyyOrganizationVo returnVo) {
        LambdaQueryWrapper auditWrapper = Wrappers.lambdaQuery();
        auditWrapper.eq(WqyyOrganizationAudit::getOrgId, (Object)returnVo.getOrgId());
        WqyyOrganizationAudit auditVo = (WqyyOrganizationAudit)this.organizationAuditService.getOne((Wrapper)auditWrapper);
        returnVo.setIsFirstAudit(Boolean.valueOf(auditVo == null || auditVo.getAuditStatus() != 4));
    }

    private void processContactInfo(WqyyOrganizationVo organizationData) {
        WqyyOrganizationContactVo masterContact;
        List<Object> contactList = organizationData.getContactList();
        if (contactList != null && !contactList.isEmpty() && (masterContact = (WqyyOrganizationContactVo)contactList.stream().filter(WqyyOrganizationContactVo::getIsMaster).findFirst().orElse(null)) != null) {
            organizationData.setMasterContact(masterContact);
            contactList = contactList.stream().filter(c -> c.getIsMaster() == false).collect(Collectors.toList());
            organizationData.setContactList(contactList);
            if (!organizationData.getContactList().isEmpty()) {
                contactList = this.contactService.getConcatAreaListByOrgId(organizationData.getId());
                organizationData.setContactList(contactList);
            }
        }
    }

    private WqyyOrganizationVo afterFillDefaultInfo(Long currentLoginOrgId, Long currentUserId) {
        ThirdOrganization thirdOrganization = this.organizationService.queryThirdOrganizationData(currentLoginOrgId);
        if (thirdOrganization != null) {
            WqyyOrganization relevanceOrg = new WqyyOrganization();
            relevanceOrg.setId(Long.valueOf(IdWorker.getId()));
            relevanceOrg.setOrgId(thirdOrganization.getId());
            relevanceOrg.setUscc(thirdOrganization.getCreditCode());
            relevanceOrg.setOrganizationName(thirdOrganization.getName());
            relevanceOrg.setAreaId(thirdOrganization.getAreaId());
            relevanceOrg.setOrganizationAddress(thirdOrganization.getAddress());
            relevanceOrg.setIsMaster(Boolean.valueOf(true));
            relevanceOrg.setOutCheck(thirdOrganization.getCanOutCheck());
            relevanceOrg.setAuditStatus(Byte.valueOf((byte)1));
            relevanceOrg.setCreateBy(String.valueOf(currentUserId));
            relevanceOrg.setUpdatedBy(String.valueOf(currentUserId));
            relevanceOrg.setIsValid(Boolean.valueOf(true));
            List<ThirdOrgInfoDic> thirdOrgCheckTypeList = this.organizationService.queryThirdOrganizationCheckTypeListData(currentLoginOrgId);
            ArrayList<WqyyOrganizationCheckType> relevanceOrgCheckTypeList = new ArrayList<WqyyOrganizationCheckType>();
            for (ThirdOrgInfoDic infoDic : thirdOrgCheckTypeList) {
                Integer checkType = dicMap.get(infoDic.getId());
                WqyyOrganizationCheckType checkTypeBean = new WqyyOrganizationCheckType();
                checkTypeBean.setId(Long.valueOf(IdWorker.getId()));
                checkTypeBean.setCheckType(checkType);
                checkTypeBean.setOrganizationId(relevanceOrg.getId());
                checkTypeBean.setCreateBy(String.valueOf(currentUserId));
                checkTypeBean.setUpdatedBy(String.valueOf(currentUserId));
                relevanceOrgCheckTypeList.add(checkTypeBean);
            }
            WqyyOrganizationAudit audit = new WqyyOrganizationAudit();
            BeanUtils.copyProperties((Object)relevanceOrg, (Object)audit);
            this.organizationService.save(relevanceOrg);
            this.organizationAuditService.save(audit);
            this.checkTypeService.saveBatch(relevanceOrgCheckTypeList);
            WqyyOrganizationVo organizationVo = new WqyyOrganizationVo();
            BeanUtils.copyProperties((Object)relevanceOrg, (Object)organizationVo);
            ArrayList checkTypeVos = new ArrayList();
            List<WqyyOrganizationCheckTypeVo> checkTypeZd = this.organizationService.queryCheckTypeList();
            relevanceOrgCheckTypeList.forEach(relevanceOrgCheckType -> {
                WqyyOrganizationCheckTypeVo checkTypeVo = new WqyyOrganizationCheckTypeVo();
                BeanUtils.copyProperties((Object)relevanceOrgCheckType, (Object)checkTypeVo);
                String checkTypeName = checkTypeZd.stream().filter(zd -> Objects.equals(zd.getCheckType(), checkTypeVo.getCheckType())).findFirst().orElse(new WqyyOrganizationCheckTypeVo()).getCheckTypeName();
                checkTypeVo.setCheckTypeName(checkTypeName);
                checkTypeVos.add(checkTypeVo);
            });
            organizationVo.setCheckTypeList(checkTypeVos);
            return organizationVo;
        }
        return null;
    }

    private boolean isFirstAuditReject(Long orgId) {
        return false;
    }

    @Transactional
    public Object insertOrUpdateOrganizationData(WqyyOrganizationParam organizationParam) throws ServiceException {
        String phone;
        boolean validate;
        if (organizationParam != null && organizationParam.getMasterContact() != null && !(validate = RegexUtils.isValidatePhoneNumber((String)(phone = organizationParam.getMasterContact().getPhone())))) {
            throw new ServiceException("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u53f7\u7801\uff01");
        }
        this.editThirdOrgInfo(organizationParam);
        return this.organizationService.insertOrUpdateOrganizationData(organizationParam);
    }

    private void editThirdOrgInfo(WqyyOrganizationParam organizationParam) {
        ThirdOrganization thirdOrg = this.organizationService.queryThirdOrganizationData(organizationParam.getCurrentLoginOrgId());
        Long paramAreaId = organizationParam.getAreaId();
        if (paramAreaId == null) {
            paramAreaId = thirdOrg.getAreaId();
        }
        AreaModel area = this.areaService.getAreaById(paramAreaId);
        thirdOrg.setProvinceId(area.getProvinceId());
        thirdOrg.setProvinceName(area.getProvinceName());
        thirdOrg.setAreaId(paramAreaId > area.getAreaId() ? paramAreaId : area.getAreaId());
        thirdOrg.setAreaName(paramAreaId > area.getAreaId() ? area.getName() : area.getAreaName());
        thirdOrg.setAddress(organizationParam.getOrganizationAddress());
        thirdOrg.setCanOutCheck(organizationParam.getOutCheck());
        thirdOrg.setUpdateBy(organizationParam.getCurrentLoginUserId());
        List<ThirdOrgInfo> dbInfos = this.organizationService.queryThirdOrgInfoListData(organizationParam.getCurrentLoginOrgId());
        List paramInfos = organizationParam.getCheckTypeList();
        if (paramInfos == null) {
            List<Long> ids = dbInfos.stream().map(ThirdOrgInfo::getId).collect(Collectors.toList());
            if (!ids.isEmpty()) {
                this.organizationService.deleteThirdOrgInfoByPrimaryKeys(ids);
            }
        } else {
            List<Long> needDel = dbInfos.stream().filter(db -> paramInfos.stream().noneMatch(param -> Objects.equals(param.getCheckType(), dicMap.get(db.getInfoDicId())))).map(ThirdOrgInfo::getId).collect(Collectors.toList());
            if (!needDel.isEmpty()) {
                this.organizationService.deleteThirdOrgInfoByPrimaryKeys(needDel);
            }
            List needAdd = paramInfos.stream().filter(param -> dbInfos.stream().noneMatch(db -> Objects.equals(dicMap.get(db.getInfoDicId()), param.getCheckType()))).collect(Collectors.toList());
            ArrayList<ThirdOrgInfo> addThirdOrgInfoList = new ArrayList<ThirdOrgInfo>();
            for (WqyyOrganizationCheckTypeParam add : needAdd) {
                ThirdOrgInfo orgInfo = new ThirdOrgInfo();
                orgInfo.setId(Long.valueOf(IdWorker.getId()));
                orgInfo.setOrgId(organizationParam.getCurrentLoginOrgId());
                for (Map.Entry<Long, Integer> entry : dicMap.entrySet()) {
                    if (!Objects.equals(add.getCheckType(), entry.getValue())) continue;
                    orgInfo.setInfoDicId(entry.getKey());
                }
                addThirdOrgInfoList.add(orgInfo);
            }
            this.organizationService.addThirdOrgInfo(addThirdOrgInfoList);
        }
        this.organizationService.updateThirdOrgInfoByPrimaryKey(thirdOrg);
    }

    @Transactional
    public Long editDetailAuditOrgData(WqyyOrganizationParam organizationParam) throws ServiceException {
        Long pkId = this.organizationService.editDetailAuditOrgData(organizationParam);
        this.organizationServiceToSupervise.changeOrgState(organizationParam.getId(), WqyyStatusEnum.DSH.getCode(), null, organizationParam.getCurrentLoginOrgId(), organizationParam.getCurrentLoginOrgName());
        return pkId;
    }

    public void deleteContactInfo(Long concatId, Long loginUserId) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
        try {
            this.organizationService.deleteContactInfo(concatId, loginUserId);
            this.txManager.commit(status);
        }
        catch (Exception e) {
            this.txManager.rollback(status);
            e.printStackTrace();
        }
    }

    public List<Object> queryOperateRecord(Long organizationId) {
        return this.organizationService.queryOperateRecord(organizationId);
    }

    public List<Map<String, String>> queryCheckTypeList() {
        List<WqyyOrganizationCheckTypeVo> checkTypeList = this.organizationService.queryCheckTypeList();
        if (checkTypeList == null) {
            return Collections.emptyList();
        }
        return checkTypeList.stream().map(v -> new HashMap<String, String>(){
            {
                this.put(v.getCheckTypeName(), v.getCheckType().toString());
            }
        }).collect(Collectors.toList());
    }

    @Transactional
    public WqyyOrganizationContactVo manageContactInfo(WqyyOrganizationContactParam concatParam) {
        long contactId;
        String phone;
        boolean validate;
        if (concatParam != null && !(validate = RegexUtils.isValidatePhoneNumber((String)(phone = concatParam.getPhone())))) {
            throw new ServiceException("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u53f7\u7801\uff01");
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(WqyyOrganization::getOrgId, (Object)concatParam.getCurrentLoginOrgId())).eq(WqyyOrganization::getIsValid, (Object)true);
        WqyyOrganization org = (WqyyOrganization)this.organizationService.getOne((Wrapper)wrapper);
        if (org == null) {
            throw new ServiceException("\u673a\u6784\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        List areaIdList = concatParam.getAreaIdList();
        if (areaIdList == null || areaIdList.isEmpty()) {
            throw new ServiceException("\u8bf7\u4f20\u5165\u8054\u7cfb\u4eba\u8d1f\u8d23\u533a\u57df\u4fe1\u606f\uff01");
        }
        ArrayList<WqyyOrganizationContact> contactList = new ArrayList<WqyyOrganizationContact>();
        if (concatParam.getContactId() == null) {
            contactId = IdWorker.getId();
            for (Long areaId : areaIdList) {
                WqyyOrganizationContact addContact = new WqyyOrganizationContact();
                addContact.setId(Long.valueOf(IdWorker.getId()));
                addContact.setOrganizationId(org.getId());
                addContact.setIsMaster(concatParam.getIsMaster());
                addContact.setContactId(Long.valueOf(contactId));
                addContact.setContact(concatParam.getContact());
                addContact.setPhone(concatParam.getPhone());
                addContact.setAreaId(areaId);
                addContact.setCreateBy(String.valueOf(concatParam.getCurrentLoginUserId()));
                addContact.setUpdatedBy(String.valueOf(concatParam.getCurrentLoginUserId()));
                contactList.add(addContact);
            }
            this.contactService.saveBatch(contactList);
        } else {
            contactId = concatParam.getContactId();
            LambdaQueryWrapper contactWrapper = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)contactWrapper.eq(WqyyOrganizationContact::getOrganizationId, (Object)org.getId())).eq(WqyyOrganizationContact::getContact, (Object)concatParam.getContact())).eq(WqyyOrganizationContact::getPhone, (Object)concatParam.getPhone());
            this.contactService.deleteContactInfoByContactIdHard(contactId);
            for (Long areaId : areaIdList) {
                WqyyOrganizationContact addContact = new WqyyOrganizationContact();
                addContact.setId(Long.valueOf(IdWorker.getId()));
                addContact.setOrganizationId(org.getId());
                addContact.setIsMaster(concatParam.getIsMaster());
                addContact.setContactId(Long.valueOf(contactId));
                addContact.setContact(concatParam.getContact());
                addContact.setPhone(concatParam.getPhone());
                addContact.setAreaId(areaId);
                addContact.setCreateBy(String.valueOf(concatParam.getCurrentLoginUserId()));
                addContact.setUpdatedBy(String.valueOf(concatParam.getCurrentLoginUserId()));
                contactList.add(addContact);
            }
            this.contactService.saveBatch(contactList);
        }
        return this.contactService.getConcatAreaInfoByContactId(contactId);
    }

    public WqyyOrganizationContactVo queryContactInfo(Long contactPk) {
        WqyyOrganizationContact contact = (WqyyOrganizationContact)this.contactService.getById(contactPk);
        if (contact == null) {
            return null;
        }
        WqyyOrganizationContactVo contactVo = new WqyyOrganizationContactVo();
        BeanUtils.copyProperties((Object)contact, (Object)contactVo);
        return contactVo;
    }

    public List<WqyyOrganizationContact> queryDbConcatListByContactPk(Long contactPk, Long loginUserThirdOrgId) {
        LambdaQueryWrapper orgWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)orgWrapper.eq(WqyyOrganization::getOrgId, (Object)loginUserThirdOrgId)).eq(WqyyOrganization::getIsValid, (Object)true);
        WqyyOrganization org = (WqyyOrganization)this.organizationService.getOne((Wrapper)orgWrapper);
        if (org == null) {
            return Collections.emptyList();
        }
        WqyyOrganizationContactVo contactVo = this.queryContactInfo(contactPk);
        if (contactVo == null) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper contactWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)contactWrapper.eq(WqyyOrganizationContact::getOrganizationId, (Object)org.getId())).eq(WqyyOrganizationContact::getContact, (Object)contactVo.getContact())).eq(WqyyOrganizationContact::getPhone, (Object)contactVo.getPhone());
        return this.contactService.list((Wrapper)contactWrapper);
    }

    public WqyyOrganizationContactVo queryDbConcatListByContactId(Long contactId, Long loginUserThirdOrgId) {
        return this.contactService.getConcatAreaInfoByContactId(contactId);
    }

    public void deleteContactInfoByContactIdHard(Long concatId) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
        try {
            this.contactService.deleteContactInfoByContactIdHard(concatId);
            this.txManager.commit(status);
        }
        catch (Exception e) {
            this.txManager.rollback(status);
            e.printStackTrace();
        }
    }

    @Generated
    public WqyyOrganizationProviderToThird(IWqyyOrganizationService organizationService, IWqyyOrganizationContactService contactService, IWqyyOrganizationAuditService organizationAuditService, IWqyyOrganizationCheckTypeService checkTypeService, IWqyyOrganizationProviderToSuperviseService organizationServiceToSupervise) {
        this.organizationService = organizationService;
        this.contactService = contactService;
        this.organizationAuditService = organizationAuditService;
        this.checkTypeService = checkTypeService;
        this.organizationServiceToSupervise = organizationServiceToSupervise;
    }

    static {
        dicMap.put(98356945135650518L, 2);
        dicMap.put(98356945135650519L, 1);
        dicMap.put(98356945135650520L, 5);
        dicMap.put(98356945135650521L, 6);
        dicMap.put(98356945135650522L, 4);
        dicMap.put(98356945135650523L, 3);
    }
}

