/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.wqyy.provider.supervise;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.sys.utils.HolidayUtils;
import cn.smarthse.snowflake.IdWorker;
import cn.smarthse.wqyy.entity.wqyy.WqyyOrganization;
import cn.smarthse.wqyy.entity.wqyy.WqyyOrganizationAudit;
import cn.smarthse.wqyy.entity.wqyy.WqyyWorkOperateLog;
import cn.smarthse.wqyy.enums.WqyyLogWorkModeEnum;
import cn.smarthse.wqyy.enums.WqyyStatusEnum;
import cn.smarthse.wqyy.model.param.activation.WqyyActivationSearchParam;
import cn.smarthse.wqyy.model.param.org.WqyyOrganizationImportModel;
import cn.smarthse.wqyy.model.param.org.WqyyOrganizationParam;
import cn.smarthse.wqyy.model.vo.activation.WqyyActivationDetailVo;
import cn.smarthse.wqyy.model.vo.org.WqyyOrganizationCheckTypeVo;
import cn.smarthse.wqyy.model.vo.org.WqyyOrganizationVo;
import cn.smarthse.wqyy.provider.supervise.IWqyyActivationProviderToSuperviseService;
import cn.smarthse.wqyy.provider.supervise.IWqyyOrganizationProviderToSuperviseService;
import cn.smarthse.wqyy.service.wqyy.IWqyyOrganizationAuditService;
import cn.smarthse.wqyy.service.wqyy.IWqyyOrganizationCheckTypeService;
import cn.smarthse.wqyy.service.wqyy.IWqyyOrganizationContactService;
import cn.smarthse.wqyy.service.wqyy.IWqyyOrganizationService;
import cn.smarthse.wqyy.service.wqyy.IWqyyScheduleService;
import cn.smarthse.wqyy.service.wqyy.IWqyyWorkOperateLogService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.smarthse.exception.ServiceException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.annotation.Transactional;

@DubboService
public class WqyyOrganizationProviderToSupervise
implements IWqyyOrganizationProviderToSuperviseService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WqyyOrganizationProviderToSupervise.class);
    private final IWqyyOrganizationService organizationService;
    private final IWqyyScheduleService scheduleService;
    private final IWqyyOrganizationAuditService organizationAuditService;
    private final IWqyyOrganizationContactService organizationContactService;
    private final IWqyyOrganizationCheckTypeService organizationCheckTypeService;
    private final IWqyyWorkOperateLogService operateLogService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    private final IWqyyActivationProviderToSuperviseService wqyyActivationProviderToSuperviseService;
    @Autowired
    protected IdWorker idworker;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private DataSourceTransactionManager txManager;

    public PageInfo<WqyyOrganizationVo> queryOrganizationData(JqGridParam param, WqyyOrganizationParam organizationParam) {
        WqyyActivationSearchParam actParam = new WqyyActivationSearchParam();
        actParam.setPage(1);
        actParam.setRows(Integer.MAX_VALUE);
        actParam.setSearchAreaId(organizationParam.getAreaId());
        Optional.ofNullable(actParam.getSearchAreaId()).map(arg_0 -> ((ISysAreaProvideService)this.sysAreaProvideService).getAreaById(arg_0)).ifPresent(area -> actParam.setSearchAreaLevel(area.getLevel()));
        JqGridData detailData = this.wqyyActivationProviderToSuperviseService.getDetailData(actParam);
        List actDetailList = detailData.getRows();
        if (actDetailList != null && !actDetailList.isEmpty()) {
            LocalDateTime now = LocalDateTime.now();
            ArrayList notLog3IdList = new ArrayList();
            actDetailList.forEach(vo -> {
                if (vo.getUpdateDate() != null) {
                    LocalDateTime lastLoginDate = vo.getUpdateDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
                    int workCountdown = 3;
                    while (workCountdown > 0) {
                        DayOfWeek dayOfWeek = (lastLoginDate = lastLoginDate.plusDays(1L)).getDayOfWeek();
                        if (dayOfWeek != DayOfWeek.SATURDAY && dayOfWeek != DayOfWeek.SUNDAY && !HolidayUtils.holidayList.contains((Object)lastLoginDate.toLocalDate())) {
                            --workCountdown;
                        }
                        if (dayOfWeek != DayOfWeek.SATURDAY && dayOfWeek != DayOfWeek.SUNDAY || !HolidayUtils.supplementaryShiftList.contains((Object)lastLoginDate.toLocalDate())) continue;
                        --workCountdown;
                    }
                    if (lastLoginDate.isBefore(now)) {
                        notLog3IdList.add(vo.getOrgId());
                    }
                }
            });
            List accessIdList = actDetailList.stream().filter(a -> a != null && a.getOrgId() != null && Objects.equals(a.getIsAccess(), 1)).map(WqyyActivationDetailVo::getOrgId).collect(Collectors.toList());
            organizationParam.setAccessIdList(accessIdList);
            organizationParam.setNotLog3IdList(notLog3IdList);
        }
        return this.organizationService.queryOrganizationData(param, organizationParam);
    }

    public PageInfo<WqyyOrganizationVo> getPageOrgAuditBySearchModel(JqGridParam param, WqyyOrganizationParam orgParam) {
        return this.organizationService.getPageOrgAuditBySearchModel(param, orgParam);
    }

    public WqyyOrganizationVo queryOrganizationDataById(WqyyOrganizationParam orgParam) {
        WqyyActivationSearchParam actParam = new WqyyActivationSearchParam();
        actParam.setPage(1);
        actParam.setRows(Integer.MAX_VALUE);
        actParam.setSearchAreaId(orgParam.getAreaId());
        Optional.ofNullable(actParam.getSearchAreaId()).map(arg_0 -> ((ISysAreaProvideService)this.sysAreaProvideService).getAreaById(arg_0)).ifPresent(area -> actParam.setSearchAreaLevel(area.getLevel()));
        JqGridData detailData = this.wqyyActivationProviderToSuperviseService.getDetailData(actParam);
        List actDetailList = detailData.getRows();
        if (actDetailList != null && !actDetailList.isEmpty()) {
            LocalDateTime now = LocalDateTime.now();
            ArrayList notLog3IdList = new ArrayList();
            actDetailList.forEach(vo -> {
                if (vo.getUpdateDate() != null) {
                    LocalDateTime lastLoginDate = vo.getUpdateDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
                    int workCountdown = 3;
                    while (workCountdown > 0) {
                        DayOfWeek dayOfWeek = (lastLoginDate = lastLoginDate.plusDays(1L)).getDayOfWeek();
                        if (dayOfWeek != DayOfWeek.SATURDAY && dayOfWeek != DayOfWeek.SUNDAY && !HolidayUtils.holidayList.contains((Object)lastLoginDate.toLocalDate())) {
                            --workCountdown;
                        }
                        if (dayOfWeek != DayOfWeek.SATURDAY && dayOfWeek != DayOfWeek.SUNDAY || !HolidayUtils.supplementaryShiftList.contains((Object)lastLoginDate.toLocalDate())) continue;
                        --workCountdown;
                    }
                    if (lastLoginDate.isBefore(now)) {
                        notLog3IdList.add(vo.getOrgId());
                    }
                }
            });
            List accessIdList = actDetailList.stream().filter(a -> a != null && a.getOrgId() != null && Objects.equals(a.getIsAccess(), 1)).map(WqyyActivationDetailVo::getOrgId).collect(Collectors.toList());
            orgParam.setAccessIdList(accessIdList);
            orgParam.setNotLog3IdList(notLog3IdList);
        }
        return this.organizationService.queryOrganizationDataById(orgParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public String changeOrgState(Long orgId, Integer status, String reason, Long loginStaffId, String operater) {
        if (orgId == null || status == null) {
            return "\u53c2\u6570\u9519\u8bef";
        }
        WqyyOrganization organization = (WqyyOrganization)this.organizationService.getById(orgId);
        if (organization == null) {
            return "\u65e0\u6570\u636e";
        }
        if (organization.getAuditStatus() == null) {
            return "\u72b6\u6001\u5f02\u5e38";
        }
        if (organization.getAuditStatus().intValue() == status.intValue()) {
            return "\u91cd\u590d\u64cd\u4f5c";
        }
        RLock lock = this.redissonClient.getLock("wqyyOrganization:changeOrgState:" + orgId + "status" + status);
        if (lock.tryLock()) {
            try {
                String string = this.changeOrgStateDetail(organization, reason, loginStaffId, operater, status);
                return string;
            }
            finally {
                lock.unlock();
            }
        }
        log.error("wqyyOrganization:changeOrgState: id:{},\u72b6\u6001\uff1a{}", (Object)orgId, (Object)status);
        return "\u91cd\u590d\u64cd\u4f5c\u3002";
    }

    public String changeOrgStateDetail(WqyyOrganization wqyyOrganization, String reason, Long loginStaffId, String operater, Integer status) {
        boolean flag;
        Date curTime = new Date();
        boolean isXiaJia = wqyyOrganization.getIsShelves().equals(0);
        LambdaUpdateChainWrapper updateChainWrapper = (LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.organizationService.lambdaUpdate().eq(WqyyOrganization::getIsValid, (Object)true)).eq(WqyyOrganization::getId, (Object)wqyyOrganization.getId())).ne(WqyyOrganization::getAuditStatus, (Object)status)).set(WqyyOrganization::getAuditStatus, (Object)status.byteValue())).set(WqyyOrganization::getUpdateDate, (Object)curTime)).set(WqyyOrganization::getUpdatedBy, (Object)loginStaffId);
        if (WqyyStatusEnum.DSH.getCode().equals(status)) {
            updateChainWrapper.set(WqyyOrganization::getOperateCommitTime, (Object)curTime);
        }
        if (WqyyStatusEnum.YSH.getCode().equals(status)) {
            updateChainWrapper.set(WqyyOrganization::getIsShelves, (Object)1);
        }
        if (!(flag = updateChainWrapper.update())) {
            return "\u4fee\u6539\u5931\u8d25";
        }
        WqyyWorkOperateLog log = new WqyyWorkOperateLog();
        log.setWorkModule(WqyyLogWorkModeEnum.ZLSH.getCode());
        log.setWorkId(wqyyOrganization.getId());
        log.setReason(reason);
        log.setOperater(operater);
        log.setUpdateBy(loginStaffId);
        log.setCreateBy(loginStaffId);
        log.setUpdateDate(curTime);
        log.setCreateDate(curTime);
        log.setWorkStatus(status);
        this.operateLogService.save(log);
        if (WqyyStatusEnum.YSH.getCode().equals(status)) {
            WqyyOrganization organization = (WqyyOrganization)this.organizationService.getById(wqyyOrganization.getId());
            WqyyOrganizationAudit organizationAudit = new WqyyOrganizationAudit();
            BeanUtils.copyProperties((Object)organization, (Object)organizationAudit);
            this.organizationAuditService.updateById(organizationAudit);
            if (isXiaJia) {
                WqyyWorkOperateLog operateLog = new WqyyWorkOperateLog();
                operateLog.setWorkModule(WqyyLogWorkModeEnum.SJXJ.getCode());
                operateLog.setWorkId(wqyyOrganization.getId());
                operateLog.setReason("\u673a\u6784\u8d44\u6599\u5ba1\u6838\u901a\u8fc7");
                operateLog.setOperater(operater);
                operateLog.setUpdateBy(loginStaffId);
                operateLog.setCreateBy(loginStaffId);
                operateLog.setUpdateDate(curTime);
                operateLog.setCreateDate(curTime);
                operateLog.setWorkStatus(Integer.valueOf(1));
                this.operateLogService.save(operateLog);
            }
        }
        return "\u4fee\u6539\u6210\u529f";
    }

    public List<WqyyOrganizationCheckTypeVo> queryCheckTypeList() {
        List<WqyyOrganizationCheckTypeVo> checkTypeList = this.organizationService.queryCheckTypeList();
        return checkTypeList;
    }

    public int addOrgScoreInfoFromExcel(List<WqyyOrganizationImportModel> list, Long loginUserId) {
        List usccList = list.stream().map(WqyyOrganizationImportModel::getUscc).collect(Collectors.toList());
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)wrapper.in((Object)"uscc", usccList)).eq((Object)"is_valid", (Object)true);
        List orgList = this.organizationService.list((Wrapper)wrapper);
        Map<String, BigDecimal> usccScoreMap = list.stream().collect(Collectors.toMap(WqyyOrganizationImportModel::getUscc, WqyyOrganizationImportModel::getOrganizationScore));
        orgList.forEach(org -> org.setOrganizationScore((BigDecimal)usccScoreMap.get(org.getUscc())));
        this.organizationService.updateBatchById(orgList);
        List orgAuditList = orgList.stream().map(o -> {
            WqyyOrganizationAudit audit = new WqyyOrganizationAudit();
            audit.setId(o.getId());
            audit.setOrganizationScore(o.getOrganizationScore());
            return audit;
        }).collect(Collectors.toList());
        this.organizationAuditService.updateBatchById(orgAuditList);
        return list.size();
    }

    public WqyyOrganization getWqyyOrgInfoByName(String organizationName) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(WqyyOrganization::getOrganizationName, (Object)organizationName);
        return (WqyyOrganization)this.organizationService.getOne((Wrapper)wrapper);
    }

    public boolean checkOrgUsccIsExist(String creditCode) {
        if (StringUtils.isBlank((CharSequence)creditCode)) {
            return false;
        }
        return this.organizationService.checkOrgUsccIsExist(creditCode);
    }

    @Transactional
    public Integer changeOrgIsShelves(WqyyOrganizationParam param) throws ServiceException {
        Date curTime = new Date();
        boolean update1 = ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.organizationService.lambdaUpdate().eq(WqyyOrganization::getId, (Object)param.getId())).eq(WqyyOrganization::getIsValid, (Object)true)).set(WqyyOrganization::getIsShelves, (Object)param.getIsShelves())).update();
        boolean update2 = ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.organizationAuditService.lambdaUpdate().eq(WqyyOrganizationAudit::getId, (Object)param.getId())).eq(WqyyOrganizationAudit::getIsValid, (Object)true)).set(WqyyOrganizationAudit::getIsShelves, (Object)param.getIsShelves())).update();
        if (!update1 && !update2) {
            log.error("\u673a\u6784\u8bbe\u7f6e\u4e0a\u67b6\u4e0b\u67b6\u64cd\u4f5c\u5931\u8d25\uff1a\u673a\u6784id\u4e3a{}", (Object)param.getId());
            throw new ServiceException("\u673a\u6784\u8bbe\u7f6e\u4e0a\u67b6\u4e0b\u67b6\u64cd\u4f5c\u5931\u8d25\uff1a\u673a\u6784id\u4e3a" + param.getId());
        }
        WqyyWorkOperateLog operateLog = new WqyyWorkOperateLog();
        operateLog.setWorkModule(WqyyLogWorkModeEnum.SJXJ.getCode());
        operateLog.setWorkId(param.getId());
        operateLog.setReason(param.getReason());
        operateLog.setOperater(param.getCreateBy());
        operateLog.setUpdateBy(Long.valueOf(param.getUpdatedBy()));
        operateLog.setCreateBy(Long.valueOf(param.getUpdatedBy()));
        operateLog.setUpdateDate(curTime);
        operateLog.setCreateDate(curTime);
        operateLog.setWorkStatus(param.getIsShelves());
        this.operateLogService.save(operateLog);
        return 1;
    }

    @Generated
    public WqyyOrganizationProviderToSupervise(IWqyyOrganizationService organizationService, IWqyyScheduleService scheduleService, IWqyyOrganizationAuditService organizationAuditService, IWqyyOrganizationContactService organizationContactService, IWqyyOrganizationCheckTypeService organizationCheckTypeService, IWqyyWorkOperateLogService operateLogService, IWqyyActivationProviderToSuperviseService wqyyActivationProviderToSuperviseService) {
        this.organizationService = organizationService;
        this.scheduleService = scheduleService;
        this.organizationAuditService = organizationAuditService;
        this.organizationContactService = organizationContactService;
        this.organizationCheckTypeService = organizationCheckTypeService;
        this.operateLogService = operateLogService;
        this.wqyyActivationProviderToSuperviseService = wqyyActivationProviderToSuperviseService;
    }
}

