/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.wqyy.provider.supervise;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.sys.utils.HolidayUtils;
import cn.smarthse.wqyy.model.param.activation.WqyyActivationSearchParam;
import cn.smarthse.wqyy.model.param.appointment.WqyyResponsivityParam;
import cn.smarthse.wqyy.model.vo.activation.WqyyActivationDetailByIdVo;
import cn.smarthse.wqyy.model.vo.activation.WqyyActivationDetailVo;
import cn.smarthse.wqyy.model.vo.activation.WqyyActivationIndexVo;
import cn.smarthse.wqyy.model.vo.subscribe.WqyyResponsivityVo;
import cn.smarthse.wqyy.provider.supervise.IWqyyActivationProviderToSuperviseService;
import cn.smarthse.wqyy.service.wqyy.IWqyyActivationService;
import cn.smarthse.wqyy.service.wqyy.IWqyyAppointmentService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DubboService
public class WqyyActivationProviderToSupervise
implements IWqyyActivationProviderToSuperviseService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WqyyActivationProviderToSupervise.class);
    private final IWqyyActivationService wqyyActivationService;
    private final IWqyyAppointmentService wqyyAppointmentService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;

    public List<WqyyActivationIndexVo> getIndexData(WqyyActivationSearchParam param) {
        List<WqyyActivationIndexVo> indexData;
        List<WqyyActivationIndexVo> scopeList = this.wqyyActivationService.getIndexDataWithArea(param);
        if (CollUtil.isEmpty(scopeList)) {
            return Collections.emptyList();
        }
        List<Object> cityIndexData = new ArrayList();
        if ("2".equals(String.valueOf(param.getSearchAreaLevel()))) {
            List<WqyyActivationIndexVo> cityArea = this.wqyyActivationService.getCityArea(param);
            if (CollUtil.isNotEmpty(cityArea)) {
                scopeList.addAll(cityArea);
            }
            cityIndexData = this.wqyyActivationService.getCityIndexData(param);
        }
        if (CollUtil.isNotEmpty(indexData = this.wqyyActivationService.getIndexData(param))) {
            if (CollUtil.isNotEmpty(cityIndexData)) {
                indexData.addAll(cityIndexData);
            }
            Map<Long, WqyyActivationIndexVo> wqyyActivationVoMap = indexData.stream().collect(Collectors.toMap(WqyyActivationIndexVo::getAreaId, v -> v));
            for (WqyyActivationIndexVo vo : scopeList) {
                if (!wqyyActivationVoMap.containsKey(vo.getAreaId())) continue;
                WqyyActivationIndexVo wqyyActivationVo = wqyyActivationVoMap.get(vo.getAreaId());
                int totalNums = wqyyActivationVo.getTotalNums();
                param.setSearchAreaId(vo.getAreaId());
                param.setAreaName(vo.getAreaName());
                Optional.ofNullable(param.getSearchAreaId()).map(arg_0 -> ((ISysAreaProvideService)this.sysAreaProvideService).getAreaById(arg_0)).ifPresent(area -> param.setSearchAreaLevel(area.getLevel()));
                this.checkParam(param);
                Map<Long, Date> lastLoginDetailData = this.wqyyActivationService.getLastLoginDetailData(param);
                param.setAreaName(null);
                Map<Long, Date> indexDisconnectData = this.getIndexDisconnectData(lastLoginDetailData);
                int indexDisconnectDataTotal = MapUtil.isNotEmpty(indexDisconnectData) ? indexDisconnectData.size() : 0;
                vo.setTotalNums(Integer.valueOf(totalNums));
                vo.setAccessNums(Integer.valueOf(indexDisconnectDataTotal));
                vo.setNoAccessNums(Integer.valueOf(totalNums - indexDisconnectDataTotal));
                vo.setAccessRate(NumberUtil.rateProcessing1((int)indexDisconnectDataTotal, (int)totalNums));
            }
        }
        return scopeList.stream().sorted(Comparator.comparing(WqyyActivationIndexVo::getAreaId)).collect(Collectors.toList());
    }

    public WqyyActivationIndexVo getIndexDataTotal(WqyyActivationSearchParam param) {
        this.checkParam(param);
        WqyyActivationIndexVo rst = new WqyyActivationIndexVo();
        rst.setAreaId(param.getSearchAreaId());
        if (Boolean.TRUE == param.getOnlyCityLevelOrg()) {
            rst.setAreaName(param.getAreaName());
        } else {
            rst.setAreaName(this.sysAreaProvideService.getAreaById(param.getSearchAreaId()).getName());
        }
        WqyyActivationIndexVo indexData = this.wqyyActivationService.getIndexDataTotal(param);
        if (Objects.nonNull(indexData)) {
            int noHasBaseNumsTotal = indexData.getNoHasBaseNums();
            int totalNumsTotal = indexData.getTotalNums();
            Map<Long, Date> lastLoginDetailData = this.wqyyActivationService.getLastLoginDetailData(param);
            Map<Long, Date> indexDisconnectData = this.getIndexDisconnectData(lastLoginDetailData);
            int indexDisconnectDataTotal = MapUtil.isNotEmpty(indexDisconnectData) ? indexDisconnectData.size() : 0;
            rst.setTotalNums(Integer.valueOf(totalNumsTotal));
            rst.setAccessNums(Integer.valueOf(indexDisconnectDataTotal));
            rst.setNoAccessNums(Integer.valueOf(totalNumsTotal - indexDisconnectDataTotal));
            rst.setAccessRate(NumberUtil.rateProcessing1((int)indexDisconnectDataTotal, (int)totalNumsTotal));
            rst.setOfflineDurationNums(Integer.valueOf(totalNumsTotal - indexDisconnectDataTotal - noHasBaseNumsTotal));
            rst.setUpdateDate(indexData.getUpdateDate());
        }
        return rst;
    }

    public WqyyActivationIndexVo getIndexDataTotalIdStr(WqyyActivationSearchParam param) {
        return this.wqyyActivationService.getIndexDataTotalIdStr(param);
    }

    public Map<Long, Date> getIndexDisconnectData(Map<Long, Date> lastLoginDetailData) {
        if (MapUtil.isEmpty(lastLoginDetailData)) {
            return Collections.emptyMap();
        }
        LocalDateTime now = LocalDateTime.now();
        LocalDate localDateNow = LocalDate.now();
        Iterator<Map.Entry<Long, Date>> iterator = lastLoginDetailData.entrySet().iterator();
        while (iterator.hasNext()) {
            LocalDateTime entryDate = iterator.next().getValue().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            DayOfWeek dayOfWeek = entryDate.getDayOfWeek();
            if (dayOfWeek != DayOfWeek.SATURDAY && dayOfWeek != DayOfWeek.SUNDAY && HolidayUtils.holidayList.contains((Object)localDateNow) || (dayOfWeek == DayOfWeek.SATURDAY || dayOfWeek == DayOfWeek.SUNDAY) && !HolidayUtils.supplementaryShiftList.contains((Object)localDateNow)) {
                entryDate = LocalDateTime.of(entryDate.toLocalDate(), LocalTime.MAX);
            }
            int workCountdown = 3;
            while (workCountdown > 0) {
                dayOfWeek = (entryDate = entryDate.plusDays(1L)).getDayOfWeek();
                if ((dayOfWeek == DayOfWeek.SATURDAY || dayOfWeek == DayOfWeek.SUNDAY || HolidayUtils.holidayList.contains((Object)entryDate.toLocalDate())) && (dayOfWeek != DayOfWeek.SATURDAY && dayOfWeek != DayOfWeek.SUNDAY || !HolidayUtils.supplementaryShiftList.contains((Object)entryDate.toLocalDate()))) continue;
                --workCountdown;
            }
            if (!entryDate.isBefore(now)) continue;
            iterator.remove();
        }
        return lastLoginDetailData;
    }

    public JqGridData<WqyyActivationDetailVo> getDetailData(WqyyActivationSearchParam param) {
        this.checkParam(param);
        List<Object> detailData = this.wqyyActivationService.getDetailData(param);
        Map<Long, Date> lastLoginDetailData = this.wqyyActivationService.getLastLoginDetailData(param);
        Map<Long, Date> indexDisconnectData = this.getIndexDisconnectData(lastLoginDetailData);
        if (CollUtil.isEmpty(detailData)) {
            return new JqGridData();
        }
        if (MapUtil.isNotEmpty(indexDisconnectData)) {
            for (WqyyActivationDetailVo detailDatum : detailData) {
                Integer r = indexDisconnectData.containsKey(detailDatum.getOrgId()) ? Integer.valueOf(0) : (Objects.equals(detailDatum.getHasBase(), 0) ? Integer.valueOf(1) : null);
                detailDatum.setDisconnect(r);
                detailDatum.setIsAccess(Integer.valueOf(Objects.equals(r, 0) ? 1 : 0));
            }
        }
        if (Objects.nonNull(param.getDisconnect())) {
            detailData = detailData.stream().filter(i -> Objects.equals(i.getDisconnect(), param.getDisconnect())).collect(Collectors.toList());
        }
        if (Objects.nonNull(param.getIsAccess())) {
            detailData = detailData.stream().filter(i -> Objects.equals(i.getIsAccess(), param.getIsAccess())).collect(Collectors.toList());
        }
        JqGridData gridData = new JqGridData(detailData, (JqGridParam)param);
        List rows = gridData.getRows();
        LocalDateTime localDateTimeNow = LocalDateTime.now();
        LocalDate localDateNow = LocalDate.now();
        long nanosecondsInOneDay = Duration.ofDays(1L).toNanos();
        rows.forEach(i -> {
            if (Objects.nonNull(i.getUpdateDate())) {
                LocalDateTime lastLoginTime = i.getUpdateDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
                if (localDateNow.equals(lastLoginTime.toLocalDate())) {
                    DayOfWeek dayOfWeek = lastLoginTime.getDayOfWeek();
                    if (dayOfWeek != DayOfWeek.SATURDAY && dayOfWeek != DayOfWeek.SUNDAY && !HolidayUtils.holidayList.contains((Object)localDateNow) || (dayOfWeek == DayOfWeek.SATURDAY || dayOfWeek == DayOfWeek.SUNDAY) && HolidayUtils.supplementaryShiftList.contains((Object)localDateNow)) {
                        i.setOfflineDuration(Long.valueOf(ChronoUnit.NANOS.between(lastLoginTime, localDateTimeNow)));
                    }
                } else {
                    DayOfWeek dayOfWeek;
                    long totalNanos = ChronoUnit.NANOS.between(lastLoginTime, localDateTimeNow);
                    boolean flag = false;
                    while (lastLoginTime.toLocalDate().isBefore(localDateNow)) {
                        dayOfWeek = lastLoginTime.getDayOfWeek();
                        if (dayOfWeek != DayOfWeek.SATURDAY && dayOfWeek != DayOfWeek.SUNDAY && HolidayUtils.holidayList.contains((Object)lastLoginTime.toLocalDate()) || (dayOfWeek == DayOfWeek.SATURDAY || dayOfWeek == DayOfWeek.SUNDAY) && !HolidayUtils.supplementaryShiftList.contains((Object)lastLoginTime.toLocalDate())) {
                            if (flag) {
                                totalNanos -= nanosecondsInOneDay;
                            } else {
                                totalNanos -= ChronoUnit.NANOS.between(lastLoginTime, LocalDateTime.of(lastLoginTime.toLocalDate(), LocalTime.MAX));
                                flag = true;
                            }
                        } else if (!flag) {
                            flag = true;
                        }
                        lastLoginTime = lastLoginTime.plusDays(1L);
                    }
                    if (localDateNow.equals(lastLoginTime.toLocalDate()) && ((dayOfWeek = lastLoginTime.getDayOfWeek()) != DayOfWeek.SATURDAY && dayOfWeek != DayOfWeek.SUNDAY && HolidayUtils.holidayList.contains((Object)localDateNow) || (dayOfWeek == DayOfWeek.SATURDAY || dayOfWeek == DayOfWeek.SUNDAY) && !HolidayUtils.supplementaryShiftList.contains((Object)localDateNow))) {
                        totalNanos -= ChronoUnit.NANOS.between(LocalDateTime.of(localDateNow, LocalTime.MIN), localDateTimeNow);
                    }
                    i.setOfflineDuration(Long.valueOf(totalNanos));
                }
            }
        });
        gridData.setRows(rows);
        return gridData;
    }

    public JqGridData<WqyyActivationDetailByIdVo> getDetailDataById(WqyyActivationSearchParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        return new JqGridData((Page)this.wqyyActivationService.getDetailDataById(param), (JqGridParam)param);
    }

    public WqyyResponsivityVo getResponsivityData(WqyyResponsivityParam param) {
        return this.wqyyAppointmentService.getResponsivityData(param);
    }

    public JqGridData<WqyyResponsivityVo> getResponsivityListData(WqyyResponsivityParam param) {
        PageInfo<WqyyResponsivityVo> pageInfo = this.wqyyAppointmentService.getResponsivityListData(param);
        return new JqGridData(pageInfo, (JqGridParam)param);
    }

    public JqGridData<WqyyResponsivityVo> getResponsivityDetail(WqyyResponsivityParam param) {
        PageInfo<WqyyResponsivityVo> pageInfo = this.wqyyAppointmentService.getResponsivityDetail(param);
        return new JqGridData(pageInfo, (JqGridParam)param);
    }

    public List<WqyyResponsivityVo> exportResponseData(WqyyResponsivityParam param) {
        return this.wqyyAppointmentService.exportResponseData(param);
    }

    void checkParam(WqyyActivationSearchParam param) {
        if ("2".equals(String.valueOf(param.getSearchAreaLevel())) && !Objects.isNull(param.getAreaName()) && param.getAreaName().endsWith("\u672c\u7ea7")) {
            param.setOnlyCityLevelOrg(Boolean.valueOf(true));
        } else {
            param.setOnlyCityLevelOrg(Boolean.valueOf(false));
        }
    }

    @Generated
    public WqyyActivationProviderToSupervise(IWqyyActivationService wqyyActivationService, IWqyyAppointmentService wqyyAppointmentService) {
        this.wqyyActivationService = wqyyActivationService;
        this.wqyyAppointmentService = wqyyAppointmentService;
    }
}

