/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.wqyy.provider.company;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.wqyy.enums.WqyySourceEnum;
import cn.smarthse.wqyy.model.param.org.WqyyOrganizationParam;
import cn.smarthse.wqyy.model.vo.org.WqyyOrganizationVo;
import cn.smarthse.wqyy.provider.company.IWqyyCompanyProviderToCompanyService;
import cn.smarthse.wqyy.service.wqyy.IWqyyOrganizationService;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.util.CollectionUtils;

@DubboService
public class WqyyCompanyProviderToCompany
implements IWqyyCompanyProviderToCompanyService {
    private final IWqyyOrganizationService organizationService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService areaService;

    public PageInfo<WqyyOrganizationVo> queryOrganizationData(JqGridParam param, WqyyOrganizationParam organizationParam) {
        organizationParam.setSource(WqyySourceEnum.Enterprise.getSource());
        organizationParam.setIsQueryPrimary(Boolean.valueOf(false));
        organizationParam.setIsShelves(Integer.valueOf(1));
        PageInfo<WqyyOrganizationVo> wqyyOrgPage = this.organizationService.queryOrganizationData(param, organizationParam);
        this.setServiceScopeValue(wqyyOrgPage);
        return wqyyOrgPage;
    }

    public WqyyOrganizationVo queryOrganizationDataById(Long pkId) {
        WqyyOrganizationParam orgParam = new WqyyOrganizationParam().setId(pkId).setSource(WqyySourceEnum.Enterprise.getSource()).setIsQueryPrimary(Boolean.valueOf(false)).setIsShelves(Integer.valueOf(1));
        return this.organizationService.queryOrganizationDataById(orgParam);
    }

    private void setServiceScopeValue(PageInfo<WqyyOrganizationVo> wqyyOrgPage) {
        boolean isEmptyData;
        boolean bl = isEmptyData = wqyyOrgPage == null || CollectionUtils.isEmpty((Collection)wqyyOrgPage.getList());
        if (isEmptyData) {
            return;
        }
        for (WqyyOrganizationVo wqyyOrg : wqyyOrgPage.getList()) {
            List contactList = wqyyOrg.getContactList();
            if (CollectionUtils.isEmpty((Collection)contactList)) continue;
            StringBuilder serviceScope = new StringBuilder();
            String regionIds = contactList.stream().filter(c -> c.getAreaId() != null).map(c -> c.getAreaId().toString()).distinct().collect(Collectors.joining(","));
            List regionList = this.areaService.getAreaListByIds(regionIds);
            regionList = ((List)Optional.of(regionList).orElse(new ArrayList())).stream().filter(Objects::nonNull).sorted(Comparator.comparing(AreaModel::getLevel)).collect(Collectors.toList());
            for (AreaModel region : regionList) {
                Byte level = region.getLevel();
                switch (level) {
                    case 0: {
                        serviceScope.append("\u56fd\u5bb6").append("\u3001");
                        break;
                    }
                    case 1: {
                        serviceScope.append(region.getProvinceName()).append("\u3001");
                        break;
                    }
                    case 2: {
                        serviceScope.append(region.getProvinceName()).append(region.getCityName()).append("\u3001");
                        break;
                    }
                    case 3: {
                        serviceScope.append(region.getCityName()).append(region.getAreaName()).append("\u3001");
                        break;
                    }
                    case 4: {
                        serviceScope.append(region.getAreaName()).append(region.getStreetName()).append("\u3001");
                        break;
                    }
                }
            }
            if (serviceScope.length() > 0) {
                serviceScope.deleteCharAt(serviceScope.length() - 1);
            }
            wqyyOrg.setServiceScope(String.valueOf(serviceScope));
        }
    }

    @Generated
    public WqyyCompanyProviderToCompany(IWqyyOrganizationService organizationService) {
        this.organizationService = organizationService;
    }
}

