/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.wqyy.framework.utils;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.wqyy.framework.Constant;
import cn.smarthse.wqyy.framework.utils.ServletUtils;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Date;

public class JwtUtil {
    public static String getUsername() {
        try {
            DecodedJWT jwt = JWT.decode((String)JwtUtil.getToken());
            return jwt.getClaim("username").asString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getUsername(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getClaim("username").asString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Long getUserId(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getClaim("userId").asLong();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Long getUserId() {
        try {
            DecodedJWT jwt = JWT.decode((String)JwtUtil.getToken());
            return jwt.getClaim("userId").asLong();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getToken() {
        HttpServletRequest request = ServletUtils.getRequest();
        String token = request.getHeader(Constant.TOKEN_HEADER_NAME);
        if (StrUtil.isBlank((CharSequence)token)) {
            return request.getParameter(Constant.TOKEN_HEADER_NAME);
        }
        return token;
    }

    public static String getToken(HttpServletRequest request) {
        String token = request.getHeader(Constant.TOKEN_HEADER_NAME);
        if (StrUtil.isBlank((CharSequence)token)) {
            return request.getParameter(Constant.TOKEN_HEADER_NAME);
        }
        return token;
    }

    public static String createToken(String username, Long userId, String secret, Long time) {
        Date date = new Date(System.currentTimeMillis() + time);
        Algorithm algorithm = Algorithm.HMAC256((String)secret);
        return JWT.create().withClaim("username", username).withClaim("userId", userId).withExpiresAt(date).sign(algorithm);
    }

    public static String createToken(String username, Long userId, String ip, String secret, Long time) {
        Date date = new Date(System.currentTimeMillis() + time);
        Algorithm algorithm = Algorithm.HMAC256((String)secret);
        return JWT.create().withClaim("username", username).withClaim("userId", userId).withClaim("ip", ip).withExpiresAt(date).sign(algorithm);
    }

    public static boolean verify(String token, String secret) {
        if (StringUtils.isBlank((CharSequence)secret)) {
            return false;
        }
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)secret);
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).withClaim("username", JwtUtil.getUsername(token)).withClaim("userId", JwtUtil.getUserId(token)).build();
            verifier.verify(token);
            return true;
        }
        catch (JWTVerificationException exception) {
            return false;
        }
    }

    public static Boolean isTokenExpired(String token) {
        Date expiration = JwtUtil.getExpirationDateFromToken(token);
        return expiration == null || expiration.before(new Date());
    }

    private static Date getExpirationDateFromToken(String token) {
        try {
            return ((Claim)JWT.decode((String)token).getClaims().get("exp")).asDate();
        }
        catch (JWTDecodeException e) {
            return null;
        }
    }
}

