/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.wqyy.framework.redis;

import java.time.Duration;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class TtlRedisCacheManager
extends RedisCacheManager {
    private static final String d = "d";
    private static final String h = "h";
    private static final String m = "m";
    private static final String s = "s";

    public TtlRedisCacheManager(RedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration) {
        super(cacheWriter, defaultCacheConfiguration);
    }

    protected RedisCache createRedisCache(String name, @Nullable RedisCacheConfiguration cacheConfig) {
        String[] cells = StringUtils.delimitedListToStringArray((String)name, (String)"=");
        name = cells[0].trim();
        if (cells.length > 1) {
            cacheConfig = this.entryTtl(cacheConfig, cells[1].trim().toLowerCase());
        }
        return super.createRedisCache(name, cacheConfig);
    }

    private RedisCacheConfiguration entryTtl(RedisCacheConfiguration cacheConfig, String ttlStr) {
        if ((ttlStr = ttlStr.toLowerCase()).endsWith(d)) {
            return cacheConfig.entryTtl(Duration.ofDays(Long.parseLong(ttlStr.replace(d, ""))));
        }
        if (ttlStr.endsWith(h)) {
            return cacheConfig.entryTtl(Duration.ofHours(Long.parseLong(ttlStr.replace(h, ""))));
        }
        if (ttlStr.endsWith(m)) {
            return cacheConfig.entryTtl(Duration.ofMinutes(Long.parseLong(ttlStr.replace(m, ""))));
        }
        if (ttlStr.endsWith(s)) {
            return cacheConfig.entryTtl(Duration.ofSeconds(Long.parseLong(ttlStr.replace(s, ""))));
        }
        return cacheConfig.entryTtl(Duration.ofHours(Long.parseLong(ttlStr.replaceAll("[^\\d]", ""))));
    }
}

