/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.wqyy.controller.app.appointment;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.wqyy.bootstrap.security.service.ShiroUtil;
import cn.smarthse.wqyy.controller.ControllerSupport;
import cn.smarthse.wqyy.model.param.appointment.IdParam;
import cn.smarthse.wqyy.model.param.appointment.PartOneParam;
import cn.smarthse.wqyy.model.param.appointment.PartTwoParam;
import cn.smarthse.wqyy.model.vo.appointment.AppointmentDateInfo;
import cn.smarthse.wqyy.model.vo.appointment.AppointmentInfo;
import cn.smarthse.wqyy.model.vo.appointment.CompanyBaseInfo;
import cn.smarthse.wqyy.model.vo.appointment.ContactsInfo;
import cn.smarthse.wqyy.model.vo.appointment.RecordInfo;
import cn.smarthse.wqyy.model.vo.appointment.StatusAndChangeDateInfo;
import cn.smarthse.wqyy.service.wqyy.IWqyyAppointmentItemService;
import cn.smarthse.wqyy.service.wqyy.IWqyyAppointmentService;
import com.github.pagehelper.PageInfo;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app/appointment"})
public class AppointmentController
extends ControllerSupport {
    private final IWqyyAppointmentService wqyyAppointmentService;
    private final IWqyyAppointmentItemService wqyyAppointmentItemService;

    @GetMapping(value={"/companyBaseInfo"})
    public ResponseData<CompanyBaseInfo> companyBaseInfo() {
        Long cid = ShiroUtil.getCid();
        return ResponseData.success((Object)this.wqyyAppointmentService.companyBaseInfo(cid));
    }

    @PostMapping(value={"/partOne"})
    public ResponseData<AppointmentInfo> appointmentPart1(@RequestBody @Valid PartOneParam param) {
        return ResponseData.success((Object)this.wqyyAppointmentService.appointmentPart1(param));
    }

    @GetMapping(value={"/appointmentNum"})
    public ResponseData<Integer> appointmentNum(Long appointmentId) {
        return ResponseData.success((Object)this.wqyyAppointmentItemService.appointmentNum(appointmentId));
    }

    @GetMapping(value={"/appointmentDateList"})
    public ResponseData<AppointmentDateInfo> appointmentDateInfoList(Long appointmentId) {
        return ResponseData.success((Object)this.wqyyAppointmentService.appointmentDateInfoList(appointmentId));
    }

    @PostMapping(value={"/partTwo"})
    public ResponseData<AppointmentInfo> appointmentPart2(@RequestBody PartTwoParam param) {
        return ResponseData.success((Object)this.wqyyAppointmentService.appointmentPart2(param));
    }

    @PostMapping(value={"/partThree"})
    public ResponseData<String> appointmentPart3(@RequestBody IdParam param) {
        try {
            this.wqyyAppointmentService.appointmentPart3(param.getAppointmentId());
            return ResponseData.success();
        }
        catch (Exception e) {
            return ResponseData.fail((String)e.getMessage());
        }
    }

    @GetMapping(value={"/info"})
    public ResponseData<AppointmentInfo> info(Long appointmentId) {
        return ResponseData.success((Object)this.wqyyAppointmentService.getInfoById(appointmentId));
    }

    @GetMapping(value={"/baseInfo"})
    public ResponseData<AppointmentInfo> baseInfo(Long appointmentId) {
        return ResponseData.success((Object)this.wqyyAppointmentService.baseInfo(appointmentId));
    }

    @GetMapping(value={"/orgContacts"})
    public ResponseData<List<ContactsInfo>> orgContacts(Long appointmentId) {
        return ResponseData.success(this.wqyyAppointmentService.getOrgContacts(appointmentId));
    }

    @GetMapping(value={"/list"})
    public ResponseData<JqGridData<RecordInfo>> list(JqGridParam param) {
        Long userId = ShiroUtil.getUserId();
        PageInfo<RecordInfo> pageInfo = this.wqyyAppointmentService.recordInfoListPage(param, userId);
        return ResponseData.success((Object)new JqGridData(pageInfo, param));
    }

    @GetMapping(value={"/getStatusAndChangeDateInfo"})
    public ResponseData<StatusAndChangeDateInfo> getStatusAndChangeDateInfo(Long appointmentId) {
        return ResponseData.success((Object)this.wqyyAppointmentService.getStatusAndChangeDateInfo(appointmentId));
    }

    @Generated
    public AppointmentController(IWqyyAppointmentService wqyyAppointmentService, IWqyyAppointmentItemService wqyyAppointmentItemService) {
        this.wqyyAppointmentService = wqyyAppointmentService;
        this.wqyyAppointmentItemService = wqyyAppointmentItemService;
    }
}

