/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.wqyy.controller.api;

import cn.hutool.crypto.digest.MD5;
import cn.hutool.extra.servlet.JakartaServletUtil;
import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.file.FileUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.uploader.FileResourceEnum;
import cn.smarthse.wqyy.bootstrap.security.service.ShiroUtil;
import cn.smarthse.wqyy.controller.ControllerSupport;
import cn.smarthse.wqyy.framework.uploader.FileMD5;
import cn.smarthse.wqyy.framework.uploader.FileUploadSimple;
import cn.smarthse.wqyy.framework.uploader.UploadFileParameter;
import cn.smarthse.wqyy.framework.uploader.UploadFilePathEnum;
import cn.smarthse.wqyy.framework.uploader.m3u8.FFmpegUtils;
import cn.smarthse.wqyy.framework.uploader.m3u8.TranscodeConfig;
import cn.smarthse.wqyy.framework.utils.JwtUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/file"})
public class FileUploadController
extends ControllerSupport {
    @DubboReference
    private ISysFileProvideService sysFileService;
    private final OssClientBean ossClientBean;
    private final Path tempDir = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);

    @Log(title="\u4e0a\u4f20\u9644\u4ef6", type=26)
    @CrossOrigin(origins={"*"})
    @ResponseBody
    @RequestMapping(value={"upload"}, method={RequestMethod.POST})
    public ResponseData<SysFileModel> upload(HttpServletRequest request, @RequestPart(value="file") MultipartFile fileData) throws IOException {
        ResponseData data = ResponseData.success(null);
        String ossFileName = FileUploadSimple.getNumberName(cn.hutool.core.io.FileUtil.getSuffix((String)fileData.getOriginalFilename()));
        String uploadDir = UploadFileParameter.FILE_PATH + FileResourceEnum.WQYY.getCode() + File.separator + UploadFilePathEnum.Common.getPath() + File.separator + FileUploadSimple.getDataPath();
        String realPath = this.ossClientBean.getLocal() + uploadDir + File.separator + ossFileName;
        String ossUrl = (uploadDir + "/" + ossFileName).replace("\\", "/");
        FileUtil.writeFromStream((MultipartFile)fileData, (String)realPath);
        SysFileModel file = new SysFileModel();
        file.setCid(JwtUtil.getUserId());
        file.setResource(Integer.valueOf(FileResourceEnum.WQYY.getValue()));
        file.setFileName(fileData.getOriginalFilename());
        file.setFileSize(String.valueOf(fileData.getSize()));
        file.setFileExt(cn.hutool.core.io.FileUtil.getSuffix((String)fileData.getOriginalFilename()));
        file.setFileHash(String.valueOf(MD5.create().digestHex(fileData.getBytes())));
        file.setCreatorIp(JakartaServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]));
        file.setOssUrl(ossUrl);
        file.setCreateBy(ShiroUtil.getUserId());
        file.setUpdateBy(file.getCreateBy());
        SysFileModel existSysFile = this.sysFileService.getFileByHash(file.getFileHash());
        if (existSysFile != null) {
            existSysFile.setFullOssurl(this.ossClientBean.getUrl(existSysFile.getOssUrl()));
            data.setResult((Object)existSysFile);
            data.setMessage("\u4e0a\u4f20\u6587\u4ef6 \u6210\u529f(hash\u503c\u5b58\u5728)\uff01");
            return data;
        }
        this.logger.debug("\u4e0a\u4f20\u6587\u4ef6\uff1afileName:{}, ossUrl:{}", (Object)file.getFileName(), (Object)ossUrl);
        if (this.ossClientBean.isAsynch()) {
            this.ossClientBean.OSSPutObject(ossFileName, new File(realPath), uploadDir, file.getFileName(), null);
            this.logger.debug("\u5220\u9664\u4e34\u65f6\u6587\u4ef6\uff1a{}", (Object)realPath);
            cn.hutool.core.io.FileUtil.del((String)realPath);
        }
        file = this.sysFileService.addSysFile(file, ShiroUtil.getUserId());
        data.setResult((Object)file);
        data.setMessage("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff01");
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"upload/m3u8"})
    public ResponseData<SysFileModel> m3u8(HttpServletRequest request, @RequestPart(name="file") MultipartFile video) throws IOException {
        this.logger.debug("\u4e0a\u4f20\u89c6\u9891\uff1atitle={}, size={}", (Object)video.getOriginalFilename(), (Object)video.getSize());
        SysFileModel existSysFile = this.sysFileService.getFileByHash(FileMD5.getFileMD5(video.getBytes()));
        if (existSysFile != null && !"mp4".equalsIgnoreCase(existSysFile.getFileExt())) {
            return ResponseData.success((String)"\u4e0a\u4f20\u6587\u4ef6 \u6210\u529f(hash\u503c\u5b58\u5728)\uff01", (Object)existSysFile);
        }
        String title = video.getOriginalFilename();
        String uploadDir = "upload/" + FileResourceEnum.WQYY.getValue() + "/m3u8";
        String today = DateTimeFormatter.ofPattern("yyyyMMdd").format(LocalDate.now());
        String numberFile = FileUploadSimple.getNumberFile();
        Path relativePath = Paths.get(uploadDir, today, numberFile);
        Path realPath = Paths.get(this.ossClientBean.getLocal(), relativePath.toString());
        Path tempFile = this.tempDir.resolve(title);
        try {
            video.transferTo(tempFile);
            realPath = Files.createDirectories(realPath, new FileAttribute[0]);
            this.logger.info("\u5f00\u59cb\u8f6c\u7801");
            try {
                FFmpegUtils.transcodeToM3u8(tempFile.toString(), realPath.toString(), new TranscodeConfig());
            }
            catch (Exception e) {
                this.logger.error("\u8f6c\u7801\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                ResponseData.fail((String)"\u8f6c\u7801\u5f02\u5e38");
            }
            this.logger.info("\u5b8c\u6210\u8f6c\u7801");
            String m3u8_ossUrl = null;
            String ossUrl = null;
            File[] files = realPath.toFile().listFiles();
            if (files != null) {
                for (File file : files) {
                    if (this.ossClientBean.isAsynch()) {
                        ossUrl = this.ossClientBean.OSSPutObject(file.getName(), file, relativePath.toString().replace("\\", "/"), String.join((CharSequence)".", title, file.getName()), null);
                    }
                    if (!file.getName().equals("index.m3u8") || StringUtils.isEmpty(ossUrl)) continue;
                    m3u8_ossUrl = ossUrl;
                }
            }
            this.logger.debug("\u5b8c\u6210\u4e0a\u4f20oss\uff0c\u5220\u9664\u4e34\u65f6\u6587\u4ef6\uff1a{}", (Object)realPath);
            cn.hutool.core.io.FileUtil.del((Path)realPath);
            SysFileModel file = new SysFileModel();
            file.setResource(Integer.valueOf(FileResourceEnum.WQYY.getValue()));
            file.setFileName(title);
            file.setFileSize("" + video.getSize());
            file.setFileExt(".m3u8");
            file.setFileHash(MD5.create().digestHex(video.getBytes()));
            file.setCreatorIp(JakartaServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]));
            file.setOssUrl(m3u8_ossUrl);
            file = this.sysFileService.addSysFile(file, ShiroUtil.getUserId());
            ResponseData responseData = ResponseData.success((Object)file);
            return responseData;
        }
        catch (Exception e) {
            this.logger.error("e: ", (Throwable)e);
            ResponseData responseData = ResponseData.fail((String)"\u4e0a\u4f20\u5931\u8d25\uff01");
            return responseData;
        }
        finally {
            Files.delete(tempFile);
        }
    }

    @RequestMapping(value={"getFileList"}, method={RequestMethod.POST})
    public ResponseData<List<SysFileModel>> getFileList(String fileIds) {
        this.logger.debug("\u3010\u7cfb\u7edf\u9644\u4ef6\u3011-\u901a\u8fc7\u6587\u4ef6id\u83b7\u53d6\u6587\u4ef6\u5bf9\u8c61\u96c6\u5408, fileIds={}", (Object)fileIds);
        ResponseData data = ResponseData.success(null);
        if (StringUtils.isEmpty((CharSequence)fileIds)) {
            data.setMessage("\u6587\u4ef6id\u4e3a\u7a7a\uff01");
            return data;
        }
        List list = this.sysFileService.getListByIds(fileIds);
        if (list != null && !list.isEmpty()) {
            data.setResult((Object)list);
            data.setMessage("\u901a\u8fc7id\u83b7\u53d6\u6587\u4ef6\u5bf9\u8c61 \u6210\u529f\uff01");
        } else {
            data.setState(ResponseStateEnum.fail.getValue());
            data.setMessage("\u6ca1\u6709\u8be5id\u7684\u6587\u4ef6\uff01");
        }
        return data;
    }

    @CrossOrigin(origins={"*"})
    @ResponseBody
    @RequestMapping(value={"postSignature"}, method={RequestMethod.GET})
    public Map<String, String> postSignature() throws Exception {
        this.logger.debug("\u670d\u52a1\u5668\u7b7e\u540d\u76f4\u4f20oss");
        String uploadDir = "upload/" + FileResourceEnum.WQYY.getCode() + "/" + UploadFilePathEnum.Common.getPath() + "/" + FileUploadSimple.getDataPath() + "/";
        return this.ossClientBean.getPostSignature(uploadDir);
    }

    @Log(title="\u76f4\u4f20oss\u540e\u4fdd\u5b58sysFile", type=26)
    @ResponseBody
    @RequestMapping(value={"add"}, method={RequestMethod.POST})
    public ResponseData<SysFileModel> add(String originalFilename, String origSize, String etagMd5, String fileUrl, String description, HttpServletRequest req) throws Exception {
        ResponseData data = new ResponseData();
        SysFileModel file = new SysFileModel();
        file.setCid(JwtUtil.getUserId());
        file.setResource(Integer.valueOf(FileResourceEnum.WQYY.getValue()));
        file.setFileName(originalFilename);
        file.setFileSize(origSize);
        file.setFileExt(cn.hutool.core.io.FileUtil.getSuffix((String)originalFilename));
        file.setFileHash(etagMd5);
        file.setCreatorIp(JakartaServletUtil.getClientIP((HttpServletRequest)req, (String[])new String[0]));
        file.setOssUrl(fileUrl);
        file.setCreateBy(ShiroUtil.getUserId());
        file.setUpdateBy(file.getCreateBy());
        file = this.sysFileService.addSysFile(file, ShiroUtil.getUserId());
        data.setResult((Object)file);
        return data;
    }

    @Generated
    public FileUploadController(OssClientBean ossClientBean) {
        this.ossClientBean = ossClientBean;
    }
}

