/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.wqyy.controller;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.modules.datacentre.model.zlb.LegalPersonInfo;
import cn.smarthse.modules.datacentre.model.zlb.ZlbUserInfo;
import cn.smarthse.modules.datacentre.provider.zlb.IZlbUserInfoProviderService;
import cn.smarthse.wqyy.bootstrap.security.service.LoginService;
import cn.smarthse.wqyy.bootstrap.security.token.LoginData;
import cn.smarthse.wqyy.bootstrap.security.token.ZlbCasToken;
import cn.smarthse.wqyy.controller.ControllerSupport;
import cn.smarthse.wqyy.controller.legalPersonBo;
import cn.smarthse.wqyy.entity.sys.Company;
import cn.smarthse.wqyy.entity.sys.SysUser;
import cn.smarthse.wqyy.service.sys.ICompanyService;
import cn.smarthse.wqyy.service.sys.ISysUserService;
import java.util.Objects;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/m/zlbLogin"})
@Validated
public class ZlbLoginController
extends ControllerSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZlbLoginController.class);
    @DubboReference
    private IZlbUserInfoProviderService zlbUserInfoProviderService;
    private final LoginService loginService;
    private final ISysUserService sysUserService;
    private final ICompanyService companyService;

    @PostMapping(value={"/legalPerson"})
    public ResponseData<LoginData> legalPerson(@Validated legalPersonBo bo) {
        String unifiedSocialId;
        String userId = bo.getZlbUserId();
        ZlbUserInfo zlbUserInfo = this.zlbUserInfoProviderService.getUserInfo(userId, "LEGAL_PERSON");
        if (zlbUserInfo == null) {
            return ResponseData.fail((String)"\u767b\u5f55\u5931\u8d25\uff01\u83b7\u53d6\u6d59\u91cc\u529e\u8d26\u53f7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (!Objects.equals(zlbUserInfo.getUserType(), "LEGAL_PERSON")) {
            return ResponseData.fail((String)"\u767b\u5f55\u5931\u8d25\uff01\u4e2a\u4eba\u7528\u6237\u65e0\u6743\u9650\uff01");
        }
        LegalPersonInfo legalPersonInfo = zlbUserInfo.getLegalPersonInfo();
        String name = legalPersonInfo.getName();
        Company company = this.companyService.getCompanyByCompanyNameAndUniscid(name, unifiedSocialId = legalPersonInfo.getUnifiedSocialId());
        if (company == null) {
            return ResponseData.fail((String)String.format("\u4f01\u4e1a\u540d\u79f0\uff1a%s, \u5728\u6d59\u91cc\u536b\u4f01\u4e2d\u4e0d\u5b58\u5728\uff01", name));
        }
        SysUser user = this.sysUserService.getManagerByCid(company.getId());
        if (user == null) {
            return ResponseData.fail((String)String.format("\u4f01\u4e1a\u540d\u79f0\uff1a%s, \u5728\u6d59\u91cc\u536b\u4f01\u4e2d\u4e0d\u5b58\u5728\u8d26\u53f7\uff01", name));
        }
        this.sysUserService.bindZlbUserId(user.getId(), userId);
        ZlbCasToken casToken = new ZlbCasToken(name, unifiedSocialId, userId);
        LoginData loginData = this.loginService.loginByZlbCas(casToken);
        loginData.setNickName(name);
        loginData.setZlbUserId(userId);
        return ResponseData.success((Object)loginData);
    }

    @Generated
    public ZlbLoginController(LoginService loginService, ISysUserService sysUserService, ICompanyService companyService) {
        this.loginService = loginService;
        this.sysUserService = sysUserService;
        this.companyService = companyService;
    }
}

