/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.wqyy.controller;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.annotation.Log;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.modules.datacentre.model.CompanyLoginModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.wqyy.bootstrap.security.service.LoginService;
import cn.smarthse.wqyy.bootstrap.security.token.LoginData;
import cn.smarthse.wqyy.controller.ControllerSupport;
import cn.smarthse.wqyy.framework.RedisKey;
import cn.smarthse.wqyy.framework.utils.JwtUtil;
import jakarta.validation.constraints.NotEmpty;
import java.util.List;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/m/login"})
@Validated
public class LoginController
extends ControllerSupport {
    private final LoginService loginService;
    private final StringRedisTemplate stringRedisTemplate;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;

    @Log(title="\u5bc6\u7801\u767b\u5f55", type=1)
    @PostMapping(value={"/password"})
    public ResponseData<LoginData> loginByPassword(String username, String cid, @NotEmpty(message="\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") String password, @NotEmpty(message="\u56fe\u5f62\u9a8c\u8bc1\u7801key\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u56fe\u5f62\u9a8c\u8bc1\u7801key\u4e0d\u80fd\u4e3a\u7a7a") String key, @NotEmpty(message="\u56fe\u5f62\u9a8c\u8bc1\u7801vcode\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u56fe\u5f62\u9a8c\u8bc1\u7801vcode\u4e0d\u80fd\u4e3a\u7a7a") String vcode) {
        if (!this.loginService.checkVCode(key, vcode)) {
            return ResponseData.fail((String)"\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
        }
        LoginData result = this.loginService.loginByPassword(username, password, cid);
        this.stringRedisTemplate.opsForValue().get((Object)RedisKey.getVCodeKey(key));
        return ResponseData.success((Object)result);
    }

    @PostMapping(value={"/token/refresh"})
    public ResponseData<LoginData> tokenRefresh(@RequestParam String refreshToken) {
        return ResponseData.success((Object)this.loginService.tokenRefresh(refreshToken));
    }

    @PostMapping(value={"/sendVCode"})
    public ResponseData<String> sendVCode(String key) {
        return ResponseData.success((String)"\u6210\u529f", (Object)this.loginService.sendVCode(key));
    }

    @PostMapping(value={"/checkVCode"})
    public ResponseData<Boolean> checkVcode(String key, @NotEmpty(message="\u9a8c\u8bc1\u7801") @NotEmpty(message="\u9a8c\u8bc1\u7801") String vode) {
        return ResponseData.success((Object)this.loginService.checkVCode(key, vode));
    }

    @PostMapping(value={"/logout"})
    public ResponseData<String> logout() {
        this.loginService.logout(JwtUtil.getUserId());
        return ResponseData.success();
    }

    @GetMapping(value={"/companyNameList"})
    public ResponseData<List<CompanyLoginModel>> companyNameList(String unifiedSocialCc) {
        if (StrUtil.isBlank((CharSequence)unifiedSocialCc)) {
            return new ResponseData();
        }
        return ResponseData.success((Object)this.companyProvideBySuperviseService.getLoginModelByUnifiedSocialCc(unifiedSocialCc));
    }

    @Generated
    public LoginController(LoginService loginService, StringRedisTemplate stringRedisTemplate) {
        this.loginService = loginService;
        this.stringRedisTemplate = stringRedisTemplate;
    }
}

