/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.wqyy.controller;

import cn.hutool.core.lang.Pair;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.annotation.Log;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.wqyy.bootstrap.security.service.LoginService;
import cn.smarthse.wqyy.bootstrap.security.token.ESSOCasToken;
import cn.smarthse.wqyy.bootstrap.security.token.LoginData;
import cn.smarthse.wqyy.controller.ControllerSupport;
import cn.smarthse.wqyy.entity.sys.SysUser;
import cn.smarthse.wqyy.service.sys.ISysUserService;
import com.alibaba.fastjson.JSONObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.xml.bind.DatatypeConverter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/m/essoLogin"})
@Validated
public class ESSOLoginController
extends ControllerSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ESSOLoginController.class);
    private final LoginService loginService;
    private final ISysUserService sysUserService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideByHSEService companyProvideByHSEService;
    @Value(value="${zlb.apiUrl}")
    public String apiUrl;
    @Value(value="${zlb.appKey}")
    private String appKey;
    @Value(value="${zlb.appSecret}")
    private String appSecret;

    @Log(title="\u6cd5\u4eba\u56de\u8c03\u5730\u5740", type=1)
    @GetMapping(value={"/callback"})
    public ResponseData<LoginData> callback(HttpServletRequest request) {
        JSONObject jsonObj;
        int errCode;
        request.setCharacterEncoding("UTF-8");
        String ssotoken = request.getParameter("ssotoken");
        log.debug(" ssotoken:{}", (Object)ssotoken);
        String gotoUrl = request.getQueryString();
        if (StrUtil.isNotBlank((CharSequence)gotoUrl)) {
            gotoUrl = gotoUrl.substring(5);
            log.debug("\u5177\u4f53\u4e1a\u52a1\u529e\u7406\u5730\u5740\uff1a {}", (Object)gotoUrl);
        }
        if (0 != (errCode = (jsonObj = this.createSign(ssotoken)).getInteger("errCode").intValue())) {
            return ResponseData.fail((String)"\u767b\u5f55\u5931\u8d25");
        }
        String info = jsonObj.getString("info");
        log.debug("\u9a8c\u8bc1\u4ee4\u724c\u5e76\u83b7\u53d6\u7528\u6237\u7684\u767b\u5f55\u4fe1\u606f\u63a5\u53e3\u8fd4\u56de\u6570\u636e\uff1a{}", (Object)info);
        JSONObject legalInfo = JSONObject.parseObject((String)info);
        String companyName = legalInfo.get((Object)"CompanyName").toString();
        if (StrUtil.isBlank((CharSequence)companyName)) {
            return ResponseData.fail((String)"\u4f01\u4e1a\u540d\u79f0\u4e3a\u7a7a");
        }
        CompanyBaseInfoModel companyBaseInfoModel = this.companyProvideByHSEService.getByName(companyName);
        if (companyBaseInfoModel == null) {
            return ResponseData.fail((String)String.format("\u4f01\u4e1a\u540d\u79f0\uff1a%s, \u5728\u6d59\u91cc\u536b\u4f01\u4e2d\u4e0d\u5b58\u5728", companyName));
        }
        SysUser user = this.sysUserService.getManagerByCid(companyBaseInfoModel.getId());
        if (user == null) {
            return ResponseData.fail((String)String.format("\u4f01\u4e1a\u540d\u79f0\uff1a%s, \u5728\u6d59\u91cc\u536b\u4f01\u4e2d\u4e0d\u5b58\u5728\u8d26\u53f7", companyName));
        }
        String uniscid = legalInfo.get((Object)"uniscid").toString();
        String zlbUserId = legalInfo.get((Object)"userId").toString();
        this.sysUserService.bindZlbUserId(user.getId(), zlbUserId);
        ESSOCasToken casToken = new ESSOCasToken(companyName, uniscid, zlbUserId);
        LoginData loginData = this.loginService.loginByESSOCas(casToken);
        return ResponseData.success((Object)loginData);
    }

    public JSONObject createSign(String token) {
        JSONObject obj = null;
        try {
            JSONObject ReqData = new JSONObject();
            ReqData.put("token", (Object)token);
            String resp = this.post(ReqData, "post");
            obj = JSONObject.parseObject((String)resp);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return obj;
    }

    public String post(JSONObject data, String requestMethod) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        String date = dateFormat.format(new Date());
        URL url = new URL(this.apiUrl);
        URI uri = new URI(url.getProtocol(), url.getHost(), url.getPath(), url.getQuery(), null);
        String canonicalQueryString = ESSOLoginController.getCanonicalQueryString(uri.getQuery());
        String message = requestMethod.toUpperCase() + "\n" + uri.getPath() + "\n" + canonicalQueryString + "\n" + this.appKey + "\n" + date + "\n";
        log.debug("\u8bf7\u6c42\u53c2\u6570 message:{}", (Object)message);
        Mac hasher = Mac.getInstance("HmacSHA256");
        hasher.init(new SecretKeySpec(this.appSecret.getBytes(), "HmacSHA256"));
        byte[] hash = hasher.doFinal(message.getBytes());
        DatatypeConverter.printHexBinary((byte[])hash);
        String sign = DatatypeConverter.printBase64Binary((byte[])hash);
        log.debug("\u7b7e\u540dsign\uff1a{}", (Object)sign);
        byte[] stream = data.toString().getBytes(StandardCharsets.UTF_8);
        HttpPost req = new HttpPost(this.apiUrl);
        req.addHeader("X-BG-HMAC-SIGNATURE", sign);
        req.addHeader("X-BG-HMAC-ALGORITHM", "hmac-sha256");
        req.addHeader("X-BG-HMAC-ACCESS-KEY", this.appKey);
        req.addHeader("X-BG-DATE-TIME", date);
        req.addHeader("Content-Type", "application/json");
        ByteArrayEntity entity = new ByteArrayEntity(stream, ContentType.create((String)ContentType.APPLICATION_JSON.getMimeType(), (String)"UTF-8"));
        req.setEntity((HttpEntity)entity);
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        CloseableHttpClient cli = httpClientBuilder.build();
        CloseableHttpResponse res = cli.execute((HttpUriRequest)req);
        int statusCode = res.getStatusLine().getStatusCode();
        log.debug("statusCode:{}", (Object)statusCode);
        InputStream in = res.getEntity().getContent();
        byte[] resp = ESSOLoginController.readStream(in);
        String strRes = new String(resp, StandardCharsets.UTF_8);
        log.debug("\u8bf7\u6c42\u54cd\u5e94\u7ed3\u679c\uff1a strRes:{}", (Object)strRes);
        cli.close();
        return strRes;
    }

    private static String getCanonicalQueryString(String query) {
        String[] params;
        if (StrUtil.isBlank((CharSequence)query)) {
            return "";
        }
        ArrayList<Pair> queryParamList = new ArrayList<Pair>();
        for (String param2 : params = query.split("&")) {
            int eqIndex = param2.indexOf("=");
            String key = param2.substring(0, eqIndex);
            String value = param2.substring(eqIndex + 1);
            Pair pair = new Pair((Object)key, (Object)value);
            queryParamList.add(pair);
        }
        List sortedParamList = queryParamList.stream().sorted(Comparator.comparing(param -> (String)param.getKey() + "=" + Optional.ofNullable((String)param.getValue()).orElse(""))).collect(Collectors.toList());
        ArrayList encodeParamList = new ArrayList();
        sortedParamList.stream().forEach(param -> {
            try {
                String key = URLEncoder.encode((String)param.getKey(), "utf-8");
                String value = URLEncoder.encode(Optional.ofNullable((String)param.getValue()).orElse(""), "utf-8").replaceAll("\\%2B", "%20").replaceAll("\\+", "%20").replaceAll("\\%21", "!").replaceAll("\\%27", "'").replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\%7E", "~").replaceAll("\\%25", "%");
                encodeParamList.add(new Pair((Object)key, (Object)value));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("encoding error");
            }
        });
        StringBuilder queryParamString = new StringBuilder(64);
        for (Pair encodeParam : encodeParamList) {
            queryParamString.append((String)encodeParam.getKey()).append("=").append(Optional.ofNullable((String)encodeParam.getValue()).orElse(""));
            queryParamString.append("&");
        }
        return queryParamString.substring(0, queryParamString.length() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readStream(InputStream in) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[10240];
        try {
            int n;
            while ((n = in.read(buffer)) != -1) {
                output.write(buffer, 0, n);
            }
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        finally {
            in.close();
            output.close();
        }
    }

    @Generated
    public ESSOLoginController(LoginService loginService, ISysUserService sysUserService) {
        this.loginService = loginService;
        this.sysUserService = sysUserService;
    }
}

