/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.wqyy.bootstrap.security.service;

import cn.smarthse.wqyy.bootstrap.security.token.ShiroPrincipal;
import cn.smarthse.wqyy.entity.sys.SysUser;
import cn.smarthse.wqyy.framework.Constant;
import cn.smarthse.wqyy.framework.RedisKey;
import cn.smarthse.wqyy.service.sys.ISysUserService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.DisabledAccountException;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class TokenService {
    private final ISysUserService sysUserService;
    private final RedisTemplate<String, ShiroPrincipal> redisTemplate;

    public ShiroPrincipal getLoginUser(Long userId) {
        String loginUserKey = RedisKey.getLoginUserKey(userId);
        ShiroPrincipal principal = (ShiroPrincipal)this.redisTemplate.opsForValue().get((Object)loginUserKey);
        if (principal == null) {
            principal = new ShiroPrincipal();
            SysUser user = this.sysUserService.getUserByUserId(userId);
            if (user == null) {
                throw new AuthenticationException("\u7528\u6237\u6216\u5bc6\u7801\u9519\u8bef, \u8bf7\u91cd\u8bd5\uff01");
            }
            if (user.getIsForbidden().booleanValue()) {
                throw new DisabledAccountException("\u8d26\u53f7\u88ab\u7981\u7528\uff01");
            }
            user.setName(user.getUsername());
            principal.setUser(user);
            this.redisTemplate.opsForValue().set((Object)loginUserKey, (Object)principal, Constant.REDIS_PRINCIPAL_TIME.longValue(), TimeUnit.MINUTES);
            return principal;
        }
        return principal;
    }

    public SysUser getByUsername(String username) {
        return this.sysUserService.getUserByUsername(username);
    }

    public SysUser getByZlbUserId(String zlbUserId) {
        return this.sysUserService.getUserByZlbUserId(zlbUserId);
    }

    public SysUser getManagerByCid(Long cid) {
        return this.sysUserService.getManagerByCid(cid);
    }

    @Generated
    public TokenService(ISysUserService sysUserService, RedisTemplate<String, ShiroPrincipal> redisTemplate) {
        this.sysUserService = sysUserService;
        this.redisTemplate = redisTemplate;
    }
}

