/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.wqyy.bootstrap.security.service;

import cn.smarthse.wqyy.bootstrap.security.token.ShiroPrincipal;
import cn.smarthse.wqyy.entity.sys.SysUser;
import java.util.Set;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;

public class ShiroUtil {
    public static Subject getSubject() {
        return SecurityUtils.getSubject();
    }

    public static ShiroPrincipal getShiroPrincipal() {
        Subject subject = ShiroUtil.getSubject();
        return (ShiroPrincipal)subject.getPrincipal();
    }

    public static SysUser getUserInfo() {
        ShiroPrincipal principal = ShiroUtil.getShiroPrincipal();
        if (principal != null) {
            return principal.getUser();
        }
        return null;
    }

    public static Long getUserId() {
        SysUser user = ShiroUtil.getUserInfo();
        return user != null ? user.getId() : null;
    }

    public static String getZlbUserId() {
        SysUser user = ShiroUtil.getUserInfo();
        return user != null ? user.getZlbUserId() : null;
    }

    public static String getLoginUsername() {
        SysUser user = ShiroUtil.getUserInfo();
        return user != null ? user.getUsername() : null;
    }

    public static Long getCid() {
        SysUser user = ShiroUtil.getUserInfo();
        return user != null ? user.getCid() : null;
    }

    public static Set<String> getPermissionSet() {
        return ShiroUtil.getShiroPrincipal().getPermissionsSet();
    }

    public static Set<String> getRoleSet() {
        return ShiroUtil.getShiroPrincipal().getRoleSet();
    }

    public static boolean hasPermission(String permissionCode) {
        return ShiroUtil.getPermissionSet().contains(permissionCode);
    }

    public static boolean hasRole(String roleCode) {
        return ShiroUtil.getRoleSet().contains(roleCode);
    }
}

