/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.wqyy.bootstrap.security.realms;

import cn.smarthse.wqyy.bootstrap.security.service.TokenService;
import cn.smarthse.wqyy.bootstrap.security.token.ShiroPrincipal;
import cn.smarthse.wqyy.bootstrap.security.token.ZlbCasToken;
import cn.smarthse.wqyy.entity.sys.SysUser;
import lombok.Generated;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class ZlbCasRealm
extends AuthorizingRealm {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZlbCasRealm.class);
    @Autowired
    @Lazy
    private TokenService tokenService;

    public boolean supports(AuthenticationToken token) {
        return token instanceof ZlbCasToken;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        ZlbCasToken token = (ZlbCasToken)authenticationToken;
        SysUser user = this.tokenService.getByZlbUserId(token.getZlbUserId());
        if (user == null) {
            throw new UnknownAccountException();
        }
        if (user.getIsForbidden().booleanValue()) {
            throw new DisabledAccountException();
        }
        String realmName = super.getName();
        return new SimpleAuthenticationInfo((Object)new ShiroPrincipal(user), (Object)"", realmName);
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        return null;
    }
}

