/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.wqyy.bootstrap.security.realms;

import cn.hutool.core.util.NumberUtil;
import cn.smarthse.common.util.Encodes;
import cn.smarthse.common.util.MD5Utils;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.wqyy.bootstrap.security.service.TokenService;
import cn.smarthse.wqyy.bootstrap.security.token.PasswordToken;
import cn.smarthse.wqyy.bootstrap.security.token.ShiroPrincipal;
import cn.smarthse.wqyy.entity.sys.SysUser;
import cn.smarthse.wqyy.framework.utils.AesEncode;
import lombok.Generated;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.lang.util.ByteSource;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class PasswordRealm
extends AuthorizingRealm {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PasswordRealm.class);
    @Autowired
    @Lazy
    private TokenService tokenService;

    public boolean supports(AuthenticationToken token) {
        return token instanceof UsernamePasswordToken;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        SysUser user;
        PasswordToken token = (PasswordToken)authenticationToken;
        String desPassword = AesEncode.desEncrypt(String.valueOf(token.getPassword())).trim();
        String md5Password = MD5Utils.getMD5String((String)desPassword);
        token.setPassword(md5Password.toCharArray());
        String desUsername = AesEncode.desEncrypt(String.valueOf(token.getUsername())).trim();
        SysUser sysUser = user = NumberUtil.isNumber((CharSequence)desUsername) ? this.tokenService.getManagerByCid(Long.valueOf(desUsername)) : this.tokenService.getByUsername(SpringEncryptUtils.encrypt((String)desUsername));
        if (user == null) {
            throw new UnknownAccountException();
        }
        if (user.getIsForbidden().booleanValue()) {
            throw new DisabledAccountException();
        }
        String credentials = user.getPassword();
        String realmName = super.getName();
        ByteSource credentialsSalt = ByteSource.Util.bytes((byte[])Encodes.hexDecode((String)user.getSalt()));
        ShiroPrincipal principal = new ShiroPrincipal(user);
        return new SimpleAuthenticationInfo((Object)principal, (Object)credentials, credentialsSalt, realmName);
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        return null;
    }
}

