/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.wqyy.bootstrap;

import cn.smarthse.wqyy.bootstrap.properties.SysProperties;
import cn.smarthse.wqyy.bootstrap.security.filter.JwtFilter;
import cn.smarthse.wqyy.bootstrap.security.realms.CustomModularRealmAuthenticator;
import cn.smarthse.wqyy.bootstrap.security.realms.ESSOCasRealm;
import cn.smarthse.wqyy.bootstrap.security.realms.JwtRealm;
import cn.smarthse.wqyy.bootstrap.security.realms.PasswordRealm;
import cn.smarthse.wqyy.bootstrap.security.realms.ZlbCasRealm;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.apache.shiro.authc.Authenticator;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.HashedCredentialsMatcher;
import org.apache.shiro.authc.pam.AtLeastOneSuccessfulStrategy;
import org.apache.shiro.authc.pam.AuthenticationStrategy;
import org.apache.shiro.mgt.DefaultSessionStorageEvaluator;
import org.apache.shiro.mgt.DefaultSubjectDAO;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.mgt.SessionStorageEvaluator;
import org.apache.shiro.mgt.SessionsSecurityManager;
import org.apache.shiro.mgt.SubjectDAO;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.springframework.aop.framework.autoproxy.DefaultAdvisorAutoProxyCreator;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.data.redis.core.StringRedisTemplate;

@Configuration
public class ShiroConfig {
    @Bean(value={"hashedCredentialsMatcher"})
    public HashedCredentialsMatcher hashedCredentialsMatcher() {
        HashedCredentialsMatcher matcher = new HashedCredentialsMatcher();
        matcher.setHashAlgorithmName("SHA-1");
        matcher.setHashIterations(1024);
        matcher.setStoredCredentialsHexEncoded(true);
        return matcher;
    }

    @Bean
    public PasswordRealm passwordRealm(@Qualifier(value="hashedCredentialsMatcher") HashedCredentialsMatcher matcher) {
        PasswordRealm userRealm = new PasswordRealm();
        userRealm.setCredentialsMatcher((CredentialsMatcher)matcher);
        return userRealm;
    }

    @Bean
    public JwtRealm jwtRealm() {
        return new JwtRealm();
    }

    @Bean
    public ESSOCasRealm essoCasRealm() {
        return new ESSOCasRealm();
    }

    @Bean
    public ZlbCasRealm zlbCasRealm() {
        return new ZlbCasRealm();
    }

    @Bean(value={"shiroFilterFactoryBean"})
    public ShiroFilterFactoryBean shiroFilter(@Qualifier(value="sessionsSecurityManager") SecurityManager securityManager, @Qualifier(value="stringRedisTemplate") StringRedisTemplate stringRedisTemplate, SysProperties sysProperties) {
        ShiroFilterFactoryBean bean = new ShiroFilterFactoryBean();
        bean.setSecurityManager(securityManager);
        LinkedHashMap<String, String> filterMap = new LinkedHashMap<String, String>();
        filterMap.put("/m/login/**", "anon");
        filterMap.put("/m/zlbLogin/**", "anon");
        filterMap.put("/m/essoLogin/**", "anon");
        filterMap.put("/api/**", "anon");
        filterMap.put("/static/**", "anon");
        filterMap.put("/upload/**", "anon");
        filterMap.put("/druid/**", "anon");
        filterMap.put("/swagger-ui.html", "anon");
        filterMap.put("/doc.html", "anon");
        filterMap.put("/swagger-resources/**", "anon");
        filterMap.put("/v2/**", "anon");
        filterMap.put("/v3/**", "anon");
        filterMap.put("/webjars/**", "anon");
        filterMap.put("/images/**", "anon");
        filterMap.put("/csrf", "anon");
        LinkedHashMap<String, JwtFilter> filter = new LinkedHashMap<String, JwtFilter>(1);
        filter.put("jwt", new JwtFilter(stringRedisTemplate, sysProperties));
        bean.setFilters(filter);
        filterMap.put("/**", "jwt");
        bean.setFilterChainDefinitionMap(filterMap);
        return bean;
    }

    @Bean
    public Authenticator authenticator() {
        CustomModularRealmAuthenticator modularRealmAuthenticator = new CustomModularRealmAuthenticator();
        modularRealmAuthenticator.setAuthenticationStrategy((AuthenticationStrategy)new AtLeastOneSuccessfulStrategy());
        return modularRealmAuthenticator;
    }

    @Bean
    public SessionsSecurityManager sessionsSecurityManager(@Qualifier(value="passwordRealm") PasswordRealm passwordRealm, @Qualifier(value="jwtRealm") JwtRealm jwtRealm, @Qualifier(value="essoCasRealm") ESSOCasRealm essoCasRealm, @Qualifier(value="zlbCasRealm") ZlbCasRealm zlbCasRealm, @Qualifier(value="authenticator") Authenticator authenticator) {
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager();
        securityManager.setAuthenticator(authenticator);
        ArrayList<AuthorizingRealm> realms = new ArrayList<AuthorizingRealm>();
        realms.add(passwordRealm);
        realms.add(jwtRealm);
        realms.add(essoCasRealm);
        realms.add(zlbCasRealm);
        securityManager.setRealms(realms);
        DefaultSubjectDAO subjectDAO = new DefaultSubjectDAO();
        DefaultSessionStorageEvaluator defaultSessionStorageEvaluator = new DefaultSessionStorageEvaluator();
        defaultSessionStorageEvaluator.setSessionStorageEnabled(false);
        subjectDAO.setSessionStorageEvaluator((SessionStorageEvaluator)defaultSessionStorageEvaluator);
        securityManager.setSubjectDAO((SubjectDAO)subjectDAO);
        return securityManager;
    }

    @Bean
    @DependsOn(value={"lifecycleBeanPostProcessor"})
    public DefaultAdvisorAutoProxyCreator advisorAutoProxyCreator() {
        DefaultAdvisorAutoProxyCreator advisorAutoProxyCreator = new DefaultAdvisorAutoProxyCreator();
        advisorAutoProxyCreator.setProxyTargetClass(true);
        return advisorAutoProxyCreator;
    }
}

