/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.wqyy.bootstrap;

import cn.smarthse.common.framework.properties.OssClientProperties;
import cn.smarthse.wqyy.bootstrap.BaseConfiguration;
import cn.smarthse.wqyy.bootstrap.properties.DruidProperties;
import cn.smarthse.wqyy.bootstrap.properties.EmailProperties;
import cn.smarthse.wqyy.bootstrap.properties.SysProperties;
import cn.smarthse.wqyy.bootstrap.properties.TaskExecutorProperties;
import java.util.Properties;
import lombok.Generated;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@ComponentScan(basePackages={"cn.smarthse.wqyy"})
@Configuration
@EnableConfigurationProperties(value={OssClientProperties.class, EmailProperties.class, DruidProperties.class, TaskExecutorProperties.class, SysProperties.class})
public class ContentConfiguration
extends BaseConfiguration {
    private final EmailProperties emailProperties;
    private final TaskExecutorProperties taskExecutorProperties;

    @Bean
    public ThreadPoolTaskExecutor taskExecutor() {
        this.logger.info("\u914d\u7f6eThreadPoolTaskExecutor");
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setThreadNamePrefix(this.taskExecutorProperties.getThreadNamePrefix());
        executor.setCorePoolSize(this.taskExecutorProperties.getCore_pool_size());
        executor.setQueueCapacity(this.taskExecutorProperties.getQueue_capacity());
        executor.setMaxPoolSize(this.taskExecutorProperties.getMax_pool_size());
        executor.setKeepAliveSeconds(this.taskExecutorProperties.getKeep_alive_seconds());
        executor.setRejectedExecutionHandler((r, executor1) -> this.logger.error("\u7ebf\u7a0b\u6c60\u5df2\u6ee1\uff0c\u65e0\u6cd5\u6267\u884c\u65b0\u4efb\u52a1\uff0c\u4efb\u52a1\u4e22\u5f03"));
        executor.initialize();
        return executor;
    }

    @Bean(value={"emailTemplate"})
    public JavaMailSenderImpl getJavaMailSenderImpl() {
        this.logger.info("\u914d\u7f6e JavaMailSenderImpl {}", (Object)this.emailProperties);
        JavaMailSenderImpl emailTemplate = new JavaMailSenderImpl();
        emailTemplate.setDefaultEncoding(this.emailProperties.getDefault_encoding());
        emailTemplate.setHost(this.emailProperties.getHost());
        emailTemplate.setPort(this.emailProperties.getPort());
        emailTemplate.setUsername(this.emailProperties.getUsername());
        emailTemplate.setPassword(this.emailProperties.getPassword());
        Properties javaMailProperties = new Properties();
        javaMailProperties.setProperty("mail.smtp.auth", "true");
        javaMailProperties.setProperty("mail.smtp.timeout", "25000");
        javaMailProperties.put("mail.smtp.starttls.enable", (Object)true);
        javaMailProperties.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        emailTemplate.setJavaMailProperties(javaMailProperties);
        return emailTemplate;
    }

    @Generated
    public ContentConfiguration(EmailProperties emailProperties, TaskExecutorProperties taskExecutorProperties) {
        this.emailProperties = emailProperties;
        this.taskExecutorProperties = taskExecutorProperties;
    }
}

