/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.wqyy.validator;

import cn.smarthse.wqyy.model.param.appointment.ItemInfo;
import cn.smarthse.wqyy.validator.annotation.TotalNumNotZero;
import java.util.List;
import java.util.Objects;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class AppointmentValidator
implements ConstraintValidator<TotalNumNotZero, List<ItemInfo>> {
    public void initialize(TotalNumNotZero constraintAnnotation) {
    }

    public boolean isValid(List<ItemInfo> value, ConstraintValidatorContext constraintValidatorContext) {
        if (value == null) {
            return false;
        }
        long count = value.stream().peek(itemInfo -> {
            if (Objects.isNull(itemInfo.getTotalNum())) {
                itemInfo.setTotalNum(0);
            }
        }).mapToInt(ItemInfo::getTotalNum).sum();
        return count > 0L;
    }
}

