package cn.smarthse.wqyy.validator;

import cn.smarthse.wqyy.model.param.appointment.ItemInfo;
import cn.smarthse.wqyy.validator.annotation.TotalNumNotZero;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.List;
import java.util.Objects;

/**
 * @ author Supw
 * @ since 2023/9/15 15:52
 */
public class AppointmentValidator implements ConstraintValidator<TotalNumNotZero, List<ItemInfo>> {
    @Override
    public void initialize(TotalNumNotZero constraintAnnotation) {
    }
    
    @Override
    public boolean isValid(List<ItemInfo> value, ConstraintValidatorContext constraintValidatorContext) {
        if (value == null){
            return false;
        }
        long count = value.stream().peek(itemInfo -> {
            if (Objects.isNull(itemInfo.getTotalNum())) itemInfo.setTotalNum(0);
        }).mapToInt(ItemInfo::getTotalNum).sum();
        return count > 0;
    }
}