package cn.smarthse.wqyy.provider.third;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.wqyy.entity.wqyy.WqyyAppointment;
import cn.smarthse.wqyy.model.param.subscribe.*;
import cn.smarthse.wqyy.model.vo.subscribe.*;

public interface IWqyySubscribeProviderToThirdService {

    /**
     * 列表
     *
     * @param param
     * @return {@link JqGridData<WqyySubscribeVo>}
     * @author ShenZQ
     * @since 2023/8/24 10:12
     */
    JqGridData<WqyyAppointment> getSubscribeDataList(WqyySubscribeSearchParam param);

    /**
     * 获取某天的预约情况
     *
     * @param param
     * @return {@link WqyyScheduleVo}
     * @author ShenZQ
     * @since 2023/8/24 11:12
     */
    WqyyScheduleVo getAllCompanyListByTime(WqyyScheduleSearchParam param);

    /**
     * 修改警戒值
     *
     * @param param
     * @return {@link Boolean}
     * @author ShenZQ
     * @since 2023/8/24 15:45
     */
    Boolean changeForbiddenLine(WqyyOrgChangeParam param);

    /**
     * 修改某天的营业状态
     *
     * @param param
     * @return {@link Boolean}
     * @author ShenZQ
     * @since 2023/8/24 16:07
     */
    Boolean changeBusinessStatueByTime(WqyyBusinessStatueChangeParam param);

    /**
     * 预约详情
     *
     * @param id
     * @return {@link WqyyScheduleDetailVo}
     * @author ShenZQ
     * @since 2023/8/24 16:20
     */
    WqyyScheduleDetailVo getSubscribeDataDetail(Long id);

    /**
     * 获取警戒值
     *
     * @param orgId
     * @return {@link WqyyForbiddenLineVo}
     * @author ShenZQ
     * @since 2023/8/28 14:43
     */
    WqyyForbiddenLineVo getForbiddenLine(Long orgId);

    /**
     * 预约详情——修改日期
     *
     * @param param
     * @return {@link Boolean}
     * @author ShenZQ
     * @since 2023/8/24 16:45
     */
    Boolean changeSubscribe(WqyySubscribeChangeParam param);

    /**
     * 预约确认
     *
     * @param param
     * @return {@link Boolean}
     * @author ShenZQ
     * @since 2023/8/24 17:29
     */
    Boolean confirm(WqyyConfirmParam param);

    /**
     * 预约日程数据按月
     *
     * @param param
     * @return {@link WqyySubscribeDataVo}
     * @author ShenZQ
     * @since 2023/8/24 17:37
     */
    WqyySubscribeDataVo getSubscribeDataByMonth(WqyyScheduleSearchParam param);

    /**
     * 获取某天的营业状态
     *
     * @param param
     * @return {@link Integer}
     * @author ShenZQ
     * @since 2023/8/29 8:56
     */
    Integer getBusinessStatueByTime(WqyyScheduleSearchParam param);

    /**
     * 判断该机构是否有卫企预约基础数据
     *
     * @param loginUserThirdOrgId
     * @return {@link Boolean}
     * @author ShenZQ
     * @since 2023/9/4 15:39
     */
    Boolean basicDataIsComplete(Long loginUserThirdOrgId);

}
