package cn.smarthse.wqyy.provider.third;

import cn.smarthse.wqyy.entity.wqyy.WqyyOrganizationContact;
import cn.smarthse.wqyy.model.param.org.WqyyOrganizationContactParam;
import cn.smarthse.wqyy.model.param.org.WqyyOrganizationParam;
import cn.smarthse.wqyy.model.vo.org.WqyyOrganizationCheckTypeVo;
import cn.smarthse.wqyy.model.vo.org.WqyyOrganizationContactVo;
import cn.smarthse.wqyy.model.vo.org.WqyyOrganizationVo;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;

import javax.smarthse.exception.ServiceException;
import java.util.List;
import java.util.Map;

public interface IWqyyOrganizationProviderToThirdService {
    /**
     * @description: 查询当前机构信息
     * @version: VERSION
     * @date: 2023/8/24 10:14
     * @param: currentLoginOrgId, currentUserId, fillAgain 点击重新填写，展示提交审核的内容，否则展示上一次通过审核的内容
     * @return: {@link WqyyOrganizationVo}
     * @author: DengJia 18402894534@163.com
     */
    WqyyOrganizationVo queryOrganizationData(Long currentLoginOrgId, Long currentUserId, boolean fillAgain);

    /**
     * @description: 修改机构（直接保存）
     * @version: VERSION
     * @date: 2023/8/24 15:25
     * @param: organizationParam
     * @return: void
     * @author: DengJia 18402894534@163.com
     */
    Object insertOrUpdateOrganizationData(WqyyOrganizationParam organizationParam) throws ServiceException;

    /**
     * @description: 机构详细信息编辑（提交审核）
     * @version: VERSION
     * @date: 2023/9/14 17:31
     * @param: organizationParam
     * @return: {@link Object}
     * @author: DengJia 18402894534@163.com
     */
    Long editDetailAuditOrgData(WqyyOrganizationParam organizationParam) throws ServiceException;

    /**
     * @description: 删除联系人信息
     * @version: VERSION
     * @date: 2023/8/25 14:02
     * @param: concatId 联系人主键id
     * @return: void
     * @author: DengJia 18402894534@163.com
     */
    void deleteContactInfo(Long concatId, Long loginUserId);

    /**
     * @description: 机构信息编辑操作记录
     * @version: VERSION
     * @date: 2023/8/25 18:54
     * @param: organizationId
     * @return: {@link List<Object>}
     * @author: DengJia 18402894534@163.com
     */
    List<Object> queryOperateRecord(Long organizationId);

    /**
     * @description: 体检预约范围列表
     * @version: VERSION
     * @date: 2023/8/30 15:05
     * @param: -
     * @return: {@link List< WqyyOrganizationCheckTypeVo >}
     * @author: DengJia 18402894534@163.com
     */
    List<Map<String, String>> queryCheckTypeList();

    /**
     * @description: 新增 / 编辑联系人信息
     * @version: VERSION
     * @date: 2023/9/18 11:25
     * @param: concat 联系人信息入参
     * @return: void
     * @author: DengJia 18402894534@163.com
     */
    WqyyOrganizationContactVo manageContactInfo(WqyyOrganizationContactParam concat);

    WqyyOrganizationContactVo queryContactInfo(Long contactPk);

    List<WqyyOrganizationContact> queryDbConcatList(LambdaQueryWrapper<WqyyOrganizationContact> contactWrapper);

    List<WqyyOrganizationContact> queryDbConcatListByContactPk(Long contactPk, Long loginUserThirdOrgId);

    WqyyOrganizationContactVo queryDbConcatListByContactId(Long contactId, Long loginUserThirdOrgId);

    void deleteContactInfoByContactIdHard(Long concatId);
}
