package cn.smarthse.wqyy.provider.supervise;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.wqyy.entity.wqyy.WqyyOrganization;
import cn.smarthse.wqyy.model.param.org.WqyyOrganizationImportModel;
import cn.smarthse.wqyy.model.param.org.WqyyOrganizationParam;
import cn.smarthse.wqyy.model.vo.org.WqyyOrganizationCheckTypeVo;
import cn.smarthse.wqyy.model.vo.org.WqyyOrganizationVo;
import com.github.pagehelper.PageInfo;

import java.util.List;

public interface IWqyyOrganizationProviderToSuperviseService {

    /**
     * @description: 条件分页查询列表
     * @version: VERSION
     * @date: 2023/8/24 14:53
     * @param: param, organizationParam
     * @return: {@link PageInfo<WqyyOrganizationVo>}
     * @author: DengJia 18402894534@163.com
     */
    PageInfo<WqyyOrganizationVo> queryOrganizationData(JqGridParam param, WqyyOrganizationParam organizationParam);

    /**
     * 分页获取机构资料审核列表数据
     *
     * @param param    参数
     * @param orgParam org参数
     * @return {@link PageInfo}<{@link WqyyOrganizationVo}>
     */
    PageInfo<WqyyOrganizationVo> getPageOrgAuditBySearchModel(JqGridParam param, WqyyOrganizationParam orgParam);

    /**
     * @description: 主键精确查找(设置主键id)
     * @version: VERSION
     * @date: 2023/8/24 10:14
     * @param: id
     * @return: {@link WqyyOrganizationVo}
     * @author: DengJia 18402894534@163.com
     * @param orgParam
     */
    WqyyOrganizationVo queryOrganizationDataById(WqyyOrganizationParam orgParam);

    /**
     * 审核接口（提交审核、退回、通过时使用）
     *
     * @param orgId        org id
     * @param status       状态 cn.smarthse.wqyy.enums.WqyyStatusEnum
     * @param reason       原因
     * @param loginStaffId 登录员工id
     * @param operater     操作人
     * @return {@link String 成功 ：失败原因}
     */
    String changeOrgState(Long orgId, Integer status, String reason,Long loginStaffId,String operater);

    /**
     * @description: 体检预约范围列表
     * @version: VERSION
     * @date: 2023/8/30 15:04
     * @param: -
     * @return: {@link List<WqyyOrganizationCheckTypeVo>}
     * @author: DengJia 18402894534@163.com
     */
    List<WqyyOrganizationCheckTypeVo> queryCheckTypeList();

    int addOrgScoreInfoFromExcel(List<WqyyOrganizationImportModel> list, Long loginUserId);

    /**
     * @description: 通过机构名称查询卫企预约机构信息
     * @version: VERSION
     * @date: 2023/9/19 14:21
     * @param: organizationName 机构名称
     * @return: {@link WqyyOrganization} 机构信息
     * @author: DengJia 18402894534@163.com
     */
    WqyyOrganization getWqyyOrgInfoByName(String organizationName);

    /**
     * @description: 判断机构信用代码是否存在
     * @version: VERSION
     * @date: 2023/9/19 14:26
     * @param: creditCode 机构信信用代码
     * @return: {@link boolean} true存在 false不存在
     * @author: DengJia 18402894534@163.com
     */
    boolean checkOrgUsccIsExist(String creditCode);

    /**
     * 企业上架下架接口
     * @param param
     * @return {@link Integer}
     */
    Integer changeOrgIsShelves(WqyyOrganizationParam param);
}
