package cn.smarthse.wqyy.provider.supervise;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.wqyy.model.param.WqyyComplaintParam;
import cn.smarthse.wqyy.model.vo.WqyyComplaintVo;
import com.github.pagehelper.PageInfo;

public interface IWqyyComplaintServiceProviderToSuperviseService {
    /**
     * 监管和运维->卫企预约投诉列表查询
     *
     * @param jqGridParam 金桥网格参数
     * @param param       参数
     * @return {@link PageInfo}<{@link WqyyComplaintVo}>
     */
    PageInfo<WqyyComplaintVo> getPageComplaintBySearchModel(JqGridParam jqGridParam, WqyyComplaintParam param);

    /**
     * 通过投诉id查询详情
     *
     * @param complaintId 投诉id
     * @param complaintQueryType 投诉详情查询来源(1监管2运维)
     * @return {@link WqyyComplaintVo}
     */
    WqyyComplaintVo detailComplaintByComplaintId(Long complaintId,Integer complaintQueryType);

    /**
     * 改变投诉状态
     *
     * @param complaintId 投诉id
     * @param status      投诉状态(1草稿，2待审核，3退回，4已审核，5禁用账号)
     * @param reason
     * @param updateBy
     * @param operater
     * @return {@link String}
     */
    String changeComplaintState(Long complaintId, Integer status, String reason, Long updateBy, String operater);
}
