package cn.smarthse.wqyy.model.vo.subscribe;

import cn.smarthse.common.util.DateUtils;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
public class WqyyScheduleDetailVo implements Serializable {

    private static final long serialVersionUID = 1302158724377582520L;

    @ApiModelProperty(name = "type", value = "预约类型 (1-门诊,2-外检)")
    private Integer type;
    @ApiModelProperty(name = "status", value = "预约状态")
    private Integer status;
    @ApiModelProperty(name = "companyName", value = "企业名称")
    private String companyName;
    @ApiModelProperty(name = "companyAddress", value = "企业地址")
    private String companyAddress;
    @ApiModelProperty(name = "contactName", value = "企业联系人")
    private String contactName;
    @ApiModelProperty(name = "contactTel", value = "企业联系人电话")
    private String contactTel;
    @ApiModelProperty(name = "orgId", value = "体检机构id")
    private Long orgId;
    @ApiModelProperty(name = "orgCantactId", value = "机构联系人id")
    private Long orgCantactId;

    @ApiModelProperty("企业预约时间")
    private Date appointmentDate;
    private String appointmentWeek;
    @ApiModelProperty("机构变更体检时间")
    private Date changeDate;
    private String changeWeek;
    @ApiModelProperty("时间体检时间")
    private Date phyDate;
    private String phyWeek;

    @ApiModelProperty("体检人员信息")
    List<WqyyScheduleDetailItemVo> items;

    @ApiModelProperty("存在的职业病危害因素")
    List<WqyySubscribeHarmFactorVo> harmItems;

    public String getAppointmentWeek() {
        if (appointmentDate == null) {
            return null;
        }
        return DateUtils.getWeek(appointmentDate).getChineseName();
    }

    public String getChangeWeek() {
        if (changeWeek == null) {
            return null;
        }
        return DateUtils.getWeek(changeWeek).getChineseName();
    }

    public String getPhyWeek() {
        if (phyWeek == null) {
            return null;
        }
        return DateUtils.getWeek(phyWeek).getChineseName();
    }

}
