package cn.smarthse.wqyy.model.vo.subscribe;

import cn.smarthse.common.util.DateUtils;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

/**
 * @ClassName WqyyResponsivityVo
 * @Description TODO
 * @Author 曾华川
 * @Date 2023年12月26日 15:23
 **/
@Data
@ApiOperation(value = "体检预约响应率", tags = "体检预约响应率")
public class WqyyResponsivityVo implements Serializable {
    private static final long serialVersionUID = -2813862365966008334L;

    private Long areaId;
    private String areaName;
    private Byte areaLevel;

    private Date updateDate;

    private String updateDateStr;

    @ApiModelProperty("已接入机构数")
    private Integer accessNum;

    @ApiModelProperty("机构接入率")
    private String accessRate;

    @ApiModelProperty("体检预约次数")
    private Integer medicalExaminationNum;

    @ApiModelProperty("响应次数")
    private Integer responseNum;

    @ApiModelProperty("响应率")
    private String responseRate;

    @ApiModelProperty("机构id")
    private String orgId;

    @ApiModelProperty("机构名称")
    private String orgName;

    @ApiModelProperty("统一社会信用代码")
    private String unifiedSocialCc;

    @ApiModelProperty("联系人")
    private String contactName;

    @ApiModelProperty("联系方式")
    private String contactTel;

    @ApiModelProperty("机构总数")
    private String totalNums;

    public String getUpdateDateStr() {
        if (updateDate == null) {
            return "-";
        }
        return DateUtils.format(updateDate, "yyyy-MM-dd HH:mm:ss");
    }

    public String getAccessRate() {
        if (accessRate == null) {
            return "-";
        }
        return accessRate + "%";
    }

    public String getResponseRate() {
        if (responseRate == null) {
            return "-";
        }
        return responseRate + "%";
    }
}
