package cn.smarthse.wqyy.model.vo.org;

import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @Author: DengJia
 * @Date: 2023/8/22
 * @Description:
 */

@Data
@ApiModel("卫企预约机构信息 Vo")
public class WqyyOrganizationVo implements Serializable {

    private static final long serialVersionUID = 7479882935026781580L;
    /**
     * 主键id;主键id
     */
    @ApiModelProperty(value = "主键id;主键id")
    private Long id;

    /**
     * 机构id
     */
    @ApiModelProperty(value = "机构id")
    private Long orgId;

    /**
     * 统一社会信用代码
     */
    @ApiModelProperty(value = "统一社会信用代码")
    private String uscc;

    /**
     * 机构名称
     */
    @ApiModelProperty(value = "机构名称")
    private String organizationName;

    /**
     * 机构所在区域id
     */
    @ApiModelProperty(value = "机构所在区域id")
    private Long areaId;

    /**
     * 机构所在区域名称,/分隔
     */
    @ApiModelProperty(value = "机构所在区域名称,/分隔")
    private String areaName;

    /**
     * 机构详细机构地址
     */
    @ApiModelProperty(value = "机构详细机构地址")
    private String organizationAddress;
    private String orgDetailArea;

    /**
     * 是否总部;0否1是
     */
    @ApiModelProperty(value = "是否总部;0否1是")
    private Boolean isMaster;

    /**
     * 总部id;wqyy_organization.id
     */
    @ApiModelProperty(value = "总部id;wqyy_organization.id")
    private Long organizationMasterId;

    /**
     * 已服务企业数
     */
    @ApiModelProperty(value = "已服务企业数")
    private Integer servedEnterprises;

    /**
     * 机构分数
     */
    @ApiModelProperty(value = "机构分数")
    private BigDecimal organizationScore;

    /**
     * 营业时间;周一至周天逗号分隔 如1,2,3,4,5
     */
    @ApiModelProperty(value = "营业时间;周一至周天逗号分隔 如1,2,3,4,5")
    private String openingTime;

    /**
     * 营业时间列表 label, value
     */
    @ApiModelProperty(value = "营业时间列表 label, value")
    private List<Map<String, String>> openingTimeList;

    /**
     * 体检开始时间;例9:00
     */
    @ApiModelProperty(value = "体检开始时间;例9:00")
    private String checkBeginTime;

    /**
     * 体检结束时间;例17:00
     */
    @ApiModelProperty(value = "体检结束时间;例17:00")
    private String checkEndTime;

    /**
     * 采血开始时间;例9:00
     */
    @ApiModelProperty(value = "采血开始时间;例9:00")
    private String bloodBeginTime;

    /**
     * 采血结束时间;例11:00
     */
    @ApiModelProperty(value = "采血结束时间;例11:00")
    private String bloodEndTime;

    /**
     * 7天内是否可预约;0不可1可
     */
    @ApiModelProperty(value = "7天内是否可预约;0不可1可")
    private Boolean applyIn7Days;

    /**
     * 是否可外出体检;0不可1可
     */
    @ApiModelProperty(value = "是否可外出体检;0不可1可")
    private Boolean outCheck;

    /**
     * 机构简介
     */
    @ApiModelProperty(value = "机构简介")
    private String organizationIntro;

    /**
     * 机构列表缩略图;文件id
     */
    @ApiModelProperty(value = "机构列表缩略图;文件id")
    private String orgListImg;

    /**
     * 机构列表缩略图;文件名称
     */
    @ApiModelProperty(value = "机构列表缩略图;文件名称")
    private String orgListImgName;

    /**
     * 机构列表缩略图;文件OssUrl
     */
    @ApiModelProperty(value = "机构列表缩略图;文件id")
    private String orgListImgOssUrl;

    /**
     * 机构详情展示图;文件id逗号分隔
     */
    @ApiModelProperty(value = "机构详情展示图;文件id逗号分隔")
    private String orgDetailImg;

    /**
     * 机构详情展示图,地址列表
     */
    @ApiModelProperty(value = "机构详情展示图,地址列表")
    private List<String> orgDetailImgOssUrls;


    /**
     * 机构详情展示图,图片信息
     */
    @ApiModelProperty(value = "机构详情展示图,图片信息")
    private List<SysFileModel> orgDetailImgBeanList;

    /**
     * 体检范围,id逗号分隔
     */
    @ApiModelProperty(value = "体检范围,id逗号分隔")
    private String concatCheckType;

    /**
     * 体检范围,名称逗号分隔
     */
    @ApiModelProperty(value = "体检范围,名称逗号分隔")
    private String concatCheckTypeName;

    /**
     * 总联系人信息
     */
    @ApiModelProperty(value = "总联系人信息")
    private WqyyOrganizationContactVo masterContact;

    /**
     * 联系人信息列表
     */
    @ApiModelProperty(value = "联系人信息列表")
    private List<WqyyOrganizationContactVo> contactList;

    /**
     * 服务范围
     */
    @ApiModelProperty(value = "服务范围")
    private String serviceScope;

    /**
     * 体检范围列表
     */
    @ApiModelProperty(value = "体检范围列表")
    private List<WqyyOrganizationCheckTypeVo> checkTypeList;

    /**
     * 是否有效;0无效1有效
     */
    @ApiModelProperty(value = "是否有效;0无效1有效")
    private Boolean isValid;

    /**
     * 创建人
     */
    @ApiModelProperty(value = "创建人")
    private String createBy;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @ApiModelProperty(value = "最后修改人ID")
    private String updatedBy;

    /**
     * 最后修改时间
     */
    @ApiModelProperty(value = "最后修改时间")
    private Date updateDate;


    /**
     * 预约人数警戒线
     */
    @ApiModelProperty(value = "预约人数警戒线")
    private Integer forbiddenLineOfPeople;

    /**
     * 预约企业警戒线
     */
    @ApiModelProperty(value = "预约企业警戒线")
    private Integer forbiddenLineOfEnterprises;

    /**
     * 预约出车警戒线
     */
    @ApiModelProperty(value = "预约出车警戒线")
    private Integer forbiddenLineOfVehicles;

    /**
     * 审核状态 1草稿，2待审核，3退回，4已审核，5禁用账号
     */
    @ApiModelProperty(value = "审核状态 1草稿，2待审核，3退回，4已审核，5禁用账号")
    private Byte auditStatus;

    /**
     * 主表机构主键id（wqyy_organization.id）用于审核中副本表关联主表信息
     */
    @ApiModelProperty(value = "主表机构主键id（wqyy_organization.id）用于审核中副本表关联主表信息")
    private Long masterOrganizationId;

    /**
     * 标记类型;0原表，1副本表，2退回上报之后的历史数据表（退回时用）
     */
    @ApiModelProperty(value = "标记类型;0原表，1副本表，2退回上报之后的历史数据表（退回时用）")
    private Integer flag;

    /**
     * 当前机构是否审核通过的前提被退回（不属于：第一次审核被退回or一开始就连续多次审核被退回。而是之前有过审核通过的记录，只是这一次被退回了。）
     * 此参数用于前端判断用。true：展示`重新填写`；false：不展示`重新填写`。
     * 点击重新填写，展示提交审核的内容，否则展示上一次通过审核的内容。
     */
    @Deprecated
    private Boolean isNowOrgAuditReject = false;

    /**
     * 当前机构是否是第一次审核
     */
    private Boolean isFirstAudit;

    @ApiModelProperty(value = "是否上下架：0下架，1上架")
    private Integer isShelves;

    /**
     * 操作记录提交时间
     */
    private Date operateCommitTime;

    /**
     * 查询大于等于3天未登录
     */
    private Boolean notLog3;

    /**
     * 最近登录日期
     */
    private Date maxLoginDate;

    /**
     * 监督单位id
     */
    private Long supervisionUnit;

    /**
     * 监督单位名称
     */
    private String supervisionName;

    /**
     * 监督单位区域
     */
    private Long supervisionAreaId;

    /**
     * 服务区域
     */
    private String serviceArea;

    /**
     * 下架原因
     */
    private String reason;

    /**
     * 当前搜索的入参区域id
     */
    private Long searchAreaId;

    /**
     * 接入状态
     * 1 -> 已接入
     * 0 -> 未接入
     */
    private Integer accessState;
}
