package cn.smarthse.wqyy.model.vo.org;

import cn.smarthse.modules.health.entity.sys.SysArea;
import cn.smarthse.modules.platform.model.AreaModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Author: DengJia
 * @Date: 2023/8/23
 * @Description:
 */

@Data
@ApiModel("卫企预约机构联系信息 Vo")
public class WqyyOrganizationContactVo implements Serializable {

    private static final long serialVersionUID = 2762294918825688623L;
    /**
     * 主键id
     */
    @ApiModelProperty(value = "主键id")
    private Long id;

    /**
     * 机构id;wqyy_organization.id
     */
    @ApiModelProperty(value = "机构id;wqyy_organization.id")
    private Long organizationId;

    /**
     * 总负责人;0否1是
     */
    @ApiModelProperty(value = "总负责人;0否1是")
    private Boolean isMaster;

    /**
     * 联系人id
     */
    @ApiModelProperty(value = "联系人id")
    private Long contactId;

    /**
     * 联系人
     */
    @ApiModelProperty(value = "联系人")
    private String contact;

    /**
     * 联系电话
     */
    @ApiModelProperty(value = "联系电话")
    private String phone;

    /**
     * 联系人负责区域id
     */
    @ApiModelProperty(value = "联系人负责区域id")
    private Long areaId;

    /**
     * 联系人负责区域名称,/分隔
     */
    @ApiModelProperty(value = "联系人负责区域名称,/分隔")
    private String areaName;

    /**
     * 是否有效;0无效1有效
     */
    @ApiModelProperty(value = "是否有效;0无效1有效")
    private Boolean isValid;

    /**
     * 创建人
     */
    @ApiModelProperty(value = "创建人")
    private String createBy;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @ApiModelProperty(value = "最后修改人ID")
    private String updatedBy;

    /**
     * 最后修改时间
     */
    @ApiModelProperty(value = "最后修改时间")
    private Date updateDate;

    /**
     * 此联系人是否为当前区域联系人
     */
    private Boolean isNowAreaConcat;

    /**
     * 联系人区域列表
     */
    private List<SysArea> areaList;

}
