package cn.smarthse.wqyy.model.vo.appointment;

import cn.smarthse.common.util.DateUtils;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.Objects;

/**
 * @ author Supw
 * @ since 2023/8/24 10:43
 */
@Data
public class StatusAndChangeDateInfo implements java.io.Serializable {

    @ApiModelProperty(name = "status",value = "状态(1-预约中,2-体检完成,3-企业未赴约)")
    private Integer status;
    @ApiModelProperty(name = "changeDate",value = "修改后的预约时间")
    private Date changeDate;
    @ApiModelProperty(name = "changeWeek",value = "修改后的周几")
    private Date changeWeek;


    public String getChangeWeek() {
        if (Objects.isNull(changeDate)) return null;
        return DateUtils.getWeek(changeDate).getChineseName();
    }
}
