package cn.smarthse.wqyy.model.vo.appointment;

import cn.smarthse.common.util.DateUtils;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.Objects;

/**
 * @ author Supw
 * @ since 2023/8/24 9:24
 */
@Data
public class RecordInfo implements java.io.Serializable{
    @ApiModelProperty(name = "appointmentId",value = "预约id")
    private Long appointmentId;
    @ApiModelProperty(name = "orgName",value = "机构名字")
    private String orgName;
    @ApiModelProperty(name = "appointmentDate",value = "预约时间")
    private Date appointmentDate;
    @ApiModelProperty(name = "week",value = "周几")
    private String week;
    @ApiModelProperty(name = "appointmentNum",value = "预约人数")
    private Integer appointmentNum;
    @ApiModelProperty(name = "status",value = "状态(1-预约中,2-体检完成,3-企业未赴约)")
    private Integer status;
    @ApiModelProperty(name = "isDateChanged",value = "预约时间是否被修改")
    private Boolean isDateChanged=false;

    private Date changeDate;


    public String getWeek() {
        if (Objects.isNull(appointmentDate)) return null;
        return DateUtils.getWeek(appointmentDate).getChineseName();
    }


//    public String getChangeWeek() {
//        if (Objects.isNull(changeWeek)) return null;
//        return DateUtils.getWeek(changeWeek).getChineseName();
//        return changeWeek;
//    }
}
