package cn.smarthse.wqyy.model.vo.appointment;

import cn.smarthse.common.util.DateUtils;
import cn.smarthse.wqyy.model.param.appointment.ItemInfo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * @ author Supw
 * @ since 2023/8/23 15:19
 */
@Data
public class AppointmentInfo implements java.io.Serializable{

    @ApiModelProperty(name = "appointmentId",value = "预约id")
    private Long appointmentId;
    @ApiModelProperty(name = "type",value = "预约类型(1-门诊，2-外检)")
    private Integer type;
    @ApiModelProperty(name = "status",value = "预约状态")
    private Integer status;
    @ApiModelProperty(name = "companyName",value = "企业名称")
    private String companyName;
    @ApiModelProperty(name = "companyAddress",value = "企业地址")
    private String companyAddress;
    @ApiModelProperty(name = "contactName",value = "企业联系人")
    private String contactName;
    @ApiModelProperty(name = "contactTel",value = "企业联系人电话")
    private String contactTel;
    @ApiModelProperty(name = "orgId",value = "体检机构id")
    private Long orgId;
    @ApiModelProperty(name = "orgCantactAreaId",value = "机构联系人id")
    private Long orgCantactAreaId;
    @ApiModelProperty(name = "appointmentDate",value = "企业预约时间")
    private Date appointmentDate;
    @ApiModelProperty(name = "changeDate",value = "机构变更体检时间")
    private Date changeDate;
    @ApiModelProperty(name = "phyDate",value = "时间体检时间")
    private Date phyDate;


    @ApiModelProperty(name = "appointmentWeek",value = "企业预约周几")
    private String appointmentWeek;
    @ApiModelProperty(name = "changeWeek",value = "机构变更体检周几")
    private String changeWeek;

    @ApiModelProperty(name = "items",value = "体检人员信息")
    List<ItemInfo> items;

    public String getChangeWeek() {
        if (Objects.isNull(changeDate) || DateUtils.isSameDay(changeDate,appointmentDate)) return null;
        return DateUtils.getWeek(changeDate).getChineseName();
    }

    public String getAppointmentWeek() {
        if (Objects.isNull(appointmentDate)) return null;
        return DateUtils.getWeek(appointmentDate).getChineseName();
    }

    public Date getChangeDate() {
        if (DateUtils.isSameDay(changeDate,appointmentDate)){
            return null;
        }
        return changeDate;
    }

}
