package cn.smarthse.wqyy.model.vo.appointment;

import cn.smarthse.common.util.DateUtils;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.Objects;

/**
 * @ author Supw
 * @ since 2023/8/23 15:19
 */
@Data
public class AppointmentDateItem implements java.io.Serializable{
    @ApiModelProperty(name = "date",value = "预约时间")
    private Date scheduleDate;
    @ApiModelProperty(name = "week",value = "周几")
    private String week;
    @ApiModelProperty(name = "alreadyBookedNum",value = "已经预约的人数")
    private Integer alreadyBookedNum=0;
    @ApiModelProperty(name = "carNum",value = "已经预约的车数")
    private Integer carNum;
    @ApiModelProperty(name = "canBooked",value = "是否可以预约")
    private Boolean canBooked;
    @ApiModelProperty(name = "isChoose",value = "已选择")
    private Boolean isChoose =false;

    public String getWeek() {
        if (Objects.isNull(scheduleDate)) return null;
        return DateUtils.getWeek(scheduleDate).getChineseName();
    }
}
