package cn.smarthse.wqyy.model.vo.activation;

import cn.smarthse.common.util.DateUtils;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class WqyyActivationIndexVo implements Serializable {

    private static final long serialVersionUID = 7622079800166445762L;

    private Long areaId;
    private String areaName;
    private Byte areaLevel;

    private Date updateDate;
    private String updateDateStr;

    @ApiModelProperty(value = "已接入机构")
    private Integer accessNums = 0;

    @ApiModelProperty(value = "未接入机构")
    private Integer noAccessNums = 0;

    @ApiModelProperty(value = "总机构")
    private Integer totalNums = 0;

    /**
     * 总机构字符串 逗号分隔
     */
    private String totalIdStr;

    @ApiModelProperty(value = "机构接入率")
    private String accessRate;

    @ApiModelProperty(value = "离线机构")
    private Integer offlineDurationNums = 0;

    @ApiModelProperty(value = "无基础数据机构")
    private Integer noHasBaseNums = 0;

    public String getUpdateDateStr() {
        if (updateDate == null) {
            return null;
        }
        return DateUtils.format(updateDate, "yyyy-MM-dd HH:mm:ss");
    }

}
