package cn.smarthse.wqyy.model.vo.activation;

import cn.smarthse.common.util.DateUtils;
import lombok.Data;

import java.io.Serializable;
import java.time.Duration;
import java.util.Date;

@Data
public class WqyyActivationDetailVo implements Serializable {

    private static final long serialVersionUID = -5490023596012959552L;

    private Long orgId;

    private String orgName;

    private String uscc;

    private String contact;

    private String phone;

    private Date updateDate;
    private String updateDateStr;

    private Integer isLogin = 0;
    private String isLoginStr;

    /**
     * 离线多少纳秒
     */
    private Long offlineDuration = null;
    private String offlineDurationTime;

    /**
     * 是否已经接入
     */
    private Integer isAccess = 0;

    /**
     * 1:大于等于3天
     * 0:小于3天
     */
    private Integer disconnect = null;

    /**
     * 1:有基础信息
     * 0:无基础信息
     */
    private Integer hasBase = 0;

    public String getUpdateDateStr() {
        if (updateDate == null) {
            return "-";
        }
        return DateUtils.format(updateDate, "yyyy-MM-dd HH:mm:ss");
    }

    public Integer getTodayLoginStatus() {
        if (updateDate == null) {
            return 0;
        }
        return DateUtils.isSameDay(new Date(), updateDate) ? 1 : 0;
    }

    public String getIsLoginStr() {
        if (isLogin == null) {
            return "未登录";
        }
        return isLogin == 1 ? "已登录" : "未登录";
    }

    public String getOfflineDurationTime() {
        if (offlineDuration == null) {
            return "-";
        }

        Duration duration = Duration.ofNanos(offlineDuration);

        return duration.toDays() + "天" + duration.toHours() % 24 + "小时";
    }

}
