package cn.smarthse.wqyy.model.vo;

import cn.smarthse.wqyy.model.vo.org.WqyyOrganizationVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 体检机构举报信息表(WqyyComplaint)表实体类
 *
 * @author zhangxu
 * @since 2023-08-24 08:58:56
 */
@Data
@ApiModel(value = "体检机构举报信息表Vo(WqyyComplaint)")
@SuppressWarnings("serial")
public class WqyyComplaintExportVo implements Serializable {

    private static final long serialVersionUID = -93253614038294737L;

    /**
     * id
     */
    @ApiModelProperty(value = "id")
    private Long id;
    /**
     * 投诉机构id
     */
    @ApiModelProperty(value = "投诉机构id")
    private Long complaintOrgId;

    /**
     * 投诉机构名字
     */
    @ApiModelProperty(value = "投诉机构名字")
    private String orgName;

    /**
     * 投诉机构详细地址
     */
    @ApiModelProperty(value = "投诉机构详细地址")
    private String orgAddress;

    /**
     * 投诉机构联系人
     */
    @ApiModelProperty(value = "投诉机构联系人")
    private String orgContact;

    /**
     * 投诉机构电话
     */
    @ApiModelProperty(value = "投诉机构电话")
    private String orgPhone;

    /**
     * 投诉企业(那个企业投诉的)
     */
    @ApiModelProperty(value = "投诉企业(那个企业投诉的)")
    private Long complaintCid;

    /**
     * 投诉企业名字
     */
    @ApiModelProperty(value = "投诉企业名字")
    private String companyName;

    /**
     * 投诉企业详细地址
     */
    @ApiModelProperty(value = "投诉企业详细地址")
    private String companyAreaDetail;

    /**
     * 职业卫生管理电话
     */
    private String occManagerTel;
    /**
     * 职业卫生管理人员名字
     */
    private String occManagerName;

    /**
     * 投诉类型
     */
    @ApiModelProperty(value = "投诉类型(见枚举类型 WqyyComplaintTypeEnum)")
    private String complaintType;
    /**
     * 投诉内容
     */
    @ApiModelProperty(value = "投诉内容")
    private String complaintContent;
    /**
     * 投诉状态(1草稿，2待审核，3退回，4已审核，5禁用账号)
     */
    @ApiModelProperty(value = "投诉状态(1草稿，2待审核，3退回，4已审核，5禁用账号)")
    private Integer status;
    /**
     * 创建人
     */
    @ApiModelProperty(value = "创建人")
    private Long createBy;
    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private Date createDate;
    /**
     * 最后修改人
     */
    @ApiModelProperty(value = "最后修改人")
    private Long updateBy;
    /**
     * 最后修改时间
     */
    @ApiModelProperty(value = "最后修改时间")
    private Date updateDate;
    /**
     * 是否有效
     */
    @ApiModelProperty(value = "是否有效")
    private Boolean isValid;

    /**
     * 卫企预约的机构详情
     */
    @ApiModelProperty(value = "卫企预约的机构详情")
    private WqyyOrganizationVo wqyyOrganizationVo;

}
