package cn.smarthse.wqyy.model.param.org;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.springframework.lang.Nullable;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * @Author: DengJia
 * @Date: 2023/8/22
 * @Description:
 */

@Data
@ApiModel("卫企预约机构信息 Param")
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class WqyyOrganizationParam implements Serializable {

    private static final long serialVersionUID = -9074048523713226771L;

    /**
     * 主键id;主键id
     */
    @ApiModelProperty(value = "主键id;主键id")
    private Long id;

    /**
     * 机构id
     */
    @ApiModelProperty(value = "机构id")
    private Long orgId;

    /**
     * 当前登录机构id
     */
    @ApiModelProperty(value = "当前登录机构id")
    private Long currentLoginOrgId;
    private String currentLoginOrgName;

    /**
     * 统一社会信用代码
     */
    @ApiModelProperty(value = "统一社会信用代码")
    private String uscc;

    /**
     * 机构名称
     */
    @ApiModelProperty(value = "机构名称")
    private String organizationName;

    /**
     * 当前登录者所在区域id
     */
    @ApiModelProperty(value = "当前登录者所在区域id")
    private Long currentLoginAreaId;

    /**
     * 当前登录者id
     */
    @ApiModelProperty(value = "当前登录者id")
    private Long currentLoginUserId;
    private String currentLoginUserName;

    /**
     * 机构所在区域id
     */
    @ApiModelProperty(value = "机构所在区域id")
    private Long areaId;

    /**
     * 机构所在区域等级
     */
    @ApiModelProperty(value = "机构所在区域等级")
    private Byte areaLevel;

    /**
     * 机构详细机构地址
     */
    @ApiModelProperty(value = "机构详细机构地址")
    private String organizationAddress;

    /**
     * 是否总部;0否1是
     */
    @ApiModelProperty(value = "是否总部;0否1是")
    private Boolean isMaster;

    /**
     * 总部id;wqyy_organization.id
     */
    @ApiModelProperty(value = "总部id;wqyy_organization.id")
    private Long organizationMasterId;

    /**
     * 已服务企业数
     */
    @ApiModelProperty(value = "已服务企业数")
    private Integer servedEnterprises;

    /**
     * 机构分数
     */
    @ApiModelProperty(value = "机构分数")
    private BigDecimal organizationScore;

    /**
     * 营业时间;周一至周天逗号分隔 如1,2,3,4,5
     */
    @ApiModelProperty(value = "营业时间;周一至周天逗号分隔 如1,2,3,4,5")
    private String openingTime;

    /**
     * 营业时间列表
     */
    @ApiModelProperty(value = "营业时间列表")
    private List<String> openingTimeList;

    /**
     * 体检开始时间;例9:00
     */
    @ApiModelProperty(value = "体检开始时间;例9:00")
    private String checkBeginTime;

    /**
     * 体检结束时间;例17:00
     */
    @ApiModelProperty(value = "体检结束时间;例17:00")
    private String checkEndTime;

    /**
     * 采血开始时间;例9:00
     */
    @ApiModelProperty(value = "采血开始时间;例9:00")
    private String bloodBeginTime;

    /**
     * 采血结束时间;例11:00
     */
    @ApiModelProperty(value = "采血结束时间;例11:00")
    private String bloodEndTime;

    /**
     * 7天内是否可预约;0不可1可
     */
    @ApiModelProperty(value = "7天内是否可预约;0不可1可")
    private Boolean applyIn7Days;

    /**
     * 是否可外出体检;0不可1可
     */
    @ApiModelProperty(value = "是否可外出体检;0不可1可")
    private Boolean outCheck;

    /**
     * 机构简介
     */
    @ApiModelProperty(value = "机构简介")
    private String organizationIntro;

    /**
     * 机构列表缩略图;文件id
     */
    @ApiModelProperty(value = "机构列表缩略图;文件id")
    private String orgListImg;

    /**
     * 机构详情展示图;文件id逗号分隔
     */
    @ApiModelProperty(value = "机构详情展示图;文件id逗号分隔")
    private String orgDetailImg;

    /**
     * 体检范围,id逗号分隔（查询此体检范围内的机构信息列表），条件查询入参
     */
    @ApiModelProperty(value = "体检范围,id逗号分隔（查询此体检范围内的机构信息列表），条件查询入参")
    private String concatCheckType;

    /**
     * 审核状态;(1草稿，2待审核，3退回，4已审核，5禁用账号)WqyyStatusEnum
     */
    @ApiModelProperty(value = "审核状态;(1草稿，2待审核，3退回，4已审核，5禁用账号)WqyyStatusEnum")
    private Byte auditStatus;

    /**
     * 总联系人信息
     */
    @ApiModelProperty(value = "总联系人信息")
    private WqyyOrganizationContactParam masterContact;

    /**
     * 联系人信息列表
     */
    @ApiModelProperty(value = "联系人信息列表")
    @Nullable
    private List<WqyyOrganizationContactParam> contactList;

    /**
     * 体检范围列表
     */
    @ApiModelProperty(value = "体检范围列表")
    @Nullable
    private List<WqyyOrganizationCheckTypeParam> checkTypeList;

    /**
     * 关键字
     */
    @ApiModelProperty(value = "关键字")
    private String keyword;

    /**
     * 预约人数警戒线
     */
    @ApiModelProperty(value = "预约人数警戒线")
    private Integer forbiddenLineOfPeople;

    /**
     * 预约企业警戒线
     */
    @ApiModelProperty(value = "预约企业警戒线")
    private Integer forbiddenLineOfEnterprises;

    /**
     * 预约出车警戒线
     */
    @ApiModelProperty(value = "预约出车警戒线")
    private Integer forbiddenLineOfVehicles;

    /**
     * 此次请求是否仅仅是添加联系人信息 isAddContact
     * true：新增联系人请求
     * false或null或不传：点击提交审核请求
     */
    private Boolean isAddContact;

    /**
     * 是否有效;0无效1有效
     */
    @ApiModelProperty(value = "是否有效;0无效1有效")
    private Boolean isValid;

    /**
     * 创建人
     */
    @ApiModelProperty(value = "创建人")
    private String createBy;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @ApiModelProperty(value = "最后修改人ID")
    private String updatedBy;

    /**
     * 最后修改时间
     */
    @ApiModelProperty(value = "最后修改时间")
    private Date updateDate;

    /**
     * 操作记录提交时间
     */
    @ApiModelProperty(value = "操作记录提交时间")
    private Date operateCommitTime;

    private Byte source;

    private Boolean isQueryPrimary=true;

    @ApiModelProperty(value = "是否上下架：0下架，1上架")
    private Integer isShelves;

    @ApiModelProperty(value = "操作原因")
    private String reason;

    /**
     * 查询大于等于3天未登录
     */
    private Boolean notLog3;

    /**
     * 监督单位名称
     */
    private String supervisionName;

    /**
     *监督单位id
     */
    private Long supervisionUnitId;

    /**
     * 监督单位的TreePath
     */
    private String supervisionUnitTreePath;

    /**
     * true：按行政区划搜监督单位，然后把搜到的监督单位，下的所有机构显示出来。
     * false/null/不传：按照行政区划搜索机构。
     */
    private Boolean searchBySupervision;

    /**
     * 通过行政区划id向下递归查询 获取到的所有下级区划id
     */
    private Set<Long> recursionAreaIdSet;

    /**
     * 行政区划id集合
     */
    private List<Long> areaIdSet;

    public WqyyOrganizationParam(Long id) {
        this.id = id;
    }

    public WqyyOrganizationParam(Long id, Long orgId) {
        this.id = id;
        this.orgId = orgId;
    }

    /**
     * 接入状态
     *      - 不传/null -> 查全部
     *      - 传1 -> 仅查已接入
     *      - 传0 -> 仅查未接入
     */
    private Integer accessState;

    /**
     * 已接入的机构id列表
     */
    private List<Long> accessIdList;

    /**
     * 大于等于3天未登录id列表
     */
    private List<Long> notLog3IdList;

    /**
     * 是否市本级机构
     *      1、null或者""：查询全部机构；
     *      2、true：查询市本级机构；
     *      3、false：查询非市本级机构。
     */
    private Boolean onlyCityLevelOrg;
}
